/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.session.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.ws.container.DeployedModule;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.javaee.dd.appext.ApplicationExt;
import com.ibm.ws.session.SessionApplicationParameters;
import com.ibm.ws.session.SessionContext;
import com.ibm.ws.session.SessionContextRegistry;
import com.ibm.ws.session.SessionManagerConfig;
import com.ibm.ws.session.utils.LoggingUtil;
import com.ibm.ws.webcontainer.SessionRegistry;
import com.ibm.ws.webcontainer.httpsession.SessionManager;
import com.ibm.ws.webcontainer.session.IHttpSessionContext;
import com.ibm.ws.webcontainer.session.impl.HttpSessionContextImpl;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppConfiguration;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.logging.Level;
import javax.servlet.ServletContext;
import javax.servlet.SessionTrackingMode;

public class SessionContextRegistryImpl
extends SessionContextRegistry
implements SessionRegistry {
    private static final String methodClassName = "SessionContextRegistryImpl";

    public SessionContextRegistryImpl(SessionManager smgr) {
        super(smgr);
    }

    protected synchronized IHttpSessionContext createSessionContext(String appName, boolean distributableWebApp, boolean allowDispatchRemoteInclude, WebApp sc, ClassLoader appCl, SessionManagerConfig smc, String j2eeName, boolean sessionSharing, String applicationSessionAppName) throws Throwable {
        IHttpSessionContext sessCtx;
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[2]);
        }
        if ((sessCtx = (IHttpSessionContext)scrSessionContexts.get(appName)) == null) {
            WebAppConfiguration webAppConfig = sc.getConfiguration();
            SessionApplicationParameters sap = new SessionApplicationParameters(appName, webAppConfig.isModuleSessionTimeoutSet(), (long)webAppConfig.getSessionTimeout(), distributableWebApp, allowDispatchRemoteInclude, (ServletContext)sc, appCl, j2eeName, webAppConfig.getSessionCookieConfig(), webAppConfig.isModuleSessionTrackingModeSet(), webAppConfig.getSessionTrackingMode());
            if (webAppConfig.getSessionCookieConfig() != null) {
                webAppConfig.setHasProgrammaticCookieConfig();
            }
            if (!sessionSharing) {
                sap.setHasApplicationSession(true);
                sap.setApplicationSessionName(applicationSessionAppName);
            }
            sessCtx = this.createSessionContextObject(smc, sap);
            scrSessionContexts.put(appName, sessCtx);
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[2]);
        }
        return sessCtx;
    }

    protected IHttpSessionContext createSessionContextObject(SessionManagerConfig smc, SessionApplicationParameters sap) {
        return new HttpSessionContextImpl(smc, sap, this.smgr.getSessionStoreService());
    }

    public boolean isSetSessionTimeout(DeployedModule webModuleConfig) {
        return this.getSessionTimeOut(webModuleConfig) != 0;
    }

    public int getSessionTimeOut(DeployedModule webModuleConfig) {
        int timeout = 0;
        try {
            timeout = webModuleConfig.getWebAppConfig().getSessionTimeout();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "getSessionTimeOut", "" + timeout);
        }
        return timeout;
    }

    public boolean isDistributable(DeployedModule webModuleConfig) {
        return webModuleConfig.getWebApp().getWebAppConfig().isDistributable();
    }

    public boolean isAllowDispatchRemoteInclude(DeployedModule webModuleConfig) {
        return false;
    }

    public String getJ2EEName(DeployedModule webModuleConfig) {
        WebAppConfiguration webAppConfiguration = webModuleConfig.getWebAppConfig();
        WebModuleMetaData webModuleMetaData = webAppConfiguration.getMetaData();
        J2EEName j2eeName = webModuleMetaData.getJ2EEName();
        if (j2eeName == null) {
            String appName = webAppConfiguration.getApplicationName();
            String moduleName = webAppConfiguration.getModuleName();
            return appName + "#" + moduleName;
        }
        return j2eeName.toString();
    }

    public String getAppKey(String vhost, DeployedModule webModuleConfig) {
        String appKey = null;
        String rootURI = webModuleConfig.getContextRoot();
        appKey = vhost + rootURI;
        return appKey;
    }

    public String getAppKey(String vhost, DeployedModule webModuleConfig, boolean useSharedSession, boolean useApplicationSession) {
        if (useSharedSession) {
            WebAppConfiguration webAppConfig = webModuleConfig.getWebAppConfig();
            return vhost + webAppConfig.getApplicationName();
        }
        return this.getAppKey(vhost, webModuleConfig);
    }

    @FFDCIgnore(value={UnableToAdaptException.class})
    public boolean getSharing(WebApp ctx) {
        Container war = ctx.getModuleContainer();
        if (war == null) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "getSharing", "ModuleContainer is null; assuming SharedSessionContext=false");
            }
            return false;
        }
        Container ear = war.getEnclosingContainer();
        if (ear == null) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "getSharing", "EnclosingContainer is null; assuming SharedSessionContext=false");
            }
            return false;
        }
        ApplicationExt adapted = null;
        try {
            adapted = (ApplicationExt)ear.adapt(ApplicationExt.class);
        }
        catch (UnableToAdaptException e) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "getSharing", "Failed to adapt enclosing container; assuming SharedSessionContext=false", e);
            }
            return false;
        }
        if (adapted == null) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "getSharing", "Adapted container is null; assuming SharedSessionContext=false");
            }
            return false;
        }
        return adapted.isSharedSessionContext();
    }

    public SessionManagerConfig getSMC(DeployedModule webModuleConfig) {
        return this.getServerSMC();
    }

    public ClassLoader getSessionClassLoader(DeployedModule webModuleConfig) {
        return webModuleConfig.getClassLoader();
    }

    @Override
    public IHttpSessionContext getSessionContext(DeployedModule webModuleConfig, WebApp ctx, String vhostName, ArrayList[] sessionRelatedListeners) throws Throwable {
        IHttpSessionContext iSctx;
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[1]);
        }
        if (!initialized) {
            this.initialize();
        }
        boolean sessionSharing = this.getSharing(ctx);
        String appKey = this.getAppKey(vhostName, webModuleConfig, sessionSharing, false);
        String appSessionAppKey = this.getAppKey(vhostName, webModuleConfig, sessionSharing, true);
        SessionManagerConfig smc = this.getSMC(webModuleConfig);
        smc.setJ2EEName(this.getJ2EEName(webModuleConfig));
        if (_globalSessionContext && smc.isUsingWebContainerSM()) {
            appKey = "GLOBAL_HTTP_SESSION_CONTEXT";
            sessionSharing = true;
        } else if (_globalSessionContext) {
            Object[] parm = new String[]{appKey};
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.INFO, methodClassName, methodNames[1], "SessionContextRegistry.SessionNotGlobalForWebApp", parm);
        }
        smc = smc.clone();
        if (smc.isUseContextRootForSessionCookiePath()) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[1], "Setting the cookie path to \"" + ctx.getContextPath() + "\" for application - " + appKey);
            }
            smc.setSessionCookiePath(ctx.getContextPath());
        }
        if (!ctx.getConfiguration().isModuleSessionTrackingModeSet()) {
            EnumSet<SessionTrackingMode> trackingModes = EnumSet.noneOf(SessionTrackingMode.class);
            if (smc.getEnableCookies()) {
                trackingModes.add(SessionTrackingMode.COOKIE);
            }
            if (smc.getEnableUrlRewriting()) {
                trackingModes.add(SessionTrackingMode.URL);
            }
            if (smc.useSSLId()) {
                trackingModes.add(SessionTrackingMode.SSL);
            }
            ctx.getConfiguration().setDefaultSessionTrackingMode(trackingModes);
        }
        if ((iSctx = (IHttpSessionContext)scrSessionContexts.get(appKey)) != null) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.INFO, methodClassName, methodNames[1], "SessionContextRegistry.existingContext", appKey);
            SessionContext wsCtx = (SessionContext)iSctx;
            if (sessionSharing) {
                wsCtx.incrementRefCount();
            }
        } else {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.INFO, methodClassName, methodNames[1], "SessionContextRegistry.newContext", appKey);
            ClassLoader sessionClassLoader = this.getSessionClassLoader(webModuleConfig);
            iSctx = this.createSessionContext(appKey, this.isDistributable(webModuleConfig), this.isAllowDispatchRemoteInclude(webModuleConfig), ctx, sessionClassLoader, smc, this.getJ2EEName(webModuleConfig), sessionSharing, appSessionAppKey);
        }
        ctx.getConfiguration().setSessionCookieConfig(iSctx.getWASSessionConfig().getSessionCookieConfig());
        ctx.getConfiguration().setSessionManagerConfig(iSctx.getWASSessionConfig());
        ArrayList sessionListeners = sessionRelatedListeners[0];
        ArrayList sessionAttrListeners = sessionRelatedListeners[1];
        ArrayList sessionIdListeners = sessionRelatedListeners[2];
        String j2eeName = null;
        if (_globalSessionContext && sessionSharing || ((SessionContext)iSctx)._sap.getHasApplicationSession()) {
            j2eeName = this.getJ2EEName(webModuleConfig);
        }
        SessionContext sessCtx = (SessionContext)iSctx;
        sessCtx.addHttpSessionListener(sessionListeners, j2eeName);
        if (!sessionIdListeners.isEmpty()) {
            this.addHttpSessionIdListeners(sessionIdListeners, j2eeName, sessCtx);
        }
        sessCtx.addHttpSessionAttributeListener(sessionAttrListeners, j2eeName);
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[1], iSctx);
        }
        return iSctx;
    }

    protected void addHttpSessionIdListeners(ArrayList list, String name, SessionContext sessCtx) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.INFO, methodClassName, "addHttpSessionIdListeners", "Called addHttpSessionIdListener in a contextother than Servlet 3.1 or later so don't do anything.");
        }
    }
}

