/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.classloading.internal.CompositeResourceProvider;
import com.ibm.ws.classloading.internal.DeclaredApiAccess;
import com.ibm.ws.classloading.internal.NoClassNotFoundLoader;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.classloading.ApiType;
import com.ibm.wsspi.classloading.ClassLoadingConfigurationException;
import com.ibm.wsspi.classloading.GatewayConfiguration;
import com.ibm.wsspi.kernel.service.utils.CompositeEnumeration;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.eclipse.osgi.internal.loader.ModuleClassLoader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;
import org.osgi.framework.wiring.BundleWiring;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class GatewayClassLoader
extends ClassLoader
implements DeclaredApiAccess,
BundleReference,
NoClassNotFoundLoader {
    private final GatewayConfiguration config;
    private final Object wiringMonitor = new Object(){
        static final long serialVersionUID = -6591900154872362572L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.GatewayClassLoader$1", 1.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
        }
    };
    private final Bundle bundle;
    private BundleWiring wiring = null;
    private final ClassLoader cl;
    private volatile BundleLoader bLoader;
    private final CompositeResourceProvider resourceProviders;
    static final long serialVersionUID = -5297397664104906350L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static GatewayClassLoader createGatewayClassLoader(Map<Bundle, Set<GatewayClassLoader>> classloaders, GatewayConfiguration config, ClassLoader bundleLoader, CompositeResourceProvider resourceProviders) {
        Bundle b;
        GatewayClassLoader result = new GatewayClassLoader(config, bundleLoader, resourceProviders);
        if (classloaders != null && (b = result.getBundle()) != null) {
            Map<Bundle, Set<GatewayClassLoader>> map = classloaders;
            synchronized (map) {
                Set<GatewayClassLoader> loaders = classloaders.get(b);
                if (loaders == null) {
                    loaders = Collections.newSetFromMap(new WeakHashMap());
                    classloaders.put(b, loaders);
                }
                loaders.add(result);
            }
        }
        return result;
    }

    private GatewayClassLoader(GatewayConfiguration config, ClassLoader bundleLoader, CompositeResourceProvider resourceProviders) {
        this.config = config;
        if (bundleLoader instanceof BundleReference) {
            this.cl = null;
            this.bundle = ((BundleReference)bundleLoader).getBundle();
            this.wiring = (BundleWiring)this.bundle.adapt(BundleWiring.class);
            if (this.wiring == null) {
                throw new IllegalStateException("Gateway bundle is not resolved.");
            }
            ModuleClassLoader moduleLoader = (ModuleClassLoader)this.wiring.getClassLoader();
            if (moduleLoader == null) {
                throw new IllegalStateException("Gateway bundle does not have a class loader.");
            }
            this.bLoader = moduleLoader.getBundleLoader();
        } else {
            this.bundle = null;
            this.cl = bundleLoader;
        }
        this.resourceProviders = resourceProviders;
    }

    @Override
    @Trivial
    public EnumSet<ApiType> getApiTypeVisibility() {
        return this.config.getApiTypeVisibility();
    }

    @Override
    @Trivial
    public URL getResource(String resName) {
        URL result = this.findResource(resName);
        return result == null ? GatewayClassLoader.getSystemResource(resName) : result;
    }

    @Override
    protected URL findResource(String name) {
        URL result = null;
        if (!"".equals(name) && !"/".equals(name)) {
            BundleLoader current;
            result = this.cl != null ? this.cl.getResource(name) : ((current = this.bLoader) == null ? null : current.findResource(name));
        }
        return result == null ? this.resourceProviders.findResource(name) : result;
    }

    @Override
    @Trivial
    public Enumeration<URL> getResources(String resName) throws IOException {
        return this.findResources(resName).add(GatewayClassLoader.getSystemResources(resName));
    }

    protected CompositeEnumeration<URL> findResources(String name) throws IOException {
        CompositeEnumeration result = new CompositeEnumeration();
        if (!"".equals(name) && !"/".equals(name)) {
            BundleLoader current;
            Enumeration<URL> urls = this.cl != null ? this.cl.getResources(name) : ((current = this.bLoader) == null ? Collections.emptyEnumeration() : current.findResources(name));
            result.add(urls);
        }
        this.resourceProviders.findResources(name, (CompositeEnumeration<URL>)result);
        return result;
    }

    @Override
    @Trivial
    protected Class<?> loadClass(String className, boolean resolve) throws ClassNotFoundException {
        return this.loadClassNoException0(className, true);
    }

    @Trivial
    @FFDCIgnore(value={ClassNotFoundException.class})
    protected Class<?> loadClassNoException0(String className, boolean exception) throws ClassNotFoundException {
        if (this.cl != null) {
            if (this.config.getDelegateToSystem()) {
                try {
                    return Delegation.loadClass(className, this.cl);
                }
                catch (ClassNotFoundException perfectlyNormal) {
                    return this.findSystemClass(className);
                }
            }
            return Delegation.loadClass(className, this.cl);
        }
        Class<?> result = Delegation.loadClass(className, this.bLoader);
        if (result != null) {
            return result;
        }
        if (this.config.getDelegateToSystem()) {
            return this.findSystemClass(className);
        }
        if (exception) {
            throw new ClassNotFoundException(className);
        }
        return null;
    }

    @Override
    @FFDCIgnore(value={ClassNotFoundException.class})
    public Class<?> loadClassNoException(String name) {
        try {
            return this.loadClassNoException0(name, false);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void populateNewLoader() throws ClassLoadingConfigurationException {
        if (this.bundle != null) {
            Object object = this.wiringMonitor;
            synchronized (object) {
                if (this.wiring == null || !this.wiring.isCurrent()) {
                    this.wiring = (BundleWiring)this.bundle.adapt(BundleWiring.class);
                    if (this.wiring != null) {
                        ModuleClassLoader newLoader = (ModuleClassLoader)this.wiring.getClassLoader();
                        if (newLoader == null) {
                            throw new ClassLoadingConfigurationException("No class loader available for the gateway bundle.");
                        }
                        this.bLoader = newLoader.getBundleLoader();
                    }
                }
            }
        }
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.GatewayClassLoader", GatewayClassLoader.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class Delegation {
        static final long serialVersionUID = -2536391674481029385L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private Delegation() {
        }

        @Trivial
        static Class<?> loadClass(String className, ClassLoader loader) throws ClassNotFoundException {
            return loader == null ? null : loader.loadClass(className);
        }

        @Trivial
        static Class<?> loadClass(String className, BundleLoader loader) {
            return loader == null ? null : loader.findClassNoException(className);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.GatewayClassLoader$Delegation", Delegation.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
        }
    }
}

