/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics30.setup.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.metrics30.setup.config.PropertySingleValueConfiguration;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Collection;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TimerBucketMaxConfiguration
extends PropertySingleValueConfiguration<Duration> {
    private static final TraceComponent tc = Tr.register(TimerBucketMaxConfiguration.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
    static final long serialVersionUID = -7551164822014424533L;

    public TimerBucketMaxConfiguration(String metricName, Duration value) {
        super(metricName, value);
    }

    public static Collection<TimerBucketMaxConfiguration> parse(String input) {
        String[] metricValuePairs;
        ArrayDeque<TimerBucketMaxConfiguration> sloMinConfigCollection = new ArrayDeque<TimerBucketMaxConfiguration>();
        if (input == null || input.length() == 0) {
            return null;
        }
        for (String kvString : metricValuePairs = input.split(";")) {
            String val;
            String[] keyValueSplit = kvString.split("=");
            String metricName = keyValueSplit[0];
            TimerBucketMaxConfiguration sloMinConfiguration = null;
            Duration dur = null;
            if (keyValueSplit.length != 2) continue;
            String s = keyValueSplit[1];
            if (s.matches("[0-9]+ms")) {
                val = s.substring(0, s.length() - 2);
                dur = Duration.ofMillis(Long.parseLong(val));
            } else if (s.matches("[0-9]+s")) {
                val = s.substring(0, s.length() - 1);
                dur = Duration.ofSeconds(Long.parseLong(val));
            } else if (s.matches("[0-9]+m")) {
                val = s.substring(0, s.length() - 1);
                dur = Duration.ofMinutes(Long.parseLong(val));
            } else if (s.matches("[0-9]+h")) {
                val = s.substring(0, s.length() - 1);
                dur = Duration.ofHours(Long.parseLong(val));
            } else if (s.matches("[0-9]+")) {
                dur = Duration.ofMillis(Long.parseLong(s));
            } else {
                Tr.warning((TraceComponent)tc, (String)"invalidTimerValueConfigured.warning.CWMMC0016W", (Object[])new Object[]{s, "mp.metrics.distribution.timer.buckets"});
            }
            if (dur == null) continue;
            sloMinConfiguration = new TimerBucketMaxConfiguration(metricName, dur);
            sloMinConfigCollection.addFirst(sloMinConfiguration);
        }
        return sloMinConfigCollection;
    }
}

