/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.internal.lifecycle;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.application.lifecycle.ApplicationPrereq;
import com.ibm.wsspi.application.lifecycle.ApplicationStartBarrier;
import com.ibm.wsspi.logging.Introspector;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(immediate=true, configurationPid={"com.ibm.ws.app.prereqs"}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.vendor=IBM"})
public class ApplicationPrereqMonitor
implements Introspector {
    public static final TraceComponent tc = Tr.register(ApplicationPrereqMonitor.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.internal.resources.AppManagerMessages", (String)"com.ibm.ws.app.manager.internal.lifecycle.ApplicationPrereqMonitor");
    private static final String PREREQ_ID_PROP = "application.prereq.id";
    private static final AtomicInteger counter = new AtomicInteger(0);
    private final int version = counter.incrementAndGet();
    private final ConfigurationAdmin configAdmin;
    private volatile Set<String> declaredPrereqs;
    private final List<String> errors = new ArrayList<String>();
    private final List<String> pendingPrereqs = new ArrayList<String>();
    private final List<String> realizedPrereqs = new ArrayList<String>();
    private int appStartBarrierBindCount;
    private int appStartBarrierUnbindCount;
    static final long serialVersionUID = 6981003721639157002L;

    @Activate
    public ApplicationPrereqMonitor(@Reference ConfigurationAdmin configAdmin, Map<String, Object> properties) {
        this.configAdmin = configAdmin;
        this.declaredPrereqs = this.findDeclarations(properties);
    }

    @Modified
    synchronized void modified(Map<String, Object> properties) {
        Set<String> oldSet = this.declaredPrereqs;
        Set<String> newSet = this.findDeclarations(properties);
        if (newSet.equals(oldSet)) {
            return;
        }
        this.declaredPrereqs = newSet;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            TreeSet<String> removed = new TreeSet<String>(oldSet);
            TreeSet<String> added = new TreeSet<String>(newSet);
            TreeSet<String> unmodified = new TreeSet<String>(oldSet);
            removed.removeAll(newSet);
            added.removeAll(oldSet);
            unmodified.removeAll(removed);
            if (unmodified.size() > 0) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Prereq declarations unmodified:", (Object[])new Object[]{unmodified});
            }
            if (removed.size() > 0) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Prereq declarations removed:", (Object[])new Object[]{removed});
            }
            if (added.size() > 0) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Prereq declarations added:", (Object[])new Object[]{added});
            }
        }
    }

    @Deactivate
    void deactivate() {
    }

    private Set<String> findDeclarations(Map<String, Object> properties) {
        Set decls = Optional.of(properties).map(props -> props.get("applicationPrereqDeclarations")).map(String[].class::cast).map(Stream::of).orElse(Stream.empty()).map(this::servicePidToPrereqId).filter(Objects::nonNull).collect(TreeSet::new, Set::add, Set::addAll);
        return Collections.unmodifiableSet(decls);
    }

    @Trivial
    @FFDCIgnore(value={Exception.class})
    private String servicePidToPrereqId(String servicePid) {
        try {
            Object[] configs = this.configAdmin.listConfigurations("(service.pid=" + servicePid + ")");
            if (configs == null) {
                throw new IllegalStateException("No configs found matching servicePid=" + servicePid);
            }
            if (configs.length > 1) {
                throw new IllegalStateException("Non unique servicePid=" + servicePid + " matched configs=" + Arrays.toString(configs));
            }
            return Objects.requireNonNull((String)configs[0].getProperties().get(PREREQ_ID_PROP));
        }
        catch (Exception e) {
            this.errors.add("" + e);
            return null;
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    synchronized void addPendingPrereq(ServiceReference<ApplicationPrereq> ref, Map<String, Object> props) {
        this.pendingPrereqs.add(this.getPrereqId(props));
    }

    synchronized void removePendingPrereq(ServiceReference<ApplicationPrereq> ref, Map<String, Object> props) {
        this.pendingPrereqs.remove(this.getPrereqId(props));
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    synchronized void addRealizedPrereq(ApplicationPrereq applicationPrereq, Map<String, Object> props) {
        this.realizedPrereqs.add(this.getPrereqId(props));
    }

    synchronized void removeRealizedPrereq(ApplicationPrereq applicationPrereq, Map<String, Object> props) {
        this.realizedPrereqs.remove(this.getPrereqId(props));
    }

    private String getPrereqId(Map<String, Object> props) {
        return Objects.requireNonNull((String)props.get(PREREQ_ID_PROP));
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    synchronized void addStartBarrier(ApplicationStartBarrier barrier, Map<String, Object> properties) {
        this.modified(properties);
        ++this.appStartBarrierBindCount;
        TreeSet<String> pending = new TreeSet<String>(this.pendingPrereqs);
        TreeSet<String> realized = new TreeSet<String>(this.realizedPrereqs);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Declared prereqs: " + this.declaredPrereqs), (Object[])new Object[0]);
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Pending prereqs:  " + pending), (Object[])new Object[0]);
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Realized prereqs: " + realized), (Object[])new Object[0]);
        }
        if (this.declaredPrereqs.equals(realized)) {
            return;
        }
        if (this.appStartBarrierBindCount > this.appStartBarrierUnbindCount + 1) {
            this.errors.clear();
        } else {
            TreeSet<String> missing = new TreeSet<String>(this.declaredPrereqs);
            TreeSet<String> blocked = pending;
            TreeSet<String> extra = realized;
            blocked.removeAll(realized);
            missing.removeAll(realized);
            extra.removeAll(this.declaredPrereqs);
            this.errors.add("addStartBarrier: prereq mismatch detected:\n\tmissing: " + missing + "\n\tblocked: " + blocked + "\n\textra:   " + extra);
        }
    }

    synchronized void removeStartBarrier(ApplicationStartBarrier ready) {
        ++this.appStartBarrierUnbindCount;
        if (this.appStartBarrierBindCount == this.appStartBarrierUnbindCount) {
            this.errors.clear();
        }
    }

    public String toString() {
        return ApplicationPrereqMonitor.class.getName() + "#" + this.version;
    }

    public String getIntrospectorName() {
        return this.getClass().getSimpleName();
    }

    public String getIntrospectorDescription() {
        return this.getIntrospectorName().replaceAll(".", "=") + "\nList the declared (D), pending (P), and realized (R) application prereqs.\nApplications cannot start until all the declared prereqs become available (i.e. are realized).";
    }

    public synchronized void introspect(PrintWriter out) throws Exception {
        out.println();
        out.println("=Detected Application Prereqs=");
        ((Stream)Stream.concat(Stream.concat(this.declaredPrereqs.stream(), this.realizedPrereqs.stream()), this.pendingPrereqs.stream()).filter(Objects::nonNull).sorted().distinct().sequential()).peek(s -> out.print('[')).peek(s -> out.print(this.declaredPrereqs.contains(s) ? (char)'D' : (char)' ')).peek(s -> out.print((char)(this.realizedPrereqs.contains(s) ? 82 : (this.pendingPrereqs.contains(s) ? 80 : 32)))).peek(s -> out.print("] ")).forEach(out::println);
        out.println();
        out.println("=App Start Barrier tracking=");
        out.println("Bind calls:   " + this.appStartBarrierBindCount);
        out.println("Unbind calls: " + this.appStartBarrierUnbindCount);
        out.println();
        out.println("=Errors=");
        this.errors.forEach(out::println);
        if (this.errors.isEmpty()) {
            out.println("No errors recorded.");
        }
    }
}

