/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import org.bouncycastle.crypto.io.InvalidCipherTextIOException;

public class CipherOutputStream
extends FilterOutputStream {
    private final Cipher cipher;
    private final byte[] oneByte = new byte[1];

    public CipherOutputStream(OutputStream outputStream, Cipher cipher) {
        super(outputStream);
        this.cipher = cipher;
    }

    @Override
    public void write(int n) throws IOException {
        this.oneByte[0] = (byte)n;
        this.write(this.oneByte, 0, 1);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2 = this.cipher.update(byArray, n, n2);
        if (byArray2 != null) {
            this.out.write(byArray2);
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        Object object;
        block7: {
            object = null;
            try {
                byte[] byArray = this.cipher.doFinal();
                if (byArray != null) {
                    this.out.write(byArray);
                }
            }
            catch (GeneralSecurityException generalSecurityException) {
                object = new InvalidCipherTextIOException("Error during cipher finalisation", (Throwable)generalSecurityException);
            }
            catch (Exception exception) {
                object = new IOException("Error closing stream: " + exception);
            }
            try {
                this.flush();
                this.out.close();
            }
            catch (IOException iOException) {
                if (object != null) break block7;
                object = iOException;
            }
        }
        if (object != null) {
            throw object;
        }
    }
}

