/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal;

import com.ibm.ws.install.InstallEventListener;
import com.ibm.ws.install.InstallProgressEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class EventManager {
    private Map<String, Collection<InstallEventListener>> listenersMap;

    public void addListener(InstallEventListener listener, String notificationType) {
        Collection<InstallEventListener> listeners;
        if (listener == null || notificationType == null) {
            return;
        }
        if (notificationType.isEmpty()) {
            return;
        }
        if (this.listenersMap == null) {
            this.listenersMap = new HashMap<String, Collection<InstallEventListener>>();
        }
        if ((listeners = this.listenersMap.get(notificationType)) == null) {
            listeners = new ArrayList<InstallEventListener>(1);
            this.listenersMap.put(notificationType, listeners);
        }
        listeners.add(listener);
    }

    public void removeListener(InstallEventListener listener) {
        if (this.listenersMap != null) {
            for (Collection<InstallEventListener> listeners : this.listenersMap.values()) {
                listeners.remove(listener);
            }
        }
    }

    public void fireProgressEvent(int state, int progress, String message) throws Exception {
        Collection<InstallEventListener> listeners;
        if (this.listenersMap != null && (listeners = this.listenersMap.get("PROGRESS")) != null) {
            for (InstallEventListener listener : listeners) {
                listener.handleInstallEvent(new InstallProgressEvent(state, progress, message));
            }
        }
    }
}

