/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.FailureScopeFactory;
import java.util.HashMap;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class FailureScopeManager {
    private static final TraceComponent tc = Tr.register(FailureScopeManager.class, (String)"Transaction", (String)"com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
    private static HashMap<Byte, FailureScopeFactory> _failureScopeFactoriesById = new HashMap();
    private static HashMap<Class<?>, FailureScopeFactory> _failureScopeFactoriesByClass = new HashMap();
    static final long serialVersionUID = 1069378069529580559L;

    @ManualTrace
    public static void registerFailureScopeFactory(Byte id, Class<?> failureScopeClass, FailureScopeFactory factory) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerFailureScopeFactory", (Object[])new Object[]{id, failureScopeClass, factory});
        }
        _failureScopeFactoriesById.put(id, factory);
        _failureScopeFactoriesByClass.put(failureScopeClass, factory);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerFailureScopeFactory");
        }
    }

    @ManualTrace
    public static byte[] toByteArray(FailureScope failureScope) {
        FailureScopeFactory failureScopeFactory;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"toByteArray", (Object[])new Object[]{failureScope});
        }
        byte[] bytes = null;
        Class<?> failureScopeClass = failureScope.getClass();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("FailureScope class: " + failureScopeClass), (Object[])new Object[0]);
        }
        if ((failureScopeFactory = _failureScopeFactoriesByClass.get(failureScopeClass)) != null) {
            bytes = failureScopeFactory.toByteArray(failureScope);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"toByteArray");
        }
        return bytes;
    }

    @ManualTrace
    public static FailureScope toFailureScope(byte[] bytes) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"toFailureScope", (Object[])new Object[]{bytes});
        }
        Byte factoryId = bytes[0];
        FailureScopeFactory failureScopeFactory = _failureScopeFactoriesById.get(factoryId);
        FailureScope failureScope = null;
        if (failureScopeFactory != null) {
            failureScope = failureScopeFactory.toFailureScope(bytes);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"toFailureScope", (Object)failureScope);
        }
        return failureScope;
    }
}

