/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.javaeesec;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.security.Principal;
import java.util.Collections;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.auth.message.callback.GroupPrincipalCallback;
import javax.security.enterprise.AuthenticationStatus;
import javax.security.enterprise.authentication.mechanism.http.AuthenticationParameters;
import javax.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import javax.security.enterprise.identitystore.CredentialValidationResult;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HttpMessageContextImpl
implements HttpMessageContext {
    private static final TraceComponent tc = Tr.register(HttpMessageContextImpl.class, (String)"security", (String)"com.ibm.ws.security.javaeesec.internal.resources.JavaEESecMessages");
    private final MessageInfo messageInfo;
    private final Subject clientSubject;
    private final CallbackHandler handler;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private Principal principal = null;
    private Set<String> groups = Collections.emptySet();
    private boolean isRegisterSession = false;
    private AuthenticationParameters authenticationParameters = new AuthenticationParameters();
    private boolean isAuthenticationRequest = false;
    private CredentialValidationResult result;
    static final long serialVersionUID = -873230647639194221L;

    public HttpMessageContextImpl(MessageInfo messageInfo, Subject clientSubject, CallbackHandler handler) {
        this.messageInfo = messageInfo;
        this.clientSubject = clientSubject;
        this.handler = handler;
        this.request = (HttpServletRequest)messageInfo.getRequestMessage();
        this.response = (HttpServletResponse)messageInfo.getResponseMessage();
    }

    public HttpMessageContextImpl(MessageInfo messageInfo, Subject clientSubject, CallbackHandler handler, AuthenticationParameters authenticationParameters) {
        this(messageInfo, clientSubject, handler);
        this.authenticationParameters = authenticationParameters;
        this.isAuthenticationRequest = true;
        this.request = (HttpServletRequest)messageInfo.getRequestMessage();
        this.response = (HttpServletResponse)messageInfo.getResponseMessage();
    }

    public void cleanClientSubject() {
    }

    public AuthenticationStatus doNothing() {
        return AuthenticationStatus.NOT_DONE;
    }

    public AuthenticationStatus forward(String path) {
        try {
            RequestDispatcher requestDispatcher = this.request.getRequestDispatcher(path);
            requestDispatcher.forward((ServletRequest)this.request, (ServletResponse)this.response);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.javaeesec.HttpMessageContextImpl", (String)"117", (Object)this, (Object[])new Object[]{path});
        }
        return AuthenticationStatus.SEND_CONTINUE;
    }

    public AuthenticationParameters getAuthParameters() {
        return this.authenticationParameters;
    }

    public Principal getCallerPrincipal() {
        return this.principal;
    }

    public Subject getClientSubject() {
        return this.clientSubject;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public CallbackHandler getHandler() {
        return this.handler;
    }

    public MessageInfo getMessageInfo() {
        return this.messageInfo;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public boolean isAuthenticationRequest() {
        return this.isAuthenticationRequest;
    }

    public boolean isProtected() {
        return ((String)this.messageInfo.getMap().get("javax.security.auth.message.MessagePolicy.isMandatory")).equalsIgnoreCase("TRUE");
    }

    public boolean isRegisterSession() {
        return this.isRegisterSession;
    }

    public AuthenticationStatus notifyContainerAboutLogin(CredentialValidationResult result) {
        if (CredentialValidationResult.Status.VALID.equals((Object)result.getStatus())) {
            this.result = result;
            return this.notifyContainerAboutLogin((Principal)result.getCallerPrincipal(), (Set<String>)result.getCallerGroups());
        }
        return AuthenticationStatus.SEND_FAILURE;
    }

    public AuthenticationStatus notifyContainerAboutLogin(Principal principal, Set<String> groups) {
        try {
            this.principal = principal;
            this.groups = Collections.unmodifiableSet(groups);
            Callback[] callbacks = new Callback[]{this.getRealmNameCallback(), new CallerPrincipalCallback(this.clientSubject, principal), new GroupPrincipalCallback(this.clientSubject, groups.toArray(new String[0]))};
            this.handler.handle(callbacks);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.javaeesec.HttpMessageContextImpl", (String)"263", (Object)this, (Object[])new Object[]{principal, groups});
        }
        return AuthenticationStatus.SUCCESS;
    }

    private NameCallback getRealmNameCallback() {
        NameCallback realmNameCallback = new NameCallback("com.ibm.wsspi.security.cred.realm");
        realmNameCallback.setName(this.getRealm());
        return realmNameCallback;
    }

    private String getRealm() {
        String realm = "defaultRealm";
        if (this.result != null) {
            String idStoreId = this.result.getIdentityStoreId();
            if (idStoreId == null || idStoreId.trim().isEmpty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The identity store id is not defined, \"defaultRealm\" is used.", (Object[])new Object[0]);
                }
            } else {
                realm = idStoreId;
            }
        }
        return realm;
    }

    public AuthenticationStatus notifyContainerAboutLogin(String callername, Set<String> groups) {
        try {
            this.groups = Collections.unmodifiableSet(groups);
            Callback[] callbacks = new Callback[]{new CallerPrincipalCallback(this.clientSubject, callername), new GroupPrincipalCallback(this.clientSubject, groups.toArray(new String[0]))};
            this.handler.handle(callbacks);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.javaeesec.HttpMessageContextImpl", (String)"303", (Object)this, (Object[])new Object[]{callername, groups});
        }
        return AuthenticationStatus.SUCCESS;
    }

    public AuthenticationStatus redirect(String location) {
        try {
            this.response.setStatus(302);
            this.response.sendRedirect(this.response.encodeURL(location));
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.javaeesec.HttpMessageContextImpl", (String)"319", (Object)this, (Object[])new Object[]{location});
        }
        return AuthenticationStatus.SEND_CONTINUE;
    }

    public AuthenticationStatus responseNotFound() {
        this.response.setStatus(404);
        return AuthenticationStatus.SEND_FAILURE;
    }

    public AuthenticationStatus responseUnauthorized() {
        this.response.setStatus(401);
        return AuthenticationStatus.SEND_FAILURE;
    }

    public void setRegisterSession(String callerName, Set<String> groups) {
        this.isRegisterSession = true;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public HttpMessageContext withRequest(HttpServletRequest request) {
        this.request = request;
        return this;
    }
}

