/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Feature;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.impl.ConfigurableImpl;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class ConfigurationImpl
implements Configuration {
    private static final Logger LOG = LogUtils.getL7dLogger(ConfigurationImpl.class);
    private Map<String, Object> props;
    private RuntimeType runtimeType;
    private Map<Object, Map<Class<?>, Integer>> providers;
    private Map<Feature, Boolean> features;
    static final long serialVersionUID = -7543288230808762499L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ConfigurationImpl(RuntimeType rt) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "<init>", new Object[]{rt});
        }
        this.props = new HashMap<String, Object>();
        this.providers = new LinkedHashMap();
        this.features = new LinkedHashMap<Feature, Boolean>();
        this.runtimeType = rt;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ConfigurationImpl(Configuration parent) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "<init>", new Object[]{parent});
        }
        this.props = new HashMap<String, Object>();
        this.providers = new LinkedHashMap();
        this.features = new LinkedHashMap<Feature, Boolean>();
        if (parent != null) {
            this.props.putAll(parent.getProperties());
            this.runtimeType = parent.getRuntimeType();
            HashSet providerClasses = new HashSet(parent.getClasses());
            for (Object o : parent.getInstances()) {
                if (!(o instanceof Feature)) {
                    this.registerParentProvider(o, parent);
                } else {
                    Feature f = (Feature)o;
                    this.features.put(f, parent.isEnabled(f));
                }
                providerClasses.remove(o.getClass());
            }
            for (Class cls : providerClasses) {
                this.registerParentProvider(ConfigurationImpl.createProvider(cls), parent);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ConfigurationImpl(Configuration parent, Class<?>[] defaultContracts) {
        this(parent);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "<init>", new Object[]{parent, defaultContracts});
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void registerParentProvider(Object o, Configuration parent) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "registerParentProvider", new Object[]{o, parent});
        }
        Map contracts = parent.getContracts(o.getClass());
        if (contracts != null) {
            this.providers.put(o, contracts);
        } else {
            this.register(o, AnnotationUtils.getBindingPriority(o.getClass()), ConfigurableImpl.getImplementedContracts(o, new Class[0]));
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "registerParentProvider");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<Class<?>> getClasses() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "getClasses", new Object[0]);
        }
        HashSet classes = new HashSet();
        for (Object o : this.getInstances()) {
            classes.add(o.getClass());
        }
        HashSet hashSet = classes;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            hashSet = hashSet;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "getClasses", hashSet);
        }
        return hashSet;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map<Class<?>, Integer> getContracts(Class<?> cls) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "getContracts", new Object[]{cls});
        }
        for (Object o : this.getInstances()) {
            if (!cls.isAssignableFrom(o.getClass())) continue;
            if (o instanceof Feature) {
                Map<Class<?>, Integer> map = Collections.emptyMap();
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    map = map;
                    LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "getContracts", map);
                }
                return map;
            }
            Map<Class<?>, Integer> map = this.providers.get(o);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                map = map;
                LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "getContracts", map);
            }
            return map;
        }
        Map<Class<?>, Integer> map = Collections.emptyMap();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            map = map;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "getContracts", map);
        }
        return map;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<Object> getInstances() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "getInstances", new Object[0]);
        }
        HashSet<Object> allInstances = new HashSet<Object>();
        allInstances.addAll(this.providers.keySet());
        allInstances.addAll(this.features.keySet());
        Set<Object> set = Collections.unmodifiableSet(allInstances);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            set = set;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "getInstances", set);
        }
        return set;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map<String, Object> getProperties() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "getProperties", new Object[0]);
        }
        Map<String, Object> map = Collections.unmodifiableMap(this.props);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            map = map;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "getProperties", map);
        }
        return map;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Object getProperty(String name) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "getProperty", new Object[]{name});
        }
        Object object = this.props.get(name);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            object = object;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "getProperty", object);
        }
        return object;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Collection<String> getPropertyNames() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "getPropertyNames", new Object[0]);
        }
        Set<String> set = Collections.unmodifiableSet(this.props.keySet());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            set = set;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "getPropertyNames", set);
        }
        return set;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public RuntimeType getRuntimeType() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "getRuntimeType", new Object[0]);
        }
        RuntimeType runtimeType = this.runtimeType;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            runtimeType = runtimeType;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "getRuntimeType", runtimeType);
        }
        return runtimeType;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isEnabled(Feature f) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "isEnabled", new Object[]{f});
        }
        boolean bl = this.features.containsKey(f) && this.features.get(f) != false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "isEnabled", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isEnabled(Class<? extends Feature> f) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "isEnabled", new Object[]{f});
        }
        for (Map.Entry<Feature, Boolean> entry : this.features.entrySet()) {
            Feature feature = entry.getKey();
            Boolean enabled = entry.getValue();
            if (!f.isAssignableFrom(feature.getClass()) || !enabled.booleanValue()) continue;
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "isEnabled", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "isEnabled", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isRegistered(Object obj) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "isRegistered", new Object[]{obj});
        }
        for (Object o : this.getInstances()) {
            if (!o.equals(obj)) continue;
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "isRegistered", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "isRegistered", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isRegistered(Class<?> cls) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "isRegistered", new Object[]{cls});
        }
        for (Object o : this.getInstances()) {
            if (cls != o.getClass()) continue;
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "isRegistered", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "isRegistered", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setProperty(String name, Object value) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "setProperty", new Object[]{name, value});
        }
        if (name == null) {
            this.props.remove(name);
        } else {
            this.props.put(name, value);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "setProperty");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setFeature(Feature f, boolean enabled) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "setFeature", new Object[]{f, enabled});
        }
        this.features.put(f, enabled);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "setFeature");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void register(Object provider, int bindingPriority, Class<?> ... contracts) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "register", new Object[]{provider, bindingPriority, contracts});
        }
        this.register(provider, ConfigurationImpl.initContractsMap(bindingPriority, contracts));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "register");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean register(Object provider, Map<Class<?>, Integer> contracts) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "register", new Object[]{provider, contracts});
        }
        if (provider.getClass() == Class.class) {
            if (this.isRegistered((Class)provider)) {
                LOG.warning("Provider class " + ((Class)provider).getName() + " has already been registered");
                boolean bl = false;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    bl = bl;
                    LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "register", bl);
                }
                return bl;
            }
            provider = ConfigurationImpl.createProvider((Class)provider);
        }
        if (this.isRegistered(provider)) {
            LOG.warning("Provider " + provider.getClass().getName() + " has already been registered");
            boolean bl = false;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "register", bl);
            }
            return bl;
        }
        if (!this.contractsValid(provider, contracts)) {
            boolean bl = false;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "register", bl);
            }
            return bl;
        }
        Map<Class<?>, Integer> metadata = this.providers.get(provider);
        if (metadata == null) {
            metadata = new HashMap();
            this.providers.put(provider, metadata);
        }
        for (Map.Entry<Class<?>, Integer> entry : contracts.entrySet()) {
            if (!entry.getKey().isAssignableFrom(provider.getClass())) continue;
            metadata.put(entry.getKey(), entry.getValue());
        }
        boolean bl = true;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "register", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean contractsValid(Object provider, Map<Class<?>, Integer> contracts) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "contractsValid", new Object[]{provider, contracts});
        }
        Class<?> providerClass = provider.getClass();
        for (Class<?> contractInterface : contracts.keySet()) {
            if (contractInterface.isAssignableFrom(providerClass)) continue;
            LOG.warning("Provider " + providerClass.getName() + " does not implement specified contract: " + contractInterface.getName());
            boolean bl = false;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "contractsValid", bl);
            }
            return bl;
        }
        boolean bl = true;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "contractsValid", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Map<Class<?>, Integer> initContractsMap(int bindingPriority, Class<?> ... contracts) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "initContractsMap", new Object[]{bindingPriority, contracts});
        }
        HashMap metadata = new HashMap();
        for (Class<?> contract : contracts) {
            metadata.put(contract, bindingPriority);
        }
        HashMap hashMap = metadata;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            hashMap = hashMap;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "initContractsMap", hashMap);
        }
        return hashMap;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={Throwable.class})
    public static Object createProvider(Class<?> cls) {
        Object obj;
        block3: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "createProvider", new Object[]{cls});
            }
            try {
                obj = cls.newInstance();
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block3;
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
            obj = obj;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurationImpl", "createProvider", obj);
        }
        return obj;
    }
}

