/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.common.gzip;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.MessageSenderInterceptor;
import org.apache.cxf.io.AbstractThresholdOutputStream;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class GZIPOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final Pattern ZERO_Q = Pattern.compile(";\\s*q=0(?:\\.0+)?$");
    public static final Pattern ENCODINGS = Pattern.compile("[,\\s]*,\\s*");
    public static final String ORIGINAL_OUTPUT_STREAM_KEY = GZIPOutInterceptor.class.getName() + ".originalOutputStream";
    public static final String USE_GZIP_KEY = GZIPOutInterceptor.class.getName() + ".useGzip";
    public static final String GZIP_ENCODING_KEY = GZIPOutInterceptor.class.getName() + ".gzipEncoding";
    public static final String SOAP_JMS_CONTENTENCODING = "SOAPJMS_contentEncoding";
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(GZIPOutInterceptor.class);
    private static final Logger LOG = LogUtils.getL7dLogger(GZIPOutInterceptor.class);
    private int threshold;
    private boolean force;
    private Set<String> supportedPayloadContentTypes;
    static final long serialVersionUID = -5035746446327924373L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public GZIPOutInterceptor() {
        super("prepare-send");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.common.gzip.GZIPOutInterceptor", "<init>", new Object[0]);
        }
        this.threshold = 1024;
        this.addAfter(MessageSenderInterceptor.class.getName());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.common.gzip.GZIPOutInterceptor", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public GZIPOutInterceptor(int threshold) {
        super("prepare-send");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.common.gzip.GZIPOutInterceptor", "<init>", new Object[]{threshold});
        }
        this.threshold = 1024;
        this.addAfter(MessageSenderInterceptor.class.getName());
        this.threshold = threshold;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.common.gzip.GZIPOutInterceptor", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setThreshold(int threshold) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.common.gzip.GZIPOutInterceptor", "setThreshold", new Object[]{threshold});
        }
        this.threshold = threshold;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.common.gzip.GZIPOutInterceptor", "setThreshold");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int getThreshold() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.common.gzip.GZIPOutInterceptor", "getThreshold", new Object[0]);
        }
        int n = this.threshold;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            n = n;
            LOG.exiting("org.apache.cxf.transport.common.gzip.GZIPOutInterceptor", "getThreshold", n);
        }
        return n;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleMessage(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.common.gzip.GZIPOutInterceptor", "handleMessage", new Object[]{message});
        }
        boolean isLoggableFine = LOG.isLoggable(Level.FINE);
        if (isLoggableFine) {
            LOG.fine("Inside handleMessage of GZIPOutInterceptor");
        }
        boolean isGzipProp = PropertyUtils.isTrue(message.getContextualProperty("cxf.add.gzip.out.interceptor"));
        if (isLoggableFine) {
            LOG.fine("isGzipProp: " + isGzipProp);
        }
        UseGzip use = this.gzipPermitted(message);
        if (isLoggableFine) {
            LOG.fine("Is gzipPermitted?: " + (Object)((Object)use));
        }
        if (isGzipProp) {
            use = UseGzip.YES;
        }
        if (use != UseGzip.NO) {
            OutputStream os = message.getContent(OutputStream.class);
            if (os == null) {
                if (isLoggableFine) {
                    LOG.fine("GZIPOutInterceptor: OutputStream is null, returning");
                }
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    LOG.exiting("org.apache.cxf.transport.common.gzip.GZIPOutInterceptor", "handleMessage");
                }
                return;
            }
            message.put(ORIGINAL_OUTPUT_STREAM_KEY, os);
            message.put(USE_GZIP_KEY, use);
            GZipThresholdOutputStream cs = new GZipThresholdOutputStream(this.threshold, os, use == UseGzip.FORCE, message);
            message.setContent(OutputStream.class, cs);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.common.gzip.GZIPOutInterceptor", "handleMessage");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public UseGzip gzipPermitted(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.common.gzip.GZIPOutInterceptor", "gzipPermitted", new Object[]{message});
        }
        boolean isLoggableFine = LOG.isLoggable(Level.FINE);
        UseGzip permitted = UseGzip.NO;
        if (this.supportedPayloadContentTypes != null && message.containsKey("Content-Type") && !this.supportedPayloadContentTypes.contains(message.get("Content-Type"))) {
            UseGzip useGzip = permitted;
            if (LOG == null || !LOG.isLoggable(Level.FINER)) return useGzip;
            useGzip = useGzip;
            LOG.exiting("org.apache.cxf.transport.common.gzip.GZIPOutInterceptor", "gzipPermitted", (Object)useGzip);
            return useGzip;
        }
        if (MessageUtils.isRequestor(message)) {
            Object o;
            if (isLoggableFine) {
                LOG.fine("Requestor role, so gzip enabled");
            }
            permitted = (o = message.getContextualProperty(USE_GZIP_KEY)) instanceof UseGzip ? (UseGzip)((Object)o) : (o instanceof String ? UseGzip.valueOf((String)o) : (this.force ? UseGzip.YES : UseGzip.NO));
            message.put(GZIP_ENCODING_KEY, "gzip");
            GZIPOutInterceptor.addHeader(message, "Accept-Encoding", "gzip;q=1.0, identity; q=0.5, *;q=0");
        } else {
            Exchange exchange;
            Message request;
            Map<String, List<String>> requestHeaders;
            if (isLoggableFine) {
                LOG.fine("Response role, checking accept-encoding");
            }
            if ((requestHeaders = CastUtils.cast((Map)(request = (exchange = message.getExchange()).getInMessage()).get(Message.PROTOCOL_HEADERS))) != null) {
                List<String> acceptEncodingHeader = CastUtils.cast(HttpHeaderHelper.getHeader(requestHeaders, "Accept-Encoding"));
                List jmsEncodingHeader = CastUtils.cast(requestHeaders.get(SOAP_JMS_CONTENTENCODING));
                if (jmsEncodingHeader != null && jmsEncodingHeader.contains("gzip")) {
                    permitted = UseGzip.YES;
                    message.put(GZIP_ENCODING_KEY, "gzip");
                }
                if (acceptEncodingHeader != null) {
                    boolean xGzipEnabled;
                    if (isLoggableFine) {
                        LOG.fine("Accept-Encoding header: " + acceptEncodingHeader);
                    }
                    ArrayList<String> zeros = new ArrayList<String>(3);
                    ArrayList<String> nonZeros = new ArrayList<String>(3);
                    for (String headerLine : acceptEncodingHeader) {
                        String[] encodings;
                        for (String enc : encodings = ENCODINGS.split(headerLine.trim())) {
                            Matcher m = ZERO_Q.matcher(enc);
                            if (m.find()) {
                                zeros.add(enc.substring(0, m.start()));
                                continue;
                            }
                            if (enc.indexOf(59) >= 0) {
                                nonZeros.add(enc.substring(0, enc.indexOf(59)));
                                continue;
                            }
                            nonZeros.add(enc);
                        }
                    }
                    boolean identityEnabled = !zeros.contains("identity") && (!zeros.contains("*") || nonZeros.contains("identity"));
                    boolean gzipEnabled = nonZeros.contains("gzip") || nonZeros.contains("*") && !zeros.contains("gzip");
                    boolean bl = xGzipEnabled = nonZeros.contains("x-gzip") || nonZeros.contains("*") && !zeros.contains("x-gzip");
                    if (isLoggableFine) {
                        LOG.fine("identityEnabled: " + identityEnabled);
                        LOG.fine("gzipEnabled: " + gzipEnabled);
                        LOG.fine("xGzipEnabled: " + xGzipEnabled);
                    }
                    if (identityEnabled && !gzipEnabled && !xGzipEnabled) {
                        permitted = UseGzip.NO;
                    } else if (identityEnabled && gzipEnabled) {
                        permitted = UseGzip.YES;
                        message.put(GZIP_ENCODING_KEY, "gzip");
                    } else if (identityEnabled && xGzipEnabled) {
                        permitted = UseGzip.YES;
                        message.put(GZIP_ENCODING_KEY, "x-gzip");
                    } else if (!identityEnabled && gzipEnabled) {
                        permitted = UseGzip.FORCE;
                        message.put(GZIP_ENCODING_KEY, "gzip");
                    } else {
                        if (identityEnabled || !xGzipEnabled) throw new Fault(new org.apache.cxf.common.i18n.Message("NO_SUPPORTED_ENCODING", BUNDLE, new Object[0]));
                        permitted = UseGzip.FORCE;
                        message.put(GZIP_ENCODING_KEY, "x-gzip");
                    }
                } else if (isLoggableFine) {
                    LOG.fine("No accept-encoding header");
                }
            }
        }
        if (LOG.isLoggable(Level.FINE) && isLoggableFine) {
            LOG.fine("gzip permitted: " + (Object)((Object)permitted));
        }
        UseGzip useGzip = permitted;
        if (LOG == null || !LOG.isLoggable(Level.FINER)) return useGzip;
        useGzip = useGzip;
        LOG.exiting("org.apache.cxf.transport.common.gzip.GZIPOutInterceptor", "gzipPermitted", (Object)useGzip);
        return useGzip;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static void addHeader(Message message, String name, String value) {
        List header;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.common.gzip.GZIPOutInterceptor", "addHeader", new Object[]{message, name, value});
        }
        Map protocolHeaders = CastUtils.cast((Map)message.get(Message.PROTOCOL_HEADERS));
        if (protocolHeaders == null) {
            protocolHeaders = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            message.put(Message.PROTOCOL_HEADERS, protocolHeaders);
        }
        if ((header = CastUtils.cast((List)protocolHeaders.get(name))) == null) {
            header = new ArrayList();
            protocolHeaders.put(name, header);
        }
        if (header.isEmpty()) {
            header.add(value);
        } else {
            header.set(0, (String)header.get(0) + "," + value);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.common.gzip.GZIPOutInterceptor", "addHeader");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setForce(boolean force) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.common.gzip.GZIPOutInterceptor", "setForce", new Object[]{force});
        }
        this.force = force;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.common.gzip.GZIPOutInterceptor", "setForce");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> getSupportedPayloadContentTypes() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.common.gzip.GZIPOutInterceptor", "getSupportedPayloadContentTypes", new Object[0]);
        }
        Set<String> set = this.supportedPayloadContentTypes;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            set = set;
            LOG.exiting("org.apache.cxf.transport.common.gzip.GZIPOutInterceptor", "getSupportedPayloadContentTypes", set);
        }
        return set;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setSupportedPayloadContentTypes(Set<String> supportedPayloadContentTypes) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.common.gzip.GZIPOutInterceptor", "setSupportedPayloadContentTypes", new Object[]{supportedPayloadContentTypes});
        }
        this.supportedPayloadContentTypes = supportedPayloadContentTypes;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.common.gzip.GZIPOutInterceptor", "setSupportedPayloadContentTypes");
        }
    }

    public static enum UseGzip {
        NO,
        YES,
        FORCE;

    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    static class GZipThresholdOutputStream
    extends AbstractThresholdOutputStream {
        Message message;
        static final long serialVersionUID = 373016828442093171L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        GZipThresholdOutputStream(int t, OutputStream orig, boolean force, Message msg) {
            super(t);
            this.wrappedStream = orig;
            this.message = msg;
            if (force) {
                this.setupGZip();
            }
        }

        private void setupGZip() {
        }

        @Override
        public void thresholdNotReached() {
            LOG.fine("Message is smaller than compression threshold, not compressing.");
        }

        @Override
        public void thresholdReached() throws IOException {
            LOG.fine("Compressing message.");
            String enc = (String)this.message.get(GZIP_ENCODING_KEY);
            GZIPOutInterceptor.addHeader(this.message, "Content-Encoding", enc);
            if (!Boolean.TRUE.equals(this.message.get("org.apache.cxf.client"))) {
                GZIPOutInterceptor.addHeader(this.message, "Vary", "Accept-Encoding");
            }
            GZIPOutputStream zipOutput = new GZIPOutputStream(this.wrappedStream);
            this.wrappedStream = zipOutput;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.transport.common.gzip.GZIPOutInterceptor$GZipThresholdOutputStream", GZipThresholdOutputStream.class, null, null);
        }
    }
}

