/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.h2internal.frames;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.http.channel.h2internal.FrameReadProcessor;
import com.ibm.ws.http.channel.h2internal.FrameTypes;
import com.ibm.ws.http.channel.h2internal.H2ConnectionSettings;
import com.ibm.ws.http.channel.h2internal.exceptions.FrameSizeException;
import com.ibm.ws.http.channel.h2internal.exceptions.ProtocolException;
import com.ibm.ws.http.channel.h2internal.frames.Frame;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;

public class FrameUnknown
extends Frame {
    public FrameUnknown(int streamId, int payloadLength, byte flags, boolean reserveBit, Frame.FrameDirection direction) {
        super(streamId, payloadLength, flags, reserveBit, direction);
        this.frameType = FrameTypes.UNKNOWN;
    }

    public FrameUnknown(int streamId, byte[] payload, boolean reserveBit) {
        super(streamId, 8, (byte)0, reserveBit, Frame.FrameDirection.WRITE);
        this.frameType = FrameTypes.UNKNOWN;
        this.writeFrameLength += this.payloadLength;
        this.setInitialized();
    }

    @Override
    public void processPayload(FrameReadProcessor frp) throws FrameSizeException {
        this.setFlags();
    }

    @Override
    public WsByteBuffer buildFrameForWrite() {
        WsByteBuffer buffer = super.buildFrameForWrite();
        byte[] frame = buffer.hasArray() ? buffer.array() : super.createFrameArray();
        this.setFrameHeaders(frame, (byte)15);
        buffer.put(frame, 0, this.writeFrameLength);
        buffer.flip();
        return buffer;
    }

    @Override
    public void validate(H2ConnectionSettings settings) throws ProtocolException, FrameSizeException {
    }

    @Override
    protected void setFlags() {
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof FrameUnknown)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Object is not a FrameUnknown", (Object[])new Object[0]);
            }
            return false;
        }
        FrameUnknown frameUnknownToCompare = (FrameUnknown)object;
        return super.equals(frameUnknownToCompare);
    }

    @Override
    public String toString() {
        StringBuilder frameToString = new StringBuilder();
        frameToString.append(super.toString());
        return frameToString.toString();
    }
}

