/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.pmi;

import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class PmiDataInfo
implements Serializable,
PmiConstants {
    private static final long serialVersionUID = -1609400918066043034L;
    private int id;
    private String name;
    private int type = -1;
    private String description = null;
    private String category = "all";
    private String unit = "unit.none";
    private int level = -1;
    private boolean resettable = true;
    private boolean aggregatable = true;
    private boolean zosAggregatable = true;
    private boolean onRequest = false;
    private String statSet = "all";
    private String platform = "all";
    private String submoduleName = null;
    private String participation = null;
    private String comment = null;
    private ArrayList dependencyList = null;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public PmiDataInfo(int id) {
        this.id = id;
    }

    public PmiDataInfo(int id, String name, int type, int level, String description) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.level = level;
        this.description = description;
        if (type == 4) {
            this.unit = "unit.ms";
        }
    }

    public PmiDataInfo(int id, String name, String unit, String description, int type, int level, boolean resettable) {
        this.id = id;
        this.name = name;
        this.unit = unit;
        this.description = description;
        this.type = type;
        this.level = level;
        this.resettable = resettable;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(int type) {
        this.type = type;
        if (this.level == -1) {
            switch (type) {
                case 1: 
                case 2: 
                case 3: {
                    this.level = 1;
                    break;
                }
                case 4: {
                    this.level = 3;
                    this.unit = "unit.ms";
                    break;
                }
                case 5: {
                    this.level = 7;
                    break;
                }
                case 15: {
                    this.level = 15;
                    break;
                }
            }
        }
    }

    public void setParticipation(String participation) {
        this.participation = participation;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setStatisticSet(String statSet) {
        this.statSet = statSet;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setResettable(boolean resettable) {
        this.resettable = resettable;
    }

    public void setAggregatable(boolean aggregatable) {
        this.aggregatable = aggregatable;
    }

    public void setZosAggregatable(boolean zosAggregatable) {
        this.zosAggregatable = zosAggregatable;
    }

    public void setOnRequest(boolean onRequest) {
        this.onRequest = onRequest;
    }

    public void setSubmoduleName(String submoduleName) {
        this.submoduleName = submoduleName;
    }

    public void addDependency(int id) {
        if (this.dependencyList == null) {
            this.dependencyList = new ArrayList(2);
        }
        this.dependencyList.add(new Integer(id));
    }

    public ArrayList getDependency() {
        return this.dependencyList;
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public int getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getCategory() {
        return this.category;
    }

    public String getParticipation() {
        return this.participation;
    }

    public int getLevel() {
        return this.level;
    }

    public String getStatisticSet() {
        return this.statSet;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isResettable() {
        return this.resettable;
    }

    public boolean isAggregatable() {
        return this.aggregatable;
    }

    public boolean isZosAggregatable() {
        return this.zosAggregatable;
    }

    public boolean isAvailableInPlatform(String p) {
        if (this.platform.equals("all")) {
            return true;
        }
        return this.platform.equals(p);
    }

    public boolean isUpdateOnRequest() {
        return this.onRequest;
    }

    public String getSubmoduleName() {
        return this.submoduleName;
    }

    void print(PrintWriter pw) {
        pw.println("id:" + this.id);
        pw.println("name:" + this.name);
        pw.println("type:" + this.type);
        pw.println("participation:" + this.participation);
        pw.println("level:" + this.level);
        pw.println("description:" + this.description);
        pw.println("comment:" + this.comment);
        pw.println("resettable:" + this.resettable);
        pw.println("submoduleName:" + this.submoduleName);
    }

    public String toString() {
        StringBuffer b = new StringBuffer("{name=").append(this.name);
        b.append(", ID=").append(this.id);
        b.append(", description=").append(this.description);
        b.append(", unit=").append(this.unit);
        b.append(", statisticSet=").append(this.statSet);
        b.append(", resettable=").append(this.resettable);
        b.append(", aggregatable=").append(this.aggregatable);
        b.append(", zosAggregatable=").append(this.zosAggregatable);
        if (this.submoduleName != null) {
            b.append(", submoduleName:").append(this.submoduleName);
        }
        b.append("}");
        return b.toString();
    }

    public PmiDataInfo copy() {
        PmiDataInfo r = new PmiDataInfo(this.id);
        if (this.name != null) {
            r.name = new String(this.name);
        }
        if (this.description != null) {
            r.description = new String(this.description);
        }
        if (this.unit != null) {
            r.unit = new String(this.unit);
        }
        r.category = this.category;
        r.type = this.type;
        r.level = this.level;
        r.resettable = this.resettable;
        r.aggregatable = this.aggregatable;
        r.zosAggregatable = this.zosAggregatable;
        r.onRequest = this.onRequest;
        r.statSet = this.statSet;
        r.platform = this.platform;
        r.submoduleName = this.submoduleName;
        r.participation = this.participation;
        r.comment = this.comment;
        r.dependencyList = this.dependencyList;
        return r;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.websphere.pmi.PmiDataInfo", PmiDataInfo.class, (String)"PMI", (String)"com.ibm.ws.pmi.properties.PMIMessages");
    }
}

