/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.util.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.annocache.util.internal.UtilImpl_ReadBuffer;
import com.ibm.ws.annocache.util.internal.UtilImpl_WriteBuffer;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public final class UtilImpl_ReadBufferPartial
implements UtilImpl_ReadBuffer {
    private final String path;
    private final RandomAccessFile file;
    private final int fileLength;
    private int filePos;
    private final byte[] buffer;
    private int bufferFill;
    private int bufferPos;
    private int bufferAvail;
    private final Charset charset;
    public static final Charset UTF_8;
    private final byte[] smallIntBytes = new byte[2];
    private final byte[] largeIntBytes = new byte[4];
    private final int MAX_STRING = 512;
    private final int MAX_WIDTH = 60;
    private final byte[] stringBytes = new byte[512];
    private final byte[] nullBytes = new byte[60];
    static final long serialVersionUID = -164732361036296695L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Override
    @Trivial
    public String getPath() {
        return this.path;
    }

    @Override
    @Trivial
    public String getEncoding() {
        return this.charset.name();
    }

    public UtilImpl_ReadBufferPartial(String path, int bufferSize) throws IOException {
        this(path, bufferSize, UTF_8);
    }

    public UtilImpl_ReadBufferPartial(String path, RandomAccessFile file, int bufferSize) throws IOException {
        this(path, file, bufferSize, UTF_8);
    }

    public UtilImpl_ReadBufferPartial(String path, int bufferSize, Charset charset) throws IOException {
        this(path, new RandomAccessFile(path, "r"), bufferSize, charset);
    }

    public UtilImpl_ReadBufferPartial(String path, RandomAccessFile file, int bufferSize, Charset charset) throws IOException {
        this.path = path;
        this.file = file;
        long rawFileLength = this.file.length();
        if (rawFileLength > Integer.MAX_VALUE) {
            throw new IOException("File length [ " + rawFileLength + " ] greater than [ " + Integer.MAX_VALUE + " ] for [ " + path + " ]");
        }
        this.fileLength = (int)rawFileLength;
        this.charset = charset;
        this.bufferFill = this.fileLength < bufferSize ? this.fileLength : bufferSize;
        this.buffer = new byte[this.bufferFill];
        this.bufferPos = 0;
        this.bufferAvail = this.bufferFill;
        this.file.read(this.buffer, 0, this.bufferFill);
        this.filePos = this.bufferFill;
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    @Trivial
    public static int asInt(byte[] b) {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            value <<= 8;
            value |= b[i] & 0xFF;
        }
        return value;
    }

    @Override
    @Trivial
    public int readSmallInt() throws IOException {
        this.read(this.smallIntBytes, 0, 2);
        return (this.smallIntBytes[0] & 0xFF) << 8 | (this.smallIntBytes[1] & 0xFF) << 0;
    }

    @Trivial
    public static int convertLargeInt(byte[] bytes) {
        return (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | (bytes[3] & 0xFF) << 0;
    }

    @Override
    @Trivial
    public int readLargeInt() throws IOException {
        this.read(this.largeIntBytes, 0, 4);
        return UtilImpl_ReadBufferPartial.convertLargeInt(this.largeIntBytes);
    }

    @Override
    @Trivial
    public int read() throws IOException {
        if (this.bufferAvail == 0) {
            throw new IOException("Read past end of file on [ " + this.path + " ]");
        }
        byte readByte = this.buffer[this.bufferPos];
        ++this.bufferPos;
        --this.bufferAvail;
        if (this.bufferAvail == 0) {
            int fileRemaining = this.fileLength - this.filePos;
            this.bufferFill = fileRemaining >= this.buffer.length ? this.buffer.length : fileRemaining;
            if (this.bufferFill != 0) {
                this.file.read(this.buffer, 0, this.bufferFill);
                this.filePos += this.bufferFill;
            }
            this.bufferPos = 0;
            this.bufferAvail = this.bufferFill;
        }
        return readByte;
    }

    @Override
    @Trivial
    public void read(byte[] bytes) throws IOException {
        this.read(bytes, 0, bytes.length);
    }

    @Override
    @Trivial
    public void read(byte[] bytes, int offset, int len) throws IOException {
        int spanLength;
        if (len == 0) {
            return;
        }
        if (len < 0) {
            throw new IOException("Disallowed read of [ " + len + " from [ " + this.path + " ]");
        }
        if (len < this.bufferAvail) {
            System.arraycopy(this.buffer, this.bufferPos, bytes, offset, len);
            this.bufferPos += len;
            this.bufferAvail -= len;
            return;
        }
        int fileAvail = this.fileLength - this.filePos + this.bufferAvail;
        if (len > fileAvail) {
            throw new IOException("Read [ " + len + " ] at [ " + (this.fileLength - fileAvail) + " ] past end of file [ " + this.fileLength + " ] on [ " + this.path + " ]");
        }
        System.arraycopy(this.buffer, this.bufferPos, bytes, offset, this.bufferAvail);
        offset += this.bufferAvail;
        fileAvail -= this.bufferAvail;
        if ((len -= this.bufferAvail) > 0 && (spanLength = len / this.buffer.length * this.buffer.length) > 0) {
            this.file.read(bytes, offset, spanLength);
            this.filePos += spanLength;
            offset += spanLength;
            len -= spanLength;
            fileAvail -= spanLength;
        }
        this.bufferFill = fileAvail > this.buffer.length ? this.buffer.length : fileAvail;
        if (this.bufferFill != 0) {
            this.file.read(this.buffer, 0, this.bufferFill);
            this.filePos += this.bufferFill;
        }
        if (len > 0) {
            System.arraycopy(this.buffer, 0, bytes, offset, len);
        }
        this.bufferPos = len;
        this.bufferAvail = this.bufferFill - len;
    }

    @Override
    @Trivial
    public int getFileLength() {
        return this.fileLength;
    }

    @Override
    public void seekEnd(int offset) throws IOException {
        this.seek(this.getFileLength() + offset);
    }

    @Override
    public void seek(int offset) throws IOException {
        boolean doReload;
        if (offset > this.filePos) {
            if (offset > this.fileLength) {
                throw new IOException("Offset [ " + offset + " ] past end [ " + this.fileLength + " ] of [ " + this.path + " ]");
            }
            doReload = true;
        } else {
            int bufferStart = this.filePos - this.bufferFill;
            if (offset < bufferStart) {
                if (offset < 0) {
                    throw new IOException("Offset [ " + offset + " ] past beginning  of [ " + this.path + " ]");
                }
                doReload = true;
            } else {
                this.bufferPos = offset - bufferStart;
                this.bufferAvail = this.bufferFill - this.bufferPos;
                doReload = false;
            }
        }
        if (doReload) {
            this.file.seek(offset);
            this.filePos = offset;
            int fileRemaining = this.fileLength - offset;
            this.bufferFill = fileRemaining > this.buffer.length ? this.buffer.length : fileRemaining;
            if (this.bufferFill > 0) {
                this.file.read(this.buffer, 0, this.bufferFill);
                this.filePos += this.bufferFill;
            }
            this.bufferPos = 0;
            this.bufferAvail = this.bufferFill;
        }
    }

    @Override
    @Trivial
    public int validSmallInt() throws IOException {
        this.read(this.smallIntBytes, 0, 2);
        int smallInt = (this.smallIntBytes[0] & 0xFF) << 8 | (this.smallIntBytes[1] & 0xFF) << 0;
        if (smallInt > 512) {
            throw new IOException("String width [ " + smallInt + " ] greater than allowed [ " + 512 + " ] for [ " + this.path + " ]");
        }
        return smallInt;
    }

    @Override
    @Trivial
    public String readString() throws IOException {
        int valueLength = this.validSmallInt();
        this.read(this.stringBytes, 0, valueLength);
        return new String(this.stringBytes, 0, valueLength, this.charset);
    }

    @Override
    @Trivial
    public String readString(int width) throws IOException {
        int valueLength = this.validSmallInt();
        this.read(this.stringBytes, 0, valueLength);
        int nullCount = width - 3 - valueLength;
        if (nullCount > 0) {
            this.read(this.nullBytes, 0, nullCount);
        }
        return new String(this.stringBytes, 0, valueLength, this.charset);
    }

    @Override
    @Trivial
    public void requireByte(byte fieldByte) throws IOException {
        byte actualByte = (byte)this.read();
        if (actualByte != fieldByte) {
            throw new IOException("Failed read of [ " + this.path + " ]: Expected field byte [ " + fieldByte + " ] actual field byte [ " + actualByte + " ]");
        }
    }

    @Override
    @Trivial
    public String requireField(byte fieldByte) throws IOException {
        this.requireByte(fieldByte);
        return this.readString();
    }

    @Override
    @Trivial
    public String requireField(byte fieldByte, int width) throws IOException {
        this.requireByte(fieldByte);
        return this.readString(width);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.util.internal.UtilImpl_ReadBufferPartial", UtilImpl_ReadBufferPartial.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
        UTF_8 = UtilImpl_WriteBuffer.UTF_8;
    }
}

