/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.anno.info.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.anno.info.internal.AnnotationValueImpl;
import com.ibm.ws.anno.info.internal.ClassInfoImpl;
import com.ibm.ws.anno.info.internal.InfoStoreImpl;
import com.ibm.ws.anno.info.internal.MethodInfoImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.anno.info.AnnotationInfo;
import com.ibm.wsspi.anno.info.AnnotationValue;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AnnotationInfoImpl
implements AnnotationInfo {
    private static final TraceComponent tc = Tr.register(AnnotationInfoImpl.class, (String)"com.ibm.ws.anno", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
    public static final String CLASS_NAME = AnnotationInfoImpl.class.getName();
    protected String hashText;
    protected InfoStoreImpl infoStore;
    protected String annotationClassName;
    protected ClassInfoImpl annotationClassInfo;
    protected boolean isInherited;
    protected Map<String, AnnotationValueImpl> values;
    static final long serialVersionUID = 6876348476124898918L;

    @Override
    public String getHashText() {
        return this.hashText;
    }

    public String toString() {
        return this.hashText;
    }

    @ManualTrace
    public AnnotationInfoImpl(String annotationClassName, InfoStoreImpl infoStore) {
        String methodName = "<init>";
        this.hashText = CLASS_NAME + "@" + Integer.toString(new Object().hashCode()) + " ( " + annotationClassName + " )";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{this.getHashText()});
        }
        this.infoStore = infoStore;
        this.annotationClassName = infoStore.internClassName(annotationClassName);
        this.annotationClassInfo = null;
        this.isInherited = false;
        this.values = null;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)this.getHashText());
        }
    }

    @Override
    public InfoStoreImpl getInfoStore() {
        return this.infoStore;
    }

    @Override
    public String getAnnotationClassName() {
        return this.annotationClassName;
    }

    protected void resolveAnnotationClassInfo() {
        this.annotationClassInfo = this.getInfoStore().getDelayableClassInfo(this.getAnnotationClassName());
        this.isInherited = this.getAnnotationClassInfo().isAnnotationPresent("java.lang.annotation.Inherited");
    }

    @Override
    public ClassInfoImpl getAnnotationClassInfo() {
        if (this.annotationClassInfo == null) {
            this.resolveAnnotationClassInfo();
        }
        return this.annotationClassInfo;
    }

    @Override
    public boolean isInherited() {
        if (this.annotationClassInfo == null) {
            this.resolveAnnotationClassInfo();
        }
        return this.isInherited;
    }

    @Override
    public boolean isValueDefaulted(String name) {
        return this.values == null || !this.values.containsKey(name);
    }

    @Override
    public AnnotationValueImpl getValue(String name) {
        AnnotationValueImpl annotationValue;
        AnnotationValueImpl annotationValueImpl = annotationValue = this.values == null ? null : this.values.get(name);
        if (annotationValue == null) {
            ClassInfoImpl useAnnotationClassInfo = this.getAnnotationClassInfo();
            MethodInfoImpl methodInfo = useAnnotationClassInfo.getMethod(name);
            if (methodInfo == null) {
                Tr.warning((TraceComponent)tc, (String)"ANNO_ANNOINFO_NO_METHOD", (Object[])new Object[]{this.getHashText(), useAnnotationClassInfo.getHashText(), name});
            } else {
                annotationValue = methodInfo.getAnnotationDefaultValue();
            }
        }
        return annotationValue;
    }

    @Override
    public AnnotationValueImpl getCachedAnnotationValue(String name) {
        AnnotationValueImpl annotationValue = this.values == null ? null : this.values.get(name);
        return annotationValue;
    }

    public void addAnnotationValue(String name, AnnotationValueImpl value) {
        if (this.values == null) {
            this.values = new HashMap<String, AnnotationValueImpl>();
        }
        AnnotationValueImpl oldValue = this.values.put(name, value);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Value Name [ {1} ] Value Enum Class [ {2} ] Value [ {3} ]", this.getHashText(), name, value.getEnumClassName(), value.getObjectValue()), (Object[])new Object[0]);
            if (oldValue != null) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Old value Name [ {1} ] Value Enum Class [ {2} ] Value [ {3} ]", this.getHashText(), name, oldValue.getEnumClassName(), oldValue.getObjectValue()), (Object[])new Object[0]);
            }
        }
    }

    public AnnotationValueImpl addAnnotationValue(String name, Object value) {
        AnnotationValueImpl annotationValue = new AnnotationValueImpl(value);
        this.addAnnotationValue(name, annotationValue);
        return annotationValue;
    }

    public AnnotationValueImpl addAnnotationValue(String name, String enumClassName, String enumName) {
        AnnotationValueImpl annotationValue = new AnnotationValueImpl(enumClassName, enumName);
        this.addAnnotationValue(name, annotationValue);
        return annotationValue;
    }

    @Override
    public AnnotationInfoImpl getAnnotationValue(String name) {
        AnnotationValueImpl annotationValue = this.getValue(name);
        return annotationValue == null ? null : annotationValue.getAnnotationValue();
    }

    @Override
    public List<? extends AnnotationValue> getArrayValue(String name) {
        AnnotationValueImpl annotationValue = this.getValue(name);
        return annotationValue == null ? null : annotationValue.getArrayValue();
    }

    @Override
    public Boolean getBoolean(String name) {
        AnnotationValueImpl annotationValue = this.getValue(name);
        return annotationValue == null ? null : annotationValue.getBoolean();
    }

    @Override
    public boolean getBooleanValue(String name) {
        return this.getValue(name).getBooleanValue();
    }

    @Override
    public Byte getByte(String name) {
        AnnotationValueImpl annotationValue = this.getValue(name);
        return annotationValue == null ? null : annotationValue.getByte();
    }

    @Override
    public byte getByteValue(String name) {
        return this.getValue(name).getByteValue();
    }

    @Override
    public Character getCharacter(String name) {
        AnnotationValueImpl annotationValue = this.getValue(name);
        return annotationValue == null ? null : annotationValue.getCharacter();
    }

    @Override
    public char getCharValue(String name) {
        return this.getValue(name).getCharValue();
    }

    @Override
    public String getClassNameValue(String name) {
        AnnotationValueImpl annotationValue = this.getValue(name);
        return annotationValue == null ? null : annotationValue.getClassNameValue();
    }

    @Override
    public Double getDouble(String name) {
        AnnotationValueImpl annotationValue = this.getValue(name);
        return annotationValue == null ? null : annotationValue.getDouble();
    }

    @Override
    public double getDoubleValue(String name) {
        return this.getValue(name).getDoubleValue();
    }

    @Override
    public String getEnumClassName(String name) {
        AnnotationValueImpl annotationValue = this.getValue(name);
        return annotationValue == null ? null : annotationValue.getEnumClassName();
    }

    @Override
    public String getEnumValue(String name) {
        AnnotationValueImpl annotationValue = this.getValue(name);
        return annotationValue == null ? null : annotationValue.getEnumValue();
    }

    @Trivial
    public void log(TraceComponent logger) {
        Tr.debug((TraceComponent)logger, (String)MessageFormat.format("Annotation [ {0} ]", this.getAnnotationClassName()), (Object[])new Object[0]);
        for (String valueName : this.values.keySet()) {
            AnnotationValueImpl nextValue = this.getValue(valueName);
            String valueEnumClassName = nextValue.getEnumClassName();
            Object valueValue = nextValue.getObjectValue();
            if (valueEnumClassName != null) {
                Tr.debug((TraceComponent)logger, (String)MessageFormat.format("  Value: Name [ {0} ] Enum Type [ {1} ] Value [ {2} ]", valueName, valueEnumClassName, valueValue), (Object[])new Object[0]);
                continue;
            }
            Tr.debug((TraceComponent)logger, (String)MessageFormat.format("  Value: Name [ {0} ] Value [ {1} ]", valueName, valueValue), (Object[])new Object[0]);
        }
    }
}

