/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.microprofile.openapi.impl.validation.OASValidationResult;
import com.ibm.ws.microprofile.openapi.impl.validation.TypeValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.ValidationHelper;
import com.ibm.ws.microprofile.openapi.impl.validation.ValidatorUtils;
import com.ibm.ws.microprofile.openapi.utils.OpenAPIModelWalker;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.microprofile.openapi.models.security.OAuthFlow;
import org.eclipse.microprofile.openapi.models.security.OAuthFlows;

public class OAuthFlowsValidator
extends TypeValidator<OAuthFlows> {
    private static final TraceComponent tc = Tr.register(OAuthFlowsValidator.class);
    private static final OAuthFlowsValidator INSTANCE = new OAuthFlowsValidator();

    public static OAuthFlowsValidator getInstance() {
        return INSTANCE;
    }

    private OAuthFlowsValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, OAuthFlows t) {
        if (t != null) {
            String message;
            if (t.getImplicit() != null) {
                OAuthFlow implicit = t.getImplicit();
                if (StringUtils.isNotBlank((CharSequence)implicit.getTokenUrl())) {
                    message = Tr.formatMessage((TraceComponent)tc, (String)"nonApplicableFieldWithValue", (Object[])new Object[]{"tokenUrl", implicit.getTokenUrl(), "OAuth Flow Object", "implicit"});
                    helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, context.getLocation(), message));
                }
                ValidatorUtils.validateRequiredField(implicit.getAuthorizationUrl(), context, "authorizationUrl").ifPresent(helper::addValidationEvent);
            }
            if (t.getPassword() != null) {
                OAuthFlow password = t.getPassword();
                if (StringUtils.isNotBlank((CharSequence)password.getAuthorizationUrl())) {
                    message = Tr.formatMessage((TraceComponent)tc, (String)"nonApplicableFieldWithValue", (Object[])new Object[]{"authorizationUrl", password.getAuthorizationUrl(), "OAuth Flow Object", "password"});
                    helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, context.getLocation(), message));
                }
                ValidatorUtils.validateRequiredField(password.getTokenUrl(), context, "tokenUrl").ifPresent(helper::addValidationEvent);
            }
            if (t.getClientCredentials() != null) {
                OAuthFlow clientCred = t.getClientCredentials();
                if (StringUtils.isNotBlank((CharSequence)clientCred.getAuthorizationUrl())) {
                    message = Tr.formatMessage((TraceComponent)tc, (String)"nonApplicableFieldWithValue", (Object[])new Object[]{"authorizationUrl", clientCred.getAuthorizationUrl(), "OAuth Flow Object", "clientCredentials"});
                    helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, context.getLocation(), message));
                }
                ValidatorUtils.validateRequiredField(clientCred.getTokenUrl(), context, "tokenUrl").ifPresent(helper::addValidationEvent);
            }
            if (t.getAuthorizationCode() != null) {
                OAuthFlow authCode = t.getAuthorizationCode();
                ValidatorUtils.validateRequiredField(authCode.getTokenUrl(), context, "tokenUrl").ifPresent(helper::addValidationEvent);
                ValidatorUtils.validateRequiredField(authCode.getAuthorizationUrl(), context, "authorizationUrl").ifPresent(helper::addValidationEvent);
            }
        }
    }
}

