/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jwt.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.jwt.Claims;
import com.ibm.websphere.security.jwt.JwtToken;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.jwt.internal.ClaimsImpl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.jwx.Headers;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.lang.JoseException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JwtTokenConsumerImpl
implements JwtToken,
Serializable {
    private static final long serialVersionUID = 1L;
    private final short serializationVersion = 1;
    private final Claims claims = new ClaimsImpl();
    private final String compact;
    private transient Headers jwtHeaders;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public JwtTokenConsumerImpl(JwtContext jwtContext) {
        this.claims.putAll(jwtContext.getJwtClaims().getClaimsMap());
        this.compact = jwtContext.getJwt();
        List jsonStructures = jwtContext.getJoseObjects();
        JsonWebStructure jsonStruct = (JsonWebStructure)jsonStructures.get(0);
        this.jwtHeaders = jsonStruct.getHeaders();
    }

    @Override
    public Claims getClaims() {
        return this.claims;
    }

    @Override
    public String getHeader(String name) {
        return this.jwtHeaders.getStringHeaderValue(name);
    }

    @Override
    public String compact() {
        return this.compact;
    }

    /*
     * WARNING - void declaration
     */
    private void readObject(ObjectInputStream input) throws ClassNotFoundException, IOException {
        input.defaultReadObject();
        try {
            this.jwtHeaders = new Headers();
            this.jwtHeaders.setFullHeaderAsJsonString((String)input.readObject());
        }
        catch (JoseException joseException) {
            void e;
            FFDCFilter.processException((Throwable)joseException, (String)"com.ibm.ws.security.jwt.internal.JwtTokenConsumerImpl", (String)"99", (Object)this, (Object[])new Object[]{input});
            throw new IOException("Error deserializing JWT headers.", (Throwable)e);
        }
    }

    private void writeObject(ObjectOutputStream output) throws IOException {
        output.defaultWriteObject();
        output.writeObject(this.jwtHeaders.getFullHeaderAsJsonString());
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.jwt.internal.JwtTokenConsumerImpl", JwtTokenConsumerImpl.class, (String)"JWTBUILDER", (String)"com.ibm.ws.security.jwt.internal.resources.JWTMessages");
    }
}

