/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channelfw.internal;

import com.ibm.websphere.channelfw.ChainData;
import com.ibm.websphere.channelfw.ChainGroupData;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.channelfw.internal.ChainDataImpl;
import com.ibm.ws.channelfw.internal.ChannelFrameworkImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.channelfw.ChainEventListener;
import com.ibm.wsspi.channelfw.exception.ChainException;
import java.util.ArrayList;
import java.util.List;

public class ChainGroupDataImpl
implements ChainGroupData {
    private static final long serialVersionUID = 3062239582748589190L;
    private static final TraceComponent tc = Tr.register(ChainGroupDataImpl.class, (String)"ChannelFramework", (String)"com.ibm.ws.channelfw.internal.resources.ChannelfwMessages");
    private String name = null;
    private ChainData[] chainArray = null;
    private transient List<ChainEventListener> chainEventListeners = null;
    private transient ChannelFrameworkImpl framework = null;

    public ChainGroupDataImpl(String groupName, ChainData[] groupChains, ChannelFrameworkImpl frameworkRef) {
        this.name = groupName;
        this.chainArray = groupChains;
        this.chainEventListeners = new ArrayList<ChainEventListener>(0);
        this.framework = frameworkRef;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ChainData[] getChains() {
        return this.chainArray;
    }

    @Override
    public boolean containsChain(String target) {
        for (ChainData chain : this.getChains()) {
            if (!chain.getName().equals(target)) continue;
            return true;
        }
        return false;
    }

    public void setChains(ChainData[] newChainArray) {
        this.chainArray = newChainArray;
    }

    public void addChain(ChainData newChain) throws ChainException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("addChain: " + newChain.getName()), (Object[])new Object[0]);
        }
        if (this.containsChain(newChain.getName())) {
            ChainException e = new ChainException("Chain already exists: " + newChain.getName());
            FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".addChain"), (String)"116", (Object)this, (Object[])new Object[]{newChain});
            throw e;
        }
        int currentLength = this.chainArray.length;
        ChainData[] newChains = new ChainData[currentLength + 1];
        System.arraycopy(this.getChains(), 0, newChains, 0, currentLength);
        newChains[currentLength] = newChain;
        this.setChains(newChains);
        for (ChainEventListener listener : this.getChainEventListeners()) {
            ((ChainDataImpl)newChain).addChainEventListener(listener);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addChain");
        }
    }

    public void removeChain(ChainData inputChain) throws ChainException {
        String chainname = inputChain.getName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("removeChain: " + chainname), (Object[])new Object[0]);
        }
        if (!this.containsChain(chainname)) {
            ChainException e = new ChainException("Unable to find chain: " + chainname);
            FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".removeChain"), (String)"157", (Object)this, (Object[])new Object[]{inputChain, this.framework});
            throw e;
        }
        int currentLength = this.chainArray.length;
        ChainData[] newChains = new ChainData[currentLength - 1];
        for (int i = 0; i < currentLength; ++i) {
            if (chainname.equals(this.chainArray[i].getName())) continue;
            newChains[i] = this.chainArray[i];
        }
        this.setChains(newChains);
        for (ChainEventListener listener : this.getChainEventListeners()) {
            this.removeListenerFromChain(listener, inputChain);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeChain");
        }
    }

    public void updateChain(ChainData inputChain) {
        String chainname = inputChain.getName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("updateChain: " + chainname), (Object[])new Object[0]);
        }
        for (int i = 0; i < this.chainArray.length; ++i) {
            if (!chainname.equals(this.chainArray[i].getName())) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Updating chain " + chainname + " in group " + this.getName()), (Object[])new Object[0]);
            }
            this.chainArray[i] = inputChain;
            break;
        }
    }

    public int getNumChainEventListeners() {
        return this.chainEventListeners.size();
    }

    public List<ChainEventListener> getChainEventListeners() {
        return this.chainEventListeners;
    }

    public boolean containsChainEventListener(ChainEventListener listener) {
        return this.chainEventListeners.contains(listener);
    }

    private void removeListenerFromChain(ChainEventListener listener, ChainData chainData) {
        ChainGroupData[] otherGroups = null;
        boolean foundOtherGroupWithListener = false;
        try {
            otherGroups = this.framework.getAllChainGroups(chainData.getName());
            foundOtherGroupWithListener = false;
            int i = 0;
            for (i = 0; i < otherGroups.length; ++i) {
                if (!((ChainGroupDataImpl)otherGroups[i]).containsChainEventListener(listener)) continue;
                foundOtherGroupWithListener = true;
                break;
            }
            if (!foundOtherGroupWithListener) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Removing listener from chain config, " + chainData.getName()), (Object[])new Object[0]);
                }
                ((ChainDataImpl)chainData).removeChainEventListener(listener);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Found chain " + chainData.getName() + " in another group, " + otherGroups[i].getName()), (Object[])new Object[0]);
            }
        }
        catch (ChainException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Chain not found in config: " + chainData.getName() + ", but will remove listener."), (Object[])new Object[0]);
            }
            ((ChainDataImpl)chainData).removeChainEventListener(listener);
        }
    }

    public final void addChainEventListener(ChainEventListener listener) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("addChainEventListener: " + listener), (Object[])new Object[0]);
        }
        if (null != listener && !this.getChainEventListeners().contains(listener)) {
            this.getChainEventListeners().add(listener);
            for (ChainData chain : this.getChains()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Adding listener to chain, " + chain.getName()), (Object[])new Object[0]);
                }
                ((ChainDataImpl)chain).addChainEventListener(listener);
            }
        }
    }

    public final void removeChainEventListener(ChainEventListener listener) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("removeChainEventListener: " + listener), (Object[])new Object[0]);
        }
        if (null != listener) {
            if (!this.getChainEventListeners().remove(listener) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Listener " + listener + " was not found in list monitored by group " + this.getName()), (Object[])new Object[0]);
            }
            for (ChainData chain : this.getChains()) {
                this.removeListenerFromChain(listener, chain);
            }
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("ChainGroupData:\r\n\tname = ");
        result.append(this.getName());
        result.append("\r\n\tchainconfigs:");
        for (ChainData chain : this.getChains()) {
            result.append("\r\n\t\t");
            result.append(chain.getName());
        }
        return result.toString();
    }
}

