/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics.internal.cdi30.interceptors;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.astefanutti.metrics.cdi30.MetricResolver;
import io.openliberty.microprofile.metrics.internal.cdi30.helper.Utils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import javax.annotation.Priority;
import javax.enterprise.inject.Intercepted;
import javax.enterprise.inject.spi.Bean;
import javax.inject.Inject;
import javax.interceptor.AroundConstruct;
import javax.interceptor.AroundInvoke;
import javax.interceptor.AroundTimeout;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.annotation.Metered;

@Metered
@Interceptor
@Priority(value=1010)
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MeteredInterceptor {
    private final Bean<?> bean;
    private final MetricRegistry registry;
    private final MetricResolver resolver;
    static final long serialVersionUID = -5026176026411568619L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Inject
    private MeteredInterceptor(@Intercepted Bean<?> bean, MetricRegistry registry, MetricResolver resolver) {
        this.bean = bean;
        this.registry = registry;
        this.resolver = resolver;
    }

    @AroundConstruct
    private Object meteredConstructor(InvocationContext context) throws Exception {
        return this.meteredCallable(context, context.getConstructor());
    }

    @AroundInvoke
    private Object meteredMethod(InvocationContext context) throws Exception {
        return this.meteredCallable(context, context.getMethod());
    }

    @AroundTimeout
    private Object meteredTimeout(InvocationContext context) throws Exception {
        return this.meteredCallable(context, context.getMethod());
    }

    /*
     * WARNING - void declaration
     */
    private <E extends Member & AnnotatedElement> Object meteredCallable(InvocationContext context, E element) throws Exception {
        MetricResolver.Of<Metered> metered = this.resolver.metered(this.bean.getBeanClass(), element);
        MetricID tmid = new MetricID(metered.metricName(), Utils.tagsToTags(metered.tags()));
        Meter meter = (Meter)this.registry.getMetric(tmid);
        if (meter == null) {
            try {
                throw new IllegalStateException("No meter with metricID [" + tmid + "] found in registry [" + this.registry + "]");
            }
            catch (IllegalStateException illegalStateException) {
                void exception;
                FFDCFilter.processException((Throwable)illegalStateException, (String)"io.openliberty.microprofile.metrics.internal.cdi30.interceptors.MeteredInterceptor", (String)"95", (Object)this, (Object[])new Object[]{context, element});
                throw exception;
            }
        }
        meter.mark();
        return context.proceed();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.metrics.internal.cdi30.interceptors.MeteredInterceptor", MeteredInterceptor.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.cdi.resources.MetricsCDI");
    }
}

