/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.config.CacheEntryReceiver;
import com.ibm.ws.cache.config.CacheId;
import com.ibm.ws.cache.config.CacheInstance;
import com.ibm.ws.cache.config.Component;
import com.ibm.ws.cache.config.ConfigEntry;
import com.ibm.ws.cache.config.DependencyId;
import com.ibm.ws.cache.config.ElementHandler;
import com.ibm.ws.cache.config.Field;
import com.ibm.ws.cache.config.Invalidation;
import com.ibm.ws.cache.config.Method;
import com.ibm.ws.cache.config.NotValue;
import com.ibm.ws.cache.config.Property;
import com.ibm.ws.cache.config.Range;
import com.ibm.ws.cache.config.RuleHandler;
import com.ibm.ws.cache.config.SkipCacheAttributeReceiver;
import com.ibm.ws.cache.config.Value;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.xml.sax.Attributes;

public class CacheHandler
extends ElementHandler
implements CacheEntryReceiver,
SkipCacheAttributeReceiver {
    private static TraceComponent tc = Tr.register(CacheHandler.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    protected String displayName;
    protected String description;
    private final ArrayList cacheInstances;
    private final ArrayList cacheEntries;
    private ArrayList groups;
    private final HashMap appContext;
    private String appName;
    private String filename;
    private String skipCacheAttribute;
    String[][] invalidClassComponentType = new String[][]{{"command", "parameter"}, {"command", "session"}, {"command", "cookie"}, {"command", "attribute"}, {"command", "header"}, {"command", "pathinfo"}, {"command", "servletpath"}, {"command", "locale"}, {"command", "body"}, {"command", "SOAPAction"}, {"command", "SOAPEnvelope"}, {"command", "serviceOperation"}, {"command", "serviceOperationParameter"}, {"command", "requestType"}, {"command", "portletSession"}, {"command", "portletWindowId"}, {"command", "portletMode"}, {"command", "portletWindowState"}, {"command", "sessionId"}, {"webservice", "portletSession"}, {"webservice", "portletWindowId"}, {"webservice", "portletMode"}, {"webservice", "portletWindowState"}, {"servlet", "method"}, {"servlet", "field"}, {"servlet", "body"}, {"servlet", "SOAPAction"}, {"servlet", "SOAPEnvelope"}, {"servlet", "serviceOperation"}, {"servlet", "serviceOperationParameter"}, {"servlet", "portletSession"}, {"servlet", "portletWindowId"}, {"servlet", "portletMode"}, {"servlet", "portletWindowState"}, {"static", "method"}, {"static", "field"}, {"static", "body"}, {"static", "SOAPAction"}, {"static", "SOAPEnvelope"}, {"static", "serviceOperation"}, {"static", "serviceOperationParameter"}, {"static", "portletSession"}, {"static", "portletWindowId"}, {"static", "portletMode"}, {"static", "portletWindowState"}, {"static", "sessionId"}, {"portlet", "method"}, {"portlet", "field"}, {"portlet", "body"}, {"portlet", "SOAPAction"}, {"portlet", "SOAPEnvelope"}, {"portlet", "SOAPHeaderEntry"}, {"portlet", "operation"}, {"portlet", "part"}, {"portlet", "serviceOperation"}, {"portlet", "serviceOperationParameter"}, {"portlet", "cookie"}, {"portlet", "pathinfo"}, {"portlet", "servletpath"}, {"portlet", "tiles_attribute"}};
    String[][] invalidClassProperty = new String[][]{{"servlet", "delay-invalidations"}, {"portlet", "delay-invalidations"}, {"portlet", "edgecacheable"}, {"portlet", "edgeable"}, {"portlet", "externalcache"}, {"portlet", "alternate_url"}, {"command", "edgeable"}, {"command", "externalcache"}, {"command", "consume-subfragments"}, {"command", "do-not-consume"}, {"webservice", "delay-invalidations"}, {"webservice", "edgecacheable"}, {"webservice", "edgeable"}, {"webservice", "externalcache"}};

    public CacheHandler(String appName, HashMap appContext) {
        this.appName = appName;
        this.appContext = appContext;
        this.cacheEntries = new ArrayList();
        this.cacheInstances = new ArrayList();
    }

    @Override
    public void finished() {
        Iterator it = this.cacheEntries.iterator();
        if (this.skipCacheAttribute != null) {
            while (it.hasNext()) {
                ConfigEntry ce = (ConfigEntry)it.next();
                if (ce.instanceName == null) {
                    ce.skipCacheAttribute = this.skipCacheAttribute;
                }
                ce.appName = this.appName;
            }
        }
    }

    @Override
    public void addCacheEntry(ConfigEntry ce) {
        ce.appName = this.appName;
        this.cacheEntries.add(ce);
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public ArrayList getEntries() {
        return this.cacheEntries;
    }

    public ArrayList getInstances() {
        return this.cacheInstances;
    }

    @Override
    public void addRules(RuleHandler ruleHandler) {
        ruleHandler.addRule("display-name", new DisplayNameHandler());
        ruleHandler.addRule("description", new DescriptionHandler());
        ruleHandler.addRule("cache-instance", new CacheInstanceHandler());
        ruleHandler.addRule("cache-entry", new CacheEntryHandler(this));
        ruleHandler.addRule("group", new GroupHandler());
        ruleHandler.addRule("skip-cache-attribute", new SkipCacheAttributeHandler(this));
    }

    private void checkInvalidClassProperty(String className, String propertyName) {
        boolean isInvalidCombination;
        if (className != null && propertyName != null && (isInvalidCombination = this.walkInvalidList(className, propertyName, this.invalidClassProperty))) {
            Tr.error((TraceComponent)tc, (String)"DYNA0050E", (Object[])new Object[]{"'" + propertyName + "'", "'" + className + "'"});
            Tr.error((TraceComponent)tc, (String)"dynacache.configerror", (Object[])new Object[]{this.filename});
        }
    }

    private void checkInvalidClassComponentType(String className, String componentType) {
        boolean isInvalidCombination;
        if (className != null && componentType != null && (isInvalidCombination = this.walkInvalidList(className, componentType, this.invalidClassComponentType))) {
            Tr.error((TraceComponent)tc, (String)"DYNA0050E", (Object[])new Object[]{"'" + componentType + "'", "'" + className + "'"});
            Tr.error((TraceComponent)tc, (String)"dynacache.configerror", (Object[])new Object[]{this.filename});
        }
    }

    private boolean walkInvalidList(String className, String name, String[][] list) {
        boolean isInvalidCombination = false;
        for (int i = 0; i != list.length; ++i) {
            if (!className.equalsIgnoreCase(list[i][0]) || !name.equalsIgnoreCase(list[i][1])) continue;
            isInvalidCombination = true;
            break;
        }
        return isInvalidCombination;
    }

    @Override
    public void addSkipCacheAttribute(String s) {
        this.skipCacheAttribute = s;
    }

    private class DisplayNameHandler
    extends ElementHandler {
        private DisplayNameHandler() {
        }

        @Override
        public void finished() {
            CacheHandler.this.displayName = this.getCharacters();
        }

        public String toString() {
            return "<display-name>";
        }
    }

    private class DescriptionHandler
    extends ElementHandler {
        private DescriptionHandler() {
        }

        @Override
        public void finished() {
            CacheHandler.this.description = this.getCharacters();
        }

        public String toString() {
            return "<description>";
        }
    }

    private class CacheInstanceHandler
    extends ElementHandler
    implements CacheEntryReceiver,
    SkipCacheAttributeReceiver {
        protected String name;
        protected ArrayList configEntries = new ArrayList();
        protected String skipCacheAttribute;

        public CacheInstanceHandler() {
            this.reset();
        }

        public String toString() {
            return "<cache-instance>";
        }

        public void reset() {
            this.name = null;
            this.configEntries = new ArrayList();
            this.skipCacheAttribute = null;
        }

        @Override
        public void startElement(String uri, String name, String qName, Attributes attrs) {
            this.name = attrs.getValue("name");
            if (this.name == null) {
                Tr.error((TraceComponent)tc, (String)"DYNA0030E", (Object[])new Object[]{"cache-instance", "name"});
            }
        }

        @Override
        public void finished() {
            CacheInstance ci = new CacheInstance();
            ci.name = this.name;
            for (ConfigEntry ce : this.configEntries) {
                ce.instanceName = this.name;
                ce.skipCacheAttribute = this.skipCacheAttribute;
            }
            ci.configEntries = this.configEntries.toArray(new ConfigEntry[0]);
            CacheHandler.this.cacheEntries.addAll(this.configEntries);
            CacheHandler.this.cacheInstances.add(ci);
            this.reset();
        }

        @Override
        public void addRules(RuleHandler ruleHandler) {
            ruleHandler.addRule("cache-entry", new CacheEntryHandler(this));
            ruleHandler.addRule("skip-cache-attribute", new SkipCacheAttributeHandler(this));
        }

        @Override
        public void addCacheEntry(ConfigEntry ce) {
            this.configEntries.add(ce);
        }

        @Override
        public void addSkipCacheAttribute(String s) {
            this.skipCacheAttribute = s;
        }
    }

    private class CacheEntryHandler
    extends ElementHandler
    implements PropertyReceiver {
        CacheEntryReceiver receiver;
        protected String className;
        protected String name;
        protected HashSet allNames;
        protected int sharingPolicy;
        protected boolean sharingSet;
        protected HashMap properties;
        protected ArrayList cacheIds = new ArrayList();
        protected ArrayList dependencyIds = new ArrayList();
        protected ArrayList invalidations = new ArrayList();

        public CacheEntryHandler(CacheEntryReceiver receiver) {
            this.reset();
            this.receiver = receiver;
        }

        public String toString() {
            return "<cache-entry>";
        }

        public void reset() {
            this.className = null;
            this.name = null;
            this.allNames = new HashSet();
            this.sharingPolicy = 1;
            this.sharingSet = false;
            this.properties = new HashMap();
            this.cacheIds = new ArrayList();
            this.invalidations = new ArrayList();
            this.dependencyIds = new ArrayList();
            CacheHandler.this.appName = null;
        }

        @Override
        public void finished() {
            ConfigEntry ce = new ConfigEntry();
            ce.className = this.className;
            ce.name = this.generateName(this.name);
            HashSet<String> newNames = new HashSet<String>();
            Iterator it = this.allNames.iterator();
            while (it.hasNext()) {
                newNames.add(this.generateName((String)it.next()));
            }
            ce.allNames = newNames;
            ce.sharingPolicy = this.sharingSet ? this.sharingPolicy : ServerCache.getSharingPolicy();
            ce.properties = this.properties;
            ce.cacheIds = this.cacheIds.toArray(new CacheId[0]);
            ce.dependencyIds = this.dependencyIds.toArray(new DependencyId[0]);
            ce.invalidations = this.invalidations.toArray(new Invalidation[0]);
            ce.appName = CacheHandler.this.appName;
            this.receiver.addCacheEntry(ce);
            this.reset();
        }

        private String generateName(String name) {
            boolean isClass;
            Object appPrefix = null;
            boolean bl = isClass = name.indexOf(".class") != -1;
            if (isClass) {
                return this.getAppPrefixedName(name);
            }
            if (this.className.equalsIgnoreCase("command")) {
                if (!isClass) {
                    return name + ".class";
                }
                return name;
            }
            return this.getAppPrefixedName(name);
        }

        private String getAppPrefixedName(String name) {
            String appPrefix = null;
            if (CacheHandler.this.appContext != null) {
                appPrefix = (String)CacheHandler.this.appContext.get(this.className);
            }
            if (appPrefix != null) {
                if (!appPrefix.endsWith("/")) {
                    appPrefix = appPrefix + "/";
                }
                if (name.startsWith("/")) {
                    name = name.substring(1);
                }
                return appPrefix + name;
            }
            return name;
        }

        @Override
        public void addRules(RuleHandler ruleHandler) {
            ruleHandler.addRule("class", new ClassHandler());
            ruleHandler.addRule("name", new NameHandler());
            ruleHandler.addRule("sharing-policy", new SharingPolicyHandler());
            ruleHandler.addRule("property", new PropertyHandler(this));
            ruleHandler.addRule("cache-id", new CacheIdHandler());
            ruleHandler.addRule("dependency-id", new DependencyIdHandler());
            ruleHandler.addRule("invalidation", new InvalidationHandler());
        }

        @Override
        public void addProperty(Property p) {
            if (this.properties == null) {
                this.properties = new HashMap();
            }
            this.properties.put(p.name, p);
        }

        private class ClassHandler
        extends ElementHandler {
            private ClassHandler() {
            }

            @Override
            public void finished() {
                CacheEntryHandler.this.className = this.getCharacters();
            }

            public String toString() {
                return "<class>";
            }
        }

        private class NameHandler
        extends ElementHandler {
            private NameHandler() {
            }

            @Override
            public void finished() {
                String tmp = this.getCharacters();
                if (CacheEntryHandler.this.name == null) {
                    CacheEntryHandler.this.name = tmp;
                }
                CacheEntryHandler.this.allNames.add(tmp);
            }

            public String toString() {
                return "<name>";
            }
        }

        private class SharingPolicyHandler
        extends ElementHandler {
            private SharingPolicyHandler() {
            }

            @Override
            public void finished() {
                String policy = this.getCharacters().toLowerCase();
                if (policy.equals("not-shared")) {
                    CacheEntryHandler.this.sharingPolicy = 1;
                } else if (policy.equals("shared-push")) {
                    CacheEntryHandler.this.sharingPolicy = 2;
                } else if (policy.equals("shared-pull")) {
                    CacheEntryHandler.this.sharingPolicy = 3;
                } else if (policy.equals("shared-push-pull")) {
                    CacheEntryHandler.this.sharingPolicy = 4;
                } else {
                    Tr.error((TraceComponent)tc, (String)"DYNA0027E", (Object[])new Object[]{policy});
                }
                CacheEntryHandler.this.sharingSet = true;
            }

            public String toString() {
                return "<sharing-policy>";
            }
        }

        private class PropertyHandler
        extends ElementHandler {
            PropertyReceiver receiver;
            String name;
            ArrayList excludeList = new ArrayList();

            public PropertyHandler(PropertyReceiver receiver) {
                this.receiver = receiver;
            }

            public String toString() {
                return "<property>";
            }

            @Override
            public void addRules(RuleHandler ruleHandler) {
                ruleHandler.addRule("exclude", new ExcludeHandler());
            }

            public void reset() {
                this.name = null;
                this.excludeList.clear();
            }

            @Override
            public void startElement(String uri, String name, String qName, Attributes attrs) {
                String string = this.name = attrs.getValue("name") != null ? attrs.getValue("name").toLowerCase() : null;
                if (this.name == null) {
                    Tr.error((TraceComponent)tc, (String)"DYNA0030E", (Object[])new Object[]{"property", "name"});
                }
            }

            @Override
            public void finished() {
                if (this.name != null) {
                    CacheHandler.this.checkInvalidClassProperty(CacheEntryHandler.this.className, this.name);
                    if (this.name.equals("edgecacheable")) {
                        this.name = "edgeable";
                    }
                    Property p = new Property();
                    p.name = this.name;
                    if (p.name.equals("primary-storage")) {
                        String value = this.getCharacters();
                        if (value.equals("memory") || value.equals("disk")) {
                            p.value = value;
                        } else {
                            p.value = "memory";
                            Tr.error((TraceComponent)tc, (String)"DYNA1032E", (Object[])new Object[]{value});
                        }
                    } else {
                        p.value = this.getCharacters();
                    }
                    p.excludeList = this.excludeList.toArray(new String[0]);
                    this.receiver.addProperty(p);
                    this.reset();
                }
            }

            private class ExcludeHandler
            extends ElementHandler {
                private ExcludeHandler() {
                }

                public String toString() {
                    return "<exclude>";
                }

                @Override
                public void finished() {
                    String value = this.getCharacters();
                    if (PropertyHandler.this.name.equals("consume-subfragments")) {
                        boolean isClass;
                        boolean bl = isClass = value.indexOf(".class") != -1;
                        if (isClass) {
                            value = CacheEntryHandler.this.getAppPrefixedName(value);
                        }
                    }
                    PropertyHandler.this.excludeList.add(value);
                }
            }
        }

        class CacheIdHandler
        extends ElementHandler
        implements PropertyReceiver,
        ComponentReceiver {
            private String idGenerator;
            private String metaDataGenerator;
            private int timeout;
            private int inactivity;
            private int priority;
            private HashMap properties;
            private ArrayList components;
            private boolean invalidId = false;

            public CacheIdHandler() {
                this.reset();
            }

            public String toString() {
                return "<cache-id>";
            }

            @Override
            public void addRules(RuleHandler ruleHandler) {
                ruleHandler.addRule("display-name", new DisplayNameHandler());
                ruleHandler.addRule("component", new ComponentHandler(this));
                ruleHandler.addRule("idgenerator", new IdGeneratorHandler());
                ruleHandler.addRule("metadatagenerator", new MetaDataGeneratorHandler());
                ruleHandler.addRule("timeout", new TimeoutHandler());
                ruleHandler.addRule("inactivity", new InactivityHandler());
                ruleHandler.addRule("priority", new PriorityHandler());
                ruleHandler.addRule("property", new PropertyHandler(this));
            }

            public void reset() {
                this.metaDataGenerator = null;
                this.idGenerator = null;
                this.timeout = 0;
                this.priority = 0;
                this.inactivity = 0;
                this.properties = new HashMap();
                this.components = new ArrayList();
                this.invalidId = false;
            }

            @Override
            public void finished() {
                if (!this.invalidId) {
                    CacheId cacheid = new CacheId();
                    cacheid.idGenerator = this.idGenerator;
                    cacheid.metaDataGenerator = this.metaDataGenerator;
                    cacheid.timeout = this.timeout;
                    cacheid.inactivity = this.inactivity;
                    cacheid.priority = this.priority;
                    cacheid.components = this.components.toArray(new Component[0]);
                    cacheid.properties = this.properties;
                    CacheEntryHandler.this.cacheIds.add(cacheid);
                }
                this.reset();
            }

            @Override
            public void addProperty(Property p) {
                if (this.properties == null) {
                    this.properties = new HashMap();
                }
                this.properties.put(p.name, p);
            }

            @Override
            public void addComponent(Component component) {
                if (this.components == null) {
                    this.components = new ArrayList();
                }
                if (this.idGenerator != null) {
                    Tr.error((TraceComponent)tc, (String)"DYNA0028E", (Object[])new Object[]{component.id, this.idGenerator});
                    return;
                }
                this.components.add(component);
            }

            @Override
            public void setInvalidId(boolean invalidId) {
                this.invalidId = invalidId;
            }

            private class IdGeneratorHandler
            extends ElementHandler {
                private IdGeneratorHandler() {
                }

                @Override
                public void finished() {
                    if (CacheIdHandler.this.components.size() != 0) {
                        Tr.error((TraceComponent)tc, (String)"DYNA0029E", (Object[])new Object[]{this.getCharacters(), ((Component)((CacheIdHandler)CacheIdHandler.this).components.get((int)0)).id});
                        return;
                    }
                    CacheIdHandler.this.idGenerator = this.getCharacters();
                }

                public String toString() {
                    return "<idgenerator>";
                }
            }

            private class MetaDataGeneratorHandler
            extends ElementHandler {
                private MetaDataGeneratorHandler() {
                }

                @Override
                public void finished() {
                    CacheIdHandler.this.metaDataGenerator = this.getCharacters();
                }

                public String toString() {
                    return "<metadatagenerator>";
                }
            }

            private class TimeoutHandler
            extends ElementHandler {
                private TimeoutHandler() {
                }

                @Override
                public void finished() {
                    String time = this.getCharacters();
                    try {
                        CacheIdHandler.this.timeout = Integer.valueOf(time);
                    }
                    catch (Exception ex) {
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.config.CacheHandler.finished", (String)"282", (Object)this);
                        Tr.error((TraceComponent)tc, (String)"dynacache.timeout", (Object[])new Object[]{"<cache-id>", time});
                    }
                }

                public String toString() {
                    return "<timeout>";
                }
            }

            private class InactivityHandler
            extends ElementHandler {
                private InactivityHandler() {
                }

                @Override
                public void finished() {
                    String time = this.getCharacters();
                    try {
                        CacheIdHandler.this.inactivity = Integer.valueOf(time);
                    }
                    catch (Exception ex) {
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.config.CacheHandler.finished", (String)"438", (Object)this);
                        Tr.error((TraceComponent)tc, (String)"dynacache.timeout", (Object[])new Object[]{"<cache-id>", time});
                        CacheIdHandler.this.inactivity = -1;
                    }
                }

                public String toString() {
                    return "<inactivity>";
                }
            }

            private class PriorityHandler
            extends ElementHandler {
                private PriorityHandler() {
                }

                @Override
                public void finished() {
                    String pri = this.getCharacters();
                    try {
                        CacheIdHandler.this.priority = Integer.valueOf(pri);
                    }
                    catch (Exception ex) {
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.config.CacheHandler.finished", (String)"298", (Object)this);
                        Tr.error((TraceComponent)tc, (String)"dynacache.priority", (Object[])new Object[]{"<cache-id>", pri});
                    }
                }

                public String toString() {
                    return "<priority>";
                }
            }
        }

        private class DependencyIdHandler
        extends ElementHandler
        implements ComponentReceiver {
            ArrayList components = new ArrayList();
            private boolean invalidId = false;

            public String toString() {
                return "<dependency-id>";
            }

            @Override
            public void addRules(RuleHandler ruleHandler) {
                ruleHandler.addRule("component", new ComponentHandler(this));
            }

            @Override
            public void addComponent(Component component) {
                if (this.components == null) {
                    this.components = new ArrayList();
                }
                this.components.add(component);
            }

            @Override
            public void setInvalidId(boolean invalidId) {
                this.invalidId = invalidId;
            }

            public void reset() {
                this.components.clear();
                this.invalidId = false;
            }

            @Override
            public void finished() {
                if (!this.invalidId) {
                    DependencyId g = new DependencyId();
                    g.baseName = this.getCharacters().trim();
                    g.components = this.components.toArray(new Component[0]);
                    CacheEntryHandler.this.dependencyIds.add(g);
                }
                this.reset();
            }
        }

        private class InvalidationHandler
        extends ElementHandler
        implements ComponentReceiver {
            private String invalidationGenerator;
            private final ArrayList components = new ArrayList();
            private boolean invalidId = false;

            public String toString() {
                return "<invalidation>";
            }

            public void reset() {
                this.components.clear();
                this.invalidationGenerator = null;
                this.invalidId = false;
            }

            @Override
            public void finished() {
                if (!this.invalidId) {
                    Invalidation invalidation = new Invalidation();
                    invalidation.baseName = this.getCharacters();
                    invalidation.invalidationGenerator = this.invalidationGenerator;
                    invalidation.components = this.components.toArray(new Component[0]);
                    CacheEntryHandler.this.invalidations.add(invalidation);
                }
                this.reset();
            }

            @Override
            public void addRules(RuleHandler ruleHandler) {
                ruleHandler.addRule("invalidationgenerator", new InvalidationGeneratorHandler());
                ruleHandler.addRule("component", new ComponentHandler(this));
            }

            @Override
            public void addComponent(Component component) {
                if (this.invalidationGenerator != null) {
                    Tr.error((TraceComponent)tc, (String)"DYNA0028E", (Object[])new Object[]{component.id, this.invalidationGenerator});
                    return;
                }
                this.components.add(component);
            }

            @Override
            public void setInvalidId(boolean invalidId) {
                this.invalidId = invalidId;
            }

            private class InvalidationGeneratorHandler
            extends ElementHandler {
                private InvalidationGeneratorHandler() {
                }

                @Override
                public void finished() {
                    if (InvalidationHandler.this.components.size() != 0) {
                        Tr.error((TraceComponent)tc, (String)"DYNA0029E", (Object[])new Object[]{this.getCharacters(), ((Component)((InvalidationHandler)InvalidationHandler.this).components.get((int)0)).id});
                        return;
                    }
                    InvalidationHandler.this.invalidationGenerator = this.getCharacters();
                }

                public String toString() {
                    return "<invalidationGenerator>";
                }
            }
        }

        private class ComponentHandler
        extends ElementHandler
        implements MethodReceiver,
        FieldReceiver {
            private String type;
            private String id;
            private boolean ignoreValue;
            private boolean multipleIds;
            private Method method;
            private Field field;
            private int index = -1;
            private boolean required;
            private HashMap values;
            private HashMap notValues;
            private ArrayList valueRanges;
            private ArrayList notValueRanges;
            private boolean invalidComponent = false;
            private final ComponentReceiver receiver;

            public ComponentHandler(ComponentReceiver receiver) {
                this.receiver = receiver;
                this.reset();
            }

            public String toString() {
                return "<component>";
            }

            public void reset() {
                this.type = null;
                this.id = null;
                this.ignoreValue = false;
                this.multipleIds = false;
                this.method = null;
                this.index = -1;
                this.required = true;
                this.values = new HashMap();
                this.notValues = new HashMap();
                this.valueRanges = new ArrayList();
                this.notValueRanges = new ArrayList();
                this.invalidComponent = false;
            }

            @Override
            public void startElement(String uri, String name, String qName, Attributes attrs) {
                this.type = attrs.getValue("type");
                this.id = attrs.getValue("id");
                try {
                    String ignore = attrs.getValue("ignore-value");
                    if (ignore != null) {
                        this.ignoreValue = Boolean.valueOf(ignore);
                    }
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.config.CacheHandler.startElement", (String)"403", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"DYNA0032E", (Object[])new Object[]{"ignore-value", attrs.getValue("ignore-value")});
                }
                try {
                    String multiIds = attrs.getValue("multipleIDs");
                    if (multiIds != null) {
                        this.multipleIds = Boolean.valueOf(multiIds);
                    }
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.config.CacheHandler.startElement", (String)"403", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"DYNA0032E", (Object[])new Object[]{"multipleIDs", attrs.getValue("multipleIDs")});
                }
                if (this.id == null) {
                    Tr.error((TraceComponent)tc, (String)"DYNA0030E", (Object[])new Object[]{"component", "id"});
                }
                if (this.type == null) {
                    Tr.error((TraceComponent)tc, (String)"DYNA0030E", (Object[])new Object[]{"component", "type"});
                }
            }

            @Override
            public void addMethod(Method m) {
                if (this.method != null || this.field != null) {
                    Tr.error((TraceComponent)tc, (String)"DYNA0031E", (Object[])new Object[]{"method", m.name});
                    return;
                }
                this.method = m;
            }

            @Override
            public void addField(Field f) {
                if (this.method != null || this.field != null) {
                    Tr.error((TraceComponent)tc, (String)"DYNA0031E", (Object[])new Object[]{"field", f.name});
                    return;
                }
                this.field = f;
            }

            @Override
            public void addRules(RuleHandler ruleHandler) {
                ruleHandler.addRule("method", new MethodHandler(this));
                ruleHandler.addRule("field", new FieldHandler(this));
                ruleHandler.addRule("index", new IndexHandler());
                ruleHandler.addRule("required", new RequiredHandler());
                ruleHandler.addRule("value", new ValueHandler());
                ruleHandler.addRule("not-value", new NotValueHandler());
            }

            @Override
            public void finished() {
                if (!this.invalidComponent) {
                    if (this.id == null || this.type == null) {
                        return;
                    }
                    Component c = new Component();
                    c.type = this.type;
                    c.id = this.id;
                    c.ignoreValue = this.ignoreValue;
                    c.multipleIds = this.multipleIds;
                    c.method = this.method;
                    c.field = this.field;
                    c.index = this.index;
                    c.required = this.required;
                    c.values = this.values;
                    c.notValues = this.notValues;
                    c.valueRanges = this.valueRanges;
                    c.notValueRanges = this.notValueRanges;
                    c.validate();
                    this.receiver.addComponent(c);
                    CacheHandler.this.checkInvalidClassComponentType(CacheEntryHandler.this.className, this.type);
                } else {
                    this.receiver.setInvalidId(true);
                }
                this.reset();
            }

            private class MethodHandler
            extends ElementHandler
            implements MethodReceiver,
            FieldReceiver {
                MethodReceiver receiver;
                Method method = null;
                Field field = null;
                int index = -1;

                public MethodHandler(MethodReceiver receiver) {
                    this.receiver = receiver;
                }

                public String toString() {
                    return "<method>";
                }

                @Override
                public void addRules(RuleHandler ruleHandler) {
                    ruleHandler.addRule("method", new MethodHandler(this));
                    ruleHandler.addRule("field", new FieldHandler(this));
                    ruleHandler.addRule("index", new IndexHandler());
                }

                @Override
                public void addMethod(Method m) {
                    if (this.method != null || this.field != null) {
                        Tr.error((TraceComponent)tc, (String)"DYNA0031E", (Object[])new Object[]{"method", m.name});
                        return;
                    }
                    this.method = m;
                }

                @Override
                public void addField(Field f) {
                    if (this.method != null || this.field != null) {
                        Tr.error((TraceComponent)tc, (String)"DYNA0031E", (Object[])new Object[]{"field", f.name});
                        return;
                    }
                    this.field = f;
                }

                @Override
                public void finished() {
                    Method newMethod = new Method();
                    newMethod.name = this.getCharacters();
                    newMethod.method = this.method;
                    newMethod.field = this.field;
                    newMethod.index = this.index;
                    this.receiver.addMethod(newMethod);
                }
            }

            private class FieldHandler
            extends ElementHandler
            implements MethodReceiver,
            FieldReceiver {
                FieldReceiver receiver;
                Method method = null;
                Field field = null;
                int index = -1;

                public FieldHandler(FieldReceiver receiver) {
                    this.receiver = receiver;
                }

                public String toString() {
                    return "<field>";
                }

                @Override
                public void addRules(RuleHandler ruleHandler) {
                    ruleHandler.addRule("method", new MethodHandler(this));
                    ruleHandler.addRule("field", new FieldHandler(this));
                    ruleHandler.addRule("index", new IndexHandler());
                }

                @Override
                public void addMethod(Method m) {
                    if (this.method != null || this.field != null) {
                        Tr.error((TraceComponent)tc, (String)"DYNA0031E", (Object[])new Object[]{"method", m.name});
                        return;
                    }
                    this.method = m;
                }

                @Override
                public void addField(Field f) {
                    if (this.method != null || this.field != null) {
                        Tr.error((TraceComponent)tc, (String)"DYNA0031E", (Object[])new Object[]{"field", f.name});
                        return;
                    }
                    this.field = f;
                }

                @Override
                public void finished() {
                    Field newField = new Field();
                    newField.name = this.getCharacters();
                    newField.method = this.method;
                    newField.field = this.field;
                    newField.index = this.index;
                    this.receiver.addField(newField);
                }
            }

            private class IndexHandler
            extends ElementHandler {
                private IndexHandler() {
                }

                @Override
                public void finished() {
                    String ind = this.getCharacters();
                    try {
                        ComponentHandler.this.index = Integer.valueOf(ind);
                    }
                    catch (Exception ex) {
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.config.CacheHandler.finished", (String)"298", (Object)this);
                        Tr.error((TraceComponent)tc, (String)"dynacache.priority", (Object[])new Object[]{"<component>", ind});
                    }
                }

                public String toString() {
                    return "<index>";
                }
            }

            private class RequiredHandler
            extends ElementHandler {
                private RequiredHandler() {
                }

                @Override
                public void finished() {
                    String req = this.getCharacters();
                    try {
                        if (req != null) {
                            ComponentHandler.this.required = Boolean.valueOf(req);
                        }
                    }
                    catch (Exception ex) {
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.config.CacheHandler.finished", (String)"547", (Object)this);
                        Tr.error((TraceComponent)tc, (String)"DYNA0032E", (Object[])new Object[]{"required", req});
                    }
                }

                public String toString() {
                    return "<required>";
                }
            }

            private class ValueHandler
            extends ElementHandler
            implements RangeReceiver {
                ArrayList ranges = new ArrayList();

                private ValueHandler() {
                }

                public String toString() {
                    return "<value>";
                }

                @Override
                public void addRules(RuleHandler ruleHandler) {
                    ruleHandler.addRule("range", new RangeHandler(this));
                }

                @Override
                public void addRange(Range r) {
                    this.ranges.add(r);
                }

                @Override
                public void finished() {
                    if (!this.getCharacters().equals("")) {
                        Value val = new Value();
                        val.value = this.getCharacters();
                        ComponentHandler.this.values.put(val.value, val);
                    }
                    if (this.ranges != null) {
                        Iterator it = this.ranges.iterator();
                        while (it.hasNext()) {
                            ComponentHandler.this.valueRanges.add(it.next());
                        }
                    }
                    this.reset();
                }

                public void reset() {
                    this.ranges.clear();
                }
            }

            private class NotValueHandler
            extends ElementHandler
            implements RangeReceiver {
                ArrayList ranges = new ArrayList();

                private NotValueHandler() {
                }

                public String toString() {
                    return "<not-value>";
                }

                @Override
                public void addRules(RuleHandler ruleHandler) {
                    ruleHandler.addRule("range", new RangeHandler(this));
                }

                @Override
                public void addRange(Range r) {
                    this.ranges.add(r);
                }

                @Override
                public void finished() {
                    if (!this.getCharacters().equals("")) {
                        NotValue notVal = new NotValue();
                        notVal.notValue = this.getCharacters();
                        ComponentHandler.this.notValues.put(notVal.notValue, notVal);
                    }
                    if (this.ranges != null) {
                        Iterator it = this.ranges.iterator();
                        while (it.hasNext()) {
                            ComponentHandler.this.notValueRanges.add(it.next());
                        }
                    }
                    this.reset();
                }

                public void reset() {
                    this.ranges.clear();
                }
            }

            private class RangeHandler
            extends ElementHandler {
                private String low;
                private String high;
                private final RangeReceiver receiver;

                public RangeHandler(RangeReceiver receiver) {
                    this.receiver = receiver;
                    this.reset();
                }

                @Override
                public void startElement(String uri, String name, String qName, Attributes attrs) {
                    this.low = attrs.getValue("low");
                    this.high = attrs.getValue("high");
                    if (this.low == null) {
                        Tr.error((TraceComponent)tc, (String)"DYNA0030E", (Object[])new Object[]{"range", "low"});
                    }
                    if (this.high == null) {
                        Tr.error((TraceComponent)tc, (String)"DYNA0030E", (Object[])new Object[]{"range", "high"});
                    }
                }

                public String toString() {
                    return "<range>";
                }

                @Override
                public void finished() {
                    Range range = new Range();
                    try {
                        range.low = Integer.parseInt(this.low);
                        range.high = Integer.parseInt(this.high);
                        if (range.low <= range.high) {
                            this.receiver.addRange(range);
                        } else {
                            Tr.error((TraceComponent)tc, (String)"DYNA1031E", (Object[])new Object[]{"'" + this.low + "'", "'" + this.high + "'"});
                            ComponentHandler.this.invalidComponent = true;
                        }
                    }
                    catch (Exception ex) {
                        Tr.error((TraceComponent)tc, (String)"DYNA1030E", (Object[])new Object[]{"'" + this.low + "'", "'" + this.high + "'"});
                        ComponentHandler.this.invalidComponent = true;
                    }
                    this.reset();
                }

                public void reset() {
                    this.low = null;
                    this.high = null;
                }
            }
        }
    }

    private class GroupHandler
    extends ElementHandler {
        public GroupHandler() {
            this.reset();
        }

        public String toString() {
            return "<group>";
        }

        public void reset() {
        }

        @Override
        public void finished() {
        }

        @Override
        public void addRules(RuleHandler ruleHandler) {
            ruleHandler.addRule("description", new DescriptionHandler());
        }

        @Override
        public void startElement(String uri, String name, String qName, Attributes attrs) {
            String nameFromAttrs = attrs.getValue("name");
            if (nameFromAttrs == null) {
                Tr.error((TraceComponent)tc, (String)"DYNA0030E", (Object[])new Object[]{"group", "name"});
            }
        }
    }

    private class SkipCacheAttributeHandler
    extends ElementHandler {
        SkipCacheAttributeReceiver receiver = null;

        public SkipCacheAttributeHandler(SkipCacheAttributeReceiver receiver) {
            this.receiver = receiver;
        }

        public String toString() {
            return "<skip-cache-attribute>";
        }

        @Override
        public void finished() {
            this.receiver.addSkipCacheAttribute(this.getCharacters());
        }
    }

    private static interface FieldReceiver {
        public void addField(Field var1);
    }

    private static interface MethodReceiver {
        public void addMethod(Method var1);
    }

    private static interface RangeReceiver {
        public void addRange(Range var1);
    }

    private static interface ComponentReceiver {
        public void addComponent(Component var1);

        public void setInvalidId(boolean var1);
    }

    private static interface PropertyReceiver {
        public void addProperty(Property var1);
    }
}

