/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.document;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.configuration.JspConfiguration;
import com.ibm.ws.jsp.translator.JspTranslationException;
import com.ibm.ws.jsp.translator.document.Jsp2Dom;
import com.ibm.ws.jsp.translator.visitor.xml.ParserFactory;
import com.ibm.ws.util.WSUtil;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import com.ibm.wsspi.jsp.resource.JspInputSource;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.util.EncodingUtils;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class JspPageParser {
    private static final int EXPRESSION_ELEMENT = 1;
    private static final int DECLARATION_ELEMENT = 2;
    private static final int SCRIPTLET_ELEMENT = 3;
    private static final int DIRECTIVE_ELEMENT = 4;
    private static final int COMMENT_ELEMENT = 5;
    private static final String WEB_INF_TAGS = "/WEB-INF/tags";
    protected Reader jspReader = null;
    protected StringBuffer templateText = new StringBuffer();
    protected int currentLineNum = 1;
    protected int currentColumnNum = 0;
    protected int textCurrLineNum = 1;
    protected int textCurrColNum = 1;
    protected int jspSyntaxLineNum = 1;
    protected int jspSyntaxColNum = 1;
    protected int actionLineCount = 1;
    protected JspInputSource inputSource = null;
    protected String resolvedRelativeURL = null;
    protected String encodedRelativeURL = null;
    protected Stack elements = new Stack();
    protected HashMap<String, String> tagPrefixes = new HashMap();
    protected HashMap<String, String> nonCustomTagPrefixMap = new HashMap();
    protected Document jspDocument = null;
    protected Element jspRootElement = null;
    protected JspCoreContext context = null;
    protected JspConfiguration jspConfiguration = null;
    protected JspOptions jspOptions = null;
    protected Stack directoryStack = null;
    protected Stack dependencyStack = null;
    protected List dependencyList = null;
    protected Map cdataJspIdMap = null;
    protected Map implicitTagLibMap = null;
    protected boolean pageEncodingSpecified = false;
    static final long serialVersionUID = -3482120669237606629L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public JspPageParser(Reader jspReader, JspInputSource inputSource, String resolvedRelativeURL, JspCoreContext context, Stack directoryStack, JspConfiguration jspConfiguration, JspOptions jspOptions, Stack dependencyStack, List dependencyList, Map cdataJspIdMap, Map implicitTagLibMap) throws JspCoreException {
        this.jspReader = jspReader;
        this.inputSource = inputSource;
        this.resolvedRelativeURL = resolvedRelativeURL;
        try {
            this.encodedRelativeURL = URLEncoder.encode(resolvedRelativeURL, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new JspCoreException(e);
        }
        this.context = context;
        this.directoryStack = directoryStack;
        this.jspConfiguration = jspConfiguration;
        this.jspOptions = jspOptions;
        this.dependencyStack = dependencyStack;
        this.dependencyList = dependencyList;
        this.cdataJspIdMap = cdataJspIdMap;
        this.implicitTagLibMap = implicitTagLibMap;
        try {
            this.jspDocument = ParserFactory.newDocument(false, false);
            this.jspRootElement = this.jspDocument.createElementNS("http://java.sun.com/JSP/Page", "jsp:root");
            this.jspRootElement.setAttributeNS("http://java.sun.com/JSP/Page", "jsp:id", this.encodedRelativeURL + "[0,1,1]");
            this.jspDocument.appendChild(this.jspRootElement);
            this.elements.push(this.jspRootElement);
        }
        catch (ParserConfigurationException e) {
            throw new JspCoreException(e);
        }
        if (this.implicitTagLibMap != null && this.implicitTagLibMap.size() > 0) {
            this.tagPrefixes.putAll(implicitTagLibMap);
        }
    }

    public Document parse() throws JspCoreException {
        try {
            if (this.jspConfiguration.getPreludeList().size() > 0) {
                this.insertImplictIncludes(this.jspConfiguration.getPreludeList());
            }
            int character = 0;
            block7: while ((character = this.readCharacter()) != -1) {
                switch (character) {
                    case 60: {
                        this.jspSyntaxLineNum = this.currentLineNum;
                        this.jspSyntaxColNum = this.currentColumnNum;
                        this.processJspSyntax();
                        continue block7;
                    }
                }
                this.templateText.append((char)character);
            }
            this.processTemplateText();
            this.jspRootElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:jsp", "http://java.sun.com/JSP/Page");
            this.jspRootElement.setAttribute("version", "2.0");
            for (String prefix : this.tagPrefixes.keySet()) {
                String uri = this.tagPrefixes.get(prefix);
                try {
                    this.jspRootElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, uri);
                }
                catch (DOMException e) {
                    throw new JspCoreException("jsp.error.unable.to.create.xml.attr", new Object[]{"xmlns:" + prefix, uri}, e);
                }
            }
            if (this.jspConfiguration.getCodaList().size() > 0) {
                this.insertImplictIncludes(this.jspConfiguration.getCodaList());
            }
            if (this.elements.size() > 1) {
                Element unmatchedElement = (Element)this.elements.peek();
                throw new JspCoreException("jsp.error.unmatched.tag", new Object[]{unmatchedElement.getNodeName()});
            }
        }
        catch (IOException e) {
            throw new JspCoreException(e);
        }
        return this.jspDocument;
    }

    protected void processJspSyntax() throws IOException, JspCoreException {
        char c = (char)this.readNextCharacter();
        if (c == '!') {
            this.readCharacter();
            int[] chars = this.readAhead(2);
            if (chars[0] == 45 && chars[1] == 45) {
                this.processHtmlCommment();
                this.textCurrLineNum = this.currentLineNum;
                this.textCurrColNum = this.currentColumnNum + 1;
            } else {
                this.templateText.append("<!");
            }
        } else if (c == '%') {
            this.readCharacter();
            this.processElement();
            this.textCurrLineNum = this.currentLineNum;
            this.textCurrColNum = this.currentColumnNum + 1;
        } else {
            this.processAction();
        }
    }

    protected void processTemplateText() {
        if (this.templateText.length() > 0) {
            int lineCount = 1;
            for (int i = 0; i < this.templateText.length(); ++i) {
                if (this.templateText.charAt(i) != '\n') continue;
                ++lineCount;
            }
            CDATASection cdata = this.jspDocument.createCDATASection(this.templateText.toString());
            if (!this.elements.empty()) {
                Element parentElement = (Element)this.elements.peek();
                parentElement.appendChild(cdata);
            }
            if (this.templateText.toString().trim().length() > 0) {
                String jspId = this.encodedRelativeURL + "[" + this.textCurrLineNum + "," + this.textCurrColNum + "," + lineCount + "]";
                this.cdataJspIdMap.put(new Integer(cdata.hashCode()), jspId);
            }
            this.templateText.delete(0, this.templateText.length());
        }
    }

    protected void processElement() throws IOException, JspCoreException {
        this.processTemplateText();
        int character = this.readNextCharacter();
        switch (character) {
            case 64: {
                this.readCharacter();
                this.processDirective();
                break;
            }
            case 45: {
                this.readCharacter();
                this.processJspComment();
                break;
            }
            case 61: {
                this.readCharacter();
                this.processScriptingElement(1);
                break;
            }
            case 33: {
                this.readCharacter();
                this.processScriptingElement(2);
                break;
            }
            default: {
                this.processScriptingElement(3);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processAction() throws IOException, JspCoreException {
        boolean endFound = false;
        StringBuffer actionText = new StringBuffer();
        actionText.append('<');
        StringBuffer actionPrefixBuffer = new StringBuffer();
        StringBuffer actionNameBuffer = new StringBuffer();
        boolean inName = false;
        int character = 0;
        this.actionLineCount = 1;
        boolean endOfFile = false;
        while (!endFound) {
            int nextChar = this.readNextCharacter();
            if (nextChar == 60) {
                endFound = true;
                break;
            }
            character = this.readCharacter();
            switch (character) {
                case -1: {
                    endOfFile = true;
                    break;
                }
                case 58: {
                    inName = true;
                    break;
                }
                case 62: {
                    endFound = true;
                    break;
                }
                case 9: 
                case 13: 
                case 32: {
                    StringBuffer sb = new StringBuffer();
                    sb.append((char)character);
                    if (this.readNextNonWhite(sb) != 62) {
                        if (inName) {
                            endFound = true;
                        } else if (actionPrefixBuffer.toString().trim().length() > 0) {
                            endFound = true;
                        }
                    }
                    if (sb.length() <= 0) break;
                    character = sb.charAt(sb.length() - 1);
                    actionText.append(sb.deleteCharAt(sb.length() - 1));
                    break;
                }
                case 10: {
                    StringBuffer sb = new StringBuffer();
                    sb.append((char)character);
                    if (this.readNextNonWhite(sb) != 62) {
                        if (inName) {
                            endFound = true;
                        } else if (actionPrefixBuffer.toString().trim().length() > 0) {
                            endFound = true;
                        }
                    }
                    if (sb.length() > 0) {
                        character = sb.charAt(sb.length() - 1);
                        actionText.append(sb.deleteCharAt(sb.length() - 1));
                    }
                    ++this.actionLineCount;
                    break;
                }
                default: {
                    if (inName) {
                        actionNameBuffer.append((char)character);
                        break;
                    }
                    actionPrefixBuffer.append((char)character);
                }
            }
            if (endOfFile) break;
            actionText.append((char)character);
        }
        boolean isEndTag = false;
        boolean hasChildren = false;
        boolean doIncrement = false;
        String actionPrefix = actionPrefixBuffer.toString().trim();
        String actionName = actionNameBuffer.toString().trim();
        if (actionPrefix.startsWith("/")) {
            actionPrefix = actionPrefix.substring(1);
            isEndTag = true;
        }
        if (actionName.endsWith("/")) {
            actionName = actionName.substring(0, actionName.length() - 1);
        } else {
            hasChildren = true;
        }
        if (inName && (actionPrefix.equals("jsp") || this.tagPrefixes.containsKey(actionPrefix))) {
            block42: {
                if (endOfFile) {
                    throw new JspCoreException("jsp.error.end.of.file.reached", new Object[]{"<" + actionPrefixBuffer.toString().trim() + " " + actionNameBuffer.toString().trim(), "Line " + this.jspSyntaxLineNum + " Col " + this.jspSyntaxColNum});
                }
                this.processTemplateText();
                if (isEndTag) {
                    Element element = (Element)this.elements.pop();
                    String jspId = element.getAttributeNS("http://java.sun.com/JSP/Page", "id");
                    jspId = jspId + "[" + this.jspSyntaxLineNum + "," + this.jspSyntaxColNum + "]";
                    if (element.getPrefix().equals(actionPrefix) && element.getLocalName().equals(actionName)) {
                        element.setAttributeNS("http://java.sun.com/JSP/Page", "jsp:id", jspId);
                        break block42;
                    } else {
                        if (!this.jspOptions.isAllowUnmatchedEndTag()) {
                            throw new JspCoreException("jsp.error.unmatched.end.tag", new Object[]{element.getNodeName(), actionPrefix + ":" + actionName, "[" + this.currentLineNum + "," + this.currentColumnNum + "]"});
                        }
                        this.templateText.append(actionText.toString());
                        this.elements.push(element);
                        return;
                    }
                }
                String namespaceURI = "http://java.sun.com/JSP/Page";
                if (!actionPrefix.equals("jsp")) {
                    namespaceURI = this.tagPrefixes.get(actionPrefix);
                    if (namespaceURI.startsWith("urn:jsptld:")) {
                        namespaceURI = namespaceURI.substring(namespaceURI.indexOf("urn:jsptld:") + 11);
                    } else if (namespaceURI.startsWith("urn:jsptagdir:")) {
                        namespaceURI = namespaceURI.substring(namespaceURI.indexOf("urn:jsptagdir:") + 14);
                    }
                }
                Element actionElement = null;
                try {
                    actionElement = this.jspDocument.createElementNS(namespaceURI, actionPrefix + ":" + actionName.trim());
                }
                catch (DOMException e) {
                    throw new JspCoreException("jsp.error.unable.to.create.xml.element", new Object[]{namespaceURI, actionPrefix + ":" + actionName.trim()}, e);
                }
                if (!this.elements.empty()) {
                    Element parentElement = (Element)this.elements.peek();
                    if (!actionName.equals("directive.include")) {
                        parentElement.appendChild(actionElement);
                    }
                }
                if (character != 62) {
                    hasChildren = this.processActionAttributes(actionElement);
                }
                if (actionName.equals("directive.include")) {
                    if (!actionElement.hasAttribute("file")) {
                        throw new JspCoreException("jsp.error.include.directive.attribute.invalid");
                    }
                    this.insertInclude(actionElement.getAttribute("file"));
                } else if (hasChildren) {
                    this.elements.push(actionElement);
                }
                String jspId = actionElement.getAttributeNS("http://java.sun.com/JSP/Page", "id");
                jspId = jspId + this.encodedRelativeURL + "[" + this.jspSyntaxLineNum + "," + this.jspSyntaxColNum + "," + this.actionLineCount + "]";
                actionElement.setAttributeNS("http://java.sun.com/JSP/Page", "jsp:id", jspId);
            }
            if (doIncrement) return;
            this.textCurrLineNum = this.currentLineNum;
            this.textCurrColNum = this.currentColumnNum + 1;
            return;
        }
        if (inName && !this.tagPrefixes.containsKey(actionPrefix)) {
            String msg = this.buildLineNumberMessage(" ");
            this.nonCustomTagPrefixMap.put(actionPrefix, msg);
        }
        this.templateText.append(actionText.toString());
    }

    protected boolean processActionAttributes(Element actionElement) throws IOException, JspCoreException {
        boolean hasChildren = true;
        StringBuffer attributeName = new StringBuffer();
        StringBuffer attributeValue = new StringBuffer();
        boolean inValue = false;
        boolean endFound = false;
        boolean usingSingleQuotes = false;
        boolean inEscape = false;
        boolean evalExpressionFollowingTwoBackslashes = WCCustomProperties.EVAL_EXPRESSION_FOLLOWING_TWO_BACKSLASHES;
        StringBuffer attrNames = new StringBuffer();
        int prev = 0;
        int character = 0;
        block16: while (!endFound) {
            prev = character;
            character = this.readCharacter();
            switch (character) {
                case -1: {
                    throw new JspCoreException("jsp.error.end.of.file.reached", new Object[]{actionElement.getNodeName(), "Line: " + this.jspSyntaxLineNum + " Col: " + this.jspSyntaxColNum});
                }
                case 62: {
                    if (!inValue) {
                        if (prev == 47) {
                            hasChildren = false;
                        }
                        endFound = true;
                        continue block16;
                    }
                    if (prev == 37) continue block16;
                    attributeValue.append("&gt;");
                    continue block16;
                }
                case 34: {
                    ArrayList<String> valueList;
                    String prefix;
                    if (inValue) {
                        String namespaceUri = null;
                        if (attributeName.toString().indexOf(58) != -1) {
                            prefix = attributeName.toString().substring(0, attributeName.toString().indexOf(58));
                            namespaceUri = this.tagPrefixes.get(prefix);
                        }
                        if (!usingSingleQuotes && !inEscape) {
                            try {
                                if (this.jspOptions.isAllowMultipleAttributeValues()) {
                                    if (namespaceUri == null) {
                                        actionElement.setAttribute(attributeName.toString(), attributeValue.toString());
                                    } else {
                                        actionElement.setAttributeNS(namespaceUri, attributeName.toString(), attributeValue.toString());
                                    }
                                    valueList = (ArrayList<String>)actionElement.getUserData(attributeName.toString());
                                    if (valueList == null) {
                                        valueList = new ArrayList<String>();
                                    }
                                    valueList.add(attributeValue.toString());
                                    actionElement.setUserData(attributeName.toString(), valueList, null);
                                    valueList = null;
                                } else if (namespaceUri == null) {
                                    actionElement.setAttribute(attributeName.toString(), attributeValue.toString());
                                } else {
                                    actionElement.setAttributeNS(namespaceUri, attributeName.toString(), attributeValue.toString());
                                }
                                attrNames.append(attributeName.toString() + "~");
                            }
                            catch (DOMException e) {
                                throw new JspCoreException("jsp.error.unable.to.create.xml.attr", new Object[]{attributeName.toString(), attributeValue.toString()}, e);
                            }
                            attributeName.delete(0, attributeName.length());
                            attributeValue.delete(0, attributeValue.length());
                            inValue = false;
                        } else {
                            attributeValue.append('\"');
                        }
                        inEscape = false;
                        continue block16;
                    }
                    inValue = true;
                    usingSingleQuotes = false;
                    continue block16;
                }
                case 39: {
                    ArrayList<String> valueList;
                    String prefix;
                    if (inValue) {
                        String namespaceUri = null;
                        if (attributeName.toString().indexOf(58) != -1) {
                            prefix = attributeName.toString().substring(0, attributeName.toString().indexOf(58));
                            namespaceUri = this.tagPrefixes.get(prefix);
                        }
                        if (usingSingleQuotes && !inEscape) {
                            try {
                                if (this.jspOptions.isAllowMultipleAttributeValues()) {
                                    if (namespaceUri == null) {
                                        actionElement.setAttribute(attributeName.toString(), attributeValue.toString());
                                    } else {
                                        actionElement.setAttributeNS(namespaceUri, attributeName.toString(), attributeValue.toString());
                                    }
                                    valueList = (ArrayList)actionElement.getUserData(attributeName.toString());
                                    if (valueList == null) {
                                        valueList = new ArrayList();
                                    }
                                    valueList.add(attributeValue.toString());
                                    actionElement.setUserData(attributeName.toString(), valueList, null);
                                    valueList = null;
                                } else if (namespaceUri == null) {
                                    actionElement.setAttribute(attributeName.toString(), attributeValue.toString());
                                } else {
                                    actionElement.setAttributeNS(namespaceUri, attributeName.toString(), attributeValue.toString());
                                }
                                attrNames.append(attributeName.toString() + "~");
                            }
                            catch (DOMException e) {
                                throw new JspCoreException("jsp.error.unable.to.create.xml.attr", new Object[]{attributeName.toString(), attributeValue.toString()}, e);
                            }
                            attributeName.delete(0, attributeName.length());
                            attributeValue.delete(0, attributeValue.length());
                            inValue = false;
                        } else {
                            attributeValue.append('\'');
                        }
                        inEscape = false;
                        continue block16;
                    }
                    inValue = true;
                    usingSingleQuotes = true;
                    continue block16;
                }
                case 92: {
                    if (inValue) {
                        if (inEscape) {
                            inEscape = false;
                            attributeValue.append((char)character);
                            continue block16;
                        }
                        int nextChar = this.readNextCharacter();
                        if (nextChar == 39 || nextChar == 34 || nextChar == 92) {
                            int[] chars;
                            inEscape = true;
                            if (!evalExpressionFollowingTwoBackslashes || (chars = this.readAhead(2))[1] == 39 || chars[1] == 34) continue block16;
                            attributeValue.append((char)character);
                            continue block16;
                        }
                        attributeValue.append((char)character);
                        continue block16;
                    }
                    attributeName.append((char)character);
                    continue block16;
                }
                case 38: {
                    if (!inValue) continue block16;
                    attributeValue.append("&amp;");
                    continue block16;
                }
                case 60: {
                    if (inValue) {
                        int[] nextChars = this.readAhead(2);
                        if (nextChars[0] == 37 || nextChars[1] == 61) continue block16;
                        attributeValue.append("&lt;");
                        continue block16;
                    }
                    throw new JspCoreException("jsp.error.invalid.jsp.syntax", new Object[]{attributeName.toString()});
                }
                case 10: {
                    ++this.actionLineCount;
                }
                case 9: 
                case 13: 
                case 32: {
                    if (!inValue) continue block16;
                    attributeValue.append((char)character);
                    continue block16;
                }
                case 61: {
                    if (!inValue) continue block16;
                    attributeValue.append((char)character);
                    continue block16;
                }
            }
            if (inValue) {
                attributeValue.append((char)character);
                continue;
            }
            attributeName.append((char)character);
        }
        if (!actionElement.getNamespaceURI().equals("http://java.sun.com/JSP/Page") && attrNames.length() > 0) {
            actionElement.setAttributeNS("http://java.sun.com/JSP/Page", "jsp:id", "{" + attrNames.toString() + "}");
        }
        return hasChildren;
    }

    protected void processHtmlCommment() throws IOException, JspCoreException {
        Object element = null;
        this.processTemplateText();
        boolean endFound = false;
        StringBuffer htmlCommentText = new StringBuffer();
        htmlCommentText.append("<!");
        int lineCount = 1;
        int character = 0;
        block6: while (!endFound) {
            character = this.readCharacter();
            switch (character) {
                case -1: {
                    throw new JspCoreException("jsp.error.end.of.file.reached", new Object[]{"html comment " + htmlCommentText.toString(), "Line: " + this.jspSyntaxLineNum + " Col: " + this.jspSyntaxColNum});
                }
                case 62: {
                    if (htmlCommentText.charAt(htmlCommentText.length() - 1) == '-' && htmlCommentText.charAt(htmlCommentText.length() - 2) == '-') {
                        endFound = true;
                    }
                    htmlCommentText.append((char)character);
                    continue block6;
                }
                case 60: {
                    endFound = true;
                    continue block6;
                }
                case 10: {
                    ++lineCount;
                    htmlCommentText.append((char)character);
                    continue block6;
                }
            }
            htmlCommentText.append((char)character);
        }
        CDATASection cdata = this.jspDocument.createCDATASection(htmlCommentText.toString());
        if (htmlCommentText.toString().trim().length() > 0) {
            String jspId = this.encodedRelativeURL + "[" + this.jspSyntaxLineNum + "," + this.jspSyntaxColNum + "," + lineCount + "]";
            this.cdataJspIdMap.put(new Integer(cdata.hashCode()), jspId);
        }
        Element parentElement = (Element)this.elements.peek();
        parentElement.appendChild(cdata);
        if ((char)character == '<') {
            this.processJspSyntax();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processDirective() throws IOException, JspCoreException {
        boolean endFound = false;
        Node element = null;
        int lineCount = 1;
        StringBuffer directive = new StringBuffer();
        StringBuffer name = new StringBuffer();
        StringBuffer value = new StringBuffer();
        String prefix = "";
        String uri = "";
        String tagdir = "";
        boolean inValue = false;
        boolean inDirective = true;
        boolean inSingleQuotes = false;
        int prev = 0;
        int character = 0;
        block12: while (!endFound) {
            prev = character;
            character = this.readCharacter();
            switch (character) {
                case -1: {
                    throw new JspCoreException("jsp.error.end.of.file.reached", new Object[]{"directive " + directive.toString(), "Line: " + this.jspSyntaxLineNum + " Col: " + this.jspSyntaxColNum});
                }
                case 60: {
                    if (inValue) {
                        value.append("&lt;");
                        continue block12;
                    }
                    if (!inDirective) throw new JspCoreException("jsp.error.invalid.jsp.syntax", new Object[]{name.toString()});
                    throw new JspCoreException("jsp.error.invalid.jsp.syntax", new Object[]{directive.toString()});
                }
                case 62: {
                    if (prev == 37) {
                        endFound = true;
                        continue block12;
                    }
                    if (inValue) {
                        value.append("&gt;");
                        continue block12;
                    }
                    if (inDirective) continue block12;
                    name.append("&gt;");
                    continue block12;
                }
                case 13: {
                    continue block12;
                }
                case 61: {
                    if (!inValue) continue block12;
                    value.append((char)character);
                    continue block12;
                }
                case 10: {
                    ++lineCount;
                }
                case 9: 
                case 32: {
                    if (inDirective && directive.toString().trim().length() > 0) {
                        if (!directive.toString().equals("taglib") && !directive.toString().equals("include")) {
                            try {
                                element = this.jspDocument.createElementNS("http://java.sun.com/JSP/Page", "jsp:directive." + directive.toString());
                            }
                            catch (DOMException e) {
                                throw new JspCoreException("jsp.error.unable.to.create.xml.element", new Object[]{"http://java.sun.com/JSP/Page", "jsp:directive." + directive.toString()}, e);
                            }
                            this.setElementAttribute((Element)element, "http://java.sun.com/JSP/Page", "jsp:id", this.encodedRelativeURL + "[" + this.jspSyntaxLineNum + "," + this.jspSyntaxColNum + "," + lineCount + "]");
                        }
                        inDirective = false;
                        continue block12;
                    }
                    if (!inValue) continue block12;
                    value.append((char)character);
                    continue block12;
                }
                case 34: 
                case 39: {
                    if (inValue) {
                        if (inSingleQuotes && character == 39 || !inSingleQuotes && character == 34) {
                            String currentImport;
                            if (directive.toString().equals("taglib")) {
                                if (name.toString().equals("prefix")) {
                                    prefix = value.toString();
                                } else if (name.toString().equals("uri")) {
                                    if (uri != null && !uri.trim().equals("")) {
                                        if (!uri.startsWith("urn:jsptagdir:")) throw new JspTranslationException("jsp.error.invalid.taglib.directive.duplicate.uri", new Object[]{value.toString(), uri});
                                        throw new JspTranslationException("jsp.error.invalid.taglib.directive.tagdir.uri", new Object[]{value.toString(), uri});
                                    }
                                    uri = value.toString();
                                } else {
                                    if (!name.toString().equals("tagdir")) throw new JspTranslationException("jsp.error.invalid.taglib.directive.attribute", new Object[]{name.toString(), value.toString()});
                                    if (uri != null && !uri.trim().equals("")) {
                                        if (!uri.startsWith("urn:jsptagdir:")) throw new JspTranslationException("jsp.error.invalid.taglib.directive.tagdir.uri", new Object[]{uri, value.toString()});
                                        throw new JspTranslationException("jsp.error.invalid.taglib.directive.duplicate.tagdir", new Object[]{value.toString(), uri});
                                    }
                                    if (value.toString() != null) {
                                        if (!value.toString().startsWith(WEB_INF_TAGS)) {
                                            throw new JspTranslationException("jsp.error.invalid.tagdir", new Object[]{tagdir});
                                        }
                                        tagdir = value.toString();
                                    }
                                    uri = "urn:jsptagdir:" + value.toString();
                                }
                            } else if (directive.toString().equals("page")) {
                                if (name.toString().equals("import")) {
                                    if (element.getAttributeNode("import") != null) {
                                        currentImport = element.getAttribute("import");
                                        this.setElementAttribute((Element)element, null, "import", currentImport + "," + value.toString());
                                    } else {
                                        this.setElementAttribute((Element)element, null, "import", value.toString());
                                    }
                                } else {
                                    if (element.getAttributeNode(name.toString()) != null && !element.getAttributeNode(name.toString()).getValue().equals(value.toString())) {
                                        throw new JspCoreException("jsp.error.page.directive.dup.value", new Object[]{name.toString()});
                                    }
                                    this.setElementAttribute((Element)element, null, name.toString(), value.toString());
                                }
                            } else if (directive.toString().equals("include")) {
                                if (!name.toString().equals("file")) throw new JspCoreException("jsp.error.include.directive.attribute.invalid", new Object[]{name.toString()});
                                String includeURI = value.toString();
                                if (includeURI == null || includeURI.toString().equals("")) {
                                    throw new JspCoreException("jsp.error.static.include.value.missing");
                                }
                                this.insertInclude(includeURI);
                            } else if (directive.toString().equals("tag")) {
                                if (name.toString().equals("import")) {
                                    if (element.getAttributeNode("import") != null) {
                                        currentImport = element.getAttribute("import");
                                        this.setElementAttribute((Element)element, null, "import", currentImport + "," + value.toString());
                                    } else {
                                        this.setElementAttribute((Element)element, null, "import", value.toString());
                                    }
                                } else {
                                    if (element.getAttributeNode(name.toString()) != null && !element.getAttributeNode(name.toString()).getValue().equals(value.toString())) {
                                        throw new JspCoreException("jsp.error.page.directive.dup.value", new Object[]{name.toString()});
                                    }
                                    this.setElementAttribute((Element)element, null, name.toString(), value.toString());
                                }
                            } else if (directive.toString().equals("attribute")) {
                                this.setElementAttribute((Element)element, null, name.toString(), value.toString());
                            } else if (directive.toString().equals("variable")) {
                                this.setElementAttribute((Element)element, null, name.toString(), value.toString());
                            }
                            name.delete(0, name.length());
                            value.delete(0, value.length());
                            inValue = false;
                            inSingleQuotes = false;
                            continue block12;
                        }
                        value.append((char)character);
                        continue block12;
                    }
                    inValue = true;
                    if (character != 39) continue block12;
                    inSingleQuotes = true;
                    continue block12;
                }
            }
            if (inValue) {
                value.append((char)character);
                continue;
            }
            if (inDirective) {
                directive.append((char)character);
                continue;
            }
            name.append((char)character);
        }
        if (!prefix.equals("") && !uri.equals("")) {
            String msg;
            boolean tagDir;
            String tmpUri = this.tagPrefixes.get(prefix);
            if (!(this.jspOptions.isAllowTaglibPrefixRedefinition() || tmpUri == null || tmpUri.equals(uri) || (tagDir = uri.startsWith("urn:jsptagdir:")) && (!tagDir || tmpUri.equals(uri.substring(14))))) {
                throw new JspCoreException("jsp.error.prefix.redefined", new Object[]{prefix, uri, tmpUri});
            }
            if (!this.jspOptions.isAllowTaglibPrefixUseBeforeDefinition() && (msg = this.nonCustomTagPrefixMap.get(prefix)) != null) {
                throw new JspCoreException("jsp.error.prefix.use_before_dcl", new Object[]{prefix, msg});
            }
            this.tagPrefixes.put(prefix, uri);
        } else if (directive.toString().equals("taglib") && prefix.equals("")) {
            throw new JspTranslationException("jsp.error.invalid.taglib.directive.missing.required.prefix");
        }
        if (element == null) return;
        if (element.getLocalName().equals("directive.page") && element.hasAttribute("pageEncoding")) {
            if (this.pageEncodingSpecified) throw new JspCoreException(JspCoreException.getMsg("jsp.error.page.pageencoding.dup", new Object[]{this.resolvedRelativeURL}));
            this.pageEncodingSpecified = true;
            if (this.jspConfiguration.getPageEncoding() != null) {
                if (!this.jspConfiguration.getPageEncoding().equalsIgnoreCase(element.getAttribute("pageEncoding"))) {
                    throw new JspCoreException("jsp.error.encoding.mismatch.config.pageencoding", new Object[]{this.jspConfiguration.getPageEncoding(), element.getAttribute("pageEncoding")});
                }
            } else {
                this.jspConfiguration.setPageEncoding(element.getAttribute("pageEncoding"));
            }
        }
        Element parentElement = (Element)this.elements.peek();
        parentElement.appendChild(element);
    }

    protected void processJspComment() throws IOException, JspCoreException {
        boolean endFound = false;
        StringBuffer jspCommentText = new StringBuffer();
        block4: while (!endFound) {
            int character = this.readCharacter();
            switch (character) {
                case -1: {
                    throw new JspCoreException("jsp.error.end.of.file.reached", new Object[]{"jspComment " + jspCommentText.toString(), "Line: " + this.jspSyntaxLineNum + " Col: " + this.jspSyntaxColNum});
                }
                case 62: {
                    if (jspCommentText.length() >= 3 && jspCommentText.charAt(jspCommentText.length() - 1) == '%' && jspCommentText.charAt(jspCommentText.length() - 2) == '-' && jspCommentText.charAt(jspCommentText.length() - 3) == '-') {
                        endFound = true;
                        continue block4;
                    }
                    jspCommentText.append((char)character);
                    continue block4;
                }
            }
            jspCommentText.append((char)character);
        }
    }

    protected void processScriptingElement(int type) throws IOException, JspCoreException {
        Element element = null;
        int lineCount = 1;
        StringBuffer value = new StringBuffer();
        boolean endFound = false;
        boolean inComment = false;
        boolean inSingleQuoteValue = false;
        boolean inDoubleQuoteValue = false;
        int character = 0;
        int previousChar = 0;
        block16: while (!endFound) {
            previousChar = character;
            character = this.readCharacter();
            switch (character) {
                case -1: {
                    throw new JspCoreException("jsp.error.end.of.file.reached", new Object[]{"scripting element " + value.toString(), "Line: " + this.jspSyntaxLineNum + " Col: " + this.jspSyntaxColNum});
                }
                case 37: {
                    int nextChar = this.readNextCharacter();
                    if (nextChar == 62) continue block16;
                    value.append((char)character);
                    continue block16;
                }
                case 60: {
                    int[] chars = this.readAhead(2);
                    if (!(inSingleQuoteValue || inDoubleQuoteValue || inComment || chars[0] != 37)) {
                        throw new JspCoreException("jsp.error.invalid.jsp.syntax", new Object[]{value.toString()});
                    }
                    value.append("&lt;");
                    continue block16;
                }
                case 38: {
                    value.append("&amp;");
                    continue block16;
                }
                case 62: {
                    if (previousChar == 37) {
                        endFound = true;
                        continue block16;
                    }
                    value.append("&gt;");
                    continue block16;
                }
                case 39: {
                    inSingleQuoteValue = !inSingleQuoteValue;
                    value.append((char)character);
                    continue block16;
                }
                case 34: {
                    inDoubleQuoteValue = !inDoubleQuoteValue;
                    value.append((char)character);
                    continue block16;
                }
                case 10: {
                    ++lineCount;
                    value.append((char)character);
                    continue block16;
                }
                case 47: {
                    int nextChar = this.readNextCharacter();
                    if (inComment && previousChar == 42 && nextChar == -1) {
                        inComment = false;
                    }
                    if (nextChar == 42 || nextChar == 47) {
                        inComment = true;
                    }
                    value.append((char)character);
                    continue block16;
                }
            }
            value.append((char)character);
        }
        switch (type) {
            case 3: {
                element = this.jspDocument.createElementNS("http://java.sun.com/JSP/Page", "jsp:scriptlet");
                break;
            }
            case 1: {
                element = this.jspDocument.createElementNS("http://java.sun.com/JSP/Page", "jsp:expression");
                break;
            }
            case 2: {
                element = this.jspDocument.createElementNS("http://java.sun.com/JSP/Page", "jsp:declaration");
                break;
            }
        }
        CDATASection cdata = this.jspDocument.createCDATASection(value.toString());
        element.appendChild(cdata);
        Element parentElement = (Element)this.elements.peek();
        parentElement.appendChild(element);
        element.setAttributeNS("http://java.sun.com/JSP/Page", "jsp:id", this.encodedRelativeURL + "[" + this.jspSyntaxLineNum + "," + this.jspSyntaxColNum + "," + lineCount + "]");
    }

    private void processCDATA() throws IOException, JspCoreException {
        boolean endFound = false;
        StringBuffer cdataText = new StringBuffer();
        int character = 0;
        block4: while (!endFound) {
            character = this.readCharacter();
            switch (character) {
                case -1: {
                    throw new JspCoreException("jsp.error.end.of.file.reached", new Object[]{"cdata", "Line: " + this.jspSyntaxLineNum + " Col: " + this.jspSyntaxColNum});
                }
                case 93: {
                    int[] chars = this.readAhead(2);
                    if (chars[0] == 93 && chars[1] == 62) {
                        endFound = true;
                        this.skip(2);
                        continue block4;
                    }
                    cdataText.append((char)character);
                    continue block4;
                }
            }
            cdataText.append((char)character);
        }
        this.templateText.append(cdataText.toString());
    }

    private void setElementAttribute(Element element, String namespace, String name, String value) throws JspCoreException {
        try {
            if (namespace != null) {
                element.setAttributeNS(namespace, name, value);
            } else {
                if (name.toString().equals("pageEncoding")) {
                    value = EncodingUtils.getJvmConverter((String)value.toString());
                }
                element.setAttribute(name, value);
            }
        }
        catch (DOMException e) {
            throw new JspCoreException("jsp.error.unable.to.create.xml.attr", new Object[]{name, value}, e);
        }
    }

    private void insertImplictIncludes(ArrayList implicitIncludeList) throws JspCoreException {
        for (String includePath : implicitIncludeList) {
            this.insertInclude(includePath);
        }
    }

    private void insertInclude(String includePath) throws JspCoreException {
        String fullPath;
        Container container;
        block19: {
            if (!includePath.startsWith("/")) {
                int lastLocation = this.resolvedRelativeURL.lastIndexOf("/");
                includePath = lastLocation > 0 ? WSUtil.resolveURI((String)(this.resolvedRelativeURL.substring(0, lastLocation + 1) + includePath)) : WSUtil.resolveURI((String)("/" + includePath));
            }
            container = this.context.getServletContext().getModuleContainer();
            fullPath = null;
            if (container != null) {
                Entry e = container.getEntry(includePath);
                if (e != null) {
                    fullPath = e.getPath();
                    try {
                        Container convertedContainer = (Container)e.adapt(Container.class);
                        if (convertedContainer != null && e.getSize() == 0L && !WCCustomProperties.ALLOW_DIRECTORY_INCLUDE) {
                            return;
                        }
                        break block19;
                    }
                    catch (UnableToAdaptException ex) {
                        throw new IllegalStateException(ex);
                    }
                }
                fullPath = includePath;
            } else {
                fullPath = this.context.getRealPath(includePath);
                if (new File(fullPath).isDirectory() && !WCCustomProperties.ALLOW_DIRECTORY_INCLUDE) {
                    return;
                }
            }
        }
        if (this.dependencyStack.contains(fullPath)) {
            throw new JspCoreException("jsp.error.static.include.circular.dependency", new Object[]{fullPath});
        }
        this.dependencyStack.push(fullPath);
        if (container != null || this.inputSource.getAbsoluteURL().getProtocol().equals("file")) {
            this.dependencyList.add(includePath);
        }
        HashMap<String, String> mergedTagLibMap = new HashMap<String, String>(this.implicitTagLibMap);
        mergedTagLibMap.putAll(this.tagPrefixes);
        JspConfiguration includeConfiguration = this.jspConfiguration.getConfigManager().getConfigurationForStaticInclude(includePath, this.jspConfiguration);
        JspInputSource includePathInputSource = this.context.getJspInputSourceFactory().copyJspInputSource(this.inputSource, includePath);
        Jsp2Dom jsp2Dom = new Jsp2Dom(includePathInputSource, this.context, this.directoryStack, includeConfiguration, this.jspOptions, this.dependencyStack, this.dependencyList, this.cdataJspIdMap, mergedTagLibMap, false);
        Document includeDocument = null;
        includeDocument = jsp2Dom.getJspDocument();
        Node parentNode = (Node)this.elements.peek();
        if (includeDocument.getDocumentElement().getNamespaceURI().equals("http://java.sun.com/JSP/Page") && includeDocument.getDocumentElement().getLocalName().equals("root")) {
            for (int i = 0; i < includeDocument.getDocumentElement().getChildNodes().getLength(); ++i) {
                Integer nodeHashCode;
                Node nodeToBeCopied = includeDocument.getDocumentElement().getChildNodes().item(i);
                Node n = this.jspDocument.importNode(nodeToBeCopied, true);
                if (nodeToBeCopied.getNodeType() == 4 && this.cdataJspIdMap.containsKey(nodeHashCode = new Integer(nodeToBeCopied.hashCode()))) {
                    String jspId = (String)this.cdataJspIdMap.remove(nodeHashCode);
                    this.cdataJspIdMap.put(new Integer(n.hashCode()), jspId);
                }
                parentNode.appendChild(n);
            }
            NamedNodeMap attrs = includeDocument.getDocumentElement().getAttributes();
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node attr = attrs.item(i);
                if (!attr.getNodeName().startsWith("xmlns:")) continue;
                String prefix = attr.getNodeName();
                prefix = prefix.substring(prefix.indexOf(":") + 1);
                String uri = attr.getNodeValue();
                if (uri.startsWith("urn:jsptld:")) {
                    uri = uri.substring(uri.indexOf("urn:jsptld:") + 11);
                } else if (uri.startsWith("urn:jsptagdir:")) {
                    uri = uri.substring(uri.indexOf("urn:jsptagdir:") + 14);
                }
                if (uri.equals("http://java.sun.com/JSP/Page") || uri.equals("http://www.w3.org/2001/XMLSchema-instance")) continue;
                this.tagPrefixes.put(prefix, uri);
            }
        } else {
            for (int i = 0; i < includeDocument.getChildNodes().getLength(); ++i) {
                Node n = this.jspDocument.importNode(includeDocument.getChildNodes().item(i), true);
                parentNode.appendChild(n);
            }
        }
        this.dependencyStack.pop();
    }

    @Trivial
    private int readCharacter() throws IOException {
        int character = this.jspReader.read();
        if (character == 10) {
            ++this.currentLineNum;
            this.currentColumnNum = 0;
        } else {
            ++this.currentColumnNum;
        }
        return character;
    }

    @Trivial
    private int readNextCharacter() throws IOException {
        this.jspReader.mark(1);
        int character = this.jspReader.read();
        this.jspReader.reset();
        return character;
    }

    private int readNextNonWhite(StringBuffer sb) throws IOException {
        int character = this.readNextCharacter();
        while (character == 32 || character == 9 || character == 10 || character == 13) {
            character = this.readCharacter();
            sb.append((char)character);
            character = this.readNextCharacter();
        }
        return character;
    }

    private int[] readAhead(int count) throws IOException {
        int[] chars = new int[count];
        this.jspReader.mark(count);
        for (int i = 0; i < count; ++i) {
            chars[i] = this.jspReader.read();
        }
        this.jspReader.reset();
        return chars;
    }

    private String readAheadToString(int count) throws IOException {
        StringBuffer sb = new StringBuffer();
        this.jspReader.mark(count);
        for (int i = 0; i < count; ++i) {
            sb.append((char)this.jspReader.read());
        }
        this.jspReader.reset();
        return sb.toString();
    }

    private void skip(int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            this.readCharacter();
        }
    }

    public String buildLineNumberMessage(String msg) {
        msg = this.resolvedRelativeURL + "(" + this.currentLineNum + "," + this.currentColumnNum + ") " + msg;
        return msg;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.jsp.translator.document.JspPageParser", JspPageParser.class, null, null);
    }
}

