/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator;

import jakarta.enterprise.inject.build.compatible.spi.InjectionPointInfo;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.lang.model.AnnotationInfo;
import jakarta.enterprise.lang.model.declarations.DeclarationInfo;
import jakarta.enterprise.lang.model.types.Type;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.stream.Collectors;
import org.jboss.weld.lite.extension.translator.AnnotationInfoImpl;
import org.jboss.weld.lite.extension.translator.DeclarationInfoImpl;
import org.jboss.weld.lite.extension.translator.TypeImpl;
import org.jboss.weld.lite.extension.translator.util.reflection.AnnotatedTypes;

class InjectionPointInfoImpl
implements InjectionPointInfo {
    private final InjectionPoint cdiInjectionPoint;
    private final BeanManager bm;

    InjectionPointInfoImpl(InjectionPoint cdiInjectionPoint, BeanManager bm) {
        this.cdiInjectionPoint = cdiInjectionPoint;
        this.bm = bm;
    }

    public Type type() {
        return TypeImpl.fromReflectionType(AnnotatedTypes.from(this.cdiInjectionPoint.getType()), this.bm);
    }

    public Collection<AnnotationInfo> qualifiers() {
        return this.cdiInjectionPoint.getQualifiers().stream().map(annotation -> new AnnotationInfoImpl((Annotation)annotation, this.bm)).collect(Collectors.toList());
    }

    public DeclarationInfo declaration() {
        return DeclarationInfoImpl.fromCdiDeclaration(this.cdiInjectionPoint.getAnnotated(), this.bm);
    }
}

