/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.data.internal.persistence.cdi;

import com.ibm.websphere.ras.annotation.Trivial;

@Trivial
enum Namespace {
    GLOBAL,
    APP,
    MODULE,
    COMP;


    final boolean isMoreGranularThan(Namespace ns) {
        return this.ordinal() > (ns == null ? GLOBAL : ns).ordinal();
    }

    static Namespace of(String jndiName) {
        if (jndiName.startsWith("java:")) {
            if (jndiName.regionMatches(5, "app/", 0, 4)) {
                return APP;
            }
            if (jndiName.regionMatches(5, "module/", 0, 7)) {
                return MODULE;
            }
            if (jndiName.regionMatches(5, "comp/", 0, 5)) {
                return COMP;
            }
            if (jndiName.regionMatches(5, "global/", 0, 7)) {
                return GLOBAL;
            }
        }
        return null;
    }

    public String toString() {
        switch (this) {
            case GLOBAL: {
                return "java:global";
            }
            case APP: {
                return "java:app";
            }
            case MODULE: {
                return "java:module";
            }
            case COMP: {
                return "java:comp";
            }
        }
        throw new IllegalStateException();
    }
}

