/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.classloading.ClassGenerator;
import com.ibm.ws.classloading.configuration.GlobalClassloadingConfiguration;
import com.ibm.ws.classloading.internal.AppClassLoader;
import com.ibm.ws.classloading.internal.DeclaredApiAccess;
import com.ibm.ws.classloading.internal.LibertyLoader;
import com.ibm.ws.classloading.internal.NoClassNotFoundLoader;
import com.ibm.ws.classloading.internal.Util;
import com.ibm.ws.classloading.internal.util.ClassRedefiner;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.boot.classloader.NameBasedClassLoaderLock;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.classloading.ClassLoaderConfiguration;
import com.ibm.wsspi.kernel.service.utils.CompositeEnumeration;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class ParentLastClassLoader
extends AppClassLoader {
    static final List<AppClassLoader.SearchLocation> PARENT_LAST_SEARCH_ORDER;
    static final long serialVersionUID = 6236954115010060458L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    ParentLastClassLoader(ClassLoader parent, ClassLoaderConfiguration config, List<Container> urls, DeclaredApiAccess access, ClassRedefiner redefiner, ClassGenerator generator, GlobalClassloadingConfiguration globalConfig, List<ClassFileTransformer> systemTransformers) {
        super(parent, config, urls, access, redefiner, generator, globalConfig, systemTransformers);
    }

    @Override
    Iterable<AppClassLoader.SearchLocation> getSearchOrder() {
        return PARENT_LAST_SEARCH_ORDER;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    @Override
    @Trivial
    public URL getResource(String name) {
        URL result = this.findResourceCommonLibraryClassLoaders(name, GlobalClassloadingConfiguration.LibraryPrecedence.beforeApp);
        if (result == null) {
            result = this.findResource(name);
        }
        if (result == null) {
            result = this.parent.getResource(name);
        }
        return result;
    }

    @Override
    @Trivial
    public Enumeration<URL> getResources(String resName) throws IOException {
        return this.findResourcesCommonLibraryClassLoaders(resName, (CompositeEnumeration<URL>)new CompositeEnumeration(), GlobalClassloadingConfiguration.LibraryPrecedence.beforeApp).add(this.findResources(resName)).add(this.parent.getResources(resName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Trivial
    @FFDCIgnore(value={ClassNotFoundException.class})
    protected Class<?> findOrDelegateLoadClass(String className, LibertyLoader.DelegatePolicy delegatePolicy, boolean returnNull) throws ClassNotFoundException {
        boolean RETURN_NULL_FOR_NO_CLASS = true;
        Class<?> beforeAppLoad = this.findClassCommonLibraryClassLoaders(className, true, GlobalClassloadingConfiguration.LibraryPrecedence.beforeApp, delegatePolicy);
        if (beforeAppLoad != null) {
            return beforeAppLoad;
        }
        ClassNotFoundException findClassException = null;
        Class<?> rc = null;
        NameBasedClassLoaderLock nameBasedClassLoaderLock = this.getClassLoadingLock(className);
        synchronized (nameBasedClassLoaderLock) {
            rc = this.findLoadedClass(className);
            if (rc == null) {
                try {
                    rc = this.findClass(className, delegatePolicy, returnNull);
                }
                catch (ClassNotFoundException cnfe) {
                    findClassException = cnfe;
                }
                if (rc == null) {
                    rc = this.generateClass(className);
                }
            }
        }
        if (rc != null) {
            return rc;
        }
        if (delegatePolicy != LibertyLoader.DelegatePolicy.includeParent) {
            if (returnNull) {
                return null;
            }
            throw findClassException;
        }
        if (this.parent instanceof NoClassNotFoundLoader) {
            rc = ((NoClassNotFoundLoader)((Object)this.parent)).loadClassNoException(className);
            if (rc != null || returnNull) {
                return rc;
            }
            throw findClassException;
        }
        if (returnNull) {
            try {
                return this.parent.loadClass(className);
            }
            catch (ClassNotFoundException cnfe) {
                return null;
            }
        }
        return this.parent.loadClass(className);
    }

    @Override
    @Trivial
    protected boolean isParentFirst() {
        return false;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ParentLastClassLoader", ParentLastClassLoader.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
        ClassLoader.registerAsParallelCapable();
        PARENT_LAST_SEARCH_ORDER = Util.freeze(Util.list(AppClassLoader.SearchLocation.BEFORE_DELEGATES, AppClassLoader.SearchLocation.SELF, AppClassLoader.SearchLocation.AFTER_DELEGATES, AppClassLoader.SearchLocation.PARENT));
    }
}

