/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.bytebuffer;

import com.ibm.wsspi.bytebuffer.WsByteBuffer;

public abstract class WsByteBufferUtils {
    public static final byte[] asByteArray(WsByteBuffer[] list) {
        if (null == list) {
            return null;
        }
        int size = 0;
        for (int i = 0; i < list.length && null != list[i]; ++i) {
            size += list[i].limit();
        }
        if (0 == size) {
            return null;
        }
        byte[] output = new byte[size];
        int offset = 0;
        int position = 0;
        for (int i = 0; i < list.length && null != list[i]; ++i) {
            position = list[i].position();
            list[i].position(0);
            list[i].get(output, offset, list[i].limit());
            offset += list[i].limit();
            list[i].position(position);
        }
        return output;
    }

    public static final byte[] asByteArray(WsByteBuffer[] list, int[] positions, int[] limits) {
        if (null == list) {
            return null;
        }
        int size = 0;
        for (int i = 0; i < list.length && null != list[i]; ++i) {
            size += limits[i] - positions[i];
        }
        if (0 == size) {
            return null;
        }
        byte[] output = new byte[size];
        int offset = 0;
        int position = 0;
        for (int i = 0; i < list.length && null != list[i]; ++i) {
            position = list[i].position();
            list[i].position(positions[i]);
            list[i].get(output, offset, limits[i] - positions[i]);
            offset += limits[i] - positions[i];
            list[i].position(position);
        }
        return output;
    }

    public static final String asString(WsByteBuffer[] list) {
        byte[] data = WsByteBufferUtils.asByteArray(list);
        return null != data ? new String(data) : null;
    }

    public static final String asString(WsByteBuffer[] list, int[] positions, int[] limits) {
        byte[] data = WsByteBufferUtils.asByteArray(list, positions, limits);
        return null != data ? new String(data) : null;
    }

    public static final String asString(WsByteBuffer buff) {
        byte[] data = WsByteBufferUtils.asByteArray(buff);
        return null != data ? new String(data) : null;
    }

    public static final String asString(WsByteBuffer buff, int position, int limit) {
        byte[] data = WsByteBufferUtils.asByteArray(buff, position, limit);
        return null != data ? new String(data) : null;
    }

    public static final byte[] asByteArray(WsByteBuffer buff) {
        if (null == buff) {
            return null;
        }
        int size = buff.limit();
        if (0 == size) {
            return null;
        }
        byte[] output = new byte[size];
        int position = buff.position();
        buff.position(0);
        buff.get(output);
        buff.position(position);
        return output;
    }

    public static final byte[] asByteArray(WsByteBuffer buff, int position, int limit) {
        if (null == buff) {
            return null;
        }
        int size = limit - position;
        if (0 == size) {
            return null;
        }
        byte[] byteBuff = new byte[size];
        int currentPosition = buff.position();
        buff.position(position);
        buff.get(byteBuff, 0, size);
        buff.position(currentPosition);
        return byteBuff;
    }

    public static final StringBuffer asStringBuffer(WsByteBuffer[] list) {
        StringBuffer sb = new StringBuffer();
        String data = WsByteBufferUtils.asString(list);
        if (null != data) {
            sb.append(data);
        }
        return sb;
    }

    public static final StringBuffer asStringBuffer(WsByteBuffer buff) {
        StringBuffer sb = new StringBuffer();
        String data = WsByteBufferUtils.asString(buff);
        if (null != data) {
            sb.append(data);
        }
        return sb;
    }

    public static final int asInt(WsByteBuffer buff) {
        return WsByteBufferUtils.asInt(WsByteBufferUtils.asByteArray(buff));
    }

    public static final int asInt(WsByteBuffer buff, int position, int limit) {
        return WsByteBufferUtils.asInt(WsByteBufferUtils.asByteArray(buff, position, limit));
    }

    public static final int asInt(WsByteBuffer[] list) {
        return WsByteBufferUtils.asInt(WsByteBufferUtils.asByteArray(list));
    }

    public static final int asInt(WsByteBuffer[] list, int[] positions, int[] limits) {
        return WsByteBufferUtils.asInt(WsByteBufferUtils.asByteArray(list, positions, limits));
    }

    public static final int asInt(byte[] data) {
        int i;
        int start;
        if (null == data) {
            return -1;
        }
        for (start = 0; start < data.length && 32 == data[start] && 9 != data[start]; ++start) {
        }
        for (i = data.length - 1; start <= i && (32 == data[i] || 9 == data[i]); --i) {
        }
        if (i <= start) {
            return -1;
        }
        int intVal = 0;
        int mark = 1;
        while (start <= i) {
            int digit = data[i] - 48;
            if (0 > digit || 9 < digit) {
                if (45 == data[i]) break;
                throw new NumberFormatException("Invalid digit: " + data[i]);
            }
            intVal += digit * mark;
            mark *= 10;
            --i;
        }
        if (start < i) {
            throw new NumberFormatException("Invalid data");
        }
        if (start == i && data[i] == 45) {
            intVal = -intVal;
        }
        return intVal;
    }

    public static void releaseBufferArray(WsByteBuffer[] list) {
        if (null == list) {
            return;
        }
        for (int i = 0; i < list.length; ++i) {
            if (null == list[i]) continue;
            list[i].release();
            list[i] = null;
        }
    }

    public static final int lengthOf(WsByteBuffer[] list) {
        if (null == list) {
            return 0;
        }
        int length = 0;
        for (int i = 0; i < list.length && null != list[i]; ++i) {
            length += list[i].remaining();
        }
        return length;
    }

    public static void flip(WsByteBuffer[] list) {
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                if (list[i] == null) continue;
                list[i].flip();
            }
        }
    }

    public static final int getTotalCapacity(WsByteBuffer[] list) {
        if (null == list) {
            return 0;
        }
        int cap = 0;
        for (int i = 0; i < list.length; ++i) {
            if (list[i] == null) continue;
            cap += list[i].capacity();
        }
        return cap;
    }

    public static void clearBufferArray(WsByteBuffer[] list) {
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                if (list[i] == null) continue;
                list[i].clear();
            }
        }
    }

    public static void putByteArrayValue(WsByteBuffer[] list, byte[] value, boolean bFlipLast) {
        if (null == list || null == value) {
            return;
        }
        if (value.length > WsByteBufferUtils.getTotalCapacity(list)) {
            throw new IllegalArgumentException("Buffers not large enough");
        }
        int remaining = value.length;
        int offset = 0;
        int avail = 0;
        for (int i = 0; i < list.length; ++i) {
            avail = list[i].limit() - list[i].position();
            if (remaining <= avail) {
                list[i].put(value, offset, remaining);
                if (!bFlipLast) break;
                list[i].flip();
                break;
            }
            list[i].put(value, offset, avail);
            list[i].flip();
            offset += avail;
            remaining -= avail;
        }
    }

    public static void putStringValue(WsByteBuffer[] buff, String value, boolean bFlipLast) {
        if (null != value) {
            WsByteBufferUtils.putByteArrayValue(buff, value.getBytes(), bFlipLast);
        }
    }

    public static WsByteBuffer[] expandBufferArray(WsByteBuffer[] oldList, WsByteBuffer[] newBuffers) {
        if (null == oldList && null == newBuffers) {
            return null;
        }
        int oldLen = null != oldList ? oldList.length : 0;
        int newLen = null != newBuffers ? newBuffers.length : 0;
        WsByteBuffer[] bb = new WsByteBuffer[oldLen + newLen];
        if (0 < oldLen) {
            System.arraycopy(oldList, 0, bb, 0, oldLen);
        }
        if (0 < newLen) {
            System.arraycopy(newBuffers, 0, bb, oldLen, newLen);
        }
        return bb;
    }

    public static WsByteBuffer[] expandBufferArray(WsByteBuffer[] list, WsByteBuffer buffer) {
        if (null == buffer) {
            return list;
        }
        int len = null != list ? list.length : 0;
        WsByteBuffer[] bb = new WsByteBuffer[len + 1];
        if (0 < len) {
            System.arraycopy(list, 0, bb, 0, len);
        }
        bb[len] = buffer;
        return bb;
    }
}

