/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.net.internal;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetServerAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.network.internal.AddressAndPort;
import io.opentelemetry.instrumentation.api.instrumenter.network.internal.AddressAndPortExtractor;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.semconv.SemanticAttributes;

public final class InternalNetServerAttributesExtractor<REQUEST, RESPONSE> {
    private final NetServerAttributesGetter<REQUEST, RESPONSE> getter;
    private final AddressAndPortExtractor<REQUEST> fallbackAddressAndPortExtractor;
    private final boolean emitOldHttpAttributes;

    public InternalNetServerAttributesExtractor(NetServerAttributesGetter<REQUEST, RESPONSE> getter, AddressAndPortExtractor<REQUEST> fallbackAddressAndPortExtractor, boolean emitOldHttpAttributes) {
        this.getter = getter;
        this.fallbackAddressAndPortExtractor = fallbackAddressAndPortExtractor;
        this.emitOldHttpAttributes = emitOldHttpAttributes;
    }

    public void onStart(AttributesBuilder attributes, REQUEST request) {
        if (this.emitOldHttpAttributes) {
            String sockFamily;
            String serverSocketAddress;
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_TRANSPORT, this.getter.getTransport(request));
            boolean setSockFamily = false;
            String clientSocketAddress = this.getter.getClientSocketAddress(request, null);
            if (clientSocketAddress != null) {
                setSockFamily = true;
            }
            if ((serverSocketAddress = this.getter.getServerSocketAddress(request, null)) != null && !serverSocketAddress.equals(this.extractServerAddress(request))) {
                setSockFamily = true;
            }
            if (setSockFamily && (sockFamily = this.getter.getSockFamily(request)) != null && !"inet".equals(sockFamily)) {
                AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_SOCK_FAMILY, sockFamily);
            }
        }
    }

    private String extractServerAddress(REQUEST request) {
        String serverAddress = this.getter.getServerAddress(request);
        if (serverAddress != null) {
            return serverAddress;
        }
        AddressAndPort addressAndPort = new AddressAndPort();
        this.fallbackAddressAndPortExtractor.extract(addressAndPort, request);
        return addressAndPort.getAddress();
    }
}

