/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.spi.config;

import java.util.ServiceLoader;
import org.jboss.resteasy.spi.config.ConfigurationFactory;

class SingletonConfigurationFactory {
    SingletonConfigurationFactory() {
    }

    static ConfigurationFactory getInstance() {
        return Holder.INSTANCE;
    }

    private static class Holder {
        static final ConfigurationFactory INSTANCE;

        private Holder() {
        }

        static {
            ServiceLoader<ConfigurationFactory> loader = ServiceLoader.load(ConfigurationFactory.class, Holder.class.getClassLoader());
            ConfigurationFactory current = null;
            for (ConfigurationFactory factory : loader) {
                if (current == null) {
                    current = factory;
                    continue;
                }
                if (factory.priority() >= current.priority()) continue;
                current = factory;
            }
            INSTANCE = current == null ? () -> Integer.MAX_VALUE : current;
        }
    }
}

