/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.interception.jaxrs;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.WriterInterceptor;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.resteasy.core.NoMessageBodyWriterFoundFailure;
import org.jboss.resteasy.core.interception.jaxrs.AbstractWriterInterceptorContext;
import org.jboss.resteasy.core.providerfactory.ResteasyProviderFactoryImpl;
import org.jboss.resteasy.spi.AsyncMessageBodyWriter;
import org.jboss.resteasy.spi.AsyncOutputStream;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.tracing.RESTEasyTracingLogger;

public class ServerWriterInterceptorContext
extends AbstractWriterInterceptorContext {
    private HttpRequest request;
    private Consumer<Throwable> onWriteComplete;

    public ServerWriterInterceptorContext(WriterInterceptor[] interceptors, ResteasyProviderFactory providerFactory, Object entity, Class type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> headers, OutputStream outputStream, HttpRequest request, Consumer<Throwable> onWriteComplete) {
        super(interceptors, annotations, entity, genericType, mediaType, type, outputStream, providerFactory, headers, RESTEasyTracingLogger.getInstance(request));
        this.request = request;
        this.onWriteComplete = onWriteComplete;
    }

    @Override
    protected MessageBodyWriter resolveWriter() {
        return ((ResteasyProviderFactoryImpl)this.providerFactory).getServerMessageBodyWriter(this.type, this.genericType, this.annotations, this.mediaType, this.tracingLogger);
    }

    @Override
    void throwWriterNotFoundException() {
        throw new NoMessageBodyWriterFoundFailure(this.type, this.mediaType);
    }

    public Object getProperty(String name) {
        return this.request.getAttribute(name);
    }

    @Override
    public CompletionStage<Void> getStarted() {
        return this.aroundWriteTo(() -> super.getStarted());
    }

    @Override
    protected CompletionStage<Void> writeTo(MessageBodyWriter writer) throws IOException {
        return this.request.getAsyncContext().executeBlockingIo(() -> writer.writeTo(this.entity, this.type, this.genericType, this.annotations, this.mediaType, this.headers, this.outputStream), this.interceptors != null && this.interceptors.length > 0);
    }

    @Override
    protected CompletionStage<Void> writeTo(AsyncMessageBodyWriter writer) {
        return this.request.getAsyncContext().executeAsyncIo(writer.asyncWriteTo(this.entity, this.type, this.genericType, this.annotations, this.mediaType, (MultivaluedMap<String, Object>)this.headers, (AsyncOutputStream)this.outputStream));
    }

    private CompletionStage<Void> aroundWriteTo(Supplier<CompletionStage<Void>> ret) {
        boolean startedSuspended = this.request.getAsyncContext().isSuspended();
        return ret.get().whenComplete((v, t) -> {
            if (t instanceof CompletionException) {
                t = t.getCause();
            }
            this.onWriteComplete.accept((Throwable)t);
            if (!startedSuspended && this.request.getAsyncContext().isSuspended()) {
                this.request.getAsyncContext().complete();
            }
        });
    }

    public Collection<String> getPropertyNames() {
        ArrayList<String> names = new ArrayList<String>();
        Enumeration<String> enames = this.request.getAttributeNames();
        while (enames.hasMoreElements()) {
            names.add(enames.nextElement());
        }
        return names;
    }

    public void setProperty(String name, Object object) {
        if (object == null) {
            this.request.removeAttribute(name);
        } else {
            this.request.setAttribute(name, object);
        }
    }

    public void removeProperty(String name) {
        this.request.removeAttribute(name);
    }
}

