/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.concurrent;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.threading.CompletionStageExecutor;
import io.openliberty.restfulWS.client.AsyncClientExecutorService;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.jboss.resteasy.concurrent.ContextualExecutors;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class ContextualExecutorService
implements ExecutorService {
    private final boolean managed;
    private final AtomicBoolean shutdown;
    private volatile ExecutorService delegate;
    static final long serialVersionUID = -3547314801592722431L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    ContextualExecutorService(ExecutorService delegate, boolean managed) {
        this.delegate = delegate;
        this.managed = managed;
        this.shutdown = new AtomicBoolean(false);
    }

    @Override
    public void shutdown() {
        if (this.shutdown.compareAndSet(false, true)) {
            if (this.isManaged()) {
                this.delegate = null;
            } else {
                ExecutorService delegate = this.getDelegate();
                delegate.shutdown();
            }
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        if (this.shutdown.compareAndSet(false, true)) {
            if (this.isManaged()) {
                this.delegate = null;
            } else {
                ExecutorService delegate = this.getDelegate();
                return delegate.shutdownNow();
            }
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isShutdown() {
        if (this.isManaged()) {
            return this.shutdown.get();
        }
        return this.getDelegate().isShutdown();
    }

    @Override
    public boolean isTerminated() {
        if (this.isManaged()) {
            return false;
        }
        return this.getDelegate().isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.isManaged()) {
            return false;
        }
        return this.getDelegate().awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.getDelegate().submit(ContextualExecutors.callable(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.getDelegate().submit(ContextualExecutors.runnable(task), result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.getDelegate().submit(ContextualExecutors.runnable(task));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.getDelegate().invokeAll(ContextualExecutors.callable(tasks));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.getDelegate().invokeAll(ContextualExecutors.callable(tasks), timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.getDelegate().invokeAny(ContextualExecutors.callable(tasks));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.getDelegate().invokeAny(ContextualExecutors.callable(tasks), timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.getDelegate().execute(ContextualExecutors.runnable(command));
    }

    public boolean isManaged() {
        return this.managed;
    }

    ExecutorService getDelegate() {
        ExecutorService delegate = this.delegate;
        if (delegate == null) {
            throw Messages.MESSAGES.executorShutdown();
        }
        return delegate;
    }

    public <T> CompletableFuture<T> supplyAsync(Supplier<T> supplier) {
        ExecutorService executor = this.getDelegate();
        if (executor instanceof CompletionStageExecutor) {
            return ((CompletionStageExecutor)executor).supplyAsync(supplier);
        }
        if (executor instanceof AsyncClientExecutorService) {
            return ((AsyncClientExecutorService)executor).supplyAsync(supplier);
        }
        return CompletableFuture.supplyAsync(supplier, this);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.concurrent.ContextualExecutorService", ContextualExecutorService.class, null, null);
    }
}

