/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.util;

import jakarta.faces.context.ExternalContext;
import jakarta.servlet.SessionCookieConfig;
import jakarta.validation.Validation;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.util.lang.ClassUtils;
import org.apache.myfaces.util.lang.Lazy;

public final class ExternalSpecifications {
    private static final Logger log = Logger.getLogger(ExternalSpecifications.class.getName());
    private static Lazy<Boolean> beanValidationAvailable = new Lazy<Boolean>(() -> {
        boolean available;
        try {
            try {
                available = ClassUtils.classForName("jakarta.validation.Validation") != null;
            }
            catch (ClassNotFoundException e) {
                available = false;
            }
            if (available) {
                try {
                    Validation.buildDefaultValidatorFactory().getValidator();
                }
                catch (Throwable t) {
                    available = false;
                }
            }
        }
        catch (Throwable t) {
            log.log(Level.FINE, "Error loading class (could be normal)", t);
            available = false;
        }
        log.info("MyFaces Core Bean Validation support " + (available ? "enabled" : "disabled"));
        return available;
    });
    private static Lazy<Boolean> cdiAvailable = new Lazy<Boolean>(() -> {
        boolean available;
        try {
            available = ClassUtils.classForName("jakarta.enterprise.inject.spi.BeanManager") != null;
        }
        catch (Throwable t) {
            available = false;
        }
        log.info("MyFaces Core CDI support " + (available ? "enabled" : "disabled"));
        return available;
    });
    private static Lazy<Boolean> sevlet6Available = new Lazy<Boolean>(() -> {
        boolean available;
        try {
            available = SessionCookieConfig.class.getMethod("getAttribute", String.class) != null;
        }
        catch (Throwable t) {
            available = false;
        }
        log.info("MyFaces Core Servlet 6.0 support " + (available ? "enabled" : "disabled"));
        return available;
    });
    private static Lazy<Boolean> el6Available = new Lazy<Boolean>(() -> {
        boolean available;
        try {
            available = ClassUtils.classForName("jakarta.el.OptionalELResolver") != null;
        }
        catch (Throwable t) {
            available = false;
        }
        log.info("MyFaces Core: EL 6.0 support " + (available ? "enabled" : "disabled"));
        return available;
    });

    public static boolean isBeanValidationAvailable() {
        return beanValidationAvailable.get();
    }

    public static boolean isCDIAvailable(ExternalContext externalContext) {
        return cdiAvailable.get() != false && externalContext.getApplicationMap().containsKey("oam.cdi.BEAN_MANAGER_INSTANCE");
    }

    public static boolean isServlet6Available() {
        return sevlet6Available.get();
    }

    public static boolean isEL6Available() {
        return el6Available.get();
    }

    private ExternalSpecifications() {
    }
}

