/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session.monitor;

import com.ibm.websphere.monitor.annotation.Args;
import com.ibm.websphere.monitor.annotation.Monitor;
import com.ibm.websphere.monitor.annotation.ProbeAtEntry;
import com.ibm.websphere.monitor.annotation.ProbeSite;
import com.ibm.websphere.monitor.annotation.PublishedMetric;
import com.ibm.websphere.monitor.meters.MeterCollection;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.session.monitor.LegacyMonitor;
import com.ibm.ws.session.monitor.SessionStats;
import com.ibm.wsspi.pmi.factory.StatisticActions;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.pmi.factory.StatsFactoryException;
import com.ibm.wsspi.pmi.factory.StatsGroup;
import com.ibm.wsspi.session.ISession;
import java.util.HashMap;

@Monitor(group={"Session"})
public class SessionMonitor
extends StatisticActions {
    @PublishedMetric
    private MeterCollection<SessionStats> sessionCountByName = new MeterCollection("Session", (Object)this);
    private static final TraceComponent tc = Tr.register(SessionMonitor.class, (String)"Monitor");
    private static HashMap<String, SessionStats> tMap = new HashMap();
    public static final int ACTIVE_SESSIONS = 6;
    public static final int LIVE_SESSIONS = 7;
    public static final int CREATE_SESSIONS = 1;
    public static final int INVALIDATED_SESSIONS = 2;
    public static final int INVALIDATED_SESSIONS_BYTIMEOUT = 16;
    private static final String template = "/com/ibm/ws/session/monitor/xml/servletSessionsModule.xml";
    private StatsGroup grp;
    private HashMap<String, LegacyMonitor> tCPMIMap = new HashMap();

    public SessionMonitor() {
        try {
            if (StatsFactory.isPMIEnabled()) {
                this.grp = StatsFactory.createStatsGroup((String)"SessionStats", (String)template, null, (StatisticActions)this);
            }
        }
        catch (StatsFactoryException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Session Module is not registered with PMI", (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)((Object)((Object)this)).getClass().getName(), (String)"SessionMonitor");
        }
    }

    private synchronized SessionStats initializeSessionStats(String appName, SessionStats sessionStats) {
        SessionStats newStats;
        block4: {
            newStats = (SessionStats)this.sessionCountByName.get(appName);
            try {
                if (newStats == null) {
                    newStats = new SessionStats();
                    this.sessionCountByName.put(appName, (Object)newStats);
                    if (StatsFactory.isPMIEnabled()) {
                        this.tCPMIMap.put(appName, new LegacyMonitor(appName, this.grp));
                        tMap.put(appName, newStats);
                    }
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)"Exception occured ", (Object[])new Object[]{e.getMessage()});
            }
        }
        return newStats;
    }

    @ProbeAtEntry
    @ProbeSite(clazz="com.ibm.ws.session.SessionEventDispatcher", method="sessionLiveCountInc", args="java.lang.Object")
    public void IncrementLiveCount(@Args Object[] myargs) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"IncrementLiveCount", (Object[])new Object[0]);
        }
        if (myargs == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"IncrementLiveCount", (Object)"Args list is null");
            }
            return;
        }
        ISession session = (ISession)myargs[0];
        if (session == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"IncrementLiveCount", (Object)"session object is null");
            }
            return;
        }
        String appName = session.getIStore().getId();
        SessionStats sStats = (SessionStats)this.sessionCountByName.get(appName);
        if (sStats == null) {
            sStats = this.initializeSessionStats(appName, new SessionStats());
        }
        sStats.liveCountInc();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"IncrementLiveCount");
        }
    }

    @ProbeAtEntry
    @ProbeSite(clazz="com.ibm.ws.session.SessionEventDispatcher", method="sessionLiveCountDec", args="java.lang.Object")
    public void DecrementLiveCount(@Args Object[] myargs) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DecrementLiveCount", (Object[])new Object[0]);
        }
        if (myargs == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"DecrementLiveCount", (Object)"Args is null");
            }
            return;
        }
        ISession session = (ISession)myargs[0];
        if (session == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"DecrementLiveCount", (Object)"session is null");
            }
            return;
        }
        String appName = session.getIStore().getId();
        if (this.sessionCountByName.get(appName) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"DecrementLiveCount", (Object)"AppName Not found in MeterCollection");
            }
            return;
        }
        SessionStats sStats = (SessionStats)this.sessionCountByName.get(appName);
        sStats.liveCountDec();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"DecrementLiveCount");
        }
    }

    @ProbeAtEntry
    @ProbeSite(clazz="com.ibm.ws.session.SessionEventDispatcher", method="sessionAccessed", args="com.ibm.wsspi.session.ISession")
    public void IncrementActiveCount(@Args Object[] myargs) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"IncrementActiveCount", (Object[])new Object[0]);
        }
        if (myargs == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"IncrementActiveCount", (Object)"Args is null");
            }
            return;
        }
        ISession session = (ISession)myargs[0];
        if (session == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"IncrementActiveCount", (Object)"Session Object is null");
            }
            return;
        }
        String appName = session.getIStore().getId();
        SessionStats sStats = (SessionStats)this.sessionCountByName.get(appName);
        if (sStats == null) {
            sStats = this.initializeSessionStats(appName, new SessionStats());
        }
        sStats.activeCountInc();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"IncrementActiveCount");
        }
    }

    @ProbeAtEntry
    @ProbeSite(clazz="com.ibm.ws.session.SessionEventDispatcher", method="sessionReleased", args="com.ibm.wsspi.session.ISession")
    public void DecrementActiveCount(@Args Object[] myargs) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DecrementActiveCount", (Object[])new Object[0]);
        }
        if (myargs == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"DecrementActiveCount", (Object)"Args is null");
            }
            return;
        }
        ISession session = (ISession)myargs[0];
        if (session == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"DecrementActiveCount", (Object)"Session Object is null");
            }
            return;
        }
        String appName = session.getIStore().getId();
        if (this.sessionCountByName.get(appName) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"DecrementActiveCount", (Object)"AppName Not found in MeterCollection");
            }
            return;
        }
        SessionStats sStats = (SessionStats)this.sessionCountByName.get(appName);
        sStats.activeCountDec();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"DecrementActiveCount");
        }
    }

    @ProbeAtEntry
    @ProbeSite(clazz="com.ibm.ws.session.SessionEventDispatcher", method="sessionCreated", args="com.ibm.wsspi.session.ISession")
    public void incrementCreateCount(@Args Object[] myargs) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"incrementCreateCount", (Object[])new Object[0]);
        }
        if (myargs == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"incrementCreateCount", (Object)"Args is null");
            }
            return;
        }
        ISession session = (ISession)myargs[0];
        if (session == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"incrementCreateCount", (Object)"Session Object is null");
            }
            return;
        }
        String appName = session.getIStore().getId();
        SessionStats sStats = (SessionStats)this.sessionCountByName.get(appName);
        if (sStats == null) {
            sStats = this.initializeSessionStats(appName, new SessionStats());
        }
        sStats.incCreateCount();
        sStats.activeCountInc();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"incrementCreateCount");
        }
    }

    @ProbeAtEntry
    @ProbeSite(clazz="com.ibm.ws.session.SessionEventDispatcher", method="sessionDestroyedByTimeout", args="com.ibm.wsspi.session.ISession")
    public void InvalidatedSessionsByTimeout(@Args Object[] myargs) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"InvalidatedSessionsByTimeout", (Object[])new Object[0]);
        }
        if (myargs == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"InvalidatedSessionsByTimeout", (Object)"Args is null");
            }
            return;
        }
        ISession session = (ISession)myargs[0];
        if (session == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"InvalidatedSessionsByTimeout", (Object)"Session Object is null");
            }
            return;
        }
        String appName = session.getIStore().getId();
        if (this.sessionCountByName.get(appName) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"InvalidatedSessionsByTimeout", (Object)"AppName Not found in MeterCollection");
            }
            return;
        }
        SessionStats sStats = (SessionStats)this.sessionCountByName.get(appName);
        sStats.setInvalidatedCountbyTimeout();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"InvalidatedSessionsByTimeout");
        }
    }

    @ProbeAtEntry
    @ProbeSite(clazz="com.ibm.ws.session.SessionEventDispatcher", method="sessionDestroyed", args="com.ibm.wsspi.session.ISession")
    public void InvalidatedSessions(@Args Object[] myargs) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"InvalidatedSessions", (Object[])new Object[0]);
        }
        if (myargs == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"InvalidatedSessions", (Object)"Args is null");
            }
            return;
        }
        ISession session = (ISession)myargs[0];
        if (session == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"InvalidatedSessions", (Object)"Session Object is null");
            }
            return;
        }
        String appName = session.getIStore().getId();
        if (this.sessionCountByName.get(appName) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"InvalidatedSessions", (Object)"AppName Not found in MeterCollection");
            }
            return;
        }
        SessionStats sStats = (SessionStats)this.sessionCountByName.get(appName);
        sStats.setInvalidatedCount();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"InvalidatedSessions");
        }
    }

    @ProbeAtEntry
    @ProbeSite(clazz="com.ibm.ws.session.SessionStatistics", method="sessionDestroyed", args="com.ibm.wsspi.session.ISession")
    public void InvalidatedSessionsinDB(@Args Object[] myargs) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"InvalidatedSessionsinDB", (Object[])new Object[0]);
        }
        if (myargs == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"InvalidatedSessionsinDB", (Object)"Args is null");
            }
            return;
        }
        ISession session = (ISession)myargs[0];
        if (session == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"InvalidatedSessionsinDB", (Object)"Session Object is null");
            }
            return;
        }
        String appName = session.getIStore().getId();
        if (this.sessionCountByName.get(appName) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"InvalidatedSessionsinDB", (Object)"AppName Not found in MeterCollection");
            }
            return;
        }
        SessionStats sStats = (SessionStats)this.sessionCountByName.get(appName);
        sStats.setInvalidatedCount();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"InvalidatedSessionsinDB");
        }
    }

    @ProbeAtEntry
    @ProbeSite(clazz="com.ibm.ws.session.SessionStatistics", method="sessionDestroyedByTimeout", args="com.ibm.wsspi.session.ISession")
    public void InvalidatedSessionsbyTimeoutinDB(@Args Object[] myargs) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"InvalidatedSessionsbyTimeoutinDB", (Object[])new Object[0]);
        }
        if (myargs == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"InvalidatedSessionsbyTimeoutinDB", (Object)"Args is null");
            }
            return;
        }
        ISession session = (ISession)myargs[0];
        if (session == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"InvalidatedSessionsbyTimeoutinDB", (Object)"Session Object is null");
            }
            return;
        }
        String appName = session.getIStore().getId();
        if (this.sessionCountByName.get(appName) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"InvalidatedSessionsbyTimeoutinDB", (Object)"AppName Not found in MeterCollection");
            }
            return;
        }
        SessionStats sStats = (SessionStats)this.sessionCountByName.get(appName);
        sStats.setInvalidatedCountbyTimeout();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"InvalidatedSessionsbyTimeoutinDB");
        }
    }

    static SessionStats getSessionStatsOB(String appName) {
        return tMap.get(appName);
    }
}

