/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.dispatcher.internal.channel;

import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.http.channel.internal.HttpBaseMessageImpl;
import com.ibm.ws.http.channel.internal.inbound.HttpInputStreamImpl;
import com.ibm.wsspi.genericbnf.HeaderField;
import com.ibm.wsspi.http.HttpCookie;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.HttpTrailers;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import com.ibm.wsspi.http.ee7.HttpInputStreamEE7;
import com.ibm.wsspi.http.ee8.Http2PushBuilder;
import com.ibm.wsspi.http.ee8.Http2Request;
import io.netty.handler.codec.http.FullHttpRequest;
import io.openliberty.http.ext.HttpRequestExt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

@Trivial
public class HttpRequestImpl
implements Http2Request,
HttpRequestExt {
    private HttpRequestMessage message = null;
    private HttpInputStreamImpl body = null;
    private boolean useEE7Streams = false;

    public HttpRequestImpl() {
    }

    public HttpRequestImpl(boolean useEE7Streams) {
        this.useEE7Streams = useEE7Streams;
    }

    public void init(HttpInboundServiceContext context) {
        this.message = context.getRequest();
        this.body = this.useEE7Streams ? new HttpInputStreamEE7(context) : new HttpInputStreamImpl(context);
    }

    public void init(FullHttpRequest request, HttpInboundServiceContext context) {
        this.message = context.getRequest();
        this.body = this.useEE7Streams ? new HttpInputStreamEE7(context, request) : new HttpInputStreamImpl(context, request);
    }

    @Override
    public HttpInputStreamImpl getBody() {
        return this.body;
    }

    @Override
    public long getContentLength() {
        return this.message.getContentLength();
    }

    @Override
    public HttpCookie getCookie(String name) {
        return this.message.getCookie(name);
    }

    @Override
    public List<HttpCookie> getCookies(String name) {
        return this.message.getAllCookies(name);
    }

    @Override
    public List<HttpCookie> getCookies() {
        return this.message.getAllCookies();
    }

    @Override
    public String getHeader(String name) {
        return this.message.getHeader(name).asString();
    }

    @Override
    public String getHeader(HttpHeaderKeys key) {
        return this.message.getHeader(key).asString();
    }

    @Override
    public List<String> getHeaders(String name) {
        List<String> values;
        List<HeaderField> hdrs = this.message.getHeaders(name);
        int size = hdrs.size();
        if (size == 0) {
            values = Collections.emptyList();
        } else if (size == 1) {
            values = Collections.singletonList(hdrs.get(0).asString());
        } else {
            values = new ArrayList<String>(size);
            for (HeaderField header : hdrs) {
                values.add(header.asString());
            }
        }
        return values;
    }

    @Override
    public List<String> getHeaderNames() {
        return this.message.getAllHeaderNames();
    }

    @Override
    public Set<String> getHeaderNamesSet() {
        return this.message.getAllHeaderNamesSet();
    }

    @Override
    public String getMethod() {
        return this.message.getMethod();
    }

    @Override
    @Trivial
    public String getQuery() {
        return this.message.getQueryString();
    }

    @Override
    public String getScheme() {
        return this.message.getScheme();
    }

    @Override
    public String getURI() {
        return this.message.getRequestURI();
    }

    @Override
    public String getURL() {
        return this.message.getRequestURL().toString();
    }

    @Override
    public String getVersion() {
        return this.message.getVersion();
    }

    @Override
    public String getVirtualHost() {
        return this.message.getVirtualHost();
    }

    @Override
    public int getVirtualPort() {
        return this.message.getVirtualPort();
    }

    @Trivial
    public String toString() {
        return this.getClass().getSimpleName() + "[message=" + this.message + "]";
    }

    @Override
    public void pushNewRequest(Http2PushBuilder pushBuilder) {
        this.message.pushNewRequest(pushBuilder);
    }

    @Override
    public List<String> getTrailerNames() {
        HttpTrailers trailers = this.message.getTrailers();
        if (trailers != null) {
            return trailers.getAllHeaderNames();
        }
        return null;
    }

    @Override
    public String getTrailer(String name) {
        HttpTrailers trailers = this.message.getTrailers();
        if (trailers != null) {
            return trailers.getHeader(name).asString();
        }
        return null;
    }

    @Override
    public boolean isTrailersReady() {
        boolean trailersNull;
        if (this.message instanceof HttpBaseMessageImpl) {
            trailersNull = ((HttpBaseMessageImpl)((Object)this.message)).getTrailersImpl() != null;
        } else {
            boolean bl = trailersNull = this.message.getTrailers() != null;
        }
        return !this.message.isChunkedEncodingSet() || !this.message.containsHeader(HttpHeaderKeys.HDR_TRAILER) || trailersNull || this.message.getVersionValue().getMajor() <= 1 && this.message.getVersionValue().getMinor() < 1;
    }

    @Override
    public boolean isPushSupported() {
        return this.message.isPushSupported();
    }
}

