/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.modelgen;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.processing.Messager;
import javax.tools.Diagnostic;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.localization.LoggingLocalization;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.SessionLogEntry;

final class MessagerLog
extends AbstractSessionLog {
    private final Map<String, Integer> categoryLogLevelMap;
    private final Messager out;
    private static final Writer NULL_WRITER = new Writer(){

        @Override
        public void write(char[] cbuf, int off, int len) {
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    };

    public MessagerLog(Messager out, Map<String, String> options) {
        this.out = out;
        this.writer = NULL_WRITER;
        this.categoryLogLevelMap = new HashMap<String, Integer>(loggerCatagories.length);
        for (String loggerCategory : loggerCatagories) {
            this.categoryLogLevelMap.put(loggerCategory, null);
        }
        this.initOrUpdateLevels(options);
    }

    @Override
    public void setLevel(int level, String category) {
        if (category == null) {
            this.level = level;
        } else if (this.categoryLogLevelMap.containsKey(category)) {
            this.categoryLogLevelMap.put(category, level);
        } else {
            this.log(6, "processor", "Unrecognized logger category: {0}", (Object)category, (Object)false);
        }
    }

    @Override
    public int getLevel(String category) {
        Integer lvl;
        if (category != null && (lvl = this.categoryLogLevelMap.get(category)) != null) {
            return lvl;
        }
        return super.getLevel(category);
    }

    @Override
    public boolean shouldPrintThread() {
        if (this.shouldPrintThread == null) {
            return this.getLevel() < 2;
        }
        return this.shouldPrintThread;
    }

    @Override
    public boolean shouldPrintDate() {
        if (this.shouldPrintDate == null) {
            return this.getLevel() < 2;
        }
        return this.shouldPrintDate;
    }

    @Override
    public boolean shouldPrintConnection() {
        if (this.shouldPrintConnection == null) {
            return this.getLevel() < 2;
        }
        return this.shouldPrintConnection;
    }

    @Override
    public boolean shouldLog(int level, String category) {
        return this.getLevel(category) <= level;
    }

    @Override
    public void log(SessionLogEntry entry) {
        if (!this.shouldLog(entry.getLevel(), entry.getNameSpace())) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getPrefixString(entry.getLevel(), entry.getNameSpace()));
        sb.append(this.getSupplementDetailString(entry));
        if (entry.hasMessage()) {
            sb.append(this.formatMessage(entry));
            sb.append(Helper.cr());
        }
        if (entry.hasException()) {
            if (this.shouldLogExceptionStackTrace()) {
                for (StackTraceElement stackTrace : entry.getException().getStackTrace()) {
                    sb.append(stackTrace);
                    sb.append(Helper.cr());
                }
            } else {
                sb.append(entry.getException().toString());
            }
            sb.append(Helper.cr());
        }
        if (this.getWriter() == NULL_WRITER) {
            this.out.printMessage(this.translateLevelToKind(entry.getLevel()), sb);
        } else {
            try {
                this.getWriter().write(sb.toString());
                this.getWriter().flush();
            }
            catch (IOException ioe) {
                throw ValidationException.logIOError(ioe);
            }
        }
    }

    private void initOrUpdateLevels(Map<String, String> settings) {
        String loggingFileString;
        String displayData;
        String exString;
        String connectionString;
        String sessionString;
        String threadString;
        String logLevelString = settings.get("eclipselink.logging.level");
        if (logLevelString != null) {
            this.setLevel(MessagerLog.translateStringToLoggingLevel(logLevelString));
        }
        for (Map.Entry<String, String> entry : settings.entrySet()) {
            if (!entry.getKey().startsWith("eclipselink.logging.level.")) continue;
            String ctg = entry.getKey().substring("eclipselink.logging.level.".length());
            this.setLevel(MessagerLog.translateStringToLoggingLevel(entry.getValue()), ctg);
        }
        String tsString = settings.get("eclipselink.logging.timestamp");
        if (tsString != null) {
            this.setShouldPrintDate(Boolean.parseBoolean(tsString));
        }
        if ((threadString = settings.get("eclipselink.logging.thread")) != null) {
            this.setShouldPrintThread(Boolean.parseBoolean(threadString));
        }
        if ((sessionString = settings.get("eclipselink.logging.session")) != null) {
            this.setShouldPrintSession(Boolean.parseBoolean(sessionString));
        }
        if ((connectionString = settings.get("eclipselink.logging.connection")) != null) {
            this.setShouldPrintConnection(Boolean.parseBoolean(connectionString));
        }
        if ((exString = settings.get("eclipselink.logging.exceptions")) != null) {
            this.setShouldLogExceptionStackTrace(Boolean.parseBoolean(exString));
        }
        if ((displayData = settings.get("eclipselink.logging.parameters")) != null) {
            this.setShouldDisplayData(Boolean.parseBoolean(displayData));
        }
        if ((loggingFileString = settings.get("eclipselink.logging.file")) != null) {
            if (!loggingFileString.trim().equals("")) {
                try {
                    FileOutputStream fos = new FileOutputStream(loggingFileString);
                    this.setWriter(fos);
                }
                catch (IOException e) {
                    throw ValidationException.invalidLoggingFile(loggingFileString, e);
                }
            } else {
                throw ValidationException.invalidLoggingFile();
            }
        }
    }

    private CharSequence getPrefixString(int level, String category) {
        StringBuilder sb = new StringBuilder();
        switch (level) {
            case 7: {
                if (SEVERE_PREFIX == null) {
                    SEVERE_PREFIX = LoggingLocalization.buildMessage("toplink_severe");
                }
                sb.append(SEVERE_PREFIX);
                break;
            }
            case 6: {
                if (WARNING_PREFIX == null) {
                    WARNING_PREFIX = LoggingLocalization.buildMessage("toplink_warning");
                }
                sb.append(WARNING_PREFIX);
                break;
            }
            case 5: {
                if (INFO_PREFIX == null) {
                    INFO_PREFIX = LoggingLocalization.buildMessage("toplink_info");
                }
                sb.append(INFO_PREFIX);
                break;
            }
            case 4: {
                if (CONFIG_PREFIX == null) {
                    CONFIG_PREFIX = LoggingLocalization.buildMessage("toplink_config");
                }
                sb.append(CONFIG_PREFIX);
                break;
            }
            case 3: {
                if (FINE_PREFIX == null) {
                    FINE_PREFIX = LoggingLocalization.buildMessage("toplink_fine");
                }
                sb.append(FINE_PREFIX);
                break;
            }
            case 2: {
                if (FINER_PREFIX == null) {
                    FINER_PREFIX = LoggingLocalization.buildMessage("toplink_finer");
                }
                sb.append(FINER_PREFIX);
                break;
            }
            case 1: {
                if (FINEST_PREFIX == null) {
                    FINEST_PREFIX = LoggingLocalization.buildMessage("toplink_finest");
                }
                sb.append(FINEST_PREFIX);
                break;
            }
            default: {
                if (TOPLINK_PREFIX == null) {
                    TOPLINK_PREFIX = LoggingLocalization.buildMessage("toplink");
                }
                sb.append(TOPLINK_PREFIX);
            }
        }
        if (category != null) {
            sb.append(category);
            sb.append(": ");
        }
        return sb;
    }

    private Diagnostic.Kind translateLevelToKind(int level) {
        switch (level) {
            case 6: 
            case 7: {
                return Diagnostic.Kind.WARNING;
            }
            case 5: {
                return Diagnostic.Kind.NOTE;
            }
        }
        return Diagnostic.Kind.OTHER;
    }
}

