/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.websphere.cache.DistributedNioMapObject;
import com.ibm.websphere.cache.Sizeable;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.Cache;
import com.ibm.ws.cache.CacheConfig;
import com.ibm.ws.cache.EntryInfo;
import com.ibm.ws.cache.InvalidationEvent;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.ValueSet;
import com.ibm.ws.cache.intf.DCache;
import com.ibm.ws.cache.util.ObjectSizer;
import com.ibm.ws.cache.util.SerializationUtility;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.ObjectPool;
import com.ibm.wsspi.cache.GenerateContents;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;

public class CacheEntry
implements com.ibm.websphere.cache.CacheEntry,
InvalidationEvent,
Sizeable,
Externalizable {
    private static final long serialVersionUID = -3194658354293955553L;
    private static TraceComponent tc = Tr.register(CacheEntry.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final String EMPTY_STRING = "";
    private static boolean errorAlreadyDisplayed = false;
    protected String cacheName = null;
    public Object id = null;
    protected byte[] serializedId = null;
    protected Object value = null;
    protected byte[] serializedValue = null;
    protected int valueHashcode = 0;
    protected Object userMetaData = null;
    protected byte[] serializedUserMetaData = null;
    protected int priority = CacheConfig.DEFAULT_PRIORITY;
    protected int timeLimit = -1;
    protected int inactivity = -1;
    public long expirationTime = -1L;
    public long validatorExpirationTime = -1L;
    protected long drsClock = -1L;
    public long timeStamp = -1L;
    protected String[] _templates = EMPTY_STRING_ARRAY;
    protected Object[] _dataIds = EMPTY_OBJECT_ARRAY;
    protected Object[] _serializedDataIds = null;
    protected boolean pendingRemoval = false;
    protected int sharingPolicy = 1;
    protected boolean persistToDisk = true;
    public int cacheType = 0;
    protected boolean useByteBuffer = false;
    protected boolean skipMemoryAndWriteToDisk = false;
    protected String externalCacheGroupId = null;
    protected transient CacheEntryPool cacheEntryPool = null;
    protected transient int clock = CacheConfig.DEFAULT_PRIORITY;
    private transient AtomicInteger refCount = new AtomicInteger(0);
    protected transient boolean removeWhenUnpinned = false;
    protected transient boolean isOverflowEntry = false;
    protected transient boolean lruEvicted = false;
    protected Object[] aliasList = EMPTY_OBJECT_ARRAY;
    protected Object[] serializedAliasList = null;
    protected transient LRUHead lruHead;
    protected transient CacheEntry _previous = null;
    protected transient CacheEntry _next = null;
    protected transient boolean loadedFromDisk = false;
    protected transient boolean skipValueSerialized = false;
    protected transient int skipMemoryAndWriteToDiskErrorCode = 0;
    protected transient int vbcSource = 0;

    @Override
    public synchronized boolean prepareForSerialization() {
        boolean success = true;
        boolean serialized = false;
        String exceptionMessage = null;
        long oldSize = 0L;
        long newSize = 0L;
        if (this.cacheEntryPool != null && this.cacheEntryPool.cache.isCacheSizeInMBEnabled()) {
            oldSize = this.getObjectSize();
        }
        if (this.value != null) {
            try {
                this.serializedValue = SerializationUtility.serialize((Serializable)this.value);
                if (this.useByteBuffer && this.value instanceof DistributedNioMapObject) {
                    ((DistributedNioMapObject)this.value).release();
                }
                this.value = null;
                serialized = true;
            }
            catch (Exception e) {
                exceptionMessage = e.toString();
            }
            if (this.value != null) {
                Tr.error((TraceComponent)tc, (String)"DYNA0052E", (Object[])new Object[]{this.id, this.value.getClass().getName(), "cache-value", exceptionMessage});
                success = false;
            }
        }
        if (this.serializedId == null && success) {
            try {
                this.serializedId = SerializationUtility.serialize((Serializable)this.id);
                serialized = true;
            }
            catch (Exception e) {
                exceptionMessage = e.toString();
            }
            if (this.serializedId == null) {
                Tr.error((TraceComponent)tc, (String)"DYNA0052E", (Object[])new Object[]{this.id, this.id == null ? "null" : this.id.getClass().getName(), "cache-id", exceptionMessage});
                success = false;
            }
        }
        if (this._serializedDataIds == null && this._dataIds.length > 0 && success) {
            this._serializedDataIds = new Object[this._dataIds.length];
            int i = 0;
            try {
                for (i = 0; i < this._dataIds.length; ++i) {
                    this._serializedDataIds[i] = SerializationUtility.serialize((Serializable)this._dataIds[i]);
                }
                serialized = true;
            }
            catch (Exception e) {
                exceptionMessage = e.toString();
            }
            if (exceptionMessage != null) {
                if (this._dataIds[i] != null) {
                    Tr.error((TraceComponent)tc, (String)"DYNA0052E", (Object[])new Object[]{this.id, this._dataIds[i] == null ? "null" : this._dataIds[i].getClass().getName(), "dep-id", exceptionMessage});
                }
                success = false;
                this._serializedDataIds = null;
            }
        }
        if (this.serializedAliasList == null && this.aliasList.length > 0 && success) {
            this.serializedAliasList = new Object[this.aliasList.length];
            int i = 0;
            try {
                for (i = 0; i < this.aliasList.length; ++i) {
                    this.serializedAliasList[i] = SerializationUtility.serialize((Serializable)this.aliasList[i]);
                }
                serialized = true;
            }
            catch (Exception e) {
                exceptionMessage = e.toString();
            }
            if (exceptionMessage != null) {
                if (this.aliasList[i] != null) {
                    Tr.error((TraceComponent)tc, (String)"DYNA0052E", (Object[])new Object[]{this.id, this.aliasList[i] == null ? "null" : this.aliasList[i].getClass().getName(), "alias-id", exceptionMessage});
                }
                success = false;
                this.serializedAliasList = null;
            }
        }
        if (this.userMetaData != null && success) {
            try {
                this.serializedUserMetaData = SerializationUtility.serialize((Serializable)this.userMetaData);
                this.userMetaData = null;
                serialized = true;
            }
            catch (Exception e) {
                exceptionMessage = e.toString();
            }
            if (this.userMetaData != null) {
                Tr.error((TraceComponent)tc, (String)"DYNA0052E", (Object[])new Object[]{this.id, this.userMetaData.getClass().getName(), "metadata", exceptionMessage});
                success = false;
            }
        }
        if (success && serialized && this.cacheEntryPool != null && this.cacheEntryPool.cache.isCacheSizeInMBEnabled()) {
            newSize = this.getObjectSize();
            if (oldSize != -1L && newSize != -1L) {
                this.cacheEntryPool.cache.increaseCacheSizeInBytes(newSize - oldSize, "PREPARE_SER");
            } else {
                this.cacheEntryPool.cache.disableCacheSizeInMB();
            }
        }
        return success;
    }

    public void processDrsInbound(long localClock) {
        if (this.drsClock <= 0L) {
            return;
        }
        long clockDifference = localClock - this.drsClock;
        if (this.expirationTime > 0L) {
            this.expirationTime += clockDifference;
        }
        if (this.timeStamp > 0L) {
            this.timeStamp += clockDifference;
        }
        this.drsClock = -1L;
    }

    public void processDrsOutbound() {
        this.drsClock = System.currentTimeMillis();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int i;
        if (!this.prepareForSerialization()) {
            throw new IOException("Object not serializable: " + (this.value == null ? "null object" : this.value.getClass().getName()));
        }
        out.writeUTF(this.cacheName);
        if (this.serializedId != null) {
            out.writeInt(this.serializedId.length);
            out.write(this.serializedId);
        } else {
            out.writeInt(-1);
        }
        if (this.skipValueSerialized) {
            out.writeInt(-1);
        } else if (this.serializedValue != null) {
            out.writeInt(this.serializedValue.length);
            out.write(this.serializedValue);
        } else {
            out.writeInt(-1);
        }
        out.writeInt(this.priority);
        out.writeInt(this.timeLimit);
        out.writeInt(this.inactivity);
        out.writeLong(this.expirationTime);
        out.writeLong(this.timeStamp);
        out.writeLong(this.drsClock);
        out.writeInt(this.cacheType);
        out.writeObject(this._templates);
        if (this._serializedDataIds != null) {
            out.writeInt(this._serializedDataIds.length);
            for (i = 0; i < this._serializedDataIds.length; ++i) {
                byte[] did = (byte[])this._serializedDataIds[i];
                out.writeInt(did.length);
                out.write(did);
            }
        } else {
            out.writeInt(-1);
        }
        out.writeBoolean(this.pendingRemoval);
        out.writeInt(this.sharingPolicy);
        out.writeBoolean(this.persistToDisk);
        out.writeBoolean(true);
        out.writeBoolean(this.useByteBuffer);
        if (this.serializedAliasList != null) {
            out.writeInt(this.serializedAliasList.length);
            for (i = 0; i < this.serializedAliasList.length; ++i) {
                byte[] aid = (byte[])this.serializedAliasList[i];
                out.writeInt(aid.length);
                out.write(aid);
            }
        } else {
            out.writeInt(-1);
        }
        if (this.serializedUserMetaData != null) {
            out.writeInt(this.serializedUserMetaData.length);
            out.write(this.serializedUserMetaData);
        } else {
            out.writeInt(-1);
        }
        out.writeBoolean(this.skipMemoryAndWriteToDisk);
        out.writeInt(this.valueHashcode);
        out.writeLong(this.validatorExpirationTime);
        if (this.externalCacheGroupId != null) {
            out.writeUTF(this.externalCacheGroupId);
        } else {
            out.writeUTF(EMPTY_STRING);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        block40: {
            block39: {
                block38: {
                    block37: {
                        try {
                            int i;
                            int len;
                            this.cacheName = in.readUTF();
                            int keyLength = in.readInt();
                            if (keyLength > 0) {
                                this.serializedId = new byte[keyLength];
                                in.readFully(this.serializedId);
                            } else {
                                this.serializedId = null;
                            }
                            if (this.serializedId != null) {
                                try {
                                    this.id = SerializationUtility.deserialize(this.serializedId, this.cacheName);
                                }
                                catch (Exception ex) {
                                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.CacheEntry.readExternal", (String)"366", (Object)this);
                                }
                            } else {
                                this.id = null;
                            }
                            if ((len = in.readInt()) > 0) {
                                this.serializedValue = new byte[len];
                                in.readFully(this.serializedValue);
                            } else {
                                this.serializedValue = null;
                            }
                            this.value = null;
                            this.priority = in.readInt();
                            this.timeLimit = in.readInt();
                            this.inactivity = in.readInt();
                            this.expirationTime = in.readLong();
                            this.timeStamp = in.readLong();
                            this.drsClock = in.readLong();
                            this.cacheType = in.readInt();
                            this._templates = (String[])in.readObject();
                            int size = in.readInt();
                            if (size > 0) {
                                this._serializedDataIds = new Object[size];
                                for (i = 0; i < size; ++i) {
                                    len = in.readInt();
                                    this._serializedDataIds[i] = new byte[len];
                                    in.readFully((byte[])this._serializedDataIds[i]);
                                }
                            } else {
                                this._serializedDataIds = null;
                            }
                            if (this._serializedDataIds != null) {
                                this._dataIds = new Object[this._serializedDataIds.length];
                                try {
                                    for (i = 0; i < this._serializedDataIds.length; ++i) {
                                        this._dataIds[i] = SerializationUtility.deserialize((byte[])this._serializedDataIds[i], this.cacheName);
                                    }
                                    this._serializedDataIds = null;
                                }
                                catch (Exception ex) {
                                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.CacheEntry.readExternal", (String)"388", (Object)this);
                                    this._dataIds = EMPTY_OBJECT_ARRAY;
                                }
                            } else {
                                this._dataIds = EMPTY_OBJECT_ARRAY;
                            }
                            this.pendingRemoval = in.readBoolean();
                            this.sharingPolicy = in.readInt();
                            this.persistToDisk = in.readBoolean();
                            in.readBoolean();
                            this.useByteBuffer = in.readBoolean();
                            size = in.readInt();
                            if (size > 0) {
                                this.serializedAliasList = new Object[size];
                                for (int i2 = 0; i2 < size; ++i2) {
                                    len = in.readInt();
                                    this.serializedAliasList[i2] = new byte[len];
                                    in.readFully((byte[])this.serializedAliasList[i2]);
                                }
                            } else {
                                this.serializedAliasList = null;
                            }
                            if (this.serializedAliasList != null) {
                                this.aliasList = new Object[this.serializedAliasList.length];
                                try {
                                    for (int i3 = 0; i3 < this.serializedAliasList.length; ++i3) {
                                        this.aliasList[i3] = SerializationUtility.deserialize((byte[])this.serializedAliasList[i3], this.cacheName);
                                    }
                                    this.serializedAliasList = null;
                                }
                                catch (Exception ex) {
                                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.CacheEntry.readExternal", (String)"428", (Object)this);
                                    this.aliasList = EMPTY_OBJECT_ARRAY;
                                }
                            } else {
                                this.aliasList = EMPTY_OBJECT_ARRAY;
                            }
                            if ((len = in.readInt()) > 0) {
                                this.serializedUserMetaData = new byte[len];
                                in.readFully(this.serializedUserMetaData);
                            } else {
                                this.serializedUserMetaData = null;
                            }
                            this.userMetaData = null;
                        }
                        catch (Exception ex) {
                            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.CacheEntry.readExternal", (String)"468", (Object)this);
                            return;
                        }
                        try {
                            this.skipMemoryAndWriteToDisk = in.readBoolean();
                        }
                        catch (Exception ex) {
                            this.skipMemoryAndWriteToDisk = false;
                            if (errorAlreadyDisplayed || !tc.isDebugEnabled()) break block37;
                            Tr.debug((TraceComponent)tc, (String)"Old format: missing skipMemoryAndWriteToDisk boolean during deserialization of cache entry.", (Object[])new Object[0]);
                            errorAlreadyDisplayed = true;
                        }
                    }
                    try {
                        this.valueHashcode = in.readInt();
                    }
                    catch (Exception ex) {
                        Object val = this.getValue();
                        this.valueHashcode = val != null ? val.hashCode() : 0;
                        if (errorAlreadyDisplayed || !tc.isDebugEnabled()) break block38;
                        Tr.debug((TraceComponent)tc, (String)"Old format: missing hashcode for value during deserialization of cache entry.", (Object[])new Object[0]);
                        errorAlreadyDisplayed = true;
                    }
                }
                try {
                    this.validatorExpirationTime = in.readLong();
                }
                catch (Exception ex) {
                    this.validatorExpirationTime = -1L;
                    if (errorAlreadyDisplayed || !tc.isDebugEnabled()) break block39;
                    Tr.debug((TraceComponent)tc, (String)"Old format: missing validator expiration time during deserialization of cache entry.", (Object[])new Object[0]);
                    errorAlreadyDisplayed = true;
                }
            }
            try {
                String externalCacheGroupId = in.readUTF();
                if (externalCacheGroupId.equals(EMPTY_STRING)) {
                    externalCacheGroupId = null;
                }
            }
            catch (IOException ioe) {
                if (errorAlreadyDisplayed || !tc.isDebugEnabled()) break block40;
                Tr.debug((TraceComponent)tc, (String)("Could not read externalCacheGroupId: " + ioe.getMessage()), (Object[])new Object[0]);
                errorAlreadyDisplayed = true;
            }
        }
    }

    @Override
    public synchronized Object getValue() {
        if (this.id != null && this.serializedValue != null) {
            long oldSize = -1L;
            if (this.cacheEntryPool != null && this.cacheEntryPool.cache.isCacheSizeInMBEnabled()) {
                oldSize = this.getObjectSize();
            }
            try {
                this.value = SerializationUtility.deserialize(this.serializedValue, this.cacheName);
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.CacheEntry.getValue", (String)"200", (Object)this);
            }
            if (this.value != null) {
                this.serializedValue = null;
                if (this.cacheEntryPool != null && this.cacheEntryPool.cache.isCacheSizeInMBEnabled()) {
                    long newSize = this.getObjectSize();
                    if (oldSize != -1L && newSize != -1L) {
                        this.cacheEntryPool.cache.increaseCacheSizeInBytes(newSize - oldSize, "GET_VALUE");
                    } else {
                        this.cacheEntryPool.cache.disableCacheSizeInMB();
                    }
                }
            }
        }
        return this.value;
    }

    public byte[] getSerializedValue() {
        return this.serializedValue;
    }

    protected void setValue(Object value) {
        this.value = value;
        this.serializedValue = null;
        this.timeStamp = System.currentTimeMillis();
        this.valueHashcode = 0;
    }

    @Override
    public Enumeration getTemplates() {
        return new ArrayEnumerator(this._templates);
    }

    public String getTemplate() {
        if (this._templates.length > 0) {
            return this._templates[0];
        }
        return null;
    }

    @Override
    public Enumeration getDataIds() {
        return new ArrayEnumerator(this._dataIds);
    }

    @Override
    public void refreshEntry() {
        this.clock = this.priority;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void reset() {
        if (this.refCount.get() > 0 && this.isRefCountingEnabled()) {
            Tr.warning((TraceComponent)tc, (String)("reset called on " + this.id + " with a refCount of " + this.refCount), (Object[])new Object[0]);
            Thread.dumpStack();
        }
        this.cacheName = null;
        this.drsClock = -1L;
        this.timeStamp = -1L;
        this.serializedId = null;
        this.id = null;
        if (this.useByteBuffer && this.value != null && this.value instanceof DistributedNioMapObject) {
            ((DistributedNioMapObject)this.value).release();
        }
        this.serializedValue = null;
        this.value = null;
        this.clock = CacheConfig.DEFAULT_PRIORITY;
        this.refCount.set(0);
        this.priority = CacheConfig.DEFAULT_PRIORITY;
        this.timeLimit = -1;
        this.inactivity = -1;
        this.expirationTime = -1L;
        this.validatorExpirationTime = -1L;
        this.removeWhenUnpinned = false;
        this._templates = EMPTY_STRING_ARRAY;
        this._dataIds = EMPTY_OBJECT_ARRAY;
        this._serializedDataIds = null;
        this.pendingRemoval = false;
        this.sharingPolicy = 1;
        this.persistToDisk = true;
        this.isOverflowEntry = false;
        this.lruEvicted = false;
        this.lruHead = null;
        this.useByteBuffer = false;
        this.aliasList = EMPTY_OBJECT_ARRAY;
        this.serializedAliasList = null;
        this.userMetaData = null;
        this.serializedUserMetaData = null;
        this.loadedFromDisk = false;
        this.cacheType = 0;
        this.skipValueSerialized = false;
        this.skipMemoryAndWriteToDisk = false;
        this.skipMemoryAndWriteToDiskErrorCode = 0;
        this.valueHashcode = 0;
        this.externalCacheGroupId = null;
    }

    public void copy(CacheEntry cacheEntry) {
        if (cacheEntry == this) {
            return;
        }
        if (this.useByteBuffer && this.value != null && this.value instanceof DistributedNioMapObject) {
            ((DistributedNioMapObject)this.value).release();
        }
        this.value = cacheEntry.value;
        this.valueHashcode = cacheEntry.valueHashcode;
        this.serializedValue = cacheEntry.serializedValue;
        this.serializedId = cacheEntry.serializedId;
        this.timeStamp = cacheEntry.timeStamp;
        this.expirationTime = cacheEntry.expirationTime;
        this.validatorExpirationTime = cacheEntry.validatorExpirationTime;
        this.timeLimit = cacheEntry.timeLimit;
        this.inactivity = cacheEntry.inactivity;
        this.drsClock = cacheEntry.drsClock;
        this.id = cacheEntry.id;
        this.priority = cacheEntry.priority;
        if (this.priority < 0) {
            this.priority = 0;
        }
        if (this.priority > CacheConfig.MAX_PRIORITY) {
            this.priority = CacheConfig.MAX_PRIORITY;
        }
        this._templates = cacheEntry._templates;
        this._dataIds = cacheEntry._dataIds;
        this._serializedDataIds = cacheEntry._serializedDataIds;
        this.sharingPolicy = cacheEntry.sharingPolicy;
        this.persistToDisk = cacheEntry.persistToDisk;
        this.refCount = new AtomicInteger(cacheEntry.refCount.get());
        this.aliasList = cacheEntry.aliasList;
        this.serializedAliasList = cacheEntry.serializedAliasList;
        this.useByteBuffer = cacheEntry.useByteBuffer;
        this.userMetaData = cacheEntry.userMetaData;
        this.serializedUserMetaData = cacheEntry.serializedUserMetaData;
        this.loadedFromDisk = cacheEntry.loadedFromDisk;
        this.cacheType = cacheEntry.cacheType;
        this.skipValueSerialized = cacheEntry.skipValueSerialized;
        this.skipMemoryAndWriteToDisk = cacheEntry.skipMemoryAndWriteToDisk;
        this.skipMemoryAndWriteToDiskErrorCode = cacheEntry.skipMemoryAndWriteToDiskErrorCode;
        this.vbcSource = cacheEntry.vbcSource;
        this.externalCacheGroupId = cacheEntry.externalCacheGroupId;
    }

    public void copyMetaData(EntryInfo entryInfo) {
        entryInfo.lock();
        if (!entryInfo.wasIdSet()) {
            throw new IllegalStateException("id was not set on entryInfo");
        }
        this.id = entryInfo.id;
        this.timeLimit = entryInfo.timeLimit;
        this.inactivity = entryInfo.inactivity;
        this.expirationTime = entryInfo.expirationTime;
        this.validatorExpirationTime = entryInfo.validatorExpirationTime;
        this.priority = entryInfo.priority;
        if (this.priority < 0) {
            this.priority = 0;
        }
        if (this.priority > CacheConfig.MAX_PRIORITY) {
            this.priority = CacheConfig.MAX_PRIORITY;
        }
        this._templates = entryInfo.templates.size() > 0 ? entryInfo.templates.toArray(new String[entryInfo.templates.size()]) : EMPTY_STRING_ARRAY;
        this._dataIds = entryInfo.dataIds.size() > 0 ? entryInfo.dataIds.toArray(new Object[entryInfo.dataIds.size()]) : EMPTY_OBJECT_ARRAY;
        this.aliasList = entryInfo.aliasList.size() > 0 ? entryInfo.aliasList.toArray(new Object[entryInfo.aliasList.size()]) : EMPTY_OBJECT_ARRAY;
        this.sharingPolicy = entryInfo.sharingPolicy;
        this.persistToDisk = entryInfo.persistToDisk;
        this.cacheType = entryInfo.cacheType;
        this.userMetaData = entryInfo.userMetaData;
        this.externalCacheGroupId = entryInfo.externalCacheGroupId;
        this._serializedDataIds = null;
        this.serializedAliasList = null;
        this.serializedUserMetaData = null;
        this.loadedFromDisk = false;
        this.skipValueSerialized = false;
        this.skipMemoryAndWriteToDisk = false;
        this.skipMemoryAndWriteToDiskErrorCode = 0;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CacheEntry)) {
            return false;
        }
        CacheEntry cacheEntry = (CacheEntry)object;
        if (this.id == null || cacheEntry.id == null) {
            return super.equals(object);
        }
        return this.id.equals(cacheEntry.id);
    }

    @Override
    public int hashCode() {
        if (this.id == null) {
            return CacheEntry.class.hashCode();
        }
        return this.id.hashCode();
    }

    @Override
    public int getTimeLimit() {
        return this.timeLimit;
    }

    public int getInactivity() {
        return this.inactivity;
    }

    @Override
    public long getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(long expirationTime) {
        this.expirationTime = expirationTime;
        this.timeLimit = (int)((this.expirationTime - System.currentTimeMillis()) / 1000L);
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public int getSharingPolicy() {
        return this.sharingPolicy;
    }

    @Override
    public boolean isBatchEnabled() {
        return true;
    }

    @Override
    public String getId() {
        if (this.id != null) {
            return this.id.toString();
        }
        return null;
    }

    @Override
    public Object getIdObject() {
        return this.id;
    }

    public byte[] getSerializedId() {
        return this.serializedId;
    }

    @Override
    public byte[] getDisplayValue() {
        byte[] returnme;
        block9: {
            this.getValue();
            if (this.value == null) {
                return new byte[0];
            }
            if (this.value instanceof GenerateContents) {
                try {
                    return ((GenerateContents)this.value).generateContents();
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.CacheEntry.getDisplayValue", (String)"887", (Object)this);
                }
            }
            Object dValue = this.value;
            if (this.value instanceof byte[]) {
                try {
                    dValue = SerializationUtility.deserialize((byte[])this.value, this.cacheName);
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.CacheEntry.getDisplayValue", (String)"896", (Object)this);
                }
            }
            returnme = null;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8));
                pw.print(dValue);
                pw.flush();
                returnme = baos.toByteArray();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.cache.CacheEntry.getDisplayValue", (String)"908", (Object)this);
                Tr.error((TraceComponent)tc, (String)"dynacache.error", (Object[])new Object[]{e.getMessage()});
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug((TraceComponent)tc, (String)("error getting value for CacheEntry " + this.id + ": " + e.getMessage()), (Object[])new Object[0]);
            }
        }
        return returnme;
    }

    @Override
    public Enumeration getAliasList() {
        return new ArrayEnumerator(this.aliasList);
    }

    public void addAlias(Object alias) {
        ValueSet vs = new ValueSet(this.aliasList.length + 1);
        if (alias != null) {
            for (int i = 0; i < this.aliasList.length; ++i) {
                vs.add(this.aliasList[i]);
            }
        }
        vs.add(alias);
        this.aliasList = vs.toArray(new Object[vs.size()]);
        this.serializedAliasList = null;
    }

    public void removeAlias(Object alias) {
        ValueSet vs = new ValueSet(this.aliasList.length);
        if (alias != null) {
            for (int i = 0; i < this.aliasList.length; ++i) {
                vs.add(this.aliasList[i]);
            }
        }
        vs.remove(alias);
        this.aliasList = vs.toArray(new Object[vs.size()]);
        this.serializedAliasList = null;
    }

    @Override
    public Object getUserMetaData() {
        if (this.serializedUserMetaData != null) {
            try {
                this.userMetaData = SerializationUtility.deserialize(this.serializedUserMetaData, this.cacheName);
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.CacheEntry.getUserMetaData", (String)"600", (Object)this);
            }
            this.serializedUserMetaData = null;
        }
        return this.userMetaData;
    }

    protected void setUserMetaData(Object userMetaData) {
        this.userMetaData = userMetaData;
        this.serializedUserMetaData = null;
    }

    protected void setSkipMemoryAndWriteToDisk(boolean skipMemoryAndWriteToDisk) {
        this.skipMemoryAndWriteToDisk = skipMemoryAndWriteToDisk;
    }

    @Override
    public long getValidatorExpirationTime() {
        return this.validatorExpirationTime;
    }

    public void setValidatorExpirationTime(long validatorExpirationTime) {
        this.validatorExpirationTime = validatorExpirationTime;
    }

    public int getVBCSource() {
        return this.vbcSource;
    }

    protected void setVBCSource(int vbcSource) {
        this.vbcSource = vbcSource;
    }

    @Override
    public boolean isInvalid() {
        if (this.validatorExpirationTime != -1L) {
            return System.currentTimeMillis() - this.validatorExpirationTime >= 0L;
        }
        return false;
    }

    @Override
    public int getCacheType() {
        return this.cacheType;
    }

    @Override
    public long getCreationTime() {
        return this.timeStamp;
    }

    public static CacheEntryPool createCacheEntryPool(DCache cache, int size) {
        CacheEntryPool pool = new CacheEntryPool(size, cache);
        return pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish() {
        if (this.cacheEntryPool != null) {
            DCache dCache = this.cacheEntryPool.cache;
            synchronized (dCache) {
                this.decRefCount();
                if (this.refCount.get() <= 0) {
                    if (this.refCount.get() < 0) {
                        this.refCount.set(0);
                    }
                    if (this.removeWhenUnpinned && this.refCount.get() == 0) {
                        this.returnToPool();
                    }
                }
            }
        }
        Object object = this.id;
        synchronized (object) {
            this.decRefCount();
            if (this.refCount.get() <= 0) {
                this.reset();
            }
        }
    }

    protected void returnToPool() {
        CacheEntryPool cep = this.cacheEntryPool;
        assert (this.refCount.get() == 0);
        if (this.lruHead != null) {
            this.lruHead.remove(this);
        }
        this.reset();
        cep.add(this);
    }

    @Override
    public long getCacheValueSize() {
        long valuesize = -1L;
        if (this.value != null) {
            Object localValue = this.value;
            valuesize = ObjectSizer.getSize(localValue);
        } else if (this.serializedValue != null) {
            byte[] localSerializedValue = this.serializedValue;
            valuesize = ObjectSizer.getSize(localSerializedValue);
        }
        return valuesize;
    }

    @Override
    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("\n[CacheEntry]").append("\nCacheId: ").append(this.id).append("\nuserMetaData: ").append(this.userMetaData).append("\npriority: ").append(this.priority).append("\ntimeLimit: ").append(this.timeLimit).append("\ninactivity: ").append(this.inactivity).append("\nexpirationTime: ").append(this.expirationTime);
        if (this.validatorExpirationTime != -1L) {
            sb.append("\nvalidatorExpirationTime: ");
            sb.append(this.validatorExpirationTime);
            sb.append("\nvalid: ");
            sb.append(!this.isInvalid());
        }
        sb.append("\nloadedFromDisk: ").append(this.loadedFromDisk).append("\ncacheValueSize: ").append(this.getCacheValueSize()).append("\ncacheValueHashcode: ").append(this.valueHashcode).append("\nskipMemoryAndWriteToDisk: ").append(this.skipMemoryAndWriteToDisk);
        if (this.externalCacheGroupId != null) {
            sb.append("\nexternalCacheGroupId: ").append(this.externalCacheGroupId);
        }
        if (tc.isDebugEnabled()) {
            sb.append("\nrefCount=");
            sb.append(this.refCount);
        }
        for (i = 0; this._templates != null && i < this._templates.length; ++i) {
            sb.append("\n[template " + i + "]");
            sb.append(this._templates[i]);
        }
        for (i = 0; this._dataIds != null && i < this._dataIds.length; ++i) {
            sb.append("\n[Dependency " + i + "]");
            sb.append(this._dataIds[i]);
        }
        for (i = 0; this.aliasList != null && i < this.aliasList.length; ++i) {
            sb.append("\n[Aliases " + i + "]");
            sb.append(this.aliasList[i]);
        }
        return sb.toString();
    }

    @Override
    public long getObjectSize() {
        long totalSize = 184L;
        long size = 0L;
        if (this.id != null) {
            Object localId = this.id;
            size = ObjectSizer.getSize(localId);
            if (size == -1L) {
                Tr.error((TraceComponent)tc, (String)"DYNA1067E", (Object[])new Object[]{this.id.getClass().getName(), "cache-id"});
                return -1L;
            }
            totalSize += size;
        }
        if (this.serializedId != null) {
            byte[] localSerializedId = this.serializedId;
            totalSize += ObjectSizer.getSize(localSerializedId);
        }
        if (this.value != null) {
            Object localValue = this.value;
            size = ObjectSizer.getSize(localValue);
            if (size == -1L) {
                Tr.error((TraceComponent)tc, (String)"DYNA1067E", (Object[])new Object[]{this.value.getClass().getName(), "cache-value"});
                return -1L;
            }
            totalSize += size;
        } else if (this.serializedValue != null) {
            byte[] localSerializedValue = this.serializedValue;
            totalSize += ObjectSizer.getSize(localSerializedValue);
        }
        if (this.userMetaData != null) {
            Object localUserMetaData = this.userMetaData;
            size = ObjectSizer.getSize(localUserMetaData);
            if (size == -1L) {
                Tr.error((TraceComponent)tc, (String)"DYNA1067E", (Object[])new Object[]{this.userMetaData.getClass().getName(), "metadata"});
                return -1L;
            }
            totalSize += size;
        }
        if (this.serializedUserMetaData != null) {
            byte[] localSerializedUserMetaData = this.serializedUserMetaData;
            totalSize += ObjectSizer.getSize(localSerializedUserMetaData);
        }
        if (this._dataIds != null && this._dataIds.length > 0) {
            totalSize = totalSize + 24L + (long)(this._dataIds.length * 16);
            for (int i = 0; i < this._dataIds.length; ++i) {
                Object localDataIds = this._dataIds[i];
                size = ObjectSizer.getSize(localDataIds);
                if (size == -1L) {
                    Tr.error((TraceComponent)tc, (String)"DYNA1067E", (Object[])new Object[]{localDataIds.getClass().getName(), "dep-id"});
                    return -1L;
                }
                totalSize += size;
            }
        }
        if (this._serializedDataIds != null && this._serializedDataIds.length > 0) {
            totalSize = totalSize + 16L + (long)(this._serializedDataIds.length * 16);
            for (int i = 0; i < this._serializedDataIds.length; ++i) {
                Object localSerializedDataIds = this._serializedDataIds[i];
                totalSize += ObjectSizer.getSize(localSerializedDataIds);
            }
        }
        if (this._templates != null && this._templates.length > 0) {
            totalSize = totalSize + 24L + (long)(this._templates.length * 16);
            for (int i = 0; i < this._templates.length; ++i) {
                String localTemplates = this._templates[i];
                totalSize += ObjectSizer.getSize(localTemplates);
            }
        }
        if (this.aliasList != null && this.aliasList.length > 0) {
            totalSize = totalSize + 24L + (long)(this.aliasList.length * 16);
            for (int i = 0; i < this.aliasList.length; ++i) {
                Object localAliasList = this.aliasList[i];
                size = ObjectSizer.getSize(localAliasList);
                if (size == -1L) {
                    Tr.error((TraceComponent)tc, (String)"DYNA1067E", (Object[])new Object[]{localAliasList.getClass().getName(), "alias-id"});
                    return -1L;
                }
                totalSize += size;
            }
        }
        if (this.serializedAliasList != null && this.serializedAliasList.length > 0) {
            totalSize = totalSize + 16L + (long)(this.serializedAliasList.length * 16);
            for (int i = 0; i < this.serializedAliasList.length; ++i) {
                Object localSerializedAliasList = this.serializedAliasList[i];
                totalSize += ObjectSizer.getSize(localSerializedAliasList);
            }
        }
        if (null != this.externalCacheGroupId) {
            String localExternalCacheGroupId = this.externalCacheGroupId;
            totalSize += ObjectSizer.getSize(localExternalCacheGroupId);
        }
        return totalSize;
    }

    public long getSerializedSize() {
        long totalSize = 0L;
        if (this.serializedId != null) {
            byte[] localSerializedId = this.serializedId;
            totalSize += ObjectSizer.getSize(localSerializedId);
        }
        if (this.serializedValue != null) {
            byte[] localSerializedValue = this.serializedValue;
            totalSize += ObjectSizer.getSize(localSerializedValue);
        }
        if (this.serializedUserMetaData != null) {
            byte[] localSerializedUserMetaData = this.serializedUserMetaData;
            totalSize += ObjectSizer.getSize(localSerializedUserMetaData);
        }
        if (this._serializedDataIds != null && this._serializedDataIds.length > 0) {
            for (int i = 0; i < this._serializedDataIds.length; ++i) {
                Object localSerializedDataIds = this._serializedDataIds[i];
                totalSize += ObjectSizer.getSize(localSerializedDataIds);
            }
        }
        if (this._templates != null && this._templates.length > 0) {
            for (int i = 0; i < this._templates.length; ++i) {
                String localTemplates = this._templates[i];
                totalSize += ObjectSizer.getSize(localTemplates);
            }
        }
        if (this.serializedAliasList != null && this.serializedAliasList.length > 0) {
            for (int i = 0; i < this.serializedAliasList.length; ++i) {
                Object localSerializedAliasList = this.serializedAliasList[i];
                totalSize += ObjectSizer.getSize(localSerializedAliasList);
            }
        }
        if (this.externalCacheGroupId != null) {
            String localExternalCacheGroupId = this.externalCacheGroupId;
            totalSize += ObjectSizer.getSize(localExternalCacheGroupId);
        }
        return totalSize;
    }

    @Override
    public String getExternalCacheGroupId() {
        return this.externalCacheGroupId;
    }

    public int getRefCount() {
        return this.refCount.get();
    }

    public void incRefCount() {
        this.refCount.incrementAndGet();
        if (this.isRefCountingEnabled()) {
            this.getCache().getRefCountLeakMap().put(this.id, Cache.extractStackTrace(this));
        }
    }

    public void decRefCount() {
        this.refCount.decrementAndGet();
        if (this.isRefCountingEnabled()) {
            if (this.refCount.get() <= 0) {
                this.getCache().getRefCountLeakMap().remove(this.id);
            } else {
                this.getCache().getRefCountLeakMap().put(this.id, Cache.extractStackTrace(this));
            }
        }
    }

    public Cache getCache() {
        Cache c = null;
        c = this.cacheEntryPool != null && this.cacheEntryPool.cache != null ? (Cache)this.cacheEntryPool.cache : (Cache)ServerCache.getCache(this.cacheName);
        return c;
    }

    public boolean isRefCountingEnabled() {
        boolean rc = false;
        if (this.getCache() != null) {
            rc = ((CacheConfig)this.getCache().getCacheConfig()).isRefCountTrackingEnabled();
        }
        return rc;
    }

    static class CacheEntryPool
    extends ObjectPool {
        DCache cache = null;
        String cacheName = null;

        public CacheEntryPool(int size, DCache cache) {
            super("CacheEntry.Pool", size);
            this.cache = cache;
            this.cacheName = cache.getCacheName();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("CacheEntryPool created for cache " + this.cacheName), (Object[])new Object[0]);
            }
        }

        public Object createObject() {
            CacheEntry ce = new CacheEntry();
            ce.reset();
            ce.cacheName = this.cacheName;
            return ce;
        }

        public CacheEntry allocate() {
            CacheEntry ce = (CacheEntry)this.remove();
            ce.cacheName = this.cacheName;
            ce.cacheEntryPool = this;
            return ce;
        }
    }

    static class ArrayEnumerator
    implements Enumeration {
        int pos = 0;
        Object[] array;

        public ArrayEnumerator(Object[] array) {
            this.array = array;
        }

        @Override
        public boolean hasMoreElements() {
            return this.array.length > this.pos;
        }

        public Object nextElement() {
            return this.array[this.pos++];
        }
    }

    public static class LRUHead
    implements Iterator {
        public int priority = 0;
        private CacheEntry head;
        private CacheEntry tail;
        private CacheEntry _iterator = null;

        public void addFirst(CacheEntry cacheEntry) {
            cacheEntry._previous = null;
            cacheEntry._next = this.head;
            if (this.head != null) {
                this.head._previous = cacheEntry;
            }
            this.head = cacheEntry;
            if (this.tail == null) {
                this.tail = cacheEntry;
            }
        }

        public void addLast(CacheEntry cacheEntry) {
            cacheEntry._previous = this.tail;
            cacheEntry._next = null;
            if (this.head == null) {
                this.head = cacheEntry;
            } else {
                this.tail._next = cacheEntry;
            }
            this.tail = cacheEntry;
        }

        public boolean isEmpty() {
            return this.head == null;
        }

        public boolean isLast(CacheEntry cacheEntry) {
            return this.tail == cacheEntry;
        }

        public Iterator iterator() {
            this._iterator = this.head;
            return this;
        }

        public Object next() {
            CacheEntry ret = this._iterator;
            this._iterator = this._iterator._next;
            return ret;
        }

        @Override
        public boolean hasNext() {
            return this._iterator != null;
        }

        @Override
        public void remove() {
            throw new IllegalStateException("remove not implemented");
        }

        public void remove(CacheEntry cacheEntry) {
            if (cacheEntry.lruHead != this && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("internal error for cacheEntry=" + cacheEntry), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("_next=" + cacheEntry._next), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("_previous=" + cacheEntry._previous), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("lruHead=" + cacheEntry.lruHead), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("this=" + this), (Object[])new Object[0]);
            }
            if (this.head == cacheEntry) {
                this.head = cacheEntry._next;
                if (this.head != null) {
                    this.head._previous = null;
                }
            } else {
                cacheEntry._previous._next = cacheEntry._next;
                if (cacheEntry._next != null) {
                    cacheEntry._next._previous = cacheEntry._previous;
                }
            }
            if (this.tail == cacheEntry) {
                this.tail = cacheEntry._previous;
            }
            cacheEntry._previous = null;
            cacheEntry._next = null;
            cacheEntry.lruHead = null;
        }

        public CacheEntry removeFirst() {
            CacheEntry ret = this.head;
            if (ret != null) {
                this.head = ret._next;
                if (this.head != null) {
                    this.head._previous = null;
                } else {
                    this.tail = null;
                }
            }
            return ret;
        }
    }
}

