/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.crypto.util.custom;

import com.ibm.ws.crypto.util.MessageUtils;
import com.ibm.ws.crypto.util.custom.CustomManifest;
import com.ibm.ws.kernel.provisioning.ProductExtension;
import com.ibm.ws.kernel.provisioning.ProductExtensionInfo;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CustomUtils {
    private static final Class<?> CLASS_NAME = CustomUtils.class;
    private static Logger logger = Logger.getLogger(CLASS_NAME.getCanonicalName(), "com.ibm.ws.crypto.util.internal.resources.Messages");
    public static final String CUSTOM_ENCRYPTION_DIR = "ws-customPasswordEncryption";
    static final String USER_FEATURE_DIR = "usr/extension/";
    private static final String RESOURCE_FILE_EXT = ".properties";
    private static final String JAR_FILE_EXT = ".jar";
    private static final String KEY_ALGORITHM_NAME = "name";
    private static final String KEY_FEATURE_NAME = "featurename";
    private static final String KEY_DESCRIPTION_NAME = "description";
    private static final String TOOL_EXTENSION_DIR = "bin/tools/extensions/";

    public static boolean isCommandLine() {
        String output = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("wlp.process.type");
            }
        });
        boolean value = true;
        if (output != null && ("server".equals(output) || "client".equals(output))) {
            value = false;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("value: " + value);
        }
        return value;
    }

    public static String getInstallRoot() {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String output;
                block5: {
                    output = System.getProperty("wlp.install.dir");
                    if (output == null) {
                        output = System.getenv("WLP_INSTALL_DIR");
                    }
                    if (output == null) {
                        URL url = CLASS_NAME.getProtectionDomain().getCodeSource().getLocation();
                        try {
                            output = new File(url.toString().substring("file:".length())).getParentFile().getParentFile().getCanonicalPath();
                        }
                        catch (IOException e) {
                            output = ".";
                            if (!logger.isLoggable(Level.FINE)) break block5;
                            logger.fine("The install root was not detected. " + e.getMessage());
                        }
                    }
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("The install root is " + output);
                }
                return output;
            }
        });
    }

    public static ResourceBundle getResourceBundle(File location, String name, Locale locale) {
        File[] files;
        for (File file : files = new File[]{new File(location, name + "_" + locale.toString() + RESOURCE_FILE_EXT), new File(location, name + "_" + locale.getLanguage() + RESOURCE_FILE_EXT), new File(location, name + RESOURCE_FILE_EXT)}) {
            if (!CustomUtils.exists(file)) continue;
            try {
                return new PropertyResourceBundle(new FileReader(file));
            }
            catch (IOException e) {
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.fine("The resource file was not loaded. The exception is " + e.getMessage());
            }
        }
        return null;
    }

    public static List<CustomManifest> findCustomEncryption(String extension) throws IOException {
        List<File> dirs = CustomUtils.listRootAndExtensionDirectories();
        return CustomUtils.findCustomEncryption(dirs, TOOL_EXTENSION_DIR + extension);
    }

    protected static List<CustomManifest> findCustomEncryption(List<File> rootDirs, String path) throws IOException {
        ArrayList<CustomManifest> list = new ArrayList<CustomManifest>();
        for (File dir : rootDirs) {
            File[] files;
            if (!CustomUtils.exists(dir = new File(dir, path)) || (files = CustomUtils.listFiles(dir)) == null) continue;
            for (File file : files) {
                if (!CustomUtils.isFile(file) || !file.getName().toLowerCase().endsWith(JAR_FILE_EXT)) continue;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("The extension manifest file : " + file);
                }
                try {
                    CustomManifest cm = new CustomManifest(file);
                    list.add(cm);
                }
                catch (IllegalArgumentException iae) {
                    if (!logger.isLoggable(Level.INFO)) continue;
                    logger.info(MessageUtils.getMessage("PASSWORDUTIL_ERROR_IN_EXTENSION_MANIFEST_FILE", file, iae.getMessage()));
                }
            }
        }
        return list;
    }

    public static boolean exists(final File file) {
        Boolean result = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                if (file.exists()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        return result;
    }

    public static boolean isAbsolute(final File file) {
        Boolean result = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                if (file.isAbsolute()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        return result;
    }

    public static boolean isFile(final File file) {
        Boolean result = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                if (file.isFile()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        return result;
    }

    public static String getCanonicalPath(final File file) throws IOException {
        String path = null;
        try {
            path = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws IOException {
                    return file.getCanonicalPath();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
        return path;
    }

    public static File[] listFiles(final File file) {
        return AccessController.doPrivileged(new PrivilegedAction<File[]>(){

            @Override
            public File[] run() {
                return file.listFiles();
            }
        });
    }

    public static String toJSON(List<CustomManifest> list) {
        String output = null;
        if (list != null && !list.isEmpty()) {
            StringBuffer sb = new StringBuffer("[");
            boolean first = true;
            for (CustomManifest cm : list) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(CustomUtils.toJSON(cm));
            }
            sb.append("]");
            output = sb.toString();
        }
        return output;
    }

    private static String toJSON(CustomManifest cm) {
        String output = null;
        if (cm != null) {
            String alg = cm.getAlgorithm();
            String fi = cm.getFeatureId();
            String fn = cm.getFeatureName();
            String desc = cm.getDescription();
            StringBuffer sb = new StringBuffer("{");
            sb.append("\"").append(KEY_ALGORITHM_NAME).append("\":\"").append(alg).append("\",");
            sb.append("\"").append(KEY_FEATURE_NAME).append("\":\"").append(fi).append(':').append(fn).append("\",");
            sb.append("\"").append(KEY_DESCRIPTION_NAME).append("\":\"").append(desc).append("\"}");
            output = sb.toString();
        }
        return output;
    }

    static List<File> listExtensionDirectories() {
        ArrayList<File> dirs = new ArrayList<File>();
        dirs.add(new File(CustomUtils.getInstallRoot(), USER_FEATURE_DIR));
        for (ProductExtensionInfo info : ProductExtension.getProductExtensions()) {
            File extensionDir = new File(info.getLocation());
            if (!CustomUtils.isAbsolute(extensionDir)) {
                File parentDir = new File(CustomUtils.getInstallRoot()).getParentFile();
                extensionDir = new File(parentDir, info.getLocation());
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("The product extension directory : " + extensionDir);
            }
            dirs.add(extensionDir);
        }
        return dirs;
    }

    static List<File> listRootAndExtensionDirectories() {
        List<File> dirs = CustomUtils.listExtensionDirectories();
        dirs.add(0, new File(CustomUtils.getInstallRoot()));
        return dirs;
    }
}

