/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.injectionengine.osgi.internal;

import com.ibm.ejs.util.Util;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.wsspi.kernel.service.utils.ServiceAndServiceReferencePair;
import com.ibm.wsspi.resource.ResourceBinding;
import com.ibm.wsspi.resource.ResourceBindingListener;
import java.util.Collection;
import java.util.Map;
import org.osgi.framework.ServiceReference;

@Trivial
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class ResourceBindingImpl
implements ResourceBinding {
    private static final TraceComponent tc = Tr.register(ResourceBindingImpl.class, (String)"Injection", (String)"com.ibm.ws.injection.resources.InjectionMessages");
    private final String refName;
    private String bindingName;
    private final String type;
    private final Map<String, Object> properties;
    private ServiceAndServiceReferencePair<ResourceBindingListener> currentListener;
    ServiceAndServiceReferencePair<ResourceBindingListener> bindingListener;
    static final long serialVersionUID = 8577018850531598835L;

    ResourceBindingImpl(String refName, String bindingName, String type, Map<String, Object> properties) {
        this.refName = refName;
        this.bindingName = bindingName;
        this.type = type;
        this.properties = properties;
    }

    public String toString() {
        return super.toString() + '[' + "referenceName=" + this.refName + ", type=" + this.type + ", properties=" + this.properties + ", bindingName=" + this.bindingName + ", bindingListener=" + (this.bindingListener == null ? null : this.bindingListener.getServiceReference()) + ']';
    }

    public String getReferenceName() {
        return this.refName;
    }

    public String getTypeName() {
        return this.type;
    }

    public String getBindingName() {
        return this.bindingName;
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public Collection<String> getPropertyNames() {
        return this.properties.keySet();
    }

    @ManualTrace
    public void notify(ServiceAndServiceReferencePair<ResourceBindingListener> listener) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"notify", (Object[])new Object[]{listener.getServiceReference(), Util.identity((Object)listener.getService())});
        }
        this.currentListener = listener;
        ((ResourceBindingListener)listener.getService()).binding((ResourceBinding)this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"notify");
        }
    }

    public void setBindingName(String bindingName) {
        if (bindingName == null) {
            throw new IllegalArgumentException("bindingName");
        }
        this.bindingName = bindingName;
        this.bindingListener = this.currentListener;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"setBindingName", (Object[])new Object[]{bindingName, this.bindingListener.getServiceReference()});
        }
    }

    public String getBindingListenerName() {
        ServiceReference ref = this.bindingListener.getServiceReference();
        Object serviceDescription = ref.getProperty("service.description");
        if (serviceDescription instanceof String) {
            return (String)serviceDescription;
        }
        return ((ResourceBindingListener)this.bindingListener.getService()).getClass().getName() + " (" + ref.getBundle().getSymbolicName() + ')';
    }
}

