/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.osgi.stackjoiner.bci;

import com.ibm.ws.logging.internal.osgi.stackjoiner.bci.ThrowableClassAdapter;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class ThrowableClassFileTransformer
implements ClassFileTransformer {
    public static final String THROWABLE_CLASS_NAME = "java/lang/Throwable";

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        byte[] ba = null;
        if (!className.equals(THROWABLE_CLASS_NAME)) {
            return ba;
        }
        ba = this.transformClassIfThrowable(classfileBuffer, className);
        return ba;
    }

    private byte[] transformClassIfThrowable(byte[] cBuffer, String nameOfClass) {
        ClassReader reader = new ClassReader(cBuffer);
        ClassWriter writer = new ClassWriter(reader, 2);
        ThrowableClassAdapter visitor = new ThrowableClassAdapter((ClassVisitor)writer);
        reader.accept((ClassVisitor)visitor, 4);
        return writer.toByteArray();
    }
}

