/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.legacyapi;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import io.smallrye.metrics.legacyapi.AnnotatedGaugeAdapter;
import io.smallrye.metrics.legacyapi.CounterAdapter;
import io.smallrye.metrics.legacyapi.FunctionCounterAdapter;
import io.smallrye.metrics.legacyapi.GaugeAdapter;
import io.smallrye.metrics.legacyapi.HistogramAdapter;
import io.smallrye.metrics.legacyapi.MemberToMetricMappings;
import io.smallrye.metrics.legacyapi.MeterHolder;
import io.smallrye.metrics.legacyapi.MetricDescriptor;
import io.smallrye.metrics.legacyapi.MpMetadata;
import io.smallrye.metrics.legacyapi.TimerAdapter;
import io.smallrye.metrics.setup.ApplicationNameResolver;
import io.smallrye.metrics.setup.config.MetricsConfigurationManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricFilter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;

public class LegacyMetricRegistryAdapter
implements MetricRegistry {
    private static final String CLASS_NAME = LegacyMetricRegistryAdapter.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLASS_NAME);
    private final String scope;
    private final MeterRegistry registry;
    public static final String MP_APPLICATION_NAME_TAG = "mp_app";
    public static final String MP_SCOPE_TAG = "mp_scope";
    protected static final String MP_APPLICATION_NAME_VAR = "mp.metrics.appName";
    protected static final String MP_DEFAULT_APPLICATION_NAME_VAR = "mp.metrics.defaultAppName";
    protected static volatile io.micrometer.core.instrument.Tag DEFAULT_APP_NAME_TAG = null;
    private final String defaultAppNameValue;
    private final Map<MetricDescriptor, MeterHolder> constructedMeters = new ConcurrentHashMap<MetricDescriptor, MeterHolder>();
    private final Map<String, MpMetadata> metadataMap = new ConcurrentHashMap<String, MpMetadata>();
    protected final ConcurrentHashMap<String, io.micrometer.core.instrument.Tag> applicationMPConfigAppNameTagCache;
    protected final ConcurrentHashMap<String, Set<MetricID>> applicationMap;
    protected final ApplicationNameResolver appNameResolver;
    protected final boolean isAppnameResolverPresent;
    private MemberToMetricMappings memberToMetricMappings;
    protected static io.micrometer.core.instrument.Tag[] SERVER_LEVEL_MPCONFIG_APPLICATION_NAME_TAG = null;
    protected static final String GLOBAL_TAG_MALFORMED_EXCEPTION = "Malformed list of Global Tags. Tag names must match the following regex [a-zA-Z_][a-zA-Z0-9_]*. Global Tag values must not be empty. Global Tag values MUST escape equal signs `=` and commas `,` with a backslash `\\` ";
    protected static final String GLOBAL_TAGS_VARIABLE = "mp.metrics.tags";
    protected static io.micrometer.core.instrument.Tag[] SERVER_LEVEL_MPCONFIG_GLOBAL_TAGS = null;

    public MeterRegistry getPrometheusMeterRegistry() {
        return this.registry;
    }

    public void addNameToApplicationMap(MetricDescriptor metricDescriptor) {
        if (this.isAppnameResolverPresent) {
            this.addNameToApplicationMap(metricDescriptor.toMetricID(), this.appNameResolver.getApplicationName());
        }
    }

    public void addNameToApplicationMap(MetricID MetricID2) {
        if (this.isAppnameResolverPresent) {
            this.addNameToApplicationMap(MetricID2, this.appNameResolver.getApplicationName());
        }
    }

    public void addNameToApplicationMap(MetricID metricID, String appName) {
        Set newSet;
        String METHOD_NAME = "addNameToApplicationMap";
        if (appName == null) {
            return;
        }
        Set<Object> set = this.applicationMap.get(appName);
        if (set == null && (set = this.applicationMap.putIfAbsent(appName, newSet = Collections.newSetFromMap(new ConcurrentHashMap()))) == null) {
            set = newSet;
        }
        set.add(metricID);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.logp(Level.FINER, CLASS_NAME, "addNameToApplicationMap", String.format("Mapped MetricID [id= %s] to application \"%s\"", metricID, appName));
        }
    }

    public void unRegisterApplicationMetrics() {
        this.unRegisterApplicationMetrics(this.appNameResolver.getApplicationName());
    }

    public void unRegisterApplicationMetrics(String appName) {
        if (appName == null) {
            return;
        }
        Set<MetricID> set = this.applicationMap.remove(appName);
        if (set != null) {
            for (MetricID metricID : set) {
                this.remove(metricID);
            }
        }
        MetricsConfigurationManager.getInstance().removeConfiguration(appName);
    }

    public LegacyMetricRegistryAdapter(String scope, MeterRegistry registry, ApplicationNameResolver appNameResolver) {
        if (appNameResolver == null) {
            this.appNameResolver = ApplicationNameResolver.DEFAULT;
            this.isAppnameResolverPresent = false;
        } else {
            this.appNameResolver = appNameResolver;
            this.isAppnameResolverPresent = true;
        }
        this.scope = scope;
        this.registry = registry;
        this.applicationMPConfigAppNameTagCache = new ConcurrentHashMap();
        this.applicationMap = new ConcurrentHashMap();
        this.defaultAppNameValue = this.resolveMPConfigDefaultAppNameTag();
        this.resolveMPConfigGlobalTagsByServer();
        if (scope != "base" && scope != "vendor") {
            this.memberToMetricMappings = new MemberToMetricMappings();
        }
    }

    private synchronized io.micrometer.core.instrument.Tag[] resolveMPConfigGlobalTagsByServer() {
        String METHOD_NAME = "resolveMPConfigGlobalTagsByServer";
        if (SERVER_LEVEL_MPCONFIG_GLOBAL_TAGS == null) {
            Optional globalTags = ConfigProvider.getConfig().getOptionalValue(GLOBAL_TAGS_VARIABLE, String.class);
            if (globalTags.isPresent() && LOGGER.isLoggable(Level.FINE)) {
                LOGGER.logp(Level.FINE, CLASS_NAME, "resolveMPConfigGlobalTagsByServer", String.format("MicroProfile Config value for \"%s\" resolved to be: %s", GLOBAL_TAGS_VARIABLE, globalTags.get()));
            }
            SERVER_LEVEL_MPCONFIG_GLOBAL_TAGS = globalTags.isPresent() ? LegacyMetricRegistryAdapter.parseGlobalTags((String)globalTags.get()) : new io.micrometer.core.instrument.Tag[]{};
        }
        return SERVER_LEVEL_MPCONFIG_GLOBAL_TAGS.length == 0 ? null : SERVER_LEVEL_MPCONFIG_GLOBAL_TAGS;
    }

    private static io.micrometer.core.instrument.Tag[] parseGlobalTags(String globalTags) {
        if (globalTags == null || globalTags.length() == 0) {
            return null;
        }
        String[] kvPairs = globalTags.split("(?<!\\\\),");
        io.micrometer.core.instrument.Tag[] arrayOfTags = new io.micrometer.core.instrument.Tag[kvPairs.length];
        int count = 0;
        for (String kvString : kvPairs) {
            if (kvString.length() == 0) {
                throw new IllegalArgumentException(GLOBAL_TAG_MALFORMED_EXCEPTION);
            }
            String[] keyValueSplit = kvString.split("(?<!\\\\)=");
            if (keyValueSplit.length != 2 || keyValueSplit[0].length() == 0 || keyValueSplit[1].length() == 0) {
                throw new IllegalArgumentException(GLOBAL_TAG_MALFORMED_EXCEPTION);
            }
            String key = keyValueSplit[0];
            String value = keyValueSplit[1];
            if (!key.matches("[a-zA-Z_][a-zA-Z0-9_]*")) {
                throw new IllegalArgumentException("Invalid Tag name. Tag names must match the following regex [a-zA-Z_][a-zA-Z0-9_]*");
            }
            value = value.replace("\\,", ",");
            value = value.replace("\\=", "=");
            arrayOfTags[count] = io.micrometer.core.instrument.Tag.of((String)key, (String)value);
            ++count;
        }
        return arrayOfTags;
    }

    private Tags combineApplicationTagsWithMPConfigAppNameTag(Tags tags) {
        io.micrometer.core.instrument.Tag mpConfigAppTag = this.resolveMPConfigAppNameTag();
        if (mpConfigAppTag != null) {
            HashMap<String, String> tagMap = new HashMap<String, String>();
            tagMap.put(mpConfigAppTag.getKey(), mpConfigAppTag.getValue());
            for (io.micrometer.core.instrument.Tag tag : tags) {
                tagMap.put(tag.getKey(), tag.getValue());
            }
            Tags result = Tags.empty();
            for (Map.Entry entry : tagMap.entrySet()) {
                result = result.and((String)entry.getKey(), (String)entry.getValue());
            }
            tags = result;
        }
        return tags;
    }

    private String resolveMPConfigDefaultAppNameTag() {
        Optional configVal = ConfigProvider.getConfig().getOptionalValue(MP_DEFAULT_APPLICATION_NAME_VAR, String.class);
        return configVal.isPresent() ? ((String)configVal.get()).trim() : null;
    }

    private synchronized io.micrometer.core.instrument.Tag resolveMPConfigAppNameTag() {
        io.micrometer.core.instrument.Tag tag;
        String appName = this.appNameResolver.getApplicationName();
        io.micrometer.core.instrument.Tag tag2 = tag = appName == null ? this.resolveMPConfigAppNameTagByServer() : this.resolveMPConfigAppNameTagByApplication(appName);
        return tag != null ? tag : (this.defaultAppNameValue != null ? io.micrometer.core.instrument.Tag.of((String)MP_APPLICATION_NAME_TAG, (String)this.defaultAppNameValue) : null);
    }

    private synchronized io.micrometer.core.instrument.Tag resolveMPConfigAppNameTagByServer() {
        if (SERVER_LEVEL_MPCONFIG_APPLICATION_NAME_TAG == null) {
            SERVER_LEVEL_MPCONFIG_APPLICATION_NAME_TAG = new io.micrometer.core.instrument.Tag[1];
            Optional applicationName = ConfigProvider.getConfig().getOptionalValue(MP_APPLICATION_NAME_VAR, String.class);
            LegacyMetricRegistryAdapter.SERVER_LEVEL_MPCONFIG_APPLICATION_NAME_TAG[0] = applicationName.isPresent() ? io.micrometer.core.instrument.Tag.of((String)MP_APPLICATION_NAME_TAG, (String)((String)applicationName.get())) : null;
        }
        return SERVER_LEVEL_MPCONFIG_APPLICATION_NAME_TAG[0];
    }

    private synchronized io.micrometer.core.instrument.Tag resolveMPConfigAppNameTagByApplication(String appName) {
        io.micrometer.core.instrument.Tag returnTag;
        if (!this.applicationMPConfigAppNameTagCache.containsKey(appName)) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Optional applicationName = ConfigProvider.getConfig((ClassLoader)classLoader).getOptionalValue(MP_APPLICATION_NAME_VAR, String.class);
            io.micrometer.core.instrument.Tag appTag = applicationName.isPresent() ? io.micrometer.core.instrument.Tag.of((String)MP_APPLICATION_NAME_TAG, (String)((String)applicationName.get())) : io.micrometer.core.instrument.Tag.of((String)"null", (String)"null");
            this.applicationMPConfigAppNameTagCache.put(appName, appTag);
        }
        return (returnTag = this.applicationMPConfigAppNameTagCache.get(appName)).getKey().equals("null") ? null : returnTag;
    }

    public LegacyMetricRegistryAdapter(String scope, MeterRegistry registry) {
        this(scope, registry, ApplicationNameResolver.DEFAULT);
    }

    public Counter counter(String name) {
        return this.internalCounter(this.internalGetMetadata(name), new MetricDescriptor(name, this.withAppTags(new Tag[0])));
    }

    public Counter counter(String name, Tag ... tags) {
        Tags unifiedTags = this.withAppTags(tags);
        return this.internalCounter(this.internalGetMetadata(name), new MetricDescriptor(name, unifiedTags));
    }

    public Counter counter(MetricID metricID) {
        String name = metricID.getName();
        return this.internalCounter(this.internalGetMetadata(name), new MetricDescriptor(name, this.withAppTags(metricID.getTagsAsArray())));
    }

    public Counter counter(Metadata metadata) {
        return this.internalCounter(this.internalGetMetadata(metadata), new MetricDescriptor(metadata.getName(), this.withAppTags(new Tag[0])));
    }

    public Counter counter(Metadata metadata, Tag ... tags) {
        Tags unifiedTags = this.withAppTags(tags);
        return this.internalCounter(this.internalGetMetadata(metadata), new MetricDescriptor(metadata.getName(), unifiedTags));
    }

    private void validateTagNamesMatch(MetricDescriptor id) {
        for (MetricDescriptor md : this.constructedMeters.keySet()) {
            if (!md.name().equals(id.name) || id.isTagNamesMatch(md.tags())) continue;
            throw new IllegalArgumentException(String.format("The set of tags names provided do not match those of an existing metric with the same name. Provided = %s Existing = %s ", id.tags.toString(), md.tags.toString()));
        }
    }

    CounterAdapter internalCounter(MpMetadata metadata, MetricDescriptor id) {
        this.validateTagNamesMatch(id);
        CounterAdapter result = this.checkCast(CounterAdapter.class, metadata, this.constructedMeters.computeIfAbsent(id, k -> new CounterAdapter()));
        if (!this.isLibertyVendorConnectionPoolMetricCounter(id.name())) {
            this.addNameToApplicationMap(id);
        }
        return result.register(metadata, id, this.registry, this.scope, this.resolveMPConfigGlobalTagsByServer());
    }

    public <T> Counter counter(Metadata metadata, T obj, ToDoubleFunction<T> func, Tag ... tags) {
        Tags unifiedTags = this.withAppTags(tags);
        return this.internalCounter(this.internalGetMetadata(metadata), obj, func, new MetricDescriptor(metadata.getName(), unifiedTags));
    }

    <T> FunctionCounterAdapter<T> internalCounter(MpMetadata metadata, T obj, ToDoubleFunction<T> func, MetricDescriptor id) {
        this.validateTagNamesMatch(id);
        FunctionCounterAdapter result = this.checkCast(FunctionCounterAdapter.class, metadata, this.constructedMeters.computeIfAbsent(id, k -> new FunctionCounterAdapter<Object>(obj, func)));
        if (!this.isLibertyVendorConnectionPoolMetricCounter(id.name())) {
            this.addNameToApplicationMap(id);
        }
        return result.register(metadata, id, this.registry, this.scope, this.resolveMPConfigGlobalTagsByServer());
    }

    public <T> Gauge<Double> gauge(String name, T o, ToDoubleFunction<T> f) {
        return this.internalGauge(this.internalGetMetadata(name), new MetricDescriptor(name, this.withAppTags(new Tag[0])), o, f);
    }

    public <T> Gauge<Double> gauge(String name, T o, ToDoubleFunction<T> f, Tag ... tags) {
        Tags unifiedTags = this.withAppTags(tags);
        return this.internalGauge(this.internalGetMetadata(name), new MetricDescriptor(name, unifiedTags), o, f);
    }

    public <T, R extends Number> Gauge<R> gauge(String name, T o, Function<T, R> f, Tag ... tags) {
        Tags unifiedTags = this.withAppTags(tags);
        return this.internalGauge(this.internalGetMetadata(name), new MetricDescriptor(name, unifiedTags), o, f);
    }

    public <T, R extends Number> Gauge<R> gauge(MetricID metricID, T o, Function<T, R> f) {
        String name = metricID.getName();
        return this.internalGauge(this.internalGetMetadata(name), new MetricDescriptor(name, this.withAppTags(new Tag[0])), o, f);
    }

    public <T, R extends Number> Gauge<R> gauge(Metadata metadata, T o, Function<T, R> f, Tag ... tags) {
        String name = metadata.getName();
        Tags unifiedTags = this.withAppTags(tags);
        return this.internalGauge(this.internalGetMetadata(metadata), new MetricDescriptor(name, unifiedTags), o, f);
    }

    <T> GaugeAdapter<Double> internalGauge(MpMetadata metadata, MetricDescriptor id, T obj, ToDoubleFunction<T> f) {
        this.validateTagNamesMatch(id);
        GaugeAdapter.DoubleFunctionGauge result = this.checkCast(GaugeAdapter.DoubleFunctionGauge.class, metadata, this.constructedMeters.computeIfAbsent(id, k -> new GaugeAdapter.DoubleFunctionGauge<Object>(obj, f)));
        if (!this.isLibertyVendorConnectionPoolMetricGauge(id.name())) {
            this.addNameToApplicationMap(id);
        }
        return result.register(metadata, id, this.registry, this.scope, this.resolveMPConfigGlobalTagsByServer());
    }

    private boolean isLibertyVendorConnectionPoolMetricCounter(String metricName) {
        return metricName.equalsIgnoreCase("connectionpool.create.total") || metricName.equalsIgnoreCase("connectionpool.destroy.total") || metricName.equalsIgnoreCase("connectionpool.queuedRequests.total") || metricName.equalsIgnoreCase("connectionpool.usedConnections.total");
    }

    private boolean isLibertyVendorConnectionPoolMetricGauge(String metricName) {
        return metricName.equalsIgnoreCase("connectionpool.managedConnections") || metricName.equalsIgnoreCase("connectionpool.connectionHandles") || metricName.equalsIgnoreCase("connectionpool.freeConnections") || metricName.equalsIgnoreCase("connectionpool.waitTime.total") || metricName.equalsIgnoreCase("connectionpool.inUseTime.total");
    }

    <T, R extends Number> GaugeAdapter<R> internalGauge(MpMetadata metadata, MetricDescriptor id, T obj, Function<T, R> f) {
        this.validateTagNamesMatch(id);
        GaugeAdapter.FunctionGauge result = this.checkCast(GaugeAdapter.FunctionGauge.class, metadata, this.constructedMeters.computeIfAbsent(id, k -> new GaugeAdapter.FunctionGauge(obj, f)));
        if (!this.isLibertyVendorConnectionPoolMetricGauge(id.name())) {
            this.addNameToApplicationMap(id);
        }
        return result.register(metadata, id, this.registry, this.scope, this.resolveMPConfigGlobalTagsByServer());
    }

    public <T extends Number> Gauge<T> gauge(String name, Supplier<T> f) {
        return this.internalGauge(this.internalGetMetadata(name), new MetricDescriptor(name, this.withAppTags(new Tag[0])), f);
    }

    public <T extends Number> Gauge<T> gauge(String name, Supplier<T> f, Tag ... tags) {
        Tags unifiedTags = this.withAppTags(tags);
        return this.internalGauge(this.internalGetMetadata(name), new MetricDescriptor(name, unifiedTags), f);
    }

    public <T extends Number> Gauge<T> gauge(MetricID metricID, Supplier<T> f) {
        String name = metricID.getName();
        return this.internalGauge(this.internalGetMetadata(name), new MetricDescriptor(name, this.withAppTags(new Tag[0])), f);
    }

    public <T extends Number> Gauge<T> gauge(Metadata metadata, Supplier<T> f, Tag ... tags) {
        String name = metadata.getName();
        Tags unifiedTags = this.withAppTags(tags);
        return this.internalGauge(this.internalGetMetadata(metadata), new MetricDescriptor(name, unifiedTags), f);
    }

    <T extends Number> GaugeAdapter<T> internalGauge(MpMetadata metadata, MetricDescriptor id, Supplier<T> f) {
        this.validateTagNamesMatch(id);
        GaugeAdapter result = this.checkCast(GaugeAdapter.NumberSupplierGauge.class, metadata, this.constructedMeters.computeIfAbsent(id, k -> new GaugeAdapter.NumberSupplierGauge(f)));
        if (!this.isLibertyVendorConnectionPoolMetricGauge(id.name())) {
            this.addNameToApplicationMap(id);
        }
        return result.register(metadata, id, this.registry, this.scope, this.resolveMPConfigGlobalTagsByServer());
    }

    void bindAnnotatedGauge(AnnotatedGaugeAdapter adapter) {
        MetricDescriptor id = new MetricDescriptor(adapter.name(), adapter.tags());
        AnnotatedGaugeAdapter oops = this.checkCast(AnnotatedGaugeAdapter.class, adapter.getMetadata(), this.constructedMeters.putIfAbsent(id, adapter));
        if (oops != null) {
            throw new IllegalArgumentException(String.format("Gauge %s already exists. (existing='%s', new='%s')", adapter.getId(), oops.getTargetName(), adapter.getTargetName()));
        }
        this.metadataMap.put(adapter.name(), adapter.getMetadata());
        adapter.register(id, this.registry);
    }

    public Histogram histogram(String name) {
        return this.internalHistogram(this.internalGetMetadata(name), new MetricDescriptor(name, this.withAppTags(new Tag[0])));
    }

    public Histogram histogram(String name, Tag ... tags) {
        Tags unifiedTags = this.withAppTags(tags);
        return this.internalHistogram(this.internalGetMetadata(name), new MetricDescriptor(name, unifiedTags));
    }

    public Histogram histogram(MetricID metricID) {
        String name = metricID.getName();
        return this.internalHistogram(this.internalGetMetadata(name), new MetricDescriptor(name, this.withAppTags(metricID.getTagsAsArray())));
    }

    public Histogram histogram(Metadata metadata) {
        return this.internalHistogram(this.internalGetMetadata(metadata), new MetricDescriptor(metadata.getName(), this.withAppTags(new Tag[0])));
    }

    public Histogram histogram(Metadata metadata, Tag ... tags) {
        Tags unifiedTags = this.withAppTags(tags);
        return this.internalHistogram(this.internalGetMetadata(metadata), new MetricDescriptor(metadata.getName(), unifiedTags));
    }

    HistogramAdapter internalHistogram(MpMetadata metadata, MetricDescriptor id) {
        this.validateTagNamesMatch(id);
        HistogramAdapter result = this.checkCast(HistogramAdapter.class, metadata, this.constructedMeters.computeIfAbsent(id, k -> new HistogramAdapter()));
        this.addNameToApplicationMap(id);
        return result.register(metadata, id, this.scope, this.resolveMPConfigGlobalTagsByServer());
    }

    public Timer timer(String name) {
        return this.internalTimer(this.internalGetMetadataTimers(name), new MetricDescriptor(name, this.withAppTags(new Tag[0])));
    }

    public Timer timer(String name, Tag ... tags) {
        Tags unifiedTags = this.withAppTags(tags);
        return this.internalTimer(this.internalGetMetadataTimers(name), new MetricDescriptor(name, unifiedTags));
    }

    public Timer timer(MetricID metricID) {
        String name = metricID.getName();
        return this.internalTimer(this.internalGetMetadataTimers(name), new MetricDescriptor(name, this.withAppTags(metricID.getTagsAsArray())));
    }

    public Timer timer(Metadata metadata) {
        return this.internalTimer(this.internalGetMetadataTimers(metadata), new MetricDescriptor(metadata.getName(), this.withAppTags(new Tag[0])));
    }

    public Timer timer(Metadata metadata, Tag ... tags) {
        Tags unifiedTags = this.withAppTags(tags);
        return this.internalTimer(this.internalGetMetadataTimers(metadata), new MetricDescriptor(metadata.getName(), unifiedTags));
    }

    TimerAdapter internalTimer(MpMetadata metadata, MetricDescriptor id) {
        this.validateTagNamesMatch(id);
        TimerAdapter result = this.checkCast(TimerAdapter.class, metadata, this.constructedMeters.computeIfAbsent(id, k -> new TimerAdapter(this.registry)));
        this.addNameToApplicationMap(id);
        return result.register(metadata, id, this.scope, this.resolveMPConfigGlobalTagsByServer());
    }

    public Metric getMetric(MetricID metricID) {
        return this.constructedMeters.get(new MetricDescriptor(metricID.getName(), this.withAppTags(metricID.getTagsAsArray())));
    }

    public <T extends Metric> T getMetric(MetricID metricID, Class<T> asType) {
        return (T)((Metric)asType.cast(this.constructedMeters.get(new MetricDescriptor(metricID.getName(), this.withAppTags(metricID.getTagsAsArray())))));
    }

    public Counter getCounter(MetricID metricID) {
        return (Counter)this.constructedMeters.get(new MetricDescriptor(metricID.getName(), this.withAppTags(metricID.getTagsAsArray())));
    }

    public Gauge<?> getGauge(MetricID metricID) {
        return (Gauge)this.constructedMeters.get(new MetricDescriptor(metricID.getName(), this.withAppTags(metricID.getTagsAsArray())));
    }

    public Histogram getHistogram(MetricID metricID) {
        return (Histogram)this.constructedMeters.get(new MetricDescriptor(metricID.getName(), this.withAppTags(metricID.getTagsAsArray())));
    }

    public Timer getTimer(MetricID metricID) {
        return (Timer)this.constructedMeters.get(new MetricDescriptor(metricID.getName(), this.withAppTags(metricID.getTagsAsArray())));
    }

    public Metadata getMetadata(String name) {
        return this.metadataMap.get(name);
    }

    public boolean remove(String name) {
        boolean isRemoveSuccess = false;
        for (Map.Entry<MetricDescriptor, MeterHolder> e : this.constructedMeters.entrySet()) {
            if (!e.getKey().name().equals(name)) continue;
            isRemoveSuccess = this.internalRemove(e.getKey());
        }
        return isRemoveSuccess;
    }

    public boolean remove(MetricID metricID) {
        return this.internalRemove(new MetricDescriptor(metricID));
    }

    public void removeMatching(MetricFilter metricFilter) {
        for (Map.Entry<MetricDescriptor, MeterHolder> e : this.constructedMeters.entrySet()) {
            MetricID mid = e.getKey().toMetricID();
            if (!metricFilter.matches(mid, (Metric)e.getValue())) continue;
            this.internalRemove(e.getKey());
        }
    }

    boolean internalRemove(MetricDescriptor match) {
        String METHOD_NAME = "internalRemove";
        MeterHolder holder = this.constructedMeters.remove(match);
        if (holder != null) {
            Meter meter;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.logp(Level.FINE, CLASS_NAME, "internalRemove", String.format("Removed metric with [id: %s]", match.toMetricID().toString()));
            }
            if ((meter = Metrics.globalRegistry.remove(holder.getMeter())) != null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.logp(Level.FINE, CLASS_NAME, "internalRemove", String.format("Removed from the Micrometer global registry a meter with MeterId [id= %s]", meter.getId()));
                }
            } else if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.logp(Level.FINE, CLASS_NAME, "internalRemove", String.format("Attempted to remove a meter with the corresponding MetricID [id= %s] from the Micrometer global registry, but does not exist.", match.toMetricID()));
            }
            if (this.constructedMeters.keySet().stream().noneMatch(id -> id.name.equals(match.name))) {
                this.metadataMap.remove(match.name);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.logp(Level.FINE, CLASS_NAME, "internalRemove", String.format("Removed metadata for [name: %s]", match.name));
                }
            }
        }
        return holder != null;
    }

    public SortedSet<String> getNames() {
        return new TreeSet<String>(this.metadataMap.keySet());
    }

    public SortedSet<MetricID> getMetricIDs() {
        TreeSet<MetricID> out = new TreeSet<MetricID>();
        for (MetricDescriptor key : this.constructedMeters.keySet()) {
            out.add(key.toMetricID());
        }
        return out;
    }

    public SortedMap<MetricID, Gauge> getGauges() {
        return this.getGauges(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Gauge> getGauges(MetricFilter metricFilter) {
        return this.getMetrics(Gauge.class, metricFilter);
    }

    public SortedMap<MetricID, Counter> getCounters() {
        return this.getCounters(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Counter> getCounters(MetricFilter metricFilter) {
        return this.getMetrics(Counter.class, metricFilter);
    }

    public SortedMap<MetricID, Histogram> getHistograms() {
        return this.getHistograms(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Histogram> getHistograms(MetricFilter metricFilter) {
        return this.getMetrics(Histogram.class, metricFilter);
    }

    public SortedMap<MetricID, Timer> getTimers() {
        return this.getTimers(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Timer> getTimers(MetricFilter metricFilter) {
        return this.getMetrics(Timer.class, metricFilter);
    }

    public SortedMap<MetricID, Metric> getMetrics(MetricFilter filter) {
        TreeMap<MetricID, Metric> out = new TreeMap<MetricID, Metric>();
        for (Map.Entry<MetricDescriptor, MeterHolder> e : this.constructedMeters.entrySet()) {
            MetricID mid = e.getKey().toMetricID();
            if (!filter.matches(mid, (Metric)e.getValue())) continue;
            out.put(e.getKey().toMetricID(), e.getValue());
        }
        return out;
    }

    public <T extends Metric> SortedMap<MetricID, T> getMetrics(Class<T> ofType, MetricFilter filter) {
        TreeMap<MetricID, Metric> out = new TreeMap<MetricID, Metric>();
        for (Map.Entry<MetricDescriptor, MeterHolder> e : this.constructedMeters.entrySet()) {
            MetricID mid;
            if (!ofType.isAssignableFrom(e.getValue().getClass()) || !filter.matches(mid = e.getKey().toMetricID(), (Metric)e.getValue())) continue;
            out.put(e.getKey().toMetricID(), e.getValue());
        }
        return out;
    }

    public Map<MetricID, Metric> getMetrics() {
        TreeMap<MetricID, Metric> out = new TreeMap<MetricID, Metric>();
        for (Map.Entry<MetricDescriptor, MeterHolder> e : this.constructedMeters.entrySet()) {
            out.put(e.getKey().toMetricID(), e.getValue());
        }
        return out;
    }

    public Map<String, Metadata> getMetadata() {
        return Collections.unmodifiableMap(this.metadataMap);
    }

    public String getScope() {
        return this.scope;
    }

    public Tags withAppTags(Tag ... tags) {
        Tags out = Tags.empty();
        if (tags != null) {
            for (Tag t : tags) {
                if (t.getTagName().equals(MP_APPLICATION_NAME_TAG) || t.getTagName().equals(MP_SCOPE_TAG)) {
                    throw new IllegalArgumentException("Can not use reserved tag names: \"mp_scope\" or \"mp_app\"");
                }
                out = out.and(t.getTagName(), t.getTagValue());
            }
        }
        out = this.combineApplicationTagsWithMPConfigAppNameTag(out);
        return out;
    }

    public Tag[] scopeTagsLegacy() {
        return new Tag[]{new Tag("scope", this.scope)};
    }

    private MpMetadata internalGetMetadata(String name) {
        MpMetadata result = this.metadataMap.computeIfAbsent(name, k -> new MpMetadata(name));
        if (!result.equals(MpMetadata.sanitize(new MpMetadata(name)))) {
            throw new IllegalArgumentException(String.format("Existing metadata (%s) does not match with supplied metadata (%s)", result.toString(), new MpMetadata(name).toString()));
        }
        return result;
    }

    private MpMetadata internalGetMetadata(Metadata metadata) {
        MpMetadata result = this.metadataMap.computeIfAbsent(metadata.getName(), k -> MpMetadata.sanitize(metadata));
        if (!result.equals(MpMetadata.sanitize(metadata))) {
            throw new IllegalArgumentException(String.format("Existing metadata (%s) does not match with supplied metadata (%s)", result.toString(), metadata.toString()));
        }
        return result;
    }

    private MpMetadata internalGetMetadataTimers(String name) {
        MpMetadata result = this.metadataMap.computeIfAbsent(name, k -> new MpMetadata(name));
        if (!result.equalsTimers(MpMetadata.sanitize(new MpMetadata(name)))) {
            throw new IllegalArgumentException(String.format("Existing metadata (%s) does not match with supplied metadata (%s)", result.toString(), new MpMetadata(name).toString()));
        }
        return result;
    }

    private MpMetadata internalGetMetadataTimers(Metadata metadata) {
        MpMetadata result = this.metadataMap.computeIfAbsent(metadata.getName(), k -> MpMetadata.sanitize(metadata));
        if (!result.equalsTimers(MpMetadata.sanitize(metadata))) {
            throw new IllegalArgumentException(String.format("Existing metadata (%s) does not match with supplied metadata (%s)", result.toString(), metadata.toString()));
        }
        return result;
    }

    <T> T checkCast(Class<T> type, MpMetadata metadata, MeterHolder o) {
        try {
            return type.cast(o);
        }
        catch (ClassCastException cce) {
            throw new IllegalStateException(String.format("Metric (%s) already defined using a different type (%s)", metadata.name, o.getMeter().getId().getType()), cce);
        }
    }

    public MemberToMetricMappings getMemberToMetricMappings() {
        return this.memberToMetricMappings;
    }
}

