/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.json;

import java.io.File;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class Version {
    private static String DEFAULT = "UNKNOWN";
    private String buildDate = DEFAULT;
    private String specTitle = DEFAULT;
    private String specVersion = DEFAULT;
    private String specVendor = DEFAULT;
    private String implTitle = DEFAULT;
    private String implVersion = DEFAULT;
    private String implVendor = DEFAULT;
    private String file = DEFAULT;

    public static void main(String[] args) {
        try {
            Version vs = new Version();
            System.out.println("");
            System.out.println("MANIFEST information for jar: [" + vs.getFile() + "]");
            System.out.println("");
            System.out.println("Specification:");
            System.out.println("\tTitle: [" + vs.getSpecificationTitle() + "]");
            System.out.println("\tVersion: [" + vs.getSpecificationVersion() + "]");
            System.out.println("\tVendor: [" + vs.getSpecificationVendor() + "]");
            System.out.println("");
            System.out.println("Implementation:");
            System.out.println("\tTitle: [" + vs.getImplementationTitle() + "]");
            System.out.println("\tVersion: [" + vs.getImplementationVersion() + "]");
            System.out.println("\tVendor: [" + vs.getImplementationVendor() + "]");
            System.out.println("");
            System.out.println("Build date: [" + vs.getBuildDate() + "]");
        }
        catch (Exception ex) {
            System.out.println("Fatal error: " + ex.toString());
            ex.printStackTrace();
        }
    }

    public Version() {
        try {
            Class<?> cls = this.getClass();
            ProtectionDomain pd = cls.getProtectionDomain();
            CodeSource cs = pd.getCodeSource();
            URL jar = cs.getLocation();
            String fName = jar.getFile();
            if (fName != null) {
                File file = new File(fName);
                this.file = file.getAbsolutePath();
                JarFile jf = new JarFile(fName);
                Manifest mf = jf.getManifest();
                jf.close();
                if (mf != null) {
                    Attributes attrs = mf.getMainAttributes();
                    if (attrs.getValue("Build-Date") != null) {
                        this.buildDate = attrs.getValue("Build-Date");
                    }
                    if (attrs.getValue(Attributes.Name.SPECIFICATION_TITLE) != null) {
                        this.specTitle = attrs.getValue(Attributes.Name.SPECIFICATION_TITLE);
                    }
                    if (attrs.getValue(Attributes.Name.SPECIFICATION_VERSION) != null) {
                        this.specVersion = attrs.getValue(Attributes.Name.SPECIFICATION_VERSION);
                    }
                    if (attrs.getValue(Attributes.Name.SPECIFICATION_VENDOR) != null) {
                        this.specVendor = attrs.getValue(Attributes.Name.SPECIFICATION_VENDOR);
                    }
                    if (attrs.getValue(Attributes.Name.IMPLEMENTATION_TITLE) != null) {
                        this.implTitle = attrs.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
                    }
                    if (attrs.getValue(Attributes.Name.IMPLEMENTATION_VERSION) != null) {
                        this.implVersion = attrs.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                    }
                    if (attrs.getValue(Attributes.Name.IMPLEMENTATION_VENDOR) != null) {
                        this.implVendor = attrs.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
                    }
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Fatal error: " + ex.toString());
            ex.printStackTrace();
        }
    }

    public String getBuildDate() {
        return this.buildDate;
    }

    public String getSpecificationVersion() {
        return this.specVersion;
    }

    public String getSpecificationTitle() {
        return this.specTitle;
    }

    public String getSpecificationVendor() {
        return this.specVendor;
    }

    public String getImplementationVersion() {
        return this.implVersion;
    }

    public String getImplementationTitle() {
        return this.implTitle;
    }

    public String getImplementationVendor() {
        return this.implVendor;
    }

    public String getFile() {
        return this.file;
    }
}

