/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ras.instrument.internal.buildtasks;

import com.ibm.ws.ras.instrument.internal.bci.InstrumentationException;
import com.ibm.ws.ras.instrument.internal.main.AbstractInstrumentation;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FileSet;

public abstract class AbstractInstrumentationTask
extends Task {
    protected File file = null;
    protected Vector<FileSet> filesets = new Vector();
    protected boolean failOnError = true;
    protected int verbosity = 3;
    protected boolean debug = false;
    protected File configFile = null;

    public void setVerbose(boolean verbose) {
        this.verbosity = verbose ? 2 : 3;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setConfigFile(File configFile) {
        this.configFile = configFile;
    }

    protected Commandline getCommandline() {
        Commandline cmdl = new Commandline();
        if (this.configFile != null) {
            cmdl.createArgument().setValue("--config");
            cmdl.createArgument().setFile(this.configFile);
        }
        if (this.debug) {
            cmdl.createArgument().setValue("--debug");
        }
        return cmdl;
    }

    protected abstract AbstractInstrumentation createInstrumentation();

    public void execute() {
        AbstractInstrumentation inst;
        ArrayList<File> flist = new ArrayList<File>();
        if (this.file != null) {
            flist.add(this.file);
        }
        for (int i = 0; i < this.filesets.size(); ++i) {
            FileSet fs = this.filesets.elementAt(i);
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            File dir = fs.getDir(this.getProject());
            String[] includedFiles = ds.getIncludedFiles();
            for (String s : Arrays.asList(includedFiles)) {
                flist.add(new File(dir, s));
            }
        }
        Commandline cmdl = this.getCommandline();
        for (File f : flist) {
            cmdl.createArgument().setFile(f);
        }
        try {
            inst = this.createInstrumentation();
            if (cmdl.size() == 0) {
                return;
            }
            inst.processArguments(cmdl.getArguments());
            inst.processPackageInfo();
        }
        catch (Exception t) {
            this.getProject().log((Task)this, "Invalid class files or jars specified " + t, 0);
            if (this.failOnError) {
                this.getProject().log("Instrumentation Failed", (Throwable)t, 0);
                throw new BuildException("InstrumentationFailed", (Throwable)t);
            }
            return;
        }
        List<File> classFiles = inst.getClassFiles();
        List<File> jarFiles = inst.getJarFiles();
        boolean instrumentationErrors = false;
        for (File f : classFiles) {
            try {
                this.log("Instrumenting class " + f, this.verbosity);
                inst.instrumentClassFile(f);
            }
            catch (Throwable t) {
                boolean instrumentationError = t instanceof InstrumentationException;
                if (this.failOnError && !instrumentationError) {
                    throw new BuildException("Instrumentation of class " + f + " failed", t);
                }
                String reason = "";
                if (instrumentationError) {
                    reason = ": " + t.getMessage();
                    instrumentationErrors = true;
                }
                this.getProject().log((Task)this, "Unable to instrument class " + f + reason, 1);
            }
        }
        for (File f : jarFiles) {
            try {
                this.log("Instrumenting archive file " + f, this.verbosity);
                inst.instrumentZipFile(f);
            }
            catch (Throwable t) {
                if (this.failOnError) {
                    throw new BuildException("InstrumentationFailed", t);
                }
                this.getProject().log((Task)this, "Unable to instrument archive " + f, 1);
            }
        }
        if (instrumentationErrors) {
            throw new BuildException("Instrumentation of classes failed");
        }
    }
}

