/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.config.xml.nester.Nester;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class RealmConfig
extends HashMap<String, Object> {
    private static final TraceComponent tc = Tr.register(RealmConfig.class, (String)"wimUtil", (String)"com.ibm.ws.security.wim.util.resources.WimUtilMessages");
    private static final long serialVersionUID = -1L;
    public static final String DEFAULT_REALM = "defaultRealm";
    public static final String ALLOW_IF_REPODOWN = "allowOpIfRepoDown";
    public static final String DELIMITER = "delimiter";
    public static final String NAME = "name";
    public static final String PARTICIPATING_BASEENTRIES = "participatingBaseEntry";
    public static final String DEFAULT_PARENTS = "defaultParents";
    public static final String DEFAULT_PARENT = "defaultParent";
    public static final String ENTITY_TYPE_NAME = "entityTypeName";
    public static final String PARENT_UNIQUE_NAME = "parentUniqueName";
    public static final String UNIQUE_USER_ID_MAPPING = "uniqueUserIdMapping";
    public static final String USER_SECURITY_NAME_MAPPING = "userSecurityNameMapping";
    public static final String USER_DISPLAY_NAME_MAPPING = "userDisplayNameMapping";
    public static final String UNIQUE_GROUP_ID_MAPPING = "uniqueGroupIdMapping";
    public static final String GROUP_SECURITY_NAME_MAPPING = "groupSecurityNameMapping";
    public static final String GROUP_DISPLAY_NAME_MAPPING = "groupDisplayNameMapping";
    public static final String URATTR_UNIQUE_USER_ID = "uniqueUserId";
    public static final String URATTR_USER_SECURITY_NAME = "userSecurityName";
    public static final String URATTR_USER_DISPLAY_NAME = "userDisplayName";
    public static final String URATTR_UNIQUE_GROUP_ID = "uniqueGroupId";
    public static final String URATTR_GROUP_SECURITY_NAME = "groupSecurityName";
    public static final String URATTR_GROUP_DISPLAY_NAME = "groupDisplayName";
    public static final String INPUT_PROPERTY = "inputProperty";
    public static final String OUTPUT_PROPERTY = "outputProperty";
    boolean defaultRealm = false;
    boolean allowOpIfRepoDown = false;
    String delimiter = "/";
    String name;
    String[] participatingBaseEntries;
    private Map<String, String> defaultParentMapping = new HashMap<String, String>();

    public boolean isDefaultRealm() {
        return (Boolean)this.get(DEFAULT_REALM);
    }

    public boolean isAllowOpIfRepoDown() {
        return (Boolean)this.get(ALLOW_IF_REPODOWN);
    }

    public String getDelimiter() {
        return (String)this.get(DELIMITER);
    }

    public String getName() {
        return (String)this.get(NAME);
    }

    public String[] getParticipatingBaseEntries() {
        return (String[])this.get(PARTICIPATING_BASEENTRIES);
    }

    public Map<String, String> getDefaultParentMapping() {
        return (Map)this.get(DEFAULT_PARENTS);
    }

    public void setDefaultParentMapping(Map<String, String> defaultParentMapping) {
        this.defaultParentMapping = defaultParentMapping;
    }

    public RealmConfig(Map<String, Object> realmProps, boolean isDefaultRealm) {
        Map<String, String> defaultParentMap;
        Map propMap = Nester.nest(realmProps, (String[])new String[]{UNIQUE_USER_ID_MAPPING, USER_SECURITY_NAME_MAPPING, USER_DISPLAY_NAME_MAPPING, UNIQUE_GROUP_ID_MAPPING, GROUP_SECURITY_NAME_MAPPING, GROUP_DISPLAY_NAME_MAPPING, PARTICIPATING_BASEENTRIES, DEFAULT_PARENTS});
        this.populateURMapping(UNIQUE_USER_ID_MAPPING, propMap);
        this.populateURMapping(USER_SECURITY_NAME_MAPPING, propMap);
        this.populateURMapping(USER_DISPLAY_NAME_MAPPING, propMap);
        this.populateURMapping(UNIQUE_GROUP_ID_MAPPING, propMap);
        this.populateURMapping(GROUP_SECURITY_NAME_MAPPING, propMap);
        this.populateURMapping(GROUP_DISPLAY_NAME_MAPPING, propMap);
        this.populateURMapping(DEFAULT_PARENTS, propMap);
        List baseEntries = (List)propMap.get(PARTICIPATING_BASEENTRIES);
        int i = 0;
        for (Map map : baseEntries) {
            String name = (String)map.get(NAME);
            if (name == null) {
                Tr.error((TraceComponent)tc, (String)"INVALID_PARTICIPATING_BASE_ENTRY_DEFINITION", (Object[])new Object[]{map});
                continue;
            }
            if (this.participatingBaseEntries == null) {
                this.participatingBaseEntries = new String[baseEntries.size()];
            }
            this.participatingBaseEntries[i++] = name;
        }
        this.put(PARTICIPATING_BASEENTRIES, this.participatingBaseEntries);
        for (Map.Entry entry : realmProps.entrySet()) {
            String key = (String)entry.getKey();
            if (!this.genericKey(key)) continue;
            this.put(key, entry.getValue());
        }
        this.put(DEFAULT_REALM, isDefaultRealm);
        if (this.participatingBaseEntries == null || this.participatingBaseEntries.length == 0) {
            Tr.error((TraceComponent)tc, (String)"MISSING_BASE_ENTRY_IN_REALM", (Object[])new Object[]{this.getName()});
        }
        if ((defaultParentMap = this.getDefaultParentMap(propMap)) != null) {
            this.put(DEFAULT_PARENTS, defaultParentMap);
        }
    }

    private Map<String, String> getDefaultParentMap(Map<String, List<Map<String, Object>>> propMap) {
        HashMap<String, String> defaultParentsMap = null;
        List<Map<String, Object>> defaultParentsList = propMap.get(DEFAULT_PARENTS);
        if (!defaultParentsList.isEmpty()) {
            defaultParentsMap = new HashMap<String, String>();
            for (Map<String, Object> defaultParents : defaultParentsList) {
                String entityName = (String)defaultParents.get(NAME);
                String parentUniqueName = (String)defaultParents.get(PARENT_UNIQUE_NAME);
                defaultParentsMap.put(entityName, parentUniqueName);
            }
        }
        return defaultParentsMap;
    }

    private boolean genericKey(String key) {
        int i = key.indexOf(46);
        if (i == -1) {
            return true;
        }
        String k = key.substring(0, i - 1);
        return !k.equals(UNIQUE_USER_ID_MAPPING) && !k.equals(USER_SECURITY_NAME_MAPPING) && !k.equals(USER_DISPLAY_NAME_MAPPING) && !k.equals(UNIQUE_GROUP_ID_MAPPING) && !k.equals(GROUP_SECURITY_NAME_MAPPING) && !k.equals(GROUP_DISPLAY_NAME_MAPPING) && !k.equals(PARTICIPATING_BASEENTRIES);
    }

    @Trivial
    private void populateURMapping(String key, Map<String, List<Map<String, Object>>> propMap) {
        List<Map<String, Object>> urMappingList = propMap.get(key);
        if (!urMappingList.isEmpty()) {
            Map<String, Object> urMapping = urMappingList.get(0);
            String[] propMapping = new String[]{(String)urMapping.get(INPUT_PROPERTY), (String)urMapping.get(OUTPUT_PROPERTY)};
            this.put(key, propMapping);
        }
    }

    public String getURMapInputPropertyInRealm(String inputProperty) {
        Object propMapping = this.get(inputProperty);
        String returnProp = null;
        if (propMapping != null) {
            returnProp = ((String[])this.get(inputProperty))[0];
        }
        return returnProp;
    }

    public String getURMapOutputPropertyInRealm(String outputProperty) {
        Object propMapping = this.get(outputProperty);
        String returnProp = null;
        if (propMapping != null) {
            returnProp = ((String[])this.get(outputProperty))[1];
        }
        return returnProp;
    }
}

