/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class IntArray {
    private static final TraceComponent tc = SibTr.register(IntArray.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private List allArrays = null;
    private final int arraySize;
    private int[] current;
    private int currentCursor = 0;
    private int elements = 0;
    private static final int DEFAULT_SIZE = 20;

    public IntArray(int initalArraySize) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<init>");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Params: initialArraySize", (Object)initalArraySize);
        }
        this.arraySize = initalArraySize;
        this.current = new int[this.arraySize];
        this.allArrays = new ArrayList();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    public IntArray() {
        this(20);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<init>");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    public void add(int anInt) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"add");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Params: int", (Object)anInt);
        }
        if (this.currentCursor == this.arraySize) {
            this.allArrays.add(this.current);
            this.current = new int[this.arraySize];
            this.currentCursor = 0;
        }
        this.current[this.currentCursor] = anInt;
        ++this.currentCursor;
        ++this.elements;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"add");
        }
    }

    public int get(int index) throws NoSuchElementException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"get");
        }
        int retValue = 0;
        int arrayNumber = index / this.arraySize;
        if (index + 1 > this.elements) {
            throw new NoSuchElementException();
        }
        if (index < 0) {
            throw new NoSuchElementException();
        }
        if (this.allArrays.size() == arrayNumber) {
            retValue = this.current[index - arrayNumber * this.arraySize];
        } else {
            int[] tempArray = (int[])this.allArrays.get(arrayNumber);
            retValue = tempArray[index - arrayNumber * this.arraySize];
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"rc=", (Object)retValue);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"get");
        }
        return retValue;
    }

    public int length() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"length");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"rc=", (Object)this.elements);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"length");
        }
        return this.elements;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer("[");
        for (int x = 0; x < this.length(); ++x) {
            if (x != 0) {
                ret.append(", ");
            }
            ret.append(this.get(x));
        }
        ret.append("]");
        return ret.toString();
    }
}

