/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.common.XidProxy;
import com.ibm.ws.sib.comms.server.IdToObjectMap;
import com.ibm.ws.sib.comms.server.TransactionToDispatchableMap;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.SIUncoordinatedTransaction;
import com.ibm.wsspi.sib.core.SIXAResource;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class IdToTransactionTable {
    public static final String $sccsid = "@(#) 1.22 SIB/ws/code/sib.comms.server.impl/src/com/ibm/ws/sib/comms/server/IdToTransactionTable.java, SIB.comms, WASX.SIB, aa1225.01 10/10/06 07:02:43 [7/2/12 05:58:59]";
    private static String CLASS_NAME = IdToTransactionTable.class.getName();
    private static final TraceComponent tc = SibTr.register(IdToTransactionTable.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private final IdToObjectMap map = new IdToObjectMap();
    public static final InvalidTransaction INVALID_TRANSACTION;
    private final HashMap conversationIdToTranIdSet = new HashMap();

    public synchronized void addLocalTran(int id, int owningConversation, SIUncoordinatedTransaction tran) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"add", (Object)new Object[]{"" + id, "" + owningConversation, tran});
        }
        LocalTransactionEntry tx = new LocalTransactionEntry(owningConversation, tran);
        if (tran != INVALID_TRANSACTION) {
            this.associateTransactionWithConversation(owningConversation, id);
        }
        this.map.put(id, tx);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"add");
        }
    }

    public synchronized void addGlobalTransactionBranch(int transactionId, int owningConversation, SIXAResource resource, XidProxy xid, boolean isOperationOptimized) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addGlobalTransactionBranch", (Object)new Object[]{"" + transactionId, "" + owningConversation, resource, xid, "" + isOperationOptimized});
        }
        ResourceManagerEntry resourceManagerEntry = null;
        if (this.map.containsKey(transactionId)) {
            resourceManagerEntry = (ResourceManagerEntry)this.map.get(transactionId);
        } else {
            resourceManagerEntry = new ResourceManagerEntry(owningConversation, resource);
            this.map.put(transactionId, resourceManagerEntry);
            if (resource != INVALID_TRANSACTION) {
                this.associateTransactionWithConversation(owningConversation, transactionId);
            }
        }
        resourceManagerEntry.setInDoubt(xid, isOperationOptimized);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addGlobalTransactionBranch");
        }
    }

    public synchronized SITransaction get(int transactionId, boolean tollerateAbsence) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"get", (Object)new Object[]{"" + transactionId, "" + tollerateAbsence});
        }
        SITransaction result = null;
        if (transactionId != 0) {
            if (tollerateAbsence) {
                if (this.map.containsKey(transactionId)) {
                    AbstractTransactionEntry tx = (AbstractTransactionEntry)this.map.get(transactionId);
                    result = tx.getSITransaction();
                }
            } else {
                AbstractTransactionEntry tx = (AbstractTransactionEntry)this.map.get(transactionId);
                result = tx.getSITransaction();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"get", result);
        }
        return result;
    }

    public synchronized SIXAResource getResourceForGlobalTransactionBranch(int transactionId, XidProxy xid) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getResourceForGlobalTransactionBranch", (Object)new Object[]{"" + transactionId, xid});
        }
        SIXAResource result = null;
        if (this.map.containsKey(transactionId)) {
            AbstractTransactionEntry uow = (AbstractTransactionEntry)this.map.get(transactionId);
            if (uow.isForLocalTransaction()) {
                SIErrorException exception = new SIErrorException();
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".getResourceForGlobalTransactionBranch"), (String)"3-030-0002", (Object[])new Object[]{this, this.map, "" + transactionId, xid});
                if (tc.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
                }
                throw exception;
            }
            ResourceManagerEntry globalUow = (ResourceManagerEntry)uow;
            if (globalUow.isXidProxyInDoubt(xid)) {
                result = (SIXAResource)globalUow.getSITransaction();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getResourceForGlobalTransactionBranch", result);
        }
        return result;
    }

    public SITransaction get(int transactionId) {
        return this.get(transactionId, false);
    }

    public synchronized void removeLocalTransaction(int transactionId) {
        AbstractTransactionEntry uow;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeLocalTransaction", (Object)("" + transactionId));
        }
        if ((uow = (AbstractTransactionEntry)this.map.get(transactionId)).isForLocalTransaction()) {
            this.map.remove(transactionId);
            if (uow.getSITransaction() != INVALID_TRANSACTION) {
                this.disassociateTransaction(uow.getOwningConnection(), transactionId);
            }
        } else {
            SIErrorException exception = new SIErrorException();
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".removeLocalTransaction"), (String)"3-030-0007", (Object[])new Object[]{this, this.map, "" + transactionId});
            if (tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
            }
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeLocalTransaction");
        }
    }

    public synchronized void removeGlobalTransactionBranch(int transactionId, XidProxy xid) {
        AbstractTransactionEntry uow;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeGlobalTransactionBranch", (Object)new Object[]{"" + transactionId, xid});
        }
        if ((uow = (AbstractTransactionEntry)this.map.get(transactionId)).isForLocalTransaction()) {
            SIErrorException exception = new SIErrorException();
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".removeGlobalTransactionBranch"), (String)"3-030-0010", (Object[])new Object[]{this, this.map, "" + transactionId, xid});
            if (tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
            }
            throw exception;
        }
        ResourceManagerEntry globalUow = (ResourceManagerEntry)uow;
        globalUow.completeXid(xid);
        if (!globalUow.hasInDoubtXids()) {
            this.map.remove(transactionId);
            if (globalUow.getSITransaction() != INVALID_TRANSACTION) {
                this.disassociateTransaction(globalUow.getOwningConnection(), transactionId);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeGlobalTransactionBranch");
        }
    }

    public synchronized void removeTransactions(Conversation conversation, TransactionToDispatchableMap dispatchableMap) {
        HashSet tranSet;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeTransactions", (Object)new Object[]{conversation, dispatchableMap});
        }
        if ((tranSet = (HashSet)this.conversationIdToTranIdSet.remove(conversation.getId())) != null) {
            Iterator iterator = tranSet.iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("removing transaction with id=" + id));
                }
                this.map.remove(id);
                dispatchableMap.removeAllDispatchablesForTransaction(id);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeTransactions");
        }
    }

    public synchronized void markAsRollbackOnly(int transactionId, Throwable throwable) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"markAsRollbackOnly", (Object)new Object[]{"" + transactionId, throwable});
        }
        AbstractTransactionEntry tx = (AbstractTransactionEntry)this.map.get(transactionId);
        tx.markAsRollbackOnly(throwable);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"markAsRollbackOnly");
        }
    }

    public synchronized void endGlobalTransactionBranch(int transactionId, XidProxy xid) {
        AbstractTransactionEntry tx;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"endGlobalTransactionBranch", (Object)new Object[]{"" + transactionId, xid});
        }
        if ((tx = (AbstractTransactionEntry)this.map.get(transactionId)).isForLocalTransaction()) {
            SIErrorException exception = new SIErrorException();
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".endGlobalTransactionBranch"), (String)"3-030-0008", (Object[])new Object[]{this, this.map, "" + transactionId, xid});
            if (tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
            }
            throw exception;
        }
        ResourceManagerEntry resource = (ResourceManagerEntry)tx;
        resource.endTransactionBranch(xid);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"endGlobalTransactionBranch");
        }
    }

    public synchronized Throwable getExceptionForRollbackOnlyLocalTransaction(int transactionId) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getExceptionForRollbackOnlyTransaction", (Object)("" + transactionId));
        }
        AbstractTransactionEntry tx = (AbstractTransactionEntry)this.map.get(transactionId);
        Throwable result = null;
        if (!tx.isForLocalTransaction()) {
            SIErrorException exception = new SIErrorException();
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".getExceptionForRollbackOnlyLocalTransaction"), (String)"3-030-0003", (Object[])new Object[]{this, this.map, "" + transactionId});
            if (tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
            }
            throw exception;
        }
        LocalTransactionEntry localTx = (LocalTransactionEntry)tx;
        result = localTx.getException();
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getExceptionForRollbackOnlyTransaction", (Object)result);
        }
        return result;
    }

    public synchronized boolean isGlobalTransactionBranchRollbackOnly(int transactionId, XidProxy xid) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isGlobalTransactionBranchRollbackOnly", (Object)new Object[]{"" + transactionId, xid});
        }
        AbstractTransactionEntry tx = (AbstractTransactionEntry)this.map.get(transactionId);
        boolean result = false;
        if (tx.isForLocalTransaction()) {
            SIErrorException exception = new SIErrorException();
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".endGlobalTransactionBranch"), (String)"3-030-0008", (Object[])new Object[]{this, this.map, "" + transactionId, xid});
            if (tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
            }
            throw exception;
        }
        ResourceManagerEntry resource = (ResourceManagerEntry)tx;
        result = resource.isRollbackOnly(xid);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isGlobalTransactionBranchRollbackOnly", (Object)("" + result));
        }
        return result;
    }

    public synchronized boolean isLocalTransactionRollbackOnly(int transactionId) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isLocalTransactionRollbackOnly", (Object)("" + transactionId));
        }
        AbstractTransactionEntry tx = (AbstractTransactionEntry)this.map.get(transactionId);
        boolean result = false;
        if (!tx.isForLocalTransaction()) {
            SIErrorException exception = new SIErrorException();
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".isLocalTransactionRollbackOnly"), (String)"3-030-0009", (Object[])new Object[]{this, this.map, "" + transactionId});
            if (tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
            }
            throw exception;
        }
        LocalTransactionEntry localTx = (LocalTransactionEntry)tx;
        result = localTx.isRollbackOnly();
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isLocalTransactionRollbackOnly", (Object)("" + result));
        }
        return result;
    }

    public synchronized void endOptimizedGlobalTransactionBranch(int transactionId, int flags) {
        AbstractTransactionEntry tx;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"endOptimizedGlobalTransactionBranch", (Object)new Object[]{"" + transactionId, "" + flags});
        }
        if ((tx = (AbstractTransactionEntry)this.map.get(transactionId)).isForLocalTransaction()) {
            SIErrorException exception = new SIErrorException();
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".endOptimizedGlobalTransactionBranch"), (String)"3-030-0004", (Object[])new Object[]{this, this.map, "" + transactionId});
            if (tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
            }
            throw exception;
        }
        ResourceManagerEntry resource = (ResourceManagerEntry)tx;
        resource.endCurrentTransactionBranch(flags, true);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"endOptimizedGlobalTransactionBranch");
        }
    }

    public synchronized Throwable getExceptionForRollbackOnlyGlobalTransactionBranch(int transactionId, XidProxy xid) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getExceptionForRollbackOnlyGlobalTransactionBranch", (Object)new Object[]{"" + transactionId, xid});
        }
        AbstractTransactionEntry tx = (AbstractTransactionEntry)this.map.get(transactionId);
        Throwable result = null;
        if (tx.isForLocalTransaction()) {
            SIErrorException exception = new SIErrorException();
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".getExceptionForRollbackOnlyGlobalTransactionBranch"), (String)"3-030-0006", (Object[])new Object[]{this, this.map, "" + transactionId});
            if (tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
            }
            throw exception;
        }
        ResourceManagerEntry resource = (ResourceManagerEntry)tx;
        if (!resource.isRollbackOnly(xid)) {
            SIErrorException exception = new SIErrorException();
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".getExceptionForRollbackOnlyGlobalTransactionBranch"), (String)"3-030-0005", (Object[])new Object[]{this, this.map, "" + transactionId});
            if (tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
            }
            throw exception;
        }
        result = resource.getException(xid);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getExceptionForRollbackOnlyGlobalTransactionBranch", (Object)result);
        }
        return result;
    }

    public synchronized void rollbackTxWithoutCompletionDirection(Conversation conversation) {
        HashSet tranSet;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"rollbackTxWithoutCompletionDirection", (Object)conversation);
        }
        if ((tranSet = (HashSet)this.conversationIdToTranIdSet.get(conversation.getId())) != null) {
            Iterator iterator = tranSet.iterator();
            while (iterator.hasNext()) {
                int transactionId = (Integer)iterator.next();
                AbstractTransactionEntry transaction = (AbstractTransactionEntry)this.map.get(transactionId);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("rolling back transaction without completion direction id=" + transactionId));
                }
                transaction.rollbackTxWithoutCompletionDirection();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"rollbackTxWithoutCompletionDirection");
        }
    }

    public synchronized void rollbackEnlisted(Conversation conversation) {
        HashSet tranSet;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"rollbackEnlisted", (Object)conversation);
        }
        if ((tranSet = (HashSet)this.conversationIdToTranIdSet.get(conversation.getId())) != null) {
            Iterator iterator = tranSet.iterator();
            while (iterator.hasNext()) {
                int transactionId = (Integer)iterator.next();
                AbstractTransactionEntry transaction = (AbstractTransactionEntry)this.map.get(transactionId);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("rolling back transaction with id=" + transactionId));
                }
                transaction.rollbackEnlisted();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"rollbackEnlisted");
        }
    }

    public String toString() {
        return this.map.toString();
    }

    private void associateTransactionWithConversation(int conversationId, int tranId) {
        HashSet<Integer> tranSet;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"associateTransactionWithConversation", (Object)new Object[]{"conversationId=" + conversationId, "tranId=" + tranId});
        }
        if ((tranSet = (HashSet<Integer>)this.conversationIdToTranIdSet.get(conversationId)) == null) {
            tranSet = new HashSet<Integer>();
            tranSet.add(tranId);
            this.conversationIdToTranIdSet.put(conversationId, tranSet);
        } else {
            tranSet.add(tranId);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"associateTransactionWithConversation");
        }
    }

    private void disassociateTransaction(int conversationId, int tranId) {
        HashSet tranSet;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"disassociateTransaction", (Object)new Object[]{"conversationId=" + conversationId, "tranId=" + tranId});
        }
        if ((tranSet = (HashSet)this.conversationIdToTranIdSet.get(conversationId)) != null) {
            tranSet.remove(tranId);
            if (tranSet.isEmpty()) {
                this.conversationIdToTranIdSet.remove(conversationId);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"disassociateTransaction");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#)SIB/ws/code/sib.comms.server.impl/src/com/ibm/ws/sib/comms/server/IdToTransactionTable.java, SIB.comms, WASX.SIB, aa1225.01 1.22");
        }
        INVALID_TRANSACTION = new InvalidTransaction();
    }

    private class LocalTransactionEntry
    extends AbstractTransactionEntry {
        private Throwable throwable;

        public LocalTransactionEntry(int connection, SIUncoordinatedTransaction transaction) {
            super(connection, (SITransaction)transaction);
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)".LocalTransactionEntry.<init>", (Object)new Object[]{"" + connection, transaction});
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)".LocalTransactionEntry.<init>");
            }
        }

        public boolean isRollbackOnly() {
            boolean result;
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)".LocalTransactionEntry.isRollbackOnly");
            }
            boolean bl = result = this.throwable != null;
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)".LocalTransactionEntry.isRollbackOnly", (Object)("" + result));
            }
            return result;
        }

        public Throwable getException() {
            Throwable result;
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)".LocalTransactionEntry.getException");
            }
            if ((result = this.throwable) == null) {
                SIErrorException exception = new SIErrorException();
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".LocalTransactionEntry.getException"), (String)"3-030-0011", (Object[])new Object[]{this, IdToTransactionTable.this.map, this.throwable});
                if (tc.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
                }
                throw exception;
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)".LocalTransactionEntry.getException", (Object)result);
            }
            return result;
        }

        @Override
        public boolean isForLocalTransaction() {
            return true;
        }

        @Override
        public void rollbackTxWithoutCompletionDirection() {
            block4: {
                if (tc.isEntryEnabled()) {
                    SibTr.entry((Object)this, (TraceComponent)tc, (String)".LocalTransactionEntry.rollbackTxWithoutCompletionDirection");
                }
                SIUncoordinatedTransaction tran = (SIUncoordinatedTransaction)this.getSITransaction();
                try {
                    tran.rollback();
                }
                catch (SIException e) {
                    if (!tc.isDebugEnabled()) break block4;
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("rollback failed with exception: " + (Object)((Object)e)));
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)".LocalTransactionEntry.rollbackTxWithoutCompletionDirection");
            }
        }

        @Override
        public void markAsRollbackOnly(Throwable throwable) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)".LocalTransactionEntry.markAsRollbackOnly", (Object)throwable);
            }
            if (this.throwable == null) {
                this.throwable = throwable;
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)".LocalTransactionEntry.markAsRollbackOnly");
            }
        }

        @Override
        public void rollbackEnlisted() {
            block4: {
                if (tc.isEntryEnabled()) {
                    SibTr.entry((Object)this, (TraceComponent)tc, (String)".LocalTransactionEntry.rollbackEnlisted");
                }
                SIUncoordinatedTransaction tran = (SIUncoordinatedTransaction)this.getSITransaction();
                try {
                    tran.rollback();
                }
                catch (SIException e) {
                    if (!tc.isDebugEnabled()) break block4;
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("rollback failed with exception: " + (Object)((Object)e)));
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)".LocalTransactionEntry.rollbackEnlisted");
            }
        }
    }

    private static class InvalidTransaction
    implements SIXAResource,
    SIUncoordinatedTransaction {
        private InvalidTransaction() {
        }

        private void selfDestruct() throws SIErrorException {
            SIErrorException exception = new SIErrorException();
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".InvalidTransaction"), (String)"3-030-0001", (Object)this);
            if (tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
            }
            throw exception;
        }

        public boolean isEnlisted() {
            this.selfDestruct();
            return false;
        }

        public void commit(Xid arg0, boolean arg1) throws XAException {
            this.selfDestruct();
        }

        public void end(Xid arg0, int arg1) throws XAException {
            this.selfDestruct();
        }

        public void forget(Xid arg0) throws XAException {
            this.selfDestruct();
        }

        public int getTransactionTimeout() throws XAException {
            this.selfDestruct();
            return 0;
        }

        public boolean isSameRM(XAResource arg0) throws XAException {
            this.selfDestruct();
            return false;
        }

        public int prepare(Xid arg0) throws XAException {
            this.selfDestruct();
            return 0;
        }

        public Xid[] recover(int arg0) throws XAException {
            this.selfDestruct();
            return new Xid[0];
        }

        public void rollback(Xid arg0) throws XAException {
            this.selfDestruct();
        }

        public boolean setTransactionTimeout(int arg0) throws XAException {
            this.selfDestruct();
            return false;
        }

        public void start(Xid arg0, int arg1) throws XAException {
            this.selfDestruct();
        }

        public void commit() throws SIIncorrectCallException, SIRollbackException, SIResourceException, SIConnectionLostException {
            this.selfDestruct();
        }

        public void rollback() throws SIIncorrectCallException, SIResourceException, SIConnectionLostException {
            this.selfDestruct();
        }
    }

    private class ResourceManagerEntry
    extends AbstractTransactionEntry {
        private XidProxy enlistedXid;
        private Throwable enlistedThrowable;
        private boolean enlistedWorkIsOptimized;
        private final HashMap xidProxyToRollbackOnlyThrowableMap;

        public ResourceManagerEntry(int connection, SIXAResource transaction) {
            super(connection, (SITransaction)transaction);
            this.enlistedXid = null;
            this.xidProxyToRollbackOnlyThrowableMap = new HashMap();
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)".ResourceManagerEntry.<init>", (Object)new Object[]{"" + connection, transaction});
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)".ResourceManagerEntry.<init>");
            }
        }

        public void endCurrentTransactionBranch(int flags, boolean optimized) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)".ResourceManagerEntry.endCurrentTransactionBranch", (Object)new Object[]{"" + flags, "" + optimized});
            }
            if (this.enlistedXid == null) {
                SIErrorException exception = new SIErrorException();
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".ResourceManagerEntry.endCurrentTransactionBranch"), (String)"3-030-0012", (Object[])new Object[]{this, IdToTransactionTable.this.map});
                if (tc.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
                }
                throw exception;
            }
            if (optimized != this.enlistedWorkIsOptimized) {
                SIErrorException exception = new SIErrorException();
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".ResourceManagerEntry.endCurrentTransactionBranch"), (String)"3-030-0013", (Object[])new Object[]{this, IdToTransactionTable.this.map, "" + optimized, "" + this.enlistedWorkIsOptimized, this.enlistedXid});
                if (tc.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
                }
                throw exception;
            }
            if (this.enlistedWorkIsOptimized) {
                try {
                    ((SIXAResource)this.getSITransaction()).end((Xid)this.enlistedXid, flags);
                }
                catch (XAException e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".ResourceManagerEntry.endCurrentTransactionBranch"), (String)"3-030-0024", (Object[])new Object[]{this, IdToTransactionTable.this.map, "errorCode=" + e.errorCode, this.enlistedXid});
                    this.markAsRollbackOnly(e);
                }
            }
            this.xidProxyToRollbackOnlyThrowableMap.put(this.enlistedXid, this.enlistedThrowable);
            this.enlistedXid = null;
            this.enlistedThrowable = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)".ResourceManagerEntry.endCurrentTransactionBranch");
            }
        }

        public boolean isXidProxyInDoubt(XidProxy xid) {
            boolean result;
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)".ResourceManagerEntry.isXidProxyInDoubt", (Object)xid);
            }
            boolean bl = result = this.xidProxyToRollbackOnlyThrowableMap.containsKey(xid) || xid.equals((Object)this.enlistedXid) && this.enlistedWorkIsOptimized;
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)".ResourceManagerEntry.isXidProxyInDoubt", (Object)("" + result));
            }
            return result;
        }

        public Throwable getException(XidProxy xid) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)".ResourceManagerEntry.getException", (Object)xid);
            }
            Throwable result = null;
            if (xid.equals((Object)this.enlistedXid)) {
                result = this.enlistedThrowable;
                if (result == null) {
                    SIErrorException exception = new SIErrorException();
                    FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".ResourceManagerEntry.getException"), (String)"3-030-0014", (Object[])new Object[]{this, IdToTransactionTable.this.map, xid});
                    throw exception;
                }
            } else if (this.xidProxyToRollbackOnlyThrowableMap.containsKey(xid)) {
                result = (Throwable)this.xidProxyToRollbackOnlyThrowableMap.get(xid);
                if (result == null) {
                    SIErrorException exception = new SIErrorException();
                    FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".ResourceManagerEntry.getException"), (String)"3-030-0015", (Object[])new Object[]{this, IdToTransactionTable.this.map, xid});
                    if (tc.isEventEnabled()) {
                        SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
                    }
                    throw exception;
                }
            } else {
                SIErrorException exception = new SIErrorException();
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".ResourceManagerEntry.getException"), (String)"3-030-0016", (Object[])new Object[]{this, IdToTransactionTable.this.map, xid});
                if (tc.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
                }
                throw exception;
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)".ResourceManagerEntry.getException", (Object)("" + result));
            }
            return result;
        }

        public boolean isRollbackOnly(XidProxy xid) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)".ResourceManagerEntry.isRollbackOnly", (Object)xid);
            }
            boolean result = false;
            if (xid.equals((Object)this.enlistedXid)) {
                result = this.enlistedThrowable != null;
            } else if (this.xidProxyToRollbackOnlyThrowableMap.containsKey(xid)) {
                result = this.xidProxyToRollbackOnlyThrowableMap.get(xid) != null;
            } else {
                SIErrorException exception = new SIErrorException();
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".ResourceManagerEntry.isRollbackOnly"), (String)"3-030-0017", (Object[])new Object[]{this, IdToTransactionTable.this.map, xid});
                if (tc.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
                }
                throw exception;
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)".ResourceManagerEntry.isRollbackOnly", (Object)("" + result));
            }
            return result;
        }

        public boolean hasInDoubtXids() {
            boolean result;
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)".ResourceManagerEntry.hasInDoubtXids");
            }
            boolean bl = result = this.enlistedXid != null || !this.xidProxyToRollbackOnlyThrowableMap.isEmpty();
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)".ResourceManagerEntry.hasInDoubtXids", (Object)("" + result));
            }
            return result;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void completeXid(XidProxy xid) {
            block9: {
                if (tc.isEntryEnabled()) {
                    SibTr.entry((Object)this, (TraceComponent)tc, (String)".ResourceManagerEntry.completeXid", (Object)xid);
                }
                if (xid.equals((Object)this.enlistedXid)) {
                    if (this.enlistedWorkIsOptimized) {
                        this.enlistedThrowable = null;
                        this.enlistedXid = null;
                        break block9;
                    } else {
                        SIErrorException exception = new SIErrorException();
                        FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".ResourceManagerEntry.completeXid"), (String)"3-030-0018", (Object[])new Object[]{this, IdToTransactionTable.this.map, xid});
                        if (tc.isEventEnabled()) {
                            SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
                        }
                        throw exception;
                    }
                }
                if (this.xidProxyToRollbackOnlyThrowableMap.containsKey(xid)) {
                    this.xidProxyToRollbackOnlyThrowableMap.remove(xid);
                } else {
                    SIErrorException exception = new SIErrorException();
                    FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".ResourceManagerEntry.completeXid"), (String)"3-030-0019", (Object[])new Object[]{this, IdToTransactionTable.this.map, xid});
                    if (tc.isEventEnabled()) {
                        SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
                    }
                    throw exception;
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)".ResourceManagerEntry.completeXid");
            }
        }

        public void endTransactionBranch(XidProxy xid) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)".ResourceManagerEntry.endTransactionBranch", (Object)xid);
            }
            if (!xid.equals((Object)this.enlistedXid)) {
                SIErrorException exception = new SIErrorException();
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".ResourceManagerEntry.endTransactionBranch"), (String)"3-030-0020", (Object[])new Object[]{this, IdToTransactionTable.this.map, xid});
                if (tc.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
                }
                throw exception;
            }
            this.xidProxyToRollbackOnlyThrowableMap.put(this.enlistedXid, this.enlistedThrowable);
            this.enlistedXid = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)".ResourceManagerEntry.endTransactionBranch");
            }
        }

        public void setInDoubt(XidProxy xid, boolean isOptimized) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)".ResourceManagerEntry.setInDoubt", (Object)new Object[]{xid, "" + isOptimized});
            }
            if (this.enlistedXid != null) {
                SIErrorException exception = new SIErrorException();
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".ResourceManagerEntry.setInDoubt"), (String)"3-030-0021", (Object[])new Object[]{this, IdToTransactionTable.this.map, xid});
                if (tc.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
                }
                throw exception;
            }
            if (this.xidProxyToRollbackOnlyThrowableMap.containsKey(xid)) {
                SIErrorException exception = new SIErrorException();
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".ResourceManagerEntry.setInDoubt"), (String)"3-030-0022", (Object[])new Object[]{this, IdToTransactionTable.this.map, xid});
                if (tc.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
                }
                throw exception;
            }
            this.enlistedXid = xid;
            this.enlistedWorkIsOptimized = isOptimized;
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)".ResourceManagerEntry.setInDoubt");
            }
        }

        @Override
        public boolean isForLocalTransaction() {
            return false;
        }

        @Override
        public void markAsRollbackOnly(Throwable throwable) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)".ResourceManagerEntry.markAsRollbackOnly", (Object)throwable);
            }
            if (this.enlistedXid == null) {
                SIErrorException exception = new SIErrorException();
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".ResourceManagerEntry.markAsRollbackOnly"), (String)"3-030-0023", (Object[])new Object[]{this, IdToTransactionTable.this.map, throwable});
                if (tc.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
                }
                throw exception;
            }
            this.enlistedThrowable = throwable;
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)".ResourceManagerEntry.markAsRollbackOnly");
            }
        }

        @Override
        public synchronized void rollbackTxWithoutCompletionDirection() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)".ResourceManagerEntry.rollbackTxWithoutCompletionDirection");
            }
            SIXAResource resource = (SIXAResource)this.getSITransaction();
            if (this.enlistedXid != null) {
                block8: {
                    try {
                        resource.end((Xid)this.enlistedXid, 0);
                    }
                    catch (XAException e) {
                        if (!tc.isDebugEnabled()) break block8;
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("end failed with exception: " + e));
                    }
                }
                this.endTransactionBranch(this.enlistedXid);
            }
            for (XidProxy xidProxy : this.xidProxyToRollbackOnlyThrowableMap.keySet()) {
                try {
                    resource.rollback((Xid)xidProxy);
                }
                catch (XAException e) {
                    if (!tc.isDebugEnabled()) continue;
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("rollback failed with exception: " + e));
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)".ResourceManagerEntry.rollbackTxWithoutCompletionDirection");
            }
        }

        @Override
        public void rollbackEnlisted() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)".ResourceManagerEntry.rollbackEnlisted");
            }
            if (this.enlistedXid != null) {
                SIXAResource resource = (SIXAResource)this.getSITransaction();
                try {
                    resource.end((Xid)this.enlistedXid, 0x20000000);
                }
                catch (XAException xAException) {
                    // empty catch block
                }
                try {
                    resource.rollback((Xid)this.enlistedXid);
                }
                catch (XAException xAException) {
                    // empty catch block
                }
                this.enlistedXid = null;
                this.enlistedThrowable = null;
                this.enlistedWorkIsOptimized = false;
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)".ResourceManagerEntry.rollbackEnlisted");
            }
        }
    }

    private abstract class AbstractTransactionEntry {
        private final int connection;
        private final SITransaction transaction;

        protected AbstractTransactionEntry(int connection, SITransaction transaction) {
            this.connection = connection;
            this.transaction = transaction;
        }

        public SITransaction getSITransaction() {
            return this.transaction;
        }

        public int getOwningConnection() {
            return this.connection;
        }

        public abstract boolean isForLocalTransaction();

        public abstract void rollbackEnlisted();

        public abstract void rollbackTxWithoutCompletionDirection();

        public abstract void markAsRollbackOnly(Throwable var1);
    }
}

