/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.utils.ras;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.utils.ras.SibStackFinder;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.ResourceBundle;

public class SibMessage
extends ListResourceBundle {
    private static SibStackFinder finder;
    private static final TraceComponent myTc;
    private static final String SIB_MESSAGE = "SIB_MESSAGE";
    private static final Object[][] resources;
    private static List<Listener> proposedList;
    private static volatile List<Listener> listeners;
    private static final TraceComponent TRACE_COMPONENT_FOR_CWSIU_MESSAGE_BUNDLE;

    public static synchronized void addListener(Listener l) {
        proposedList.add(l);
        listeners = new ArrayList<Listener>(proposedList);
    }

    public static synchronized void removeListener(Listener l) {
        proposedList.remove(l);
        listeners = new ArrayList<Listener>(proposedList);
    }

    @Override
    public Object[][] getContents() {
        return resources;
    }

    private static Object[] format(String me, TraceComponent tc, String msgKey, Object objs) {
        String formattedMsg;
        String resourceBundle = tc.getResourceBundleName();
        TraceNLS nls = TraceNLS.getTraceNLS((String)resourceBundle);
        Object[] objs1 = new Object[]{null};
        if (objs != null) {
            objs1 = objs.getClass().isArray() ? (Object[])objs : new Object[]{objs};
        }
        if ((formattedMsg = nls.getFormattedMessage(msgKey, objs1, null)).equalsIgnoreCase(msgKey)) {
            return SibMessage.getFormattedMessage(me, resourceBundle, msgKey, objs1, tc);
        }
        return new Object[]{me, formattedMsg};
    }

    private static Object[] getFormattedMessage(String me, String resourceBundle, String msgKey, Object[] objs, TraceComponent tc) {
        String formattedMsg;
        ResourceBundle bundle = SibMessage.getResourceBundle(resourceBundle, Locale.getDefault(), tc);
        if (bundle == null) {
            return new Object[]{me, msgKey};
        }
        String message = null;
        try {
            message = bundle.getString(msgKey);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (message == null || message.equals("")) {
            return new Object[]{me, msgKey};
        }
        if (objs == null) {
            return new Object[]{me, message};
        }
        try {
            formattedMsg = MessageFormat.format(message, objs);
        }
        catch (IllegalArgumentException e) {
            formattedMsg = message;
        }
        return new Object[]{me, formattedMsg};
    }

    private static ResourceBundle getResourceBundle(String name, Locale locale, TraceComponent tc) {
        Class<?> aClass;
        ResourceBundle rb = null;
        if (finder == null) {
            finder = SibStackFinder.getInstance();
        }
        if ((aClass = finder.getCaller()) != null) {
            ClassLoader cl = null;
            try {
                cl = AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() throws Exception {
                        return aClass.getClassLoader();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Tr.event((TraceComponent)tc, (String)("Unable to get context class loader: " + e.getMessage()), (Object[])new Object[0]);
            }
            try {
                rb = ResourceBundle.getBundle(name, locale, cl);
            }
            catch (RuntimeException re) {
                Tr.event((TraceComponent)tc, (String)"Unable to load {0} from {1} (from class {2}) in {3}; caught exception: {4}", (Object[])new Object[]{name, cl, aClass, locale.toString(), re});
            }
        } else {
            Tr.event((TraceComponent)tc, (String)"Unable to load {0} class was null", (Object[])new Object[]{name});
        }
        return rb;
    }

    static void audit(String me, TraceComponent tc, String msgKey, Object objs) {
        Object[] formattedMessage = SibMessage.format(me, tc, msgKey, objs);
        for (Listener l : listeners) {
            l.message(Listener.MessageType.AUDIT, me, tc, msgKey, objs, formattedMessage);
        }
    }

    static void error(String me, TraceComponent tc, String msgKey, Object objs) {
        Object[] formattedMessage = SibMessage.format(me, tc, msgKey, objs);
        for (Listener l : listeners) {
            l.message(Listener.MessageType.ERROR, me, tc, msgKey, objs, formattedMessage);
        }
    }

    static void fatal(String me, TraceComponent tc, String msgKey, Object objs) {
        Object[] formattedMessage = SibMessage.format(me, tc, msgKey, objs);
        for (Listener l : listeners) {
            l.message(Listener.MessageType.FATAL, me, tc, msgKey, objs, formattedMessage);
        }
    }

    static void info(String me, TraceComponent tc, String msgKey, Object objs) {
        Object[] formattedMessage = SibMessage.format(me, tc, msgKey, objs);
        for (Listener l : listeners) {
            l.message(Listener.MessageType.INFO, me, tc, msgKey, objs, formattedMessage);
        }
    }

    static void service(String me, TraceComponent tc, String msgKey, Object objs) {
        Object[] formattedMessage = SibMessage.format(me, tc, msgKey, objs);
        for (Listener l : listeners) {
            l.message(Listener.MessageType.SERVICE, me, tc, msgKey, objs, formattedMessage);
        }
    }

    static void warning(String me, TraceComponent tc, String msgKey, Object objs) {
        Object[] formattedMessage = SibMessage.format(me, tc, msgKey, objs);
        for (Listener l : listeners) {
            l.message(Listener.MessageType.WARNING, me, tc, msgKey, objs, formattedMessage);
        }
    }

    static void SuppressableError(SibTr.Suppressor s, String me, TraceComponent tc, String msgKey, Object objs) {
        SibMessage.suppressableOperation(s, me, tc, msgKey, objs, Listener.MessageType.ERROR);
    }

    static void SuppressableInfo(SibTr.Suppressor s, String me, TraceComponent tc, String msgKey, Object objs) {
        SibMessage.suppressableOperation(s, me, tc, msgKey, objs, Listener.MessageType.INFO);
    }

    static void SuppressableWarning(SibTr.Suppressor s, String me, TraceComponent tc, String msgKey, Object objs) {
        SibMessage.suppressableOperation(s, me, tc, msgKey, objs, Listener.MessageType.WARNING);
    }

    private static void suppressableOperation(SibTr.Suppressor s, String me, TraceComponent tc, String msgKey, Object objs, Listener.MessageType messageType) {
        String messageNumber;
        Object[] sibMessageInserts = SibMessage.format(me, tc, msgKey, objs);
        String actualMessage = (String)sibMessageInserts[1];
        if (actualMessage != null && actualMessage.length() > 10) {
            messageNumber = actualMessage.substring(0, 10);
            if (messageNumber.equals("Can't find")) {
                messageNumber = msgKey;
            }
        } else {
            messageNumber = msgKey;
        }
        if (s == null) {
            SibMessage.emitOperation(me, tc, msgKey, objs, messageType, sibMessageInserts);
        } else {
            SibTr.Suppressor.Decision decision = s.suppress(messageNumber, actualMessage);
            decision.emitSuppressedMessagesMessageIfNecessary(TRACE_COMPONENT_FOR_CWSIU_MESSAGE_BUNDLE);
            if (decision.isSuppressThisMessage()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Suppressed " + (Object)((Object)messageType) + ": " + actualMessage), (Object[])new Object[0]);
                }
            } else {
                SibMessage.emitOperation(me, tc, msgKey, objs, messageType, sibMessageInserts);
            }
            decision.emitSuppressingFollowingMessagesMessageIfNecessary(TRACE_COMPONENT_FOR_CWSIU_MESSAGE_BUNDLE);
        }
    }

    private static void emitOperation(String me, TraceComponent tc, String msgKey, Object objs, Listener.MessageType messageType, Object[] sibMessageInserts) {
        for (Listener l : listeners) {
            l.message(messageType, me, tc, msgKey, objs, sibMessageInserts);
        }
    }

    static {
        myTc = Tr.register(SibMessage.class, (String)"", (String)"com.ibm.ws.sib.utils.ras.SibMessage");
        resources = new Object[][]{{SIB_MESSAGE, "{0} {1}"}};
        listeners = null;
        proposedList = new ArrayList<Listener>();
        proposedList.add(new TrListener());
        listeners = new ArrayList<Listener>(proposedList);
        TRACE_COMPONENT_FOR_CWSIU_MESSAGE_BUNDLE = Tr.register(SibTr.Suppressor.class, (String)"", (String)"com.ibm.ws.sib.utils.CWSIUMessages");
    }

    public static interface Listener {
        public void message(MessageType var1, String var2, TraceComponent var3, String var4, Object var5, Object[] var6);

        public static enum MessageType {
            AUDIT,
            ERROR,
            FATAL,
            INFO,
            SERVICE,
            WARNING;

        }
    }

    private static class TrListener
    implements Listener {
        private TrListener() {
        }

        @Override
        public void message(Listener.MessageType type, String me, TraceComponent tc, String msgKey, Object objs, Object[] formattedMessage) {
            switch (type) {
                case AUDIT: {
                    if (!TraceComponent.isAnyTracingEnabled() || !myTc.isAuditEnabled()) break;
                    Tr.audit((TraceComponent)myTc, (String)SibMessage.SIB_MESSAGE, (Object[])formattedMessage);
                    break;
                }
                case ERROR: {
                    Tr.error((TraceComponent)myTc, (String)SibMessage.SIB_MESSAGE, (Object[])formattedMessage);
                    break;
                }
                case FATAL: {
                    Tr.fatal((TraceComponent)myTc, (String)SibMessage.SIB_MESSAGE, (Object[])formattedMessage);
                    break;
                }
                case INFO: {
                    Tr.info((TraceComponent)myTc, (String)SibMessage.SIB_MESSAGE, (Object[])formattedMessage);
                    break;
                }
                case WARNING: {
                    Tr.warning((TraceComponent)myTc, (String)SibMessage.SIB_MESSAGE, (Object[])formattedMessage);
                }
            }
        }
    }
}

