/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session;

import com.ibm.ws.webcontainer.httpsession.SessionMgrComponentImpl;
import com.ibm.wsspi.session.IStore;
import com.ibm.wsspi.session.ITimer;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class SessionInvalidatorWithThreadPool
implements ITimer {
    private long _delay = 0L;
    private volatile ScheduledFuture<?> _result;

    @Override
    public void start(IStore store, int interval) {
        ScheduledExecutorService scheduler = SessionMgrComponentImpl.INSTANCE.get().getScheduledExecutorService();
        InvalidationTask invalTask = new InvalidationTask(store);
        this._result = scheduler.scheduleWithFixedDelay(invalTask, this._delay * 1000L, interval * 1000, TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() {
        ScheduledFuture<?> currentResult = this._result;
        if (currentResult != null) {
            currentResult.cancel(false);
        }
    }

    public void setDelay(long invalStart) {
        this._delay = invalStart;
    }

    protected static class InvalidationTask
    implements Runnable {
        IStore _store;

        public InvalidationTask(IStore store) {
            this._store = store;
        }

        @Override
        public void run() {
            this._store.runInvalidation();
        }
    }
}

