/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.util;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.utils.ras.SibTr;

public final class ArrayUtil {
    private static TraceComponent tc = SibTr.register(ArrayUtil.class, (String)"SIBMfp", (String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    public static final int BYTE_SIZE = 1;
    public static final int SHORT_SIZE = 2;
    public static final int INT_SIZE = 4;
    public static final int LONG_SIZE = 8;

    private ArrayUtil() {
    }

    public static long readLong(byte[] b, int offset) {
        long retValue = (long)b[offset++] << 56;
        retValue |= ((long)b[offset++] & 0xFFL) << 48;
        retValue |= ((long)b[offset++] & 0xFFL) << 40;
        retValue |= ((long)b[offset++] & 0xFFL) << 32;
        retValue |= ((long)b[offset++] & 0xFFL) << 24;
        retValue |= ((long)b[offset++] & 0xFFL) << 16;
        retValue |= ((long)b[offset++] & 0xFFL) << 8;
        return retValue |= (long)b[offset] & 0xFFL;
    }

    public static void writeLong(byte[] b, int offset, long value) {
        b[offset++] = (byte)(value >>> 56);
        b[offset++] = (byte)(value >>> 48);
        b[offset++] = (byte)(value >>> 40);
        b[offset++] = (byte)(value >>> 32);
        b[offset++] = (byte)(value >>> 24);
        b[offset++] = (byte)(value >>> 16);
        b[offset++] = (byte)(value >>> 8);
        b[offset] = (byte)value;
    }

    public static int readInt(byte[] b, int offset) {
        int retValue = b[offset++] << 24;
        retValue |= (b[offset++] & 0xFF) << 16;
        retValue |= (b[offset++] & 0xFF) << 8;
        return retValue |= b[offset] & 0xFF;
    }

    public static void writeInt(byte[] b, int offset, int value) {
        b[offset++] = (byte)(value >>> 24);
        b[offset++] = (byte)(value >>> 16);
        b[offset++] = (byte)(value >>> 8);
        b[offset] = (byte)value;
    }

    public static short readShort(byte[] b, int offset) {
        int retValue = b[offset++] << 8;
        return (short)(retValue |= b[offset] & 0xFF);
    }

    public static void writeShort(byte[] b, int offset, short value) {
        b[offset++] = (byte)(value >>> 8);
        b[offset] = (byte)value;
    }

    public static byte[] readBytes(byte[] b, int offset, int length) {
        byte[] retValue = new byte[length];
        System.arraycopy(b, offset, retValue, 0, length);
        return retValue;
    }

    public static void writeBytes(byte[] b, int offset, byte[] value) {
        System.arraycopy(value, 0, b, offset, value.length);
    }
}

