/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.mfp.JmsBodyType;
import com.ibm.ws.sib.mfp.JsJmsBytesMessage;
import com.ibm.ws.sib.mfp.MessageDecodeFailedException;
import com.ibm.ws.sib.mfp.impl.JsJmsMessageImpl;
import com.ibm.ws.sib.mfp.impl.JsMsgObject;
import com.ibm.ws.sib.mfp.impl.JsMsgPart;
import com.ibm.ws.sib.mfp.schema.JmsBytesBodyAccess;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.ref.SoftReference;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

final class JsJmsBytesMessageImpl
extends JsJmsMessageImpl
implements JsJmsBytesMessage {
    private static final long serialVersionUID = 1L;
    private static final byte[] flattenedClassName;
    private static TraceComponent tc;
    private transient SoftReference<Document> softRefToDocument = null;

    JsJmsBytesMessageImpl() {
    }

    JsJmsBytesMessageImpl(int flag) throws MessageDecodeFailedException {
        super(flag);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"<init>");
        }
        this.setFormat("JMS:bytes");
        this.setBodyType(JmsBodyType.BYTES);
        if (flag != 2) {
            this.jmo.getPayloadPart().setPart(1, JmsBytesBodyAccess.schema);
            this.clearBody();
        }
    }

    JsJmsBytesMessageImpl(JsMsgObject inJmo) {
        super(inJmo);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"<init>, inbound jmo ");
        }
    }

    @Override
    public byte[] getBytes() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getBytes");
        }
        byte[] payload = (byte[])this.getPayload().getField(0);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            if (payload == null) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"getBytes", null);
            } else {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"getBytes", (Object)new Object[]{payload, payload.length});
            }
        }
        return payload;
    }

    @Override
    public void setBytes(byte[] payload) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            if (payload == null) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"setBytes", null);
            } else {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"setBytes", (Object)new Object[]{payload, payload.length});
            }
        }
        this.softRefToDocument = null;
        this.clearCachedLengths();
        this.getPayload().setField(0, payload);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setBytes");
        }
    }

    @Override
    public void clearBody() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"clearBody");
        }
        this.softRefToDocument = null;
        this.clearCachedLengths();
        this.getPayload().setChoiceField(1, 0);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"clearBody");
        }
    }

    @Override
    int guessPayloadLength() {
        int length = 0;
        byte[] payload = (byte[])this.getPayload().getField(0);
        if (payload != null) {
            length = payload.length + 24;
        }
        return length;
    }

    @Override
    int guessFluffedDataSize() {
        int payloadSize;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"guessFluffedDataSize");
        }
        int total = 0;
        JsMsgPart part = this.getPayloadIfFluffed();
        total = part != null ? (total += part.estimateFieldValueSize(0)) : ((payloadSize = this.jmo.getPayloadPart().getAssembledLengthIfKnown()) != -1 ? (total += payloadSize - 40 + FLUFFED_OBJECT_OVERHEAD) : (total += this.getPayload().estimateFieldValueSize(0)));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"guessFluffedDataSize", (Object)total);
        }
        return total;
    }

    JsMsgPart getPayload() {
        return this.getPayload(JmsBytesBodyAccess.schema);
    }

    @Override
    final byte[] getFlattenedClassName() {
        return flattenedClassName;
    }

    @Override
    final Document getPayloadDocument() throws ParserConfigurationException, IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getPayloadDocument");
        }
        Document domDoc = null;
        if (this.softRefToDocument != null) {
            domDoc = this.softRefToDocument.get();
        }
        if (domDoc == null) {
            byte[] bytes = this.getBytes();
            if (bytes != null && bytes.length > 0) {
                DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
                domFactory.setNamespaceAware(true);
                DocumentBuilder builder = domFactory.newDocumentBuilder();
                ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                try {
                    domDoc = builder.parse(is);
                    this.softRefToDocument = new SoftReference<Document>(domDoc);
                }
                catch (SAXException e) {
                    domDoc = null;
                }
            } else {
                domDoc = null;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getPayloadDocument", (Object)domDoc);
        }
        return domDoc;
    }

    static {
        tc = SibTr.register(JsJmsBytesMessageImpl.class, (String)"SIBMfp", (String)"com.ibm.ws.sib.mfp.CWSIFMessages");
        flattenedClassName = JsJmsBytesMessageImpl.flattenClassName(JsJmsBytesMessageImpl.class.getName());
    }
}

