/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.IORInfo;
import org.omg.PortableInterceptor.IORInterceptor;

public class RMIInterceptor
extends LocalObject
implements IORInterceptor {
    static final Logger logger = Logger.getLogger(RMIInterceptor.class.getName());
    private Codec codec;
    static ThreadLocal currentCodeBase = new ThreadLocal();

    public RMIInterceptor(Codec codec) {
        this.codec = codec;
    }

    static void setCurrent(String codeBase) {
        currentCodeBase.set(codeBase);
    }

    public void establish_components(IORInfo info) {
        String codeBase = (String)currentCodeBase.get();
        if (codeBase != null) {
            logger.finer("registering " + codeBase + " for ORB");
            Any any = ORB.init().create_any();
            any.insert_string(codeBase);
            try {
                byte[] data = this.codec.encode(any);
                TaggedComponent component = new TaggedComponent(25, data);
                info.add_ior_component(component);
            }
            catch (InvalidTypeForEncoding e) {
                logger.log(Level.WARNING, "Failed to add java codebase to IOR" + e.getMessage(), e);
            }
        }
    }

    public String name() {
        return "RMI IOR Interceptor";
    }

    public void destroy() {
    }
}

