/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class StAXUtils {
    private static final TraceComponent tc = Tr.register(StAXUtils.class, null, null);
    public static final String IBM_XLXP2_XML_OUTPUT_FACTORY = "com.ibm.xml.xlxp2.api.stax.XMLOutputFactoryImpl";
    public static final String IBM_XLXP2_XML_INPUT_FACTORY = "com.ibm.xml.xlxp2.api.wssec.WSSXMLInputFactory";
    public static final String IBM_XLXP2_XML_EVENT_FACTORY = "com.ibm.xml.xlxp2.api.stax.XMLEventFactoryImpl";
    static final long serialVersionUID = -1540081915831785081L;

    @FFDCIgnore(value={ClassNotFoundException.class})
    public static ClassLoader getStAXProviderClassLoader() {
        try {
            Class.forName(IBM_XLXP2_XML_OUTPUT_FACTORY);
            Class.forName(IBM_XLXP2_XML_INPUT_FACTORY);
            Class<?> eventFactoryClass = Class.forName(IBM_XLXP2_XML_EVENT_FACTORY);
            return eventFactoryClass.getClassLoader();
        }
        catch (ClassNotFoundException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unable to load IBM STAX XLXP2 Provider " + e.getMessage() + ", StAX from JRE is used"), (Object[])new Object[0]);
            }
            return ClassLoader.getSystemClassLoader();
        }
    }
}

