/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions.factories;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import org.eclipse.persistence.config.SessionCustomizer;
import org.eclipse.persistence.eis.EISConnectionSpec;
import org.eclipse.persistence.eis.EISLogin;
import org.eclipse.persistence.exceptions.ExceptionHandler;
import org.eclipse.persistence.exceptions.SessionLoaderException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetConstructorFor;
import org.eclipse.persistence.internal.security.PrivilegedInvokeConstructor;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.internal.sessions.factories.model.SessionConfigs;
import org.eclipse.persistence.internal.sessions.factories.model.event.SessionEventManagerConfig;
import org.eclipse.persistence.internal.sessions.factories.model.log.DefaultSessionLogConfig;
import org.eclipse.persistence.internal.sessions.factories.model.log.JavaLogConfig;
import org.eclipse.persistence.internal.sessions.factories.model.log.LogConfig;
import org.eclipse.persistence.internal.sessions.factories.model.log.ServerLogConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.DatabaseLoginConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.EISLoginConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.LoginConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.StructConverterConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.XMLLoginConfig;
import org.eclipse.persistence.internal.sessions.factories.model.platform.CustomServerPlatformConfig;
import org.eclipse.persistence.internal.sessions.factories.model.platform.ServerPlatformConfig;
import org.eclipse.persistence.internal.sessions.factories.model.pool.ConnectionPolicyConfig;
import org.eclipse.persistence.internal.sessions.factories.model.pool.ConnectionPoolConfig;
import org.eclipse.persistence.internal.sessions.factories.model.pool.PoolsConfig;
import org.eclipse.persistence.internal.sessions.factories.model.pool.ReadConnectionPoolConfig;
import org.eclipse.persistence.internal.sessions.factories.model.pool.WriteConnectionPoolConfig;
import org.eclipse.persistence.internal.sessions.factories.model.project.ProjectConfig;
import org.eclipse.persistence.internal.sessions.factories.model.property.PropertyConfig;
import org.eclipse.persistence.internal.sessions.factories.model.rcm.RemoteCommandManagerConfig;
import org.eclipse.persistence.internal.sessions.factories.model.rcm.command.CommandsConfig;
import org.eclipse.persistence.internal.sessions.factories.model.sequencing.DefaultSequenceConfig;
import org.eclipse.persistence.internal.sessions.factories.model.sequencing.NativeSequenceConfig;
import org.eclipse.persistence.internal.sessions.factories.model.sequencing.SequenceConfig;
import org.eclipse.persistence.internal.sessions.factories.model.sequencing.TableSequenceConfig;
import org.eclipse.persistence.internal.sessions.factories.model.sequencing.UnaryTableSequenceConfig;
import org.eclipse.persistence.internal.sessions.factories.model.sequencing.XMLFileSequenceConfig;
import org.eclipse.persistence.internal.sessions.factories.model.session.DatabaseSessionConfig;
import org.eclipse.persistence.internal.sessions.factories.model.session.ServerSessionConfig;
import org.eclipse.persistence.internal.sessions.factories.model.session.SessionBrokerConfig;
import org.eclipse.persistence.internal.sessions.factories.model.session.SessionConfig;
import org.eclipse.persistence.internal.sessions.factories.model.transport.JMSPublishingTransportManagerConfig;
import org.eclipse.persistence.internal.sessions.factories.model.transport.JMSTopicTransportManagerConfig;
import org.eclipse.persistence.internal.sessions.factories.model.transport.Oc4jJGroupsTransportManagerConfig;
import org.eclipse.persistence.internal.sessions.factories.model.transport.RMIIIOPTransportManagerConfig;
import org.eclipse.persistence.internal.sessions.factories.model.transport.RMITransportManagerConfig;
import org.eclipse.persistence.internal.sessions.factories.model.transport.SunCORBATransportManagerConfig;
import org.eclipse.persistence.internal.sessions.factories.model.transport.TransportManagerConfig;
import org.eclipse.persistence.internal.sessions.factories.model.transport.UserDefinedTransportManagerConfig;
import org.eclipse.persistence.internal.sessions.factories.model.transport.discovery.DiscoveryConfig;
import org.eclipse.persistence.internal.sessions.factories.model.transport.naming.JNDINamingServiceConfig;
import org.eclipse.persistence.internal.sessions.factories.model.transport.naming.RMIRegistryNamingServiceConfig;
import org.eclipse.persistence.logging.DefaultSessionLog;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.oxm.XMLLogin;
import org.eclipse.persistence.platform.database.converters.StructConverter;
import org.eclipse.persistence.platform.server.NoServerPlatform;
import org.eclipse.persistence.platform.server.ServerPlatform;
import org.eclipse.persistence.platform.server.ServerPlatformUtils;
import org.eclipse.persistence.sequencing.DefaultSequence;
import org.eclipse.persistence.sequencing.NativeSequence;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sequencing.TableSequence;
import org.eclipse.persistence.sequencing.UnaryTableSequence;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.DatasourceLogin;
import org.eclipse.persistence.sessions.JNDIConnector;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.sessions.broker.SessionBroker;
import org.eclipse.persistence.sessions.coordination.DiscoveryManager;
import org.eclipse.persistence.sessions.coordination.RemoteCommandManager;
import org.eclipse.persistence.sessions.coordination.TransportManager;
import org.eclipse.persistence.sessions.coordination.corba.sun.SunCORBATransportManager;
import org.eclipse.persistence.sessions.coordination.jms.JMSPublishingTransportManager;
import org.eclipse.persistence.sessions.coordination.jms.JMSTopicTransportManager;
import org.eclipse.persistence.sessions.coordination.rmi.RMITransportManager;
import org.eclipse.persistence.sessions.factories.XMLProjectReader;
import org.eclipse.persistence.sessions.server.ConnectionPolicy;
import org.eclipse.persistence.sessions.server.ConnectionPool;
import org.eclipse.persistence.sessions.server.ReadConnectionPool;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.tools.profiler.PerformanceProfiler;

public class SessionsFactory {
    protected Map<String, Session> m_sessions;
    protected Map<String, Integer> m_logLevels = new HashMap<String, Integer>();
    protected ClassLoader m_classLoader;

    public SessionsFactory() {
        this.m_logLevels.put("off", 8);
        this.m_logLevels.put("severe", 7);
        this.m_logLevels.put("warning", 6);
        this.m_logLevels.put("info", 5);
        this.m_logLevels.put("config", 4);
        this.m_logLevels.put("fine", 3);
        this.m_logLevels.put("finer", 2);
        this.m_logLevels.put("finest", 1);
        this.m_logLevels.put("all", 0);
    }

    public Map<String, Session> buildSessionConfigs(SessionConfigs eclipseLinkSessions, ClassLoader classLoader) {
        this.m_sessions = new HashMap<String, Session>();
        this.m_classLoader = classLoader;
        ArrayList<SessionBrokerConfig> sessionBrokerConfigs = new ArrayList<SessionBrokerConfig>();
        Enumeration<SessionConfig> e = eclipseLinkSessions.getSessionConfigs().elements();
        while (e.hasMoreElements()) {
            SessionConfig sessionConfig = e.nextElement();
            if (sessionConfig instanceof SessionBrokerConfig) {
                sessionBrokerConfigs.add((SessionBrokerConfig)sessionConfig);
                continue;
            }
            AbstractSession session = this.buildSession(sessionConfig);
            session.getDatasourcePlatform().getConversionManager().setLoader(classLoader);
            this.processSessionCustomizer(sessionConfig, session);
            this.m_sessions.put(session.getName(), session);
        }
        for (SessionBrokerConfig sessionBrokerConfig : sessionBrokerConfigs) {
            SessionBroker sessionBroker = this.buildSessionBrokerConfig(sessionBrokerConfig);
            sessionBroker.getDatasourcePlatform().getConversionManager().setLoader(classLoader);
            this.processSessionCustomizer(sessionBrokerConfig, sessionBroker);
            this.m_sessions.put(sessionBroker.getName(), sessionBroker);
        }
        return this.m_sessions;
    }

    protected void processSessionCustomizer(SessionConfig sessionConfig, AbstractSession session) {
        String sessionCustomizerClassName = sessionConfig.getSessionCustomizerClass();
        if (sessionCustomizerClassName != null) {
            try {
                Class<?> sessionCustomizerClass = this.m_classLoader.loadClass(sessionCustomizerClassName);
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    ((SessionCustomizer)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(sessionCustomizerClass))).customize(session);
                } else {
                    ((SessionCustomizer)PrivilegedAccessHelper.newInstanceFromClass(sessionCustomizerClass)).customize(session);
                }
            }
            catch (Exception exception) {
                throw SessionLoaderException.failedToLoadTag("session-customizer-class", sessionCustomizerClassName, exception);
            }
        }
    }

    protected AbstractSession buildSession(SessionConfig sessionConfig) {
        if (sessionConfig instanceof ServerSessionConfig) {
            return this.buildServerSessionConfig((ServerSessionConfig)sessionConfig);
        }
        return this.buildDatabaseSessionConfig((DatabaseSessionConfig)sessionConfig);
    }

    protected AbstractSession buildDatabaseSessionConfig(DatabaseSessionConfig databaseSessionConfig) {
        DatabaseSessionImpl databaseSession = this.createSession(databaseSessionConfig, null);
        Login login = this.buildLogin(databaseSessionConfig.getLoginConfig());
        if (login != null) {
            databaseSession.setLogin(login);
        }
        this.processDatabaseSessionConfig(databaseSessionConfig, databaseSession);
        this.processSessionConfig(databaseSessionConfig, databaseSession);
        return databaseSession;
    }

    protected void processDatabaseSessionConfig(DatabaseSessionConfig sessionConfig, AbstractSession session) {
    }

    protected AbstractSession buildServerSessionConfig(ServerSessionConfig serverSessionConfig) {
        Login login = this.buildLogin(serverSessionConfig.getLoginConfig());
        ServerSession serverSession = (ServerSession)this.createSession(serverSessionConfig, login);
        this.processDatabaseSessionConfig(serverSessionConfig, serverSession);
        this.processPoolsConfig(serverSessionConfig.getPoolsConfig(), serverSession);
        this.processConnectionPolicyConfig(serverSessionConfig.getConnectionPolicyConfig(), serverSession);
        this.processSessionConfig(serverSessionConfig, serverSession);
        return serverSession;
    }

    protected DatabaseSessionImpl createSession(DatabaseSessionConfig sessionConfig, Login login) {
        Project primaryProject = sessionConfig.getPrimaryProject() != null ? this.loadProjectConfig(sessionConfig.getPrimaryProject()) : new Project();
        this.prepareProjectLogin(primaryProject, login);
        DatabaseSessionImpl sessionToReturn = this.getSession(sessionConfig, primaryProject);
        if (sessionConfig.getAdditionalProjects() != null) {
            Enumeration<ProjectConfig> additionalProjects = sessionConfig.getAdditionalProjects().elements();
            while (additionalProjects.hasMoreElements()) {
                Project subProject = this.loadProjectConfig(additionalProjects.nextElement());
                primaryProject.addDescriptors(subProject, sessionToReturn);
            }
        }
        return sessionToReturn;
    }

    protected void prepareProjectLogin(Project project, Login login) {
        if (login != null) {
            project.setLogin(login);
        } else if (project.getDatasourceLogin() == null) {
            project.setLogin(new DatabaseLogin());
        }
    }

    protected DatabaseSessionImpl getSession(SessionConfig sessionConfig, Project project) {
        if (sessionConfig instanceof ServerSessionConfig) {
            return (ServerSession)project.createServerSession();
        }
        return (DatabaseSessionImpl)project.createDatabaseSession();
    }

    protected Project loadProjectConfig(ProjectConfig projectConfig) {
        Project project = null;
        String projectString = projectConfig.getProjectString().trim();
        if (projectConfig.isProjectClassConfig()) {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    project = (Project)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(this.m_classLoader.loadClass(projectString)));
                }
                project = (Project)PrivilegedAccessHelper.newInstanceFromClass(this.m_classLoader.loadClass(projectString));
            }
            catch (Exception exception) {
                throw SessionLoaderException.failedToLoadProjectClass(projectString, exception);
            }
        } else {
            try {
                project = XMLProjectReader.read(projectString, this.m_classLoader);
            }
            catch (ValidationException validationException) {
                if (validationException.getErrorCode() == 7099) {
                    try {
                        project = XMLProjectReader.read(projectString);
                    }
                    catch (Exception exception) {
                        throw SessionLoaderException.failedToLoadProjectXml(projectString, validationException);
                    }
                }
                throw SessionLoaderException.failedToLoadProjectXml(projectString, validationException);
            }
        }
        return project;
    }

    protected Login buildLogin(LoginConfig loginConfig) {
        if (loginConfig instanceof EISLoginConfig) {
            return this.buildEISLoginConfig((EISLoginConfig)loginConfig);
        }
        if (loginConfig instanceof XMLLoginConfig) {
            return this.buildXMLLoginConfig((XMLLoginConfig)loginConfig);
        }
        if (loginConfig instanceof DatabaseLoginConfig) {
            return this.buildDatabaseLoginConfig((DatabaseLoginConfig)loginConfig);
        }
        return null;
    }

    protected Login buildEISLoginConfig(EISLoginConfig eisLoginConfig) {
        EISLogin eisLogin = new EISLogin();
        String specClassName = eisLoginConfig.getConnectionSpecClass();
        if (specClassName != null) {
            try {
                Class<?> specClass = this.m_classLoader.loadClass(specClassName);
                EISConnectionSpec spec = null;
                spec = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? (EISConnectionSpec)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(specClass)) : (EISConnectionSpec)PrivilegedAccessHelper.newInstanceFromClass(specClass);
                eisLogin.setConnectionSpec(spec);
            }
            catch (Exception exception) {
                throw SessionLoaderException.failedToLoadTag("connection-spec-class", specClassName, exception);
            }
        }
        eisLogin.setConnectionFactoryURL(eisLoginConfig.getConnectionFactoryURL());
        this.processLoginConfig(eisLoginConfig, eisLogin);
        return eisLogin;
    }

    protected Login buildXMLLoginConfig(XMLLoginConfig xmlLoginConfig) {
        XMLLogin xmlLogin = new XMLLogin();
        this.processLoginConfig(xmlLoginConfig, xmlLogin);
        return xmlLogin;
    }

    protected Login buildDatabaseLoginConfig(DatabaseLoginConfig databaseLoginConfig) {
        String datasourceName;
        String connectionString;
        DatabaseLogin databaseLogin = new DatabaseLogin();
        String driverClassName = databaseLoginConfig.getDriverClass();
        if (driverClassName != null) {
            try {
                Class<?> driverClass = this.m_classLoader.loadClass(driverClassName);
                databaseLogin.setDriverClass(driverClass);
            }
            catch (Exception exception) {
                throw SessionLoaderException.failedToLoadTag("driver-class", driverClassName, exception);
            }
        }
        if ((connectionString = databaseLoginConfig.getConnectionURL()) != null) {
            databaseLogin.setConnectionString(connectionString);
        }
        if ((datasourceName = databaseLoginConfig.getDatasource()) != null) {
            try {
                JNDIConnector jndiConnector = new JNDIConnector(new InitialContext(), datasourceName);
                jndiConnector.setLookupType(databaseLoginConfig.getLookupType());
                databaseLogin.setConnector(jndiConnector);
            }
            catch (Exception exception) {
                throw SessionLoaderException.failedToLoadTag("datasource", datasourceName, exception);
            }
        }
        databaseLogin.setShouldBindAllParameters(databaseLoginConfig.getBindAllParameters());
        databaseLogin.setShouldCacheAllStatements(databaseLoginConfig.getCacheAllStatements());
        databaseLogin.setUsesByteArrayBinding(databaseLoginConfig.getByteArrayBinding());
        databaseLogin.setUsesStringBinding(databaseLoginConfig.getStringBinding());
        databaseLogin.setUsesStreamsForBinding(databaseLoginConfig.getStreamsForBinding());
        databaseLogin.setShouldForceFieldNamesToUpperCase(databaseLoginConfig.getForceFieldNamesToUppercase());
        databaseLogin.setShouldOptimizeDataConversion(databaseLoginConfig.getOptimizeDataConversion());
        databaseLogin.setShouldTrimStrings(databaseLoginConfig.getTrimStrings());
        databaseLogin.setUsesBatchWriting(databaseLoginConfig.getBatchWriting());
        databaseLogin.setUsesJDBCBatchWriting(databaseLoginConfig.getJdbcBatchWriting());
        Integer maxBatchWritingSize = databaseLoginConfig.getMaxBatchWritingSize();
        if (maxBatchWritingSize != null) {
            databaseLogin.setMaxBatchWritingSize(maxBatchWritingSize);
        }
        databaseLogin.setUsesNativeSQL(databaseLoginConfig.getNativeSQL());
        this.processLoginConfig(databaseLoginConfig, databaseLogin);
        this.processStructConverterConfig(databaseLoginConfig.getStructConverterConfig(), databaseLogin);
        if (databaseLoginConfig.isConnectionHealthValidatedOnError() != null) {
            databaseLogin.setConnectionHealthValidatedOnError(databaseLoginConfig.isConnectionHealthValidatedOnError());
        }
        if (databaseLoginConfig.getQueryRetryAttemptCount() != null) {
            databaseLogin.setQueryRetryAttemptCount(databaseLoginConfig.getQueryRetryAttemptCount());
        }
        if (databaseLoginConfig.getDelayBetweenConnectionAttempts() != null) {
            databaseLogin.setDelayBetweenConnectionAttempts(databaseLoginConfig.getDelayBetweenConnectionAttempts());
        }
        if (databaseLoginConfig.getPingSQL() != null) {
            databaseLogin.setPingSQL(databaseLoginConfig.getPingSQL());
        }
        return databaseLogin;
    }

    protected void processStructConverterConfig(StructConverterConfig converterClassConfig, DatabaseLogin login) {
        Platform platform;
        if (converterClassConfig != null && (platform = login.getDatasourcePlatform()) instanceof DatabasePlatform) {
            for (String converterClassName : converterClassConfig.getStructConverterClasses()) {
                try {
                    Class<?> converterClass = this.m_classLoader.loadClass(converterClassName);
                    StructConverter converter = null;
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            converter = (StructConverter)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(converterClass));
                        }
                        catch (PrivilegedActionException ex) {
                            throw (Exception)ex.getCause();
                        }
                    } else {
                        converter = (StructConverter)PrivilegedAccessHelper.newInstanceFromClass(converterClass);
                    }
                    ((DatabasePlatform)platform).addStructConverter(converter);
                }
                catch (Exception exception) {
                    throw SessionLoaderException.failedToLoadTag("struct-converter", converterClassName, exception);
                }
            }
        }
    }

    protected void processLoginConfig(LoginConfig loginConfig, DatasourceLogin login) {
        String tableQualifier;
        String platformClassName = loginConfig.getPlatformClass();
        if (platformClassName != null) {
            try {
                Class<?> platformClass = this.m_classLoader.loadClass(platformClassName);
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    login.usePlatform((DatasourcePlatform)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(platformClass)));
                } else {
                    login.usePlatform((DatasourcePlatform)PrivilegedAccessHelper.newInstanceFromClass(platformClass));
                }
            }
            catch (Exception exception) {
                throw SessionLoaderException.failedToLoadTag("platform-class", platformClassName, exception);
            }
        }
        if ((tableQualifier = loginConfig.getTableQualifier()) != null) {
            login.setTableQualifier(tableQualifier);
        }
        login.setUserName(loginConfig.getUsername());
        login.setEncryptionClassName(loginConfig.getEncryptionClass());
        login.setEncryptedPassword(loginConfig.getEncryptedPassword());
        login.setUsesExternalConnectionPooling(loginConfig.getExternalConnectionPooling());
        login.setUsesExternalTransactionController(loginConfig.getExternalTransactionController());
        if (loginConfig.getSequencingConfig() != null) {
            if (loginConfig.getSequencingConfig().getDefaultSequenceConfig() != null) {
                Sequence sequence = this.buildSequence(loginConfig.getSequencingConfig().getDefaultSequenceConfig());
                login.setDefaultSequence(sequence);
            }
            if (loginConfig.getSequencingConfig().getSequenceConfigs() != null && !loginConfig.getSequencingConfig().getSequenceConfigs().isEmpty()) {
                Enumeration eSequenceConfigs = loginConfig.getSequencingConfig().getSequenceConfigs().elements();
                while (eSequenceConfigs.hasMoreElements()) {
                    Sequence sequence = this.buildSequence((SequenceConfig)eSequenceConfigs.nextElement());
                    login.addSequence(sequence);
                }
            }
        }
        if (loginConfig.getPropertyConfigs() != null) {
            Enumeration e = loginConfig.getPropertyConfigs().elements();
            while (e.hasMoreElements()) {
                PropertyConfig propertyConfig = (PropertyConfig)e.nextElement();
                login.getProperties().put(propertyConfig.getName(), propertyConfig.getValue());
            }
        }
    }

    protected void processPoolsConfig(PoolsConfig poolsConfig, ServerSession serverSession) {
        if (poolsConfig != null) {
            ConnectionPoolConfig sequenceConnectionPoolConfig;
            WriteConnectionPoolConfig writeConnectionPoolConfig;
            ReadConnectionPoolConfig readConnectionPoolConfig = poolsConfig.getReadConnectionPoolConfig();
            if (readConnectionPoolConfig != null) {
                serverSession.setReadConnectionPool(this.buildReadConnectionPoolConfig(readConnectionPoolConfig, serverSession));
            }
            if ((writeConnectionPoolConfig = poolsConfig.getWriteConnectionPoolConfig()) != null) {
                serverSession.addConnectionPool(this.buildConnectionPoolConfig(writeConnectionPoolConfig, serverSession));
            }
            if ((sequenceConnectionPoolConfig = poolsConfig.getSequenceConnectionPoolConfig()) != null) {
                this.processSequenceConnectionPoolConfig(sequenceConnectionPoolConfig, serverSession);
            }
            Enumeration e = poolsConfig.getConnectionPoolConfigs().elements();
            while (e.hasMoreElements()) {
                ConnectionPoolConfig connectionPoolConfig = (ConnectionPoolConfig)e.nextElement();
                serverSession.addConnectionPool(this.buildConnectionPoolConfig(connectionPoolConfig, serverSession));
            }
        }
    }

    protected void processSequenceConnectionPoolConfig(ConnectionPoolConfig poolConfig, ServerSession serverSession) {
        Integer minConnections;
        serverSession.getSequencingControl().setShouldUseSeparateConnection(true);
        Integer maxConnections = poolConfig.getMaxConnections();
        if (maxConnections != null) {
            serverSession.getSequencingControl().setMaxPoolSize(maxConnections);
        }
        if ((minConnections = poolConfig.getMinConnections()) != null) {
            serverSession.getSequencingControl().setMinPoolSize(minConnections);
        }
    }

    protected void processServerPlatformConfig(ServerPlatformConfig platformConfig, ServerPlatform platform) {
        if (!platformConfig.getEnableRuntimeServices()) {
            platform.disableRuntimeServices();
        }
        if (!platformConfig.getEnableJTA()) {
            platform.disableJTA();
        }
    }

    protected ConnectionPool buildConnectionPoolConfig(ConnectionPoolConfig poolConfig, ServerSession serverSession) {
        ConnectionPool connectionPool = new ConnectionPool();
        this.processConnectionPoolConfig(poolConfig, connectionPool, serverSession);
        return connectionPool;
    }

    protected ServerPlatform buildCustomServerPlatformConfig(CustomServerPlatformConfig platformConfig, DatabaseSessionImpl session) {
        ServerPlatform platform;
        String serverClassName = platformConfig.getServerClassName();
        try {
            Constructor constructor;
            Class<?> serverClass = this.m_classLoader.loadClass(serverClassName);
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                constructor = (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(serverClass, new Class[]{DatabaseSession.class}, false));
                platform = (ServerPlatform)AccessController.doPrivileged(new PrivilegedInvokeConstructor(constructor, new Object[]{session}));
            } else {
                constructor = PrivilegedAccessHelper.getConstructorFor(serverClass, new Class[]{DatabaseSession.class}, false);
                platform = (ServerPlatform)PrivilegedAccessHelper.invokeConstructor(constructor, new Object[]{session});
            }
        }
        catch (Exception e) {
            throw SessionLoaderException.failedToLoadTag("server-class", serverClassName, e);
        }
        String externalTransactionControllerClass = platformConfig.getExternalTransactionControllerClass();
        if (externalTransactionControllerClass != null) {
            try {
                platform.setExternalTransactionControllerClass(this.m_classLoader.loadClass(externalTransactionControllerClass));
            }
            catch (Exception exception) {
                throw SessionLoaderException.failedToLoadTag("external-transaction-controller-class", externalTransactionControllerClass, exception);
            }
        }
        return platform;
    }

    protected ConnectionPool buildReadConnectionPoolConfig(ReadConnectionPoolConfig poolConfig, ServerSession serverSession) {
        ConnectionPool connectionPool = poolConfig.getExclusive() ? new ConnectionPool() : new ReadConnectionPool();
        this.processConnectionPoolConfig(poolConfig, connectionPool, serverSession);
        return connectionPool;
    }

    protected void processConnectionPolicyConfig(ConnectionPolicyConfig connectionPolicyConfig, ServerSession serverSession) {
        if (connectionPolicyConfig != null) {
            ConnectionPolicy connectionPolicy = serverSession.getDefaultConnectionPolicy();
            if (connectionPolicyConfig.getUseExclusiveConnection()) {
                connectionPolicy.setExclusiveMode(ConnectionPolicy.ExclusiveMode.Isolated);
            } else {
                connectionPolicy.setExclusiveMode(ConnectionPolicy.ExclusiveMode.Transactional);
            }
            connectionPolicy.setIsLazy(connectionPolicyConfig.getLazy());
        }
    }

    protected void processConnectionPoolConfig(ConnectionPoolConfig poolConfig, ConnectionPool connectionPool, AbstractSession session) {
        Integer minConnections;
        Login login = this.buildLogin(poolConfig.getLoginConfig());
        if (login != null) {
            connectionPool.setLogin(login);
        } else {
            connectionPool.setLogin(session.getDatasourceLogin());
        }
        connectionPool.setName(poolConfig.getName());
        Integer maxConnections = poolConfig.getMaxConnections();
        if (maxConnections != null) {
            connectionPool.setMaxNumberOfConnections(maxConnections);
        }
        if ((minConnections = poolConfig.getMinConnections()) != null) {
            connectionPool.setMinNumberOfConnections(minConnections);
        }
    }

    protected void processSessionConfig(SessionConfig sessionConfig, AbstractSession session) {
        String exceptionHandlerClassName;
        session.setName(sessionConfig.getName().trim());
        this.processSessionEventManagerConfig(sessionConfig.getSessionEventManagerConfig(), session);
        ((DatabaseSessionImpl)session).setServerPlatform(this.buildServerPlatformConfig(sessionConfig.getServerPlatformConfig(), (DatabaseSessionImpl)session));
        SessionLog log = this.buildSessionLog(sessionConfig.getLogConfig(), session);
        if (log != null) {
            session.setSessionLog(log);
        }
        this.buildRemoteCommandManagerConfig(sessionConfig.getRemoteCommandManagerConfig(), session);
        if (sessionConfig.getProfiler() != null && sessionConfig.getProfiler().equals("eclipselink")) {
            session.setProfiler(new PerformanceProfiler());
        }
        if ((exceptionHandlerClassName = sessionConfig.getExceptionHandlerClass()) != null) {
            try {
                Class<?> exceptionHandlerClass = this.m_classLoader.loadClass(exceptionHandlerClassName);
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    session.setExceptionHandler((ExceptionHandler)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(exceptionHandlerClass)));
                } else {
                    session.setExceptionHandler((ExceptionHandler)PrivilegedAccessHelper.newInstanceFromClass(exceptionHandlerClass));
                }
            }
            catch (Exception e) {
                throw SessionLoaderException.failedToLoadTag("exception-handler-class", exceptionHandlerClassName, e);
            }
        }
    }

    protected ServerPlatform buildServerPlatformConfig(ServerPlatformConfig platformConfig, DatabaseSessionImpl session) {
        ServerPlatform platform;
        if (platformConfig == null) {
            return new NoServerPlatform(session);
        }
        if (platformConfig instanceof CustomServerPlatformConfig) {
            platform = this.buildCustomServerPlatformConfig((CustomServerPlatformConfig)platformConfig, session);
        } else {
            String serverClassName = platformConfig.getServerClassName();
            if (platformConfig.isSupported()) {
                platform = ServerPlatformUtils.createServerPlatform(session, serverClassName, this.m_classLoader);
            } else {
                throw SessionLoaderException.serverPlatformNoLongerSupported(serverClassName);
            }
        }
        this.processServerPlatformConfig(platformConfig, platform);
        return platform;
    }

    protected void buildRemoteCommandManagerConfig(RemoteCommandManagerConfig rcmConfig, AbstractSession session) {
        if (rcmConfig != null) {
            RemoteCommandManager rcm = new RemoteCommandManager(session);
            this.processCommandsConfig(rcmConfig.getCommandsConfig(), rcm);
            this.buildTransportManager(rcmConfig.getTransportManagerConfig(), rcm);
            rcm.setChannel(rcmConfig.getChannel());
        }
    }

    protected void buildTransportManager(TransportManagerConfig tmConfig, RemoteCommandManager rcm) {
        if (tmConfig instanceof RMITransportManagerConfig) {
            this.buildRMITransportManagerConfig((RMITransportManagerConfig)tmConfig, rcm);
        } else if (tmConfig instanceof RMIIIOPTransportManagerConfig) {
            this.buildRMIIIOPTransportManagerConfig((RMIIIOPTransportManagerConfig)tmConfig, rcm);
        } else if (tmConfig instanceof JMSTopicTransportManagerConfig) {
            this.buildJMSTopicTransportManagerConfig((JMSTopicTransportManagerConfig)tmConfig, rcm);
        } else if (tmConfig instanceof JMSPublishingTransportManagerConfig) {
            this.buildJMSPublishingTransportManagerConfig((JMSPublishingTransportManagerConfig)tmConfig, rcm);
        } else if (tmConfig instanceof Oc4jJGroupsTransportManagerConfig) {
            this.buildOc4jJGroupsTransportManagerConfig((Oc4jJGroupsTransportManagerConfig)tmConfig, rcm);
        } else if (tmConfig instanceof SunCORBATransportManagerConfig) {
            this.buildSunCORBATransportManagerConfig((SunCORBATransportManagerConfig)tmConfig, rcm);
        } else if (tmConfig instanceof UserDefinedTransportManagerConfig) {
            this.buildUserDefinedTransportManagerConfig((UserDefinedTransportManagerConfig)tmConfig, rcm);
        }
    }

    protected void buildRMITransportManagerConfig(RMITransportManagerConfig tmConfig, RemoteCommandManager rcm) {
        RMITransportManager tm = new RMITransportManager(rcm);
        rcm.setTransportManager(tm);
        DiscoveryConfig discoveryConfig = tmConfig.getDiscoveryConfig();
        if (discoveryConfig != null) {
            this.processDiscoveryConfig(discoveryConfig, rcm.getDiscoveryManager());
        }
        if (tmConfig.getJNDINamingServiceConfig() != null) {
            tm.setNamingServiceType(0);
            this.processJNDINamingServiceConfig(tmConfig.getJNDINamingServiceConfig(), tm);
        } else if (tmConfig.getRMIRegistryNamingServiceConfig() != null) {
            tm.setNamingServiceType(1);
            this.processRMIRegistryNamingServiceConfig(tmConfig.getRMIRegistryNamingServiceConfig(), tm);
        }
        tm.setIsRMIOverIIOP(tmConfig instanceof RMIIIOPTransportManagerConfig);
        rcm.setShouldPropagateAsynchronously(tmConfig.getSendMode().equals("Asynchronous"));
        this.processTransportManagerConfig(tmConfig, tm);
    }

    protected Sequence buildSequence(SequenceConfig sequenceConfig) {
        if (sequenceConfig == null) {
            return null;
        }
        String name = sequenceConfig.getName();
        int size = sequenceConfig.getPreallocationSize();
        if (sequenceConfig instanceof DefaultSequenceConfig) {
            return new DefaultSequence(name, size);
        }
        if (sequenceConfig instanceof NativeSequenceConfig) {
            return new NativeSequence(name, size);
        }
        if (sequenceConfig instanceof TableSequenceConfig) {
            TableSequenceConfig tsc = (TableSequenceConfig)sequenceConfig;
            return new TableSequence(name, size, tsc.getTable(), tsc.getNameField(), tsc.getCounterField());
        }
        if (sequenceConfig instanceof UnaryTableSequenceConfig) {
            UnaryTableSequenceConfig utsc = (UnaryTableSequenceConfig)sequenceConfig;
            return new UnaryTableSequence(name, size, utsc.getCounterField());
        }
        if (sequenceConfig instanceof XMLFileSequenceConfig) {
            try {
                Class<?> xmlClass = Class.forName("org.eclipse.persistence.eis.adapters.xmlfile.XMLFileSequence");
                Sequence sequence = (Sequence)xmlClass.newInstance();
                sequence.setName(name);
                sequence.setInitialValue(size);
                return sequence;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    protected void buildRMIIIOPTransportManagerConfig(RMIIIOPTransportManagerConfig tmConfig, RemoteCommandManager rcm) {
        this.buildRMITransportManagerConfig(tmConfig, rcm);
    }

    protected void buildJMSTopicTransportManagerConfig(JMSTopicTransportManagerConfig tmConfig, RemoteCommandManager rcm) {
        JMSTopicTransportManager tm = new JMSTopicTransportManager(rcm);
        rcm.setTransportManager(tm);
        this.processJMSTransportManagerConfig(tmConfig, tm);
    }

    protected void buildJMSPublishingTransportManagerConfig(JMSPublishingTransportManagerConfig tmConfig, RemoteCommandManager rcm) {
        JMSPublishingTransportManager tm = new JMSPublishingTransportManager(rcm);
        rcm.setTransportManager(tm);
        this.processJMSTransportManagerConfig(tmConfig, tm);
    }

    protected void processJMSTransportManagerConfig(JMSPublishingTransportManagerConfig tmConfig, JMSPublishingTransportManager tm) {
        String topicHostURL;
        if (tmConfig.getJNDINamingServiceConfig() != null) {
            tm.setNamingServiceType(0);
            this.processJNDINamingServiceConfig(tmConfig.getJNDINamingServiceConfig(), tm);
        }
        if ((topicHostURL = tmConfig.getTopicHostURL()) != null) {
            tm.setTopicHostUrl(topicHostURL);
        }
        tm.setTopicConnectionFactoryName(tmConfig.getTopicConnectionFactoryName());
        tm.setTopicName(tmConfig.getTopicName());
        this.processTransportManagerConfig(tmConfig, tm);
    }

    protected void buildOc4jJGroupsTransportManagerConfig(Oc4jJGroupsTransportManagerConfig tmConfig, RemoteCommandManager rcm) {
        TransportManager tm = null;
        try {
            Class<?> tmClass = this.m_classLoader.loadClass(tmConfig.getTransportManagerClassName());
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                Constructor constructor = (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(tmClass, new Class[]{RemoteCommandManager.class, Boolean.TYPE, String.class}, false));
                tm = (TransportManager)AccessController.doPrivileged(new PrivilegedInvokeConstructor(constructor, new Object[]{rcm, tmConfig.useSingleThreadedNotification(), tmConfig.getTopicName()}));
            } else {
                Constructor constructor = PrivilegedAccessHelper.getConstructorFor(tmClass, new Class[]{RemoteCommandManager.class, Boolean.TYPE, String.class}, false);
                tm = (TransportManager)PrivilegedAccessHelper.invokeConstructor(constructor, new Object[]{rcm, tmConfig.useSingleThreadedNotification(), tmConfig.getTopicName()});
            }
        }
        catch (Exception e) {
            throw SessionLoaderException.failedToParseXML("Oc4jJGroupsTransportManager class is invalid: " + tmConfig.getTransportManagerClassName(), e);
        }
        rcm.setTransportManager(tm);
        this.processTransportManagerConfig(tmConfig, tm);
    }

    protected void buildUserDefinedTransportManagerConfig(UserDefinedTransportManagerConfig tmConfig, RemoteCommandManager rcm) {
        TransportManager tm = null;
        String transportManagerClassName = tmConfig.getTransportClass();
        if (transportManagerClassName != null) {
            try {
                Class<?> transportManagerClass = this.m_classLoader.loadClass(transportManagerClassName);
                tm = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? (TransportManager)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(transportManagerClass)) : (TransportManager)PrivilegedAccessHelper.newInstanceFromClass(transportManagerClass);
            }
            catch (Exception exception) {
                throw SessionLoaderException.failedToLoadTag("transport-class", transportManagerClassName, exception);
            }
            rcm.setTransportManager(tm);
            this.processTransportManagerConfig(tmConfig, tm);
        }
    }

    protected void processJNDINamingServiceConfig(JNDINamingServiceConfig namingConfig, TransportManager tm) {
        String url = namingConfig.getURL();
        if (url != null) {
            tm.getRemoteCommandManager().setUrl(url);
        }
        tm.setUserName(namingConfig.getUsername());
        tm.setEncryptionClassName(namingConfig.getEncryptionClass());
        tm.setEncryptedPassword(namingConfig.getEncryptedPassword());
        tm.setInitialContextFactoryName(namingConfig.getInitialContextFactoryName());
        Enumeration e = namingConfig.getPropertyConfigs().elements();
        while (e.hasMoreElements()) {
            PropertyConfig propertyConfig = (PropertyConfig)e.nextElement();
            tm.getRemoteContextProperties().put(propertyConfig.getName(), propertyConfig.getValue());
        }
    }

    protected void processRMIRegistryNamingServiceConfig(RMIRegistryNamingServiceConfig namingConfig, TransportManager tm) {
        tm.getRemoteCommandManager().setUrl(namingConfig.getURL());
    }

    protected void processDiscoveryConfig(DiscoveryConfig discoveryConfig, DiscoveryManager discoveryManager) {
        discoveryManager.setMulticastGroupAddress(discoveryConfig.getMulticastGroupAddress());
        discoveryManager.setMulticastPort(discoveryConfig.getMulticastPort());
        discoveryManager.setAnnouncementDelay(discoveryConfig.getAnnouncementDelay());
        discoveryManager.setPacketTimeToLive(discoveryConfig.getPacketTimeToLive());
    }

    protected void processTransportManagerConfig(TransportManagerConfig tmConfig, TransportManager tm) {
        tm.setShouldRemoveConnectionOnError(tmConfig.getOnConnectionError().equals("DiscardConnection"));
    }

    protected void processSessionEventManagerConfig(SessionEventManagerConfig sessionEventManagerConfig, AbstractSession session) {
        if (sessionEventManagerConfig != null) {
            Enumeration e = sessionEventManagerConfig.getSessionEventListeners().elements();
            while (e.hasMoreElements()) {
                String listenerClassName = (String)e.nextElement();
                try {
                    Class<?> listenerClass = this.m_classLoader.loadClass(listenerClassName);
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        session.getEventManager().addListener((SessionEventListener)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(listenerClass)));
                    }
                    session.getEventManager().addListener((SessionEventListener)PrivilegedAccessHelper.newInstanceFromClass(listenerClass));
                }
                catch (Exception exception) {
                    throw SessionLoaderException.failedToLoadTag("event-listener-class", listenerClassName, exception);
                }
            }
        }
    }

    protected SessionLog buildSessionLog(LogConfig logConfig, AbstractSession session) {
        if (logConfig instanceof JavaLogConfig) {
            return this.buildJavaLogConfig((JavaLogConfig)logConfig, session);
        }
        if (logConfig instanceof DefaultSessionLogConfig) {
            return this.buildDefaultSessionLogConfig((DefaultSessionLogConfig)logConfig);
        }
        if (logConfig instanceof ServerLogConfig) {
            return this.buildServerLogConfig((ServerLogConfig)logConfig, session);
        }
        return null;
    }

    protected SessionLog buildJavaLogConfig(JavaLogConfig javaLogConfig, AbstractSession session) {
        SessionLog javaLog = null;
        try {
            ConversionManager conversionManager = new ConversionManager();
            conversionManager.setLoader(this.getClass().getClassLoader());
            javaLog = (SessionLog)((Class)conversionManager.convertObject("org.eclipse.persistence.logging.JavaLog", Class.class)).newInstance();
            javaLog.setSession(session);
        }
        catch (Exception exception) {
            throw ValidationException.unableToLoadClass("org.eclipse.persistence.logging.JavaLog", exception);
        }
        this.processLogConfig(javaLogConfig, javaLog);
        return javaLog;
    }

    protected SessionLog buildDefaultSessionLogConfig(DefaultSessionLogConfig defaultSessionLogConfig) {
        DefaultSessionLog defaultSessionLog = new DefaultSessionLog();
        defaultSessionLog.setLevel(this.m_logLevels.get(defaultSessionLogConfig.getLogLevel()));
        defaultSessionLog.setWriter(defaultSessionLogConfig.getFilename());
        this.processLogConfig(defaultSessionLogConfig, defaultSessionLog);
        return defaultSessionLog;
    }

    protected SessionLog buildServerLogConfig(ServerLogConfig serverLogConfig, AbstractSession session) {
        SessionLog serverLog = ((DatabaseSessionImpl)session).getServerPlatform().getServerLog();
        return serverLog;
    }

    protected void processLogConfig(LogConfig logConfig, SessionLog log) {
        if (logConfig.getLoggingOptions() != null) {
            if (logConfig.getLoggingOptions().getShouldLogExceptionStackTrace() != null) {
                log.setShouldLogExceptionStackTrace(logConfig.getLoggingOptions().getShouldLogExceptionStackTrace());
            }
            if (logConfig.getLoggingOptions().getShouldPrintConnection() != null) {
                log.setShouldPrintConnection(logConfig.getLoggingOptions().getShouldPrintConnection());
            }
            if (logConfig.getLoggingOptions().getShouldPrintDate() != null) {
                log.setShouldPrintDate(logConfig.getLoggingOptions().getShouldPrintDate());
            }
            if (logConfig.getLoggingOptions().getShouldPrintSession() != null) {
                log.setShouldPrintSession(logConfig.getLoggingOptions().getShouldPrintSession());
            }
            if (logConfig.getLoggingOptions().getShouldPrintThread() != null) {
                log.setShouldPrintThread(logConfig.getLoggingOptions().getShouldPrintThread());
            }
        }
    }

    protected void buildSunCORBATransportManagerConfig(SunCORBATransportManagerConfig tmConfig, RemoteCommandManager rcm) {
        SunCORBATransportManager tm = new SunCORBATransportManager(rcm);
        rcm.setTransportManager(tm);
        this.processTransportManagerConfig(tmConfig, tm);
    }

    protected void processCommandsConfig(CommandsConfig commandsConfig, RemoteCommandManager rcm) {
        if (commandsConfig != null) {
            ((AbstractSession)rcm.getCommandProcessor()).setShouldPropagateChanges(commandsConfig.getCacheSync());
        }
    }

    protected SessionBroker buildSessionBrokerConfig(SessionBrokerConfig sessionBrokerConfig) {
        SessionBroker sessionBroker = new SessionBroker();
        Enumeration<String> sessionNames = sessionBrokerConfig.getSessionNames().elements();
        while (sessionNames.hasMoreElements()) {
            String sessionName = sessionNames.nextElement();
            sessionBroker.registerSession(sessionName, (AbstractSession)this.m_sessions.get(sessionName));
        }
        this.processSessionConfig(sessionBrokerConfig, sessionBroker);
        return sessionBroker;
    }
}

