/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.structures;

import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EmbeddableAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.DirectAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.mappings.structures.ArrayMapping;
import org.eclipse.persistence.mappings.structures.ObjectArrayMapping;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField;

public class ArrayAccessor
extends DirectAccessor {
    private String m_databaseType;
    private ColumnMetadata m_column;
    private MetadataClass m_referenceClass;
    private MetadataClass m_targetClass;
    private String m_targetClassName;

    public ArrayAccessor() {
        super("<array>");
    }

    public ArrayAccessor(MetadataAnnotation array, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(array, accessibleObject, classAccessor);
        this.m_targetClass = this.getMetadataClass(array.getAttributeString("targetClass"));
        this.m_databaseType = array.getAttributeString("databaseType");
        if (this.isAnnotationPresent("javax.persistence.Column")) {
            this.m_column = new ColumnMetadata(this.getAnnotation("javax.persistence.Column"), this);
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof ArrayAccessor) {
            ArrayAccessor accessor = (ArrayAccessor)objectToCompare;
            if (!this.valuesMatch(this.m_column, accessor.getColumn())) {
                return false;
            }
            if (!this.valuesMatch(this.m_databaseType, accessor.getDatabaseType())) {
                return false;
            }
            return !this.valuesMatch(this.m_targetClassName, accessor.getTargetClassName());
        }
        return false;
    }

    public ColumnMetadata getColumn() {
        return this.m_column;
    }

    @Override
    protected ColumnMetadata getColumn(String loggingCtx) {
        return this.m_column == null ? super.getColumn(loggingCtx) : this.m_column;
    }

    public String getDatabaseType() {
        return this.m_databaseType;
    }

    @Override
    public String getDefaultFetchType() {
        return "EAGER";
    }

    public EmbeddableAccessor getEmbeddableAccessor() {
        return this.getProject().getEmbeddableAccessor(this.getReferenceClass());
    }

    @Override
    public MetadataClass getReferenceClass() {
        if (this.m_referenceClass == null) {
            this.m_referenceClass = this.getTargetClass();
            if (this.m_referenceClass == null || this.m_referenceClass.isVoid()) {
                this.m_referenceClass = this.getReferenceClassFromGeneric();
                if (this.m_referenceClass == null) {
                    if (this.getClassAccessor().isMappedSuperclass()) {
                        return this.getMetadataClass(Void.class);
                    }
                    throw ValidationException.unableToDetermineTargetClass(this.getAttributeName(), this.getJavaClass());
                }
            }
        }
        return this.m_referenceClass;
    }

    @Override
    public MetadataDescriptor getReferenceDescriptor() {
        if (this.isDirectEmbeddableCollection()) {
            return this.getEmbeddableAccessor().getDescriptor();
        }
        return super.getReferenceDescriptor();
    }

    protected MetadataClass getTargetClass() {
        return this.m_targetClass;
    }

    protected String getTargetClassName() {
        return this.m_targetClassName;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObject(this.m_column, accessibleObject);
        this.m_targetClass = this.initXMLClassName(this.m_targetClassName);
    }

    @Override
    public boolean isDirectEmbeddableCollection() {
        return this.getEmbeddableAccessor() != null;
    }

    @Override
    public void process() {
        if (this.isDirectEmbeddableCollection()) {
            ObjectArrayMapping mapping = new ObjectArrayMapping();
            this.setMapping(mapping);
            mapping.setReferenceClassName(this.getReferenceClassName());
            mapping.setAttributeName(this.getAttributeName());
            this.setAccessorMethods(mapping);
            mapping.setStructureName(this.getDatabaseType());
            mapping.setField(new ObjectRelationalDatabaseField(this.getDatabaseField(this.getDescriptor().getPrimaryTable(), "metadata_default_column")));
        } else {
            ArrayMapping mapping = new ArrayMapping();
            this.setMapping(mapping);
            mapping.setAttributeName(this.getAttributeName());
            this.setAccessorMethods(mapping);
            mapping.setStructureName(this.getDatabaseType());
            mapping.setField(new ObjectRelationalDatabaseField(this.getDatabaseField(this.getDescriptor().getPrimaryTable(), "metadata_default_column")));
        }
    }

    public void setColumn(ColumnMetadata column) {
        this.m_column = column;
    }

    public void setDatabaseType(String databaseType) {
        this.m_databaseType = databaseType;
    }

    public void setTargetClassName(String targetClassName) {
        this.m_targetClassName = targetClassName;
    }
}

